/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MappingsToRoots {
    public static VirtualFile @NotNull [] getRootsUnderVcs(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull AbstractVcs vcs) {
        ArrayList<VirtualFile> result2;
        if (project == null) {
            MappingsToRoots.$$$reportNull$$$0(0);
        }
        if (newMappings == null) {
            MappingsToRoots.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> mappings = new ArrayList<VirtualFile>(newMappings.getMappingsAsFilesUnderVcs(vcs));
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        List<Object> list2 = result2 = convertor != null ? convertor.convertRoots(mappings) : mappings;
        if (!vcs.allowsNestedRoots()) {
            result2.sort((Comparator<VirtualFile>)FilePathComparator.getInstance());
            ApplicationManager.getApplication().runReadAction(() -> {
                FileIndexFacade facade = (FileIndexFacade)project.getService(FileIndexFacade.class);
                int i2 = 1;
                while (i2 < result2.size()) {
                    VirtualFile current2;
                    VirtualFile previous = (VirtualFile)result2.get(i2 - 1);
                    if (facade.isValidAncestor(previous, current2 = (VirtualFile)result2.get(i2))) {
                        result2.remove(i2);
                        continue;
                    }
                    ++i2;
                }
            });
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            MappingsToRoots.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    @NotNull
    public static List<VirtualFile> getDetailedVcsMappings(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull AbstractVcs vcs) {
        if (project == null) {
            MappingsToRoots.$$$reportNull$$$0(4);
        }
        if (newMappings == null) {
            MappingsToRoots.$$$reportNull$$$0(5);
        }
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(6);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(newMappings.getMappingsAsFilesUnderVcs(vcs));
        Collection<VirtualFile> modules2 = DefaultVcsRootPolicy.getInstance(project).getDefaultVcsRoots();
        List modulesUnderVcs = ContainerUtil.filter(modules2, file2 -> {
            if (!file2.isDirectory()) {
                return false;
            }
            NewMappings.MappedRoot root = newMappings.getMappedRootFor((VirtualFile)file2);
            return root != null && vcs.equals((Object)root.vcs);
        });
        List modulesToAdd = (List)ApplicationManager.getApplication().runReadAction(() -> {
            FileIndexFacade facade = (FileIndexFacade)project.getService(FileIndexFacade.class);
            return ContainerUtil.filter((Collection)modulesUnderVcs, module -> ContainerUtil.or((Iterable)roots, root -> facade.isValidAncestor(root, module)));
        });
        return new ArrayList<VirtualFile>(ContainerUtil.union(roots, (Collection)modulesToAdd));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMappings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsUnderVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcs";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedVcsMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

