/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.list.IconListPopupRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupListElementRendererWithIcon
extends PopupListElementRenderer<Object>
implements IconListPopupRenderer {
    protected IconComponent myIconLabel;

    public PopupListElementRendererWithIcon(ListPopupImpl aPopup) {
        super(aPopup);
    }

    @Override
    public boolean isIconAt(@NotNull Point point) {
        if (point == null) {
            PopupListElementRendererWithIcon.$$$reportNull$$$0(0);
        }
        JList list2 = this.myPopup.getList();
        int index2 = this.myPopup.getList().locationToIndex(point);
        Rectangle bounds2 = this.myPopup.getList().getCellBounds(index2, index2);
        Component renderer2 = this.getListCellRendererComponent(list2, list2.getSelectedValue(), index2, true, true);
        renderer2.setBounds(bounds2);
        renderer2.doLayout();
        point.translate(-bounds2.x, -bounds2.y);
        return SwingUtilities.getDeepestComponentAt(renderer2, point.x, point.y) instanceof IconComponent;
    }

    @Override
    protected void customizeComponent(JList<?> list2, Object value2, boolean isSelected) {
        super.customizeComponent(list2, value2, isSelected);
        this.myIconLabel.setIcon(isSelected ? IconUtil.wrapToSelectionAwareIcon(this.myDescriptor.getSelectedIconFor(value2)) : this.myDescriptor.getIconFor(value2));
    }

    @Override
    protected void setComponentIcon(Icon icon2, Icon disabledIcon) {
        this.myIconLabel.setIcon(icon2);
        this.myIconLabel.setDisabledIcon(disabledIcon);
    }

    @Override
    @Nullable
    protected JComponent createIconBar() {
        return this.myIconLabel;
    }

    @Override
    protected JComponent createItemComponent() {
        this.myTextLabel = new ErrorLabel();
        this.myTextLabel.setOpaque(true);
        this.myTextLabel.setBorder(JBUI.Borders.empty((int)1));
        this.myIconLabel = new IconComponent();
        OpaquePanel panel2 = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)JBColor.WHITE);
        panel2.add((Component)this.myIconLabel, "West");
        panel2.add((Component)this.myTextLabel, "Center");
        return this.layoutComponent((JComponent)panel2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/vcs/ui/PopupListElementRendererWithIcon", "isIconAt"));
    }

    public static class IconComponent
    extends JLabel {
        public IconComponent(Border border) {
            this.setBorder(border);
        }

        public IconComponent() {
            this((Border)JBUI.Borders.emptyRight((int)JBUI.CurrentTheme.ActionsList.elementIconGap()));
        }
    }
}

