/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class PersistentFSPaths {
    @NonNls
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    @NotNull
    private final String myCachesDir;

    PersistentFSPaths(@NotNull String dir) {
        if (dir == null) {
            PersistentFSPaths.$$$reportNull$$$0(0);
        }
        this.myCachesDir = dir;
    }

    @NotNull
    File getCorruptionMarkerFile() {
        return new File(new File(this.myCachesDir), "corruption.marker");
    }

    @NotNull
    File getVfsEnumBaseFile() {
        return new File(new File(this.myCachesDir), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    @NotNull
    Path getVfsEnumFile(@NotNull String enumName) {
        if (enumName == null) {
            PersistentFSPaths.$$$reportNull$$$0(1);
        }
        Path path2 = Path.of(this.myCachesDir, new String[0]).resolve(DEPENDENT_PERSISTENT_LIST_START_PREFIX + enumName + VFS_FILES_EXTENSION);
        if (path2 == null) {
            PersistentFSPaths.$$$reportNull$$$0(2);
        }
        return path2;
    }

    Path getRootsFile() {
        if (FSRecords.ourStoreRootsSeparately) {
            return new File(this.myCachesDir).getAbsoluteFile().toPath().resolve("roots" + VFS_FILES_EXTENSION);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSPaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsEnumFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVfsEnumFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

