/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabbedContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.BaseButtonBehavior;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TabContentLayout
extends ContentLayout
implements MorePopupAware {
    static final int MORE_ICON_BORDER = 6;
    public static final int TAB_LAYOUT_START = 4;
    LayoutData myLastLayout;
    ArrayList<ContentTabLabel> myTabs;
    final Map<Content, ContentTabLabel> myContent2Tabs;
    List<AnAction> myDoubleClickActions;
    private final JBTabPainter tabPainter;

    TabContentLayout(@NotNull ToolWindowContentUi ui2) {
        if (ui2 == null) {
            TabContentLayout.$$$reportNull$$$0(0);
        }
        super(ui2);
        this.myTabs = new ArrayList();
        this.myContent2Tabs = new HashMap<Content, ContentTabLabel>();
        this.myDoubleClickActions = new ArrayList<AnAction>();
        this.tabPainter = JBTabPainter.getTOOL_WINDOW();
        new BaseButtonBehavior(this.myUi.getTabComponent()){

            protected void execute(MouseEvent e) {
                if (!TabContentLayout.this.myUi.isCurrent(TabContentLayout.this)) {
                    return;
                }
                Rectangle moreRect = TabContentLayout.this.getMoreRect();
                if (moreRect != null) {
                    TabContentLayout.this.showMorePopup();
                }
            }
        };
    }

    @Override
    public void init(@NotNull ContentManager contentManager2) {
        if (contentManager2 == null) {
            TabContentLayout.$$$reportNull$$$0(1);
        }
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false){

            @Override
            protected boolean allowEngravement() {
                return this.myUi.window.isActive();
            }
        };
        MouseDragHelper.setComponentDraggable((JComponent)this.myIdLabel, (boolean)true);
        for (int i2 = 0; i2 < contentManager2.getContentCount(); ++i2) {
            this.contentAdded(new ContentManagerEvent((Object)this, contentManager2.getContent(i2), i2));
        }
    }

    @Override
    public void reset() {
        this.myTabs.clear();
        this.myContent2Tabs.clear();
        this.myIdLabel = null;
    }

    void setTabDoubleClickActions(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            TabContentLayout.$$$reportNull$$$0(2);
        }
        this.myDoubleClickActions = actions2;
    }

    private Rectangle getMoreRect() {
        if (this.myLastLayout == null) {
            return null;
        }
        return this.myLastLayout.moreRect;
    }

    public void dropCaches() {
        this.myLastLayout = null;
    }

    public boolean canShowMorePopup() {
        return this.getMoreRect() != null;
    }

    public void showMorePopup() {
        Rectangle rect = this.getMoreRect();
        if (rect == null) {
            return;
        }
        List tabs2 = ContainerUtil.filter(this.myTabs, this.myLastLayout.toDrop::contains);
        List contentsToShow = ContainerUtil.map((Collection)tabs2, ContentTabLabel::getContent);
        SelectContentStep step2 = new SelectContentStep(contentsToShow);
        RelativePoint point = new RelativePoint((Component)this.myUi.getTabComponent(), new Point(rect.x, rect.y + rect.height));
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2).show(point);
    }

    @Override
    public void layout() {
        boolean toolbarUpdateNeeded;
        Rectangle bounds2 = this.myUi.getTabComponent().getBounds();
        ContentManager manager2 = this.myUi.getContentManager();
        LayoutData data2 = new LayoutData(this.myUi);
        data2.eachX = 4;
        data2.eachY = 0;
        if (this.isIdVisible()) {
            this.myIdLabel.setBounds(data2.eachX, data2.eachY, this.myIdLabel.getPreferredSize().width, bounds2.height);
            data2.eachX += this.myIdLabel.getPreferredSize().width;
        }
        int tabsStart = data2.eachX;
        if (manager2.getContentCount() == 0) {
            return;
        }
        Content selected2 = manager2.getSelectedContent();
        if (selected2 == null) {
            selected2 = manager2.getContents()[0];
        }
        if (this.myLastLayout != null && this.myLastLayout.layoutSize.equals(bounds2.getSize()) && this.myLastLayout.contentCount == manager2.getContentCount() && ContainerUtil.all(this.myTabs, Component::isValid)) {
            for (ContentTabLabel each : this.myTabs) {
                if (each.getContent() != selected2 || each.getBounds().width == 0) continue;
                data2 = this.myLastLayout;
                data2.fullLayout = false;
            }
        }
        if (data2.fullLayout) {
            for (ContentTabLabel eachTab : this.myTabs) {
                Dimension eachSize = eachTab.getPreferredSize();
                data2.requiredWidth += eachSize.width;
                data2.toLayout.add(eachTab);
            }
            data2.toFitWidth = bounds2.getSize().width - data2.eachX;
            ContentTabLabel selectedTab = this.myContent2Tabs.get(selected2);
            while (data2.requiredWidth > data2.toFitWidth && data2.toLayout.size() > 1) {
                if (data2.toLayout.get(0) != selectedTab) {
                    TabContentLayout.dropTab(data2, data2.toLayout.remove(0));
                    continue;
                }
                if (data2.toLayout.get(data2.toLayout.size() - 1) == selectedTab) break;
                TabContentLayout.dropTab(data2, data2.toLayout.remove(data2.toLayout.size() - 1));
            }
            boolean reachedBounds = false;
            data2.moreRect = null;
            TabsDrawMode toDrawTabs = this.isToDrawTabs();
            for (ContentTabLabel each : data2.toLayout) {
                if (toDrawTabs == TabsDrawMode.HIDE) {
                    each.setBounds(0, 0, 0, 0);
                    continue;
                }
                data2.eachY = 0;
                Dimension eachSize = each.getPreferredSize();
                if (data2.eachX + eachSize.width < data2.toFitWidth + tabsStart) {
                    each.setBounds(data2.eachX, data2.eachY, eachSize.width, bounds2.height - data2.eachY);
                    data2.eachX += eachSize.width;
                    continue;
                }
                if (!reachedBounds) {
                    int width = bounds2.width - data2.eachX;
                    each.setBounds(data2.eachX, data2.eachY, width, bounds2.height - data2.eachY);
                    data2.eachX += width;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                reachedBounds = true;
            }
            for (ContentTabLabel each : data2.toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
        }
        if (data2.toDrop.size() > 0) {
            toolbarUpdateNeeded = this.myLastLayout != null && this.myLastLayout.moreRect == null;
            data2.moreRect = new Rectangle(data2.eachX + 6, 0, 16, bounds2.height);
        } else {
            toolbarUpdateNeeded = this.myLastLayout != null && this.myLastLayout.moreRect != null;
            data2.moreRect = null;
        }
        Rectangle moreRect = data2.moreRect == null ? null : new Rectangle(data2.eachX, 0, 22, bounds2.height);
        this.myUi.isResizableArea = p -> moreRect == null || !moreRect.contains((Point)p);
        this.myLastLayout = data2;
        if (toolbarUpdateNeeded) {
            ActivityTracker.getInstance().inc();
        }
    }

    @Override
    public int getMinimumWidth() {
        ContentManager contentManager2;
        Content selected2;
        int result2 = 0;
        if (this.myIdLabel != null && this.isIdVisible()) {
            result2 += this.myIdLabel.getPreferredSize().width;
            Insets insets = this.myIdLabel.getInsets();
            if (insets != null) {
                result2 += insets.left + insets.right;
            }
        }
        if ((selected2 = (contentManager2 = this.myUi.getContentManager()).getSelectedContent()) == null && contentManager2.getContents().length > 0) {
            selected2 = contentManager2.getContents()[0];
        }
        return result2 += selected2 != null ? this.myContent2Tabs.get((Object)selected2).getMinimumSize().width : 0;
    }

    @Nullable
    ContentTabLabel findTabLabelByContent(@Nullable Content content2) {
        return this.myContent2Tabs.get(content2);
    }

    static void dropTab(LayoutData data2, ContentTabLabel toDropLabel) {
        data2.requiredWidth -= toDropLabel.getPreferredSize().width + 1;
        data2.toDrop.add(toDropLabel);
    }

    @NotNull
    TabsDrawMode isToDrawTabs() {
        int size2 = this.myTabs.size();
        if (size2 > 1) {
            TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_ALL;
            if (tabsDrawMode == null) {
                TabContentLayout.$$$reportNull$$$0(3);
            }
            return tabsDrawMode;
        }
        if (size2 == 1) {
            ContentTabLabel tabLabel = this.myTabs.get(0);
            if (!StringUtil.isEmptyOrSpaces((String)tabLabel.getContent().getToolwindowTitle())) {
                TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_ALL;
                if (tabsDrawMode == null) {
                    TabContentLayout.$$$reportNull$$$0(4);
                }
                return tabsDrawMode;
            }
            if (tabLabel.hasActiveIcons()) {
                TabsDrawMode tabsDrawMode = TabsDrawMode.PAINT_SIMPLIFIED;
                if (tabsDrawMode == null) {
                    TabContentLayout.$$$reportNull$$$0(5);
                }
                return tabsDrawMode;
            }
            TabsDrawMode tabsDrawMode = TabsDrawMode.HIDE;
            if (tabsDrawMode == null) {
                TabContentLayout.$$$reportNull$$$0(6);
            }
            return tabsDrawMode;
        }
        TabsDrawMode tabsDrawMode = TabsDrawMode.HIDE;
        if (tabsDrawMode == null) {
            TabContentLayout.$$$reportNull$$$0(7);
        }
        return tabsDrawMode;
    }

    @Override
    public void paintComponent(Graphics g) {
        TabsDrawMode toDrawTabs = this.isToDrawTabs();
        if (toDrawTabs == TabsDrawMode.HIDE) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (ContentTabLabel each : this.myTabs) {
            int borderThickness = JBUIScale.scale((int)1);
            Rectangle r = each.getBounds();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (toDrawTabs != TabsDrawMode.PAINT_ALL) continue;
            if (each.isSelected()) {
                this.tabPainter.paintSelectedTab(JBTabsPosition.top, g2d, r, borderThickness, each.getTabColor(), this.myUi.window.isActive(), each.isHovered());
                continue;
            }
            this.tabPainter.paintTab(JBTabsPosition.top, g2d, r, borderThickness, each.getTabColor(), this.myUi.window.isActive(), each.isHovered());
        }
        g2d.dispose();
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.myTabs) {
            each.update();
        }
        this.updateIdLabel(this.myIdLabel);
    }

    @Override
    public void rebuild() {
        this.myUi.getTabComponent().removeAll();
        this.myUi.getTabComponent().add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi, true);
        for (ContentTabLabel each : this.myTabs) {
            this.myUi.getTabComponent().add(each);
            ToolWindowContentUi.initMouseListeners(each, this.myUi, false);
        }
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
        Content content2 = event.getContent();
        ContentTabLabel tab = content2 instanceof TabbedContent ? new TabbedContentTabLabel((TabbedContent)content2, this) : new ContentTabLabel(content2, this);
        this.myTabs.add(event.getIndex(), tab);
        this.myContent2Tabs.put(content2, tab);
        DnDTarget target2 = TabContentLayout.getDnDTarget(content2);
        if (target2 != null) {
            DnDSupport.createBuilder((JComponent)tab).setDropHandler((DnDDropHandler)target2).setTargetChecker((DnDTargetChecker)target2).setCleanUpOnLeaveCallback(() -> target2.cleanUpOnLeave()).install();
        }
    }

    @Nullable
    private static DnDTarget getDnDTarget(Content content2) {
        DnDTarget target2 = (DnDTarget)content2.getUserData(Content.TAB_DND_TARGET_KEY);
        if (target2 != null) {
            return target2;
        }
        return (DnDTarget)ObjectUtils.tryCast((Object)content2, DnDTarget.class);
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
        ContentTabLabel tab = this.myContent2Tabs.get(event.getContent());
        if (tab != null) {
            this.myTabs.remove(tab);
            this.myContent2Tabs.remove(event.getContent());
        }
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected2 = this.myUi.getContentManager().getSelectedContent();
        if (selected2 != null) {
            ContentTabLabel tab = this.myContent2Tabs.get(selected2);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.myIdLabel);
        }
    }

    @Override
    @NlsActions.ActionText
    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getPreviousContentActionName() {
        return UIBundle.message((String)"tabbed.pane.select.previous.tab", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    public String getNextContentActionName() {
        return UIBundle.message((String)"tabbed.pane.select.next.tab", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/TabContentLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabContentLayout";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "isToDrawTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTabDoubleClickActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum TabsDrawMode {
        PAINT_ALL,
        PAINT_SIMPLIFIED,
        HIDE;

    }

    static class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        boolean fullLayout = true;
        ArrayList<ContentTabLabel> toLayout = new ArrayList();
        Collection<ContentTabLabel> toDrop = new HashSet<ContentTabLabel>();
        Rectangle moreRect;
        public int eachX;
        public int eachY;
        public int contentCount;

        LayoutData(ToolWindowContentUi ui2) {
            this.layoutSize = ui2.getTabComponent().getSize();
            this.contentCount = ui2.getContentManager().getContentCount();
        }
    }
}

