/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectsWelcomeScreenActionBase;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewRecentProjectPanel
extends RecentProjectPanel {
    public NewRecentProjectPanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            NewRecentProjectPanel.$$$reportNull$$$0(0);
        }
        this(parentDisposable, true);
    }

    public NewRecentProjectPanel(@NotNull Disposable parentDisposable, boolean withSpeedSearch2) {
        ListWithFilter panel2;
        if (parentDisposable == null) {
            NewRecentProjectPanel.$$$reportNull$$$0(1);
        }
        super(parentDisposable, withSpeedSearch2);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)this, JScrollPane.class);
        if (scrollPane != null) {
            scrollPane.setBackground(WelcomeScreenUIManager.getProjectsBackground());
            JBDimension size2 = JBUI.size((int)300, (int)460);
            scrollPane.setSize((Dimension)size2);
            scrollPane.setMinimumSize((Dimension)size2);
            scrollPane.setPreferredSize((Dimension)size2);
        }
        if ((panel2 = (ListWithFilter)UIUtil.findComponentOfType((JComponent)this, ListWithFilter.class)) != null) {
            panel2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        }
    }

    @Override
    protected Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JList list2 = (JList)UIUtil.findComponentOfType((JComponent)this, JList.class);
        if (list2 != null) {
            list2.updateUI();
        }
    }

    @Override
    protected JBList<AnAction> createList(AnAction[] recentProjectActions, Dimension size2) {
        final JBList<AnAction> list2 = super.createList(recentProjectActions, size2);
        list2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        list2.getActionMap().put("selectNextColumn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected2 = list2.getSelectedValue();
                ProjectGroup group2 = null;
                if (selected2 instanceof ProjectGroupActionGroup) {
                    group2 = ((ProjectGroupActionGroup)((Object)selected2)).getGroup();
                }
                if (group2 != null) {
                    if (!group2.isExpanded()) {
                        group2.setExpanded(true);
                        ListModel model2 = ((NameFilteringListModel)list2.getModel()).getOriginalModel();
                        int index2 = list2.getSelectedIndex();
                        RecentProjectsWelcomeScreenActionBase.rebuildRecentProjectDataModel(model2);
                        list2.setSelectedIndex(group2.getProjects().isEmpty() ? index2 : index2 + 1);
                    }
                } else {
                    Component next;
                    FocusTraversalPolicy policy;
                    FlatWelcomeFrame frame = (FlatWelcomeFrame)ComponentUtil.getParentOfType(FlatWelcomeFrame.class, (Component)list2);
                    if (frame != null && (policy = frame.getFocusTraversalPolicy()) != null && (next = policy.getComponentAfter(frame, (Component)list2)) != null) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(next, true));
                    }
                }
            }
        });
        list2.getActionMap().put("selectPreviousColumn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selected2 = list2.getSelectedValue();
                ProjectGroup group2 = null;
                if (selected2 instanceof ProjectGroupActionGroup) {
                    group2 = ((ProjectGroupActionGroup)((Object)selected2)).getGroup();
                }
                if (group2 != null && group2.isExpanded()) {
                    group2.setExpanded(false);
                    int index2 = list2.getSelectedIndex();
                    ListModel model2 = ((NameFilteringListModel)list2.getModel()).getOriginalModel();
                    RecentProjectsWelcomeScreenActionBase.rebuildRecentProjectDataModel(model2);
                    list2.setSelectedIndex(index2);
                }
            }
        });
        return list2;
    }

    @Override
    protected boolean isUseGroups() {
        return true;
    }

    @Override
    protected ListCellRenderer<AnAction> createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectPanel.RecentProjectItemRenderer(){
            private GridBagConstraints nameCell;
            private GridBagConstraints pathCell;
            final JComponent spacer;
            {
                this.spacer = new NonOpaquePanel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(JBUIScale.scale((int)22), super.getPreferredSize().height);
                    }
                };
            }

            private void initConstraints() {
                this.nameCell = new GridBagConstraints();
                this.pathCell = new GridBagConstraints();
                GridBagConstraints rightButtonCell = new GridBagConstraints();
                this.nameCell.gridx = 0;
                this.nameCell.gridy = 0;
                this.nameCell.weightx = 1.0;
                this.nameCell.weighty = 1.0;
                this.nameCell.anchor = 23;
                this.nameCell.insets = JBUI.insets((int)6, (int)5, (int)1, (int)5);
                this.pathCell.gridx = 0;
                this.pathCell.gridy = 1;
                this.pathCell.insets = JBUI.insets((int)1, (int)5, (int)6, (int)5);
                this.pathCell.anchor = 25;
                rightButtonCell.gridx = 1;
                rightButtonCell.gridy = 0;
                rightButtonCell.anchor = 24;
                rightButtonCell.insets = JBUI.insets((int)7, (int)7, (int)7, (int)7);
                rightButtonCell.gridheight = 2;
            }

            @Override
            protected Color getListBackground(boolean isSelected, boolean hasFocus) {
                return isSelected ? WelcomeScreenUIManager.getProjectsSelectionBackground(hasFocus) : WelcomeScreenUIManager.getProjectsBackground();
            }

            @Override
            protected Color getListForeground(boolean isSelected, boolean hasFocus) {
                return WelcomeScreenUIManager.getProjectsSelectionForeground(isSelected, hasFocus);
            }

            @Override
            protected void layoutComponents() {
                this.setLayout(new GridBagLayout());
                this.initConstraints();
                this.add((Component)this.myName, this.nameCell);
                this.add((Component)this.myPath, this.pathCell);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends AnAction> list2, final AnAction value2, int index2, boolean selected2, boolean focused) {
                Color fore = this.getListForeground(selected2, list2.hasFocus());
                final Color back = this.getListBackground(selected2, list2.hasFocus());
                final JLabel name = new JLabel();
                final JLabel path2 = ComponentPanelBuilder.createNonWrappingCommentComponent((String)"");
                name.setForeground(fore);
                path2.setForeground(UIUtil.getInactiveTextColor());
                this.setBackground(back);
                return new JPanel(){
                    {
                        this.setLayout(new BorderLayout());
                        this.setBackground(back);
                        boolean isGroup = value2 instanceof ProjectGroupActionGroup;
                        boolean isInsideGroup = false;
                        if (value2 instanceof ReopenProjectAction) {
                            String path22 = ((ReopenProjectAction)value2).getProjectPath();
                            for (ProjectGroup group2 : RecentProjectsManager.getInstance().getGroups()) {
                                List projects = group2.getProjects();
                                if (!projects.contains(path22)) continue;
                                isInsideGroup = true;
                                break;
                            }
                        }
                        this.setBorder((Border)JBUI.Borders.empty((int)8, (int)7));
                        if (isInsideGroup) {
                            this.add((Component)spacer, "West");
                        }
                        if (isGroup) {
                            ProjectGroup group3 = ((ProjectGroupActionGroup)value2).getGroup();
                            name.setText(" " + group3.getName());
                            name.setIcon(IconUtil.toSize(group3.isExpanded() ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon(), JBUIScale.scale((int)16), JBUIScale.scale((int)16)));
                            name.setFont(name.getFont().deriveFont(1));
                            this.add(name);
                        } else if (value2 instanceof ReopenProjectAction) {
                            boolean isValid;
                            NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            name.setText(((ReopenProjectAction)value2).getProjectNameToDisplay());
                            String realPath = PathUtil.toSystemDependentName((String)((ReopenProjectAction)value2).getProjectPath());
                            int i2 = isInsideGroup ? 80 : 60;
                            path2.setText(this.getTitle2Text((ReopenProjectAction)value2, path2, JBUIScale.scale((int)i2)));
                            if (!realPath.equals(path2.getText())) {
                                NewRecentProjectPanel.this.projectsWithLongPaths.add((ReopenProjectAction)value2);
                            }
                            boolean bl = isValid = !NewRecentProjectPanel.this.isPathValid(((ReopenProjectAction)value2).getProjectPath());
                            if (isValid) {
                                name.setForeground(UIUtil.getInactiveTextColor());
                            }
                            p.add((Component)name, (Object)"North");
                            p.add((Component)path2, (Object)"South");
                            p.setBorder((Border)JBUI.Borders.emptyRight((int)30));
                            String projectPath = ((ReopenProjectAction)value2).getProjectPath();
                            RecentProjectsManagerBase recentProjectsManage = RecentProjectsManagerBase.getInstanceEx();
                            Icon icon2 = recentProjectsManage.getProjectIcon(projectPath, StartupUiUtil.isUnderDarcula(), true);
                            JLabel projectIcon = new JLabel("", icon2, 2){

                                @Override
                                protected void paintComponent(Graphics g) {
                                    Icon icon2 = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
                                    icon2.paintIcon(this, g, 0, 0);
                                }
                            };
                            projectIcon.setDisabledIcon(IconUtil.desaturate(icon2));
                            if (isValid) {
                                projectIcon.setEnabled(false);
                            }
                            projectIcon.setBorder((Border)JBUI.Borders.emptyRight((int)8));
                            projectIcon.setVerticalAlignment(0);
                            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
                            panel2.add((Component)p);
                            panel2.add((Component)projectIcon, (Object)"West");
                            this.add((Component)panel2);
                        }
                        AccessibleContextUtil.setCombinedName((Component)this, (Component)name, (String)" - ", (Component)path2);
                        AccessibleContextUtil.setCombinedDescription((Component)this, (Component)name, (String)" - ", (Component)path2);
                    }

                    private Icon getGray(Icon icon2) {
                        int w = icon2.getIconWidth();
                        int h = icon2.getIconHeight();
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice gd = ge.getDefaultScreenDevice();
                        GraphicsConfiguration gc = gd.getDefaultConfiguration();
                        BufferedImage image = gc.createCompatibleImage(w, h);
                        Graphics2D g2d = image.createGraphics();
                        icon2.paintIcon(null, g2d, 0, 0);
                        Image gray = GrayFilter.createDisabledImage(image);
                        return new ImageIcon(gray);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, JBUIScale.scale((int)(value2 instanceof ProjectGroupActionGroup ? 32 : 50)));
                    }
                };
            }
        };
    }

    @Override
    @Nullable
    protected JPanel createTitle() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/welcomeScreen/NewRecentProjectPanel", "<init>"));
    }
}

