/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForwardDependenciesBuilder
extends DependenciesBuilder {
    private final Map<PsiFile, Set<PsiFile>> myDirectDependencies;
    private final int myTransitive;
    @Nullable
    private final GlobalSearchScope myTargetScope;
    private final Set<VirtualFile> myStarted;

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope2) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(1);
        }
        super(project, scope2);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myStarted = new HashSet<VirtualFile>();
        this.myTransitive = 0;
        this.myTargetScope = null;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope2, @Nullable GlobalSearchScope targetScope) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(3);
        }
        super(project, scope2);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myStarted = new HashSet<VirtualFile>();
        this.myTargetScope = targetScope;
        this.myTransitive = 0;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope2, int transitive) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(5);
        }
        super(project, scope2);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myStarted = new HashSet<VirtualFile>();
        this.myTransitive = transitive;
        this.myTargetScope = null;
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisBundle.message((String)"forward.dependencies.usage.view.root.node.text", (Object[])new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisBundle.message((String)"forward.dependencies.usage.view.initial.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return false;
    }

    @Override
    public void analyze() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        psiManager.startBatchFilesProcessingMode();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        try {
            this.getScope().acceptIdempotentVisitor((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ForwardDependenciesBuilder.this.visit(file2, fileIndex, psiManager);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ForwardDependenciesBuilder$1", "visitFile"));
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private void visit(@NotNull PsiFile file2, @NotNull ProjectFileIndex fileIndex, @NotNull PsiManager psiManager) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(6);
        }
        if (fileIndex == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(7);
        }
        if (psiManager == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(8);
        }
        if ((viewProvider = file2.getViewProvider()).getBaseLanguage() != file2.getLanguage()) {
            return;
        }
        ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (indicator2 != null) {
            if (indicator2.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator2.setText(AnalysisBundle.message((String)"package.dependencies.progress.text", (Object[])new Object[0]));
            if (virtualFile2 != null) {
                indicator2.setText2(this.getRelativeToProjectPath(virtualFile2));
            }
            if (this.myTotalFileCount > 0 && this.myStarted.add(virtualFile2)) {
                indicator2.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
            }
        }
        boolean isInLibrary = virtualFile2 == null || fileIndex.isInLibrary(virtualFile2);
        HashSet<Object> collectedDeps = new HashSet<Object>();
        collectedDeps.add(file2);
        int depth = 0;
        HashSet<PsiFile> processed2 = new HashSet<PsiFile>();
        do {
            if (depth++ > this.getTransitiveBorder()) {
                return;
            }
            for (PsiFile psiFile : new HashSet(collectedDeps)) {
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile != null) {
                    if (indicator2 != null) {
                        indicator2.setText2(this.getRelativeToProjectPath(vFile));
                    }
                    if (!isInLibrary && fileIndex.isInLibrary(vFile)) {
                        processed2.add(psiFile);
                    }
                }
                if (!processed2.add(psiFile)) continue;
                HashSet found = new HashSet();
                ForwardDependenciesBuilder.analyzeFileDependencies(psiFile, (place, dependency) -> {
                    PsiFile dependencyFile = dependency.getContainingFile();
                    if (dependencyFile != null) {
                        VirtualFile depFile;
                        if (viewProvider == dependencyFile.getViewProvider()) {
                            return;
                        }
                        if (dependencyFile.isPhysical() && (depFile = dependencyFile.getVirtualFile()) != null && (fileIndex.isInContent(depFile) || fileIndex.isInLibrary(depFile)) && (this.myTargetScope == null || this.myTargetScope.contains(depFile))) {
                            PsiElement navigationElement = dependencyFile.getNavigationElement();
                            found.add(navigationElement instanceof PsiFile ? (PsiFile)navigationElement : dependencyFile);
                        }
                    }
                });
                Set deps = this.getDependencies().computeIfAbsent(file2, __ -> new HashSet());
                deps.addAll(found);
                this.getDirectDependencies().put(psiFile, new HashSet(found));
                collectedDeps.addAll(found);
                psiManager.dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)file2.getProject()).dropFileCaches(psiFile);
            }
            collectedDeps.removeAll(processed2);
        } while (this.isTransitive() && !collectedDeps.isEmpty());
    }

    @Override
    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        Map<PsiFile, Set<PsiFile>> map2 = this.myDirectDependencies;
        if (map2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(9);
        }
        return map2;
    }

    private boolean isTransitive() {
        return this.myTransitive > 0;
    }

    public int getTransitiveBorder() {
        return this.myTransitive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/ForwardDependenciesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/ForwardDependenciesBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

