/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.ProfilerDumpWriter;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/actions/ExportProfilerResultAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "writer", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "(Lcom/intellij/profiler/api/ProfilerDumpWriter;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.profiler.common"})
public class ExportProfilerResultAction
extends DumbAwareAction {
    private final ProfilerDumpWriter writer;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        VirtualFile baseDir;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(CommonProfilerBundleKt.profilerMessage("profiler.action.export", new Object[0]), CommonProfilerBundleKt.profilerMessage("profiler.action.export.selectPath", new Object[0]), new String[0]);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, e.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026og(descriptor, e.project)");
        FileSaverDialog saverDialog = fileSaverDialog;
        String snapshotsFolder = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().getFolder();
        if (snapshotsFolder != null) {
            object2 = LocalFileSystem.getInstance().findFileByPath(snapshotsFolder);
        } else {
            Project project = e.getProject();
            object2 = baseDir = project != null ? project.getBaseDir() : null;
        }
        if ((object = saverDialog.save(baseDir, this.writer.getDumpFileName())) == null || (object = object.getFile()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saverDialog.save(baseDir\u2026FileName)?.file ?: return");
        Object file2 = object;
        new Task.Backgroundable(this, (File)file2, e, e.getProject(), CommonProfilerBundleKt.profilerMessage("profiler.action.export.text", new Object[0]), true, PerformInBackgroundOption.DEAF){
            final /* synthetic */ ExportProfilerResultAction this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ AnActionEvent $e;

            public void run(@NotNull ProgressIndicator indicator2) {
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                ExportProfilerResultAction.access$getWriter$p(this.this$0).writeDump(this.$file, indicator2);
                Project project = this.$e.getProject();
                if (project == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
                Project project2 = project;
                ProfilerToolWindowManager.Companion.getInstance(project2).showInfoBalloon(CommonProfilerBundleKt.profilerMessage("profiler.action.export.balloon", new Object[0]));
            }

            public void onThrowable(@NotNull Throwable error2) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                com.intellij.profiler.actions.ExportProfilerResultAction$Companion.access$notifySaveDumpError(ExportProfilerResultAction.Companion, error2.getMessage(), this.getProject());
                this.$file.delete();
            }

            public void onCancel() {
                this.$file.delete();
            }
            {
                this.this$0 = this$0;
                this.$file = $captured_local_variable$1;
                this.$e = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }.queue();
    }

    public ExportProfilerResultAction(@NotNull ProfilerDumpWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(CommonProfilerBundleKt.profilerMessage("export.profiler.result.action.name", new Object[0]), null, AllIcons.ToolbarDecorator.Export);
        this.writer = writer;
    }

    public static final /* synthetic */ ProfilerDumpWriter access$getWriter$p(ExportProfilerResultAction $this) {
        return $this.writer;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\"\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\n*\u00070\u0006\u00a2\u0006\u0002\b\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0003\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/actions/ExportProfilerResultAction$Companion;", "", "()V", "notifySaveDumpError", "", "message", "", "project", "Lcom/intellij/openapi/project/Project;", "withTextAfterColon", "Lorg/jetbrains/annotations/Nls;", "text", "intellij.profiler.common"})
    public static final class Companion {
        private final void notifySaveDumpError(@Nls String message2, Project project) {
            ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, this.withTextAfterColon(CommonProfilerBundleKt.profilerMessage("profiler.action.export.save.error", new Object[0]), message2), project, null, 4, null);
        }

        @Nls
        private final String withTextAfterColon(String $this$withTextAfterColon, @Nls String text2) {
            CharSequence charSequence = text2;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || charSequence.length() == 0 ? $this$withTextAfterColon : $this$withTextAfterColon + ": " + text2;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$notifySaveDumpError(Companion $this, String message2, Project project) {
            $this.notifySaveDumpError(message2, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

