/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.charts;

import com.intellij.profiler.charts.BarDataset;
import com.intellij.profiler.charts.Grid;
import com.intellij.profiler.charts.GridChartWrapper;
import com.intellij.profiler.charts.MinMax;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J>\u0010 \u001a\u00020\u001d*\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001aH$R&\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/charts/BarChart;", "T", "", "Lcom/intellij/profiler/charts/GridChartWrapper;", "", "()V", "datasets", "", "Lcom/intellij/profiler/charts/BarDataset;", "getDatasets", "()Ljava/util/List;", "setDatasets", "(Ljava/util/List;)V", "gap", "getGap", "()I", "setGap", "(I)V", "ranges", "Lcom/intellij/profiler/charts/Grid;", "getRanges", "()Lcom/intellij/profiler/charts/Grid;", "space", "getSpace", "setSpace", "findMinMax", "Lcom/intellij/profiler/charts/MinMax;", "getDatasetCount", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "paintDataset", "datasetIndex", "datasetCount", "xy", "intellij.profiler.common"})
public abstract class BarChart<T extends Number>
extends GridChartWrapper<Integer, T> {
    @NotNull
    private List<BarDataset<T>> datasets;
    @NotNull
    private final Grid<Integer, T> ranges;
    private int gap;
    private int space;

    @NotNull
    public final List<BarDataset<T>> getDatasets() {
        return this.datasets;
    }

    public final void setDatasets(@NotNull List<BarDataset<T>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.datasets = list2;
    }

    @Override
    @NotNull
    public Grid<Integer, T> getRanges() {
        return this.ranges;
    }

    public final int getGap() {
        return this.gap;
    }

    public final void setGap(int n) {
        this.gap = n;
    }

    public final int getSpace() {
        return this.space;
    }

    public final void setSpace(int n) {
        this.space = n;
    }

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        MinMax<Integer, T> xy = this.findMinMax();
        if (xy.isInitialized()) {
            int datasetCount = this.getDatasetCount();
            Graphics graphics = g.create(this.getMargins().left, this.getMargins().top, this.getGridWidth(), this.getGridHeight());
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D grid = (Graphics2D)graphics;
            this.paintGrid(grid, g, xy);
            int index2 = 0;
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BarDataset dataset2 = (BarDataset)element$iv;
                boolean bl = false;
                this.paintDataset(dataset2, index2, datasetCount, grid, xy);
                if (dataset2.getStacked()) continue;
                int n = index2;
                index2 = n + 1;
            }
            grid.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getDatasetCount() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.datasets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BarDataset barDataset = (BarDataset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getStacked() ? 0 : 1;
            collection.add(n);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MinMax<Integer, T> findMinMax() {
        MinMax minMax;
        if (this.getRanges().isInitialized()) {
            minMax = this.getRanges();
        } else {
            MinMax minMax2 = this.getRanges().plus(new MinMax());
            boolean bl = false;
            boolean bl2 = false;
            MinMax minMax3 = minMax2;
            MinMax minMax4 = this.getRanges();
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BarDataset it = (BarDataset)element$iv;
                boolean bl4 = false;
                Iterable $this$forEachIndexed$iv = it.getData();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void v;
                    void $this$apply;
                    int n = index$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Number number = (Number)item$iv;
                    int i2 = n;
                    boolean bl6 = false;
                    $this$apply.process(i2, v);
                }
            }
            Unit unit = Unit.INSTANCE;
            minMax = minMax4.times(minMax2);
        }
        return minMax;
    }

    protected abstract void paintDataset(@NotNull BarDataset<T> var1, int var2, int var3, @NotNull Graphics2D var4, @NotNull MinMax<Integer, T> var5);

    public BarChart() {
        boolean bl = false;
        this.datasets = new ArrayList();
        this.ranges = new Grid();
        this.gap = 10;
        this.space = -1;
    }
}

