/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.dtrace;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Container;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0011\u0010\u0017\u001a\u00020\t*\u00070\t\u00a2\u0006\u0002\b\u0018H\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/dtrace/DTraceConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "settings", "Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "Lcom/intellij/profiler/dtrace/DTraceSettingsState;", "(Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;)V", "commandLine", "Lcom/intellij/ui/components/JBTextField;", "commandLineStr", "", "executable", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "frequency", "Lcom/intellij/ui/components/fields/IntegerField;", "apply", "", "createComponent", "Lcom/intellij/openapi/ui/DialogPanel;", "getDisplayName", "getId", "isModified", "", "reset", "withTrailingColon", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.profiler.common"})
public final class DTraceConfigurable
implements SearchableConfigurable {
    private final TextFieldWithBrowseButton executable;
    private final IntegerField frequency;
    @NlsSafe
    private final String commandLineStr;
    private final JBTextField commandLine;
    private final SimpleProfilerSettingsState settings;
    @NotNull
    public static final String ID = "dynamic.analysis.tools.profiler.dtrace";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        String string = this.executable.getText();
        String string2 = this.settings.getExecutablePath();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        if (Intrinsics.areEqual((Object)string, (Object)string3) ^ true) return true;
        Integer n = this.frequency.getValue();
        int n2 = this.settings.getSamplingFrequency();
        if (n == null) return true;
        if (n != n2) return true;
        if (!(Intrinsics.areEqual((Object)this.commandLine.getText(), (Object)this.commandLineStr) ^ true)) return false;
        return true;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return CommonProfilerBundleKt.profilerMessage("dtrace.name", new Object[0]);
    }

    @NotNull
    public DialogPanel createComponent() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, this.withTrailingColon(CommonProfilerBundleKt.profilerMessage("dtrace.executable", new Object[0])), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ DTraceConfigurable this$0;
            {
                this.this$0 = dTraceConfigurable;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)DTraceConfigurable.access$getExecutable$p(this.this$0), new CCFlags[0], null, null, 6, null);
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, this.withTrailingColon(CommonProfilerBundleKt.profilerMessage("dtrace.sampling.frequency", new Object[0])), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ DTraceConfigurable this$0;
            {
                this.this$0 = dTraceConfigurable;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                CCFlags[] cCFlagsArray = new CCFlags[]{};
                GrowPolicy growPolicy2 = null;
                String string = CommonProfilerBundleKt.profilerMessage("dtrace.comment.sample.per.second", new Object[0]);
                Cell.invoke$default($this$row, (JComponent)DTraceConfigurable.access$getFrequency$p(this.this$0), cCFlagsArray, growPolicy2, string, 2, null);
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, this.withTrailingColon(CommonProfilerBundleKt.profilerMessage("dtrace.command.line.arguments", new Object[0])), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ DTraceConfigurable this$0;
            {
                this.this$0 = dTraceConfigurable;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                CCFlags[] cCFlagsArray = new CCFlags[]{};
                GrowPolicy growPolicy2 = null;
                String string = CommonProfilerBundleKt.profilerMessage("dtrace.comment.command.line", new Object[0]);
                Cell.invoke$default($this$row, (JComponent)DTraceConfigurable.access$getCommandLine$p(this.this$0), cCFlagsArray, growPolicy2, string, 2, null);
            }
        }, 2, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        return panel$iv;
    }

    @Nls
    private final String withTrailingColon(String $this$withTrailingColon) {
        return $this$withTrailingColon + ':';
    }

    public void apply() {
        this.settings.setExecutablePath(this.executable.getText());
        Integer n = this.frequency.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"frequency.value");
        this.settings.setSamplingFrequency(n);
        String string = this.commandLine.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.text");
        this.settings.setDefaultCmdArgs(CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)string, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null)));
    }

    public void reset() {
        String string = this.settings.getExecutablePath();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        this.executable.setText(string2);
        this.frequency.setValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        this.commandLine.setText(this.commandLineStr);
    }

    public DTraceConfigurable(@NotNull SimpleProfilerSettingsState settings2) {
        TextFieldWithBrowseButton $this$apply;
        Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
        this.settings = settings2;
        String string = CommonProfilerBundleKt.profilerMessage("dtrace.executable", new Object[0]);
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = ComponentsKt.textFieldWithBrowseButton$default(null, string, fileChooserDescriptor2, null, 8, null);
        boolean bl = false;
        boolean bl2 = false;
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = textFieldWithBrowseButton2;
        DTraceConfigurable dTraceConfigurable = this;
        boolean bl3 = false;
        String string2 = this.settings.getExecutablePath();
        boolean bl4 = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        $this$apply.setText(string3);
        Unit unit = Unit.INSTANCE;
        dTraceConfigurable.executable = textFieldWithBrowseButton2;
        textFieldWithBrowseButton2 = new IntegerField(null, 0, Integer.MAX_VALUE);
        bl = false;
        bl2 = false;
        $this$apply = textFieldWithBrowseButton2;
        dTraceConfigurable = this;
        boolean bl5 = false;
        $this$apply.setValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        $this$apply.setDefaultValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        unit = Unit.INSTANCE;
        dTraceConfigurable.frequency = textFieldWithBrowseButton2;
        this.commandLineStr = CollectionsKt.joinToString$default((Iterable)this.settings.getDefaultCmdArgs(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        this.commandLine = new JBTextField(this.commandLineStr);
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getExecutable$p(DTraceConfigurable $this) {
        return $this.executable;
    }

    public static final /* synthetic */ IntegerField access$getFrequency$p(DTraceConfigurable $this) {
        return $this.frequency;
    }

    public static final /* synthetic */ JBTextField access$getCommandLine$p(DTraceConfigurable $this) {
        return $this.commandLine;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/dtrace/DTraceConfigurable$Companion;", "", "()V", "ID", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

