/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.dtrace;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerProcessBase;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.AttachCanceledException;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachProfilerUtilsKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ParsingData;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBase;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBaseKt;
import com.intellij.profiler.dtrace.DTraceScript;
import com.intellij.profiler.dtrace.DTraceScriptKt;
import com.intellij.profiler.dtrace.FullDumpParser;
import com.intellij.profiler.sudo.SudoProcessHandler;
import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B'\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H$J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0016\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H$J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020#H\u0014J\b\u0010'\u001a\u00020#H\u0014J\b\u0010(\u001a\u00020#H\u0014J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0014R\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "Lcom/intellij/profiler/ProfilerProcessBase;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "attachedTimestamp", "", "dtraceProcessHandler", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/AttachableTargetProcess;JLcom/intellij/profiler/sudo/SudoProcessHandler;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAttachedTimestamp", "()J", "dumpParser", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/profiler/dtrace/FullDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "createDumpParser", "createDumpWriter", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "data", "Lcom/intellij/profiler/api/NewCallTreeOnlyProfilerData;", "createProfilerData", "builder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "dispose", "", "doStop", "", "onDTraceStopped", "onTargetProcessTerminated", "onTerminateCalled", "postProcessData", "Companion", "intellij.profiler.common"})
public abstract class DTraceProfilerProcessBase
extends ProfilerProcessBase<AttachableTargetProcess> {
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    private final AtomicReference<FullDumpParser<BaseCallStackElement>> dumpParser;
    @NotNull
    private final Logger LOG;
    private final long attachedTimestamp;
    private final SudoProcessHandler dtraceProcessHandler;
    private static final Logger staticLogger;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    protected abstract FullDumpParser<BaseCallStackElement> createDumpParser();

    @NotNull
    protected abstract NewCallTreeOnlyProfilerData createProfilerData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> var1);

    @Nullable
    protected ProfilerDumpWriter createDumpWriter(@NotNull NewCallTreeOnlyProfilerData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return null;
    }

    protected void onDTraceStopped() {
    }

    @NotNull
    protected DummyCallTreeBuilder<BaseCallStackElement> postProcessData(@NotNull DummyCallTreeBuilder<BaseCallStackElement> builder2) {
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        return builder2;
    }

    @Override
    @NotNull
    protected Logger getLOG() {
        return this.LOG;
    }

    @Override
    protected boolean doStop() {
        this.dtraceProcessHandler.sendSIGINT();
        return true;
    }

    @Override
    protected void onTargetProcessTerminated() {
    }

    @Override
    protected void onTerminateCalled() {
        this.dtraceProcessHandler.destroyProcess();
    }

    @Override
    public void dispose() {
        this.dtraceProcessHandler.destroyProcess();
        this.dumpParser.set(null);
        super.dispose();
    }

    @Override
    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    protected DTraceProfilerProcessBase(@NotNull Project project, final @NotNull AttachableTargetProcess targetProcess, long attachedTimestamp, @NotNull SudoProcessHandler dtraceProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)dtraceProcessHandler), (String)"dtraceProcessHandler");
        super(project, (ProfilerTargetProcess)targetProcess);
        this.attachedTimestamp = attachedTimestamp;
        this.dtraceProcessHandler = dtraceProcessHandler;
        this.dtraceProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private BufferedWriter currentProcessRawDumpFileWriter;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    this.getDumpReadIndicator().checkCanceled();
                    if (this.getState() == Attached.INSTANCE && ProcessOutputType.isStdout(outputType)) {
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace stopped", (boolean)false, (int)2, null)) {
                            this.onDTraceStopped();
                            if (UtilsKt.keepTempProfilerFiles()) {
                                File file2 = UtilsKt.dtraceOutputFile(targetProcess.getPid());
                                this.getLOG().info("DTrace dump will be written to " + file2.getAbsolutePath());
                                this.currentProcessRawDumpFileWriter = new BufferedWriter(new FileWriter(file2));
                            }
                            dumpParser.set(this.createDumpParser());
                            this.changeStateAndNotifyAsync(ReadingData.INSTANCE);
                        }
                    }
                    if (this.getState() != ReadingData.INSTANCE) break block5;
                    FullDumpParser fullDumpParser = (FullDumpParser)dumpParser.get();
                    if (fullDumpParser != null) {
                        LineByLineParser lineByLineParser = fullDumpParser;
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
                        LineByLineParser.consumeText$default(lineByLineParser, string, null, 2, null);
                    }
                    BufferedWriter bufferedWriter = this.currentProcessRawDumpFileWriter;
                    if (bufferedWriter != null) {
                        bufferedWriter.append(event.getText());
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BufferedWriter bufferedWriter = this.currentProcessRawDumpFileWriter;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                FullDumpParser fullDumpParser = (FullDumpParser)dumpParser.get();
                if (fullDumpParser == null) {
                    return;
                }
                FullDumpParser parser = fullDumpParser;
                this.getLOG().info("Dtrace process terminated with code: " + event.getExitCode());
                this.changeStateAndNotifyAsync(ParsingData.INSTANCE);
                DummyCallTreeBuilder dummyCallTreeBuilder = parser.getChartBuilders().get("CPU Samples");
                if (dummyCallTreeBuilder == null) {
                    dummyCallTreeBuilder = new DummyCallTreeBuilder();
                }
                DummyCallTreeBuilder<BaseCallStackElement> cpuAnalyzedTree = this.postProcessData(dummyCallTreeBuilder);
                NewCallTreeOnlyProfilerData data2 = this.createProfilerData(cpuAnalyzedTree);
                this.getDumpReadIndicator().checkCanceled();
                this.changeStateAndNotifyAsync(new DataReady(data2, this.createDumpWriter(data2)));
            }
        });
        this.profilerConfiguration = DTraceProfilerProcessBaseKt.getLegacyDTraceProfilerConfiguration();
        this.dumpParser = new AtomicReference<Object>(null);
        this.LOG = staticLogger;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DTraceProfilerProcessBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        staticLogger = logger;
    }

    public static final /* synthetic */ Logger access$getStaticLogger$cp() {
        return staticLogger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0090\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001526\u0010\u0018\u001a2\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u0002H\b0\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase$Companion;", "", "()V", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "attachBase", "Lorg/jetbrains/concurrency/Promise;", "ProfilerProcess", "Lcom/intellij/profiler/dtrace/DTraceProfilerProcessBase;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "backgroundOption", "Lcom/intellij/openapi/progress/PerformInBackgroundOption;", "dTraceScript", "Lcom/intellij/profiler/dtrace/DTraceScript;", "timeoutInMilliseconds", "", "project", "Lcom/intellij/openapi/project/Project;", "sudoPasswordSupplier", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "onDTraceAttached", "Lkotlin/Function2;", "Lcom/intellij/profiler/sudo/SudoProcessHandler;", "Lkotlin/ParameterName;", "name", "dtraceProcessHandler", "indicator", "intellij.profiler.common"})
    public static final class Companion {
        @NotNull
        public final <ProfilerProcess extends DTraceProfilerProcessBase> Promise<ProfilerProcess> attachBase(@NotNull AttachableTargetProcess targetProcess, @NotNull PerformInBackgroundOption backgroundOption, @NotNull DTraceScript dTraceScript, int timeoutInMilliseconds, @NotNull Project project, @NotNull Function1<? super ProgressIndicator, String> sudoPasswordSupplier, @NotNull Function2<? super SudoProcessHandler, ? super ProgressIndicator, ? extends ProfilerProcess> onDTraceAttached) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)backgroundOption, (String)"backgroundOption");
            Intrinsics.checkNotNullParameter((Object)dTraceScript, (String)"dTraceScript");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
            Intrinsics.checkNotNullParameter(onDTraceAttached, (String)"onDTraceAttached");
            AsyncPromise result2 = new AsyncPromise();
            Function0<Boolean> $fun$setWrongPasswordResult$2 = new Function0<Boolean>(result2){
                final /* synthetic */ AsyncPromise $result;

                public final boolean invoke() {
                    return this.$result.setError((Throwable)new AttachFailedException(CommonProfilerBundleKt.commonProfilerMessage("profiler.valid.password.required", new Object[0])));
                }
                {
                    this.$result = asyncPromise;
                    super(0);
                }
            };
            new Task.Backgroundable(targetProcess, sudoPasswordSupplier, $fun$setWrongPasswordResult$2, dTraceScript, result2, onDTraceAttached, timeoutInMilliseconds, project, backgroundOption, project, CommonProfilerBundleKt.commonProfilerMessage("attach.task.title", new Object[0]), true, backgroundOption){
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ Function1 $sudoPasswordSupplier;
                final /* synthetic */ attachBase.2 $setWrongPasswordResult$2;
                final /* synthetic */ DTraceScript $dTraceScript;
                final /* synthetic */ AsyncPromise $result;
                final /* synthetic */ Function2 $onDTraceAttached;
                final /* synthetic */ int $timeoutInMilliseconds;
                final /* synthetic */ Project $project;
                final /* synthetic */ PerformInBackgroundOption $backgroundOption;

                public void run(@NotNull ProgressIndicator indicator2) {
                    Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                    indicator2.setText(CommonProfilerBundleKt.commonProfilerMessage("attach.task.text", this.$targetProcess.getFullName()));
                    String password = (String)this.$sudoPasswordSupplier.invoke((Object)indicator2);
                    if (password == null) {
                        this.$setWrongPasswordResult$2.invoke();
                        return;
                    }
                    Semaphore semaphore = new Semaphore(1);
                    AtomicBoolean terminated = new AtomicBoolean(false);
                    SudoProcessHandler handler2 = DTraceScriptKt.startDTraceProcessNew(this.$targetProcess.getPid(), this.$dTraceScript, (Function0<String>)((Function0)new Function0<String>(password){
                        final /* synthetic */ String $password;

                        @NotNull
                        public final String invoke() {
                            return this.$password;
                        }
                        {
                            this.$password = string;
                            super(0);
                        }
                    }), (Function0<Unit>)((Function0)new Function0<Unit>(this, semaphore){
                        final /* synthetic */ attachBase.3 this$0;
                        final /* synthetic */ Semaphore $semaphore;

                        public final void invoke() {
                            this.$semaphore.up();
                            this.this$0.$setWrongPasswordResult$2.invoke();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$semaphore = semaphore;
                            super(0);
                        }
                    }), (Function1<? super Integer, Unit>)((Function1)attachBase.run.handler.3.INSTANCE));
                    ProcessAdapter adapter2 = new ProcessAdapter(this, terminated, handler2, indicator2, semaphore){
                        final /* synthetic */ attachBase.3 this$0;
                        final /* synthetic */ AtomicBoolean $terminated;
                        final /* synthetic */ SudoProcessHandler $handler;
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ Semaphore $semaphore;

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            if (this.$terminated.get()) {
                                return;
                            }
                            if (ProcessOutputType.isStdout(outputType)) {
                                String string = event.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace attached", (boolean)false, (int)2, null)) {
                                    try {
                                        this.this$0.$result.setResult(this.this$0.$onDTraceAttached.invoke((Object)((Object)this.$handler), (Object)this.$indicator));
                                    }
                                    catch (Throwable e) {
                                        this.this$0.$result.setError(e);
                                        this.$handler.destroyProcess();
                                    }
                                    this.$semaphore.up();
                                    return;
                                }
                            }
                            if (ProcessOutputType.isStderr(outputType)) {
                                String string = event.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DTrace cannot instrument translated processes", (boolean)false, (int)2, null)) {
                                    this.this$0.$result.setError((Throwable)AttachProfilerUtilsKt.cannotInstrumentTranslatedProcess());
                                    this.$handler.destroyProcess();
                                    this.$semaphore.up();
                                    return;
                                }
                            }
                            if (!ProcessOutputType.isStderr(outputType)) return;
                            String string = event.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.text");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"dtrace: failed to grab pid", (boolean)false, (int)2, null)) return;
                            this.this$0.$result.setError((Throwable)AttachProfilerUtilsKt.attachFailedCantGrubPid(this.this$0.$targetProcess));
                            this.$handler.destroyProcess();
                            this.$semaphore.up();
                        }
                        {
                            this.this$0 = this$0;
                            this.$terminated = $captured_local_variable$1;
                            this.$handler = $captured_local_variable$2;
                            this.$indicator = $captured_local_variable$3;
                            this.$semaphore = $captured_local_variable$4;
                        }
                    };
                    handler2.addProcessListener((ProcessListener)adapter2);
                    handler2.startNotify();
                    long start2 = System.currentTimeMillis();
                    while (!semaphore.waitFor(100L)) {
                        boolean canceled = indicator2.isCanceled();
                        if (!canceled && System.currentTimeMillis() - start2 <= (long)this.$timeoutInMilliseconds) continue;
                        terminated.set(true);
                        handler2.destroyProcess();
                        this.$result.setError((Throwable)(canceled ? (Exception)AttachCanceledException.INSTANCE : (Exception)AttachProfilerUtilsKt.attachFailedTimeout(this.$targetProcess)));
                        break;
                    }
                    handler2.removeProcessListener((ProcessListener)adapter2);
                }
                {
                    this.$targetProcess = $captured_local_variable$0;
                    this.$sudoPasswordSupplier = $captured_local_variable$1;
                    this.$setWrongPasswordResult$2 = $captured_local_variable$2;
                    this.$dTraceScript = $captured_local_variable$3;
                    this.$result = $captured_local_variable$4;
                    this.$onDTraceAttached = $captured_local_variable$5;
                    this.$timeoutInMilliseconds = $captured_local_variable$6;
                    this.$project = $captured_local_variable$7;
                    this.$backgroundOption = $captured_local_variable$8;
                    super($super_call_param$9, $super_call_param$10, $super_call_param$11, $super_call_param$12);
                }
            }.queue();
            return (Promise)result2;
        }

        public static /* synthetic */ Promise attachBase$default(Companion companion, AttachableTargetProcess attachableTargetProcess, PerformInBackgroundOption performInBackgroundOption, DTraceScript dTraceScript, int n, Project project, Function1 function1, Function2 function2, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                function1 = (Function1)new Function1<ProgressIndicator, String>(project){
                    final /* synthetic */ Project $project;

                    @Nullable
                    public final String invoke(@Nullable ProgressIndicator it) {
                        return ProfilerManager.INSTANCE.getSudoPassword(this.$project, it);
                    }
                    {
                        this.$project = project;
                        super(1);
                    }
                };
            }
            return companion.attachBase(attachableTargetProcess, performInBackgroundOption, dTraceScript, n, project, (Function1<? super ProgressIndicator, String>)function1, function2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

