/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.sudo;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.ProcessUtilKt;
import com.intellij.profiler.sudo.ExecSudoCommandKt;
import com.intellij.profiler.sudo.SendResult;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#BV\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u0012#\b\u0002\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0016\u001a\u00020\bH\u0014J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001c\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00042\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0016\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0006\u0010\"\u001a\u00020\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/sudo/SudoProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "commandWithParameters", "", "", "sudoPasswordSupplier", "Lkotlin/Function0;", "onWrongSudoPassword", "", "onCantSendSudoSignal", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "signal", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "consumeRest", "", "<set-?>", "wrongSudoPassword", "getWrongSudoPassword", "()Z", "doDestroyProcess", "killSudoProcessTree", "process", "Ljava/lang/Process;", "notifyIfCant", "result", "notifyTextAvailable", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "runSyncIfTestOtherwiseExecute", "body", "sendSIGINT", "Companion", "intellij.profiler.common"})
public final class SudoProcessHandler
extends OSProcessHandler {
    private volatile boolean wrongSudoPassword;
    private boolean consumeRest;
    private final Function0<String> sudoPasswordSupplier;
    private final Function0<Unit> onWrongSudoPassword;
    private final Function1<Integer, Unit> onCantSendSudoSignal;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final boolean getWrongSudoPassword() {
        return this.wrongSudoPassword;
    }

    public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        logger.debug("sudo text available from " + ProcessOutputType.getKeyNameForLogging(outputType) + ": " + text2);
        if (this.consumeRest) {
            super.notifyTextAvailable(text2, outputType);
            return;
        }
        if (this.wrongSudoPassword) {
            return;
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            super.notifyTextAvailable(text2, outputType);
            return;
        }
        if (ProcessOutputType.isStderr(outputType) && StringsKt.contains$default((CharSequence)text2, (CharSequence)"Sorry, try again.", (boolean)false, (int)2, null)) {
            this.wrongSudoPassword = true;
            this.destroyProcess();
            this.onWrongSudoPassword.invoke();
            return;
        }
        this.consumeRest = true;
        super.notifyTextAvailable(text2, outputType);
    }

    protected void doDestroyProcess() {
        if (this.wrongSudoPassword) {
            super.doDestroyProcess();
            return;
        }
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS((Process)this.getProcess())) {
            Process process2 = this.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            this.killSudoProcessTree(process2);
        } else {
            this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SudoProcessHandler this$0;

                public final void invoke() {
                    Process process2 = this.this$0.getProcess();
                    Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
                    SudoProcessHandler.access$notifyIfCant(this.this$0, ExecSudoCommandKt.sudoSendSIGKILL(process2, (String)SudoProcessHandler.access$getSudoPasswordSupplier$p(this.this$0).invoke()) == SendResult.FAILED, 9);
                }
                {
                    this.this$0 = sudoProcessHandler;
                    super(0);
                }
            }));
        }
    }

    private final void killSudoProcessTree(Process process2) {
        this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)new Function0<Unit>(this, process2){
            final /* synthetic */ SudoProcessHandler this$0;
            final /* synthetic */ Process $process;

            public final void invoke() {
                SudoProcessHandler.access$notifyIfCant(this.this$0, ProcessUtilKt.killSudoProcessTreeSync$default(this.$process, (String)SudoProcessHandler.access$getSudoPasswordSupplier$p(this.this$0).invoke(), 0, 4, null), 9);
            }
            {
                this.this$0 = sudoProcessHandler;
                this.$process = process2;
                super(0);
            }
        }));
    }

    public final void sendSIGINT() {
        this.runSyncIfTestOtherwiseExecute((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SudoProcessHandler this$0;

            public final void invoke() {
                Process process2 = this.this$0.getProcess();
                Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
                SudoProcessHandler.access$notifyIfCant(this.this$0, ProcessUtilKt.killSudoProcessTreeSync(process2, (String)SudoProcessHandler.access$getSudoPasswordSupplier$p(this.this$0).invoke(), 2), 2);
            }
            {
                this.this$0 = sudoProcessHandler;
                super(0);
            }
        }));
    }

    private final void notifyIfCant(boolean result2, int signal) {
        if (!result2) {
            this.onCantSendSudoSignal.invoke((Object)signal);
        }
    }

    private final void runSyncIfTestOtherwiseExecute(Function0<Unit> body) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            body.invoke();
        } else {
            Object object = body;
            if (object != null) {
                Function0<Unit> function0 = object;
                object = new Runnable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                };
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.executeTask((Runnable)object), (String)"executeTask(body)");
        }
    }

    public SudoProcessHandler(@NotNull List<String> commandWithParameters, @NotNull Function0<String> sudoPasswordSupplier, @NotNull Function0<Unit> onWrongSudoPassword, @NotNull Function1<? super Integer, Unit> onCantSendSudoSignal) {
        block1: {
            Intrinsics.checkNotNullParameter(commandWithParameters, (String)"commandWithParameters");
            Intrinsics.checkNotNullParameter(sudoPasswordSupplier, (String)"sudoPasswordSupplier");
            Intrinsics.checkNotNullParameter(onWrongSudoPassword, (String)"onWrongSudoPassword");
            Intrinsics.checkNotNullParameter(onCantSendSudoSignal, (String)"onCantSendSudoSignal");
            super(ExecSudoCommandKt.sudoCmd().withParameters(commandWithParameters));
            this.sudoPasswordSupplier = sudoPasswordSupplier;
            this.onWrongSudoPassword = onWrongSudoPassword;
            this.onCantSendSudoSignal = onCantSendSudoSignal;
            OutputStream outputStream = this.getProcessInput();
            if (outputStream == null) break block1;
            OutputStream outputStream2 = outputStream;
            boolean bl = false;
            boolean bl2 = false;
            OutputStream $this$apply = outputStream2;
            boolean bl3 = false;
            String string = (String)this.sudoPasswordSupplier.invoke() + '\n';
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            $this$apply.write(byArray);
            $this$apply.flush();
        }
    }

    public /* synthetic */ SudoProcessHandler(List list2, Function0 function0, Function0 function02, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function02 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function1 = 2.INSTANCE;
        }
        this(list2, (Function0<String>)function0, (Function0<Unit>)function02, (Function1<? super Integer, Unit>)function1);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SudoProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        SudoProcessHandler.logger = logger;
    }

    public static final /* synthetic */ void access$notifyIfCant(SudoProcessHandler $this, boolean result2, int signal) {
        $this.notifyIfCant(result2, signal);
    }

    public static final /* synthetic */ Function0 access$getSudoPasswordSupplier$p(SudoProcessHandler $this) {
        return $this.sudoPasswordSupplier;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/sudo/SudoProcessHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "intellij.profiler.common"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

