/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerCommonIcons;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.BackTracesCallTree;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.OneOrTwoTreesPanel;
import com.intellij.profiler.ui.calltree.CallWithValuePercentageWithMetricTreeRenderer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/BackTracesPanel;", "Lcom/intellij/profiler/ui/OneOrTwoTreesPanel;", "Lcom/intellij/profiler/model/BackTracesCallTree;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "renderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "(Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "treeRenderer", "Lcom/intellij/profiler/ui/calltree/CallWithValuePercentageWithMetricTreeRenderer;", "trees", "Lcom/intellij/profiler/ui/OneOrTwoTreesPanel$Trees;", "model", "intellij.profiler.common"})
public final class BackTracesPanel
extends OneOrTwoTreesPanel<BackTracesCallTree<BaseCallStackElement>> {
    @Override
    @NotNull
    protected OneOrTwoTreesPanel.Trees trees(@NotNull BackTracesCallTree<BaseCallStackElement> model2) {
        OneOrTwoTreesPanel.Trees trees;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        BackTracesCallTree<BaseCallStackElement> backTracesCallTree = model2;
        if (backTracesCallTree instanceof BackTracesCallTree.NotRecursive) {
            trees = new OneOrTwoTreesPanel.Trees.One(((BackTracesCallTree.NotRecursive)model2).getRoot());
        } else if (backTracesCallTree instanceof BackTracesCallTree.Recursive) {
            trees = new OneOrTwoTreesPanel.Trees.Two(((BackTracesCallTree.Recursive)model2).getFromRoots(), ((BackTracesCallTree.Recursive)model2).getFromLeafs(), CommonProfilerBundleKt.profilerMessage("ui.calculate.backtraces.from.leaf", new Object[0]));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return trees;
    }

    @NotNull
    protected CallWithValuePercentageWithMetricTreeRenderer treeRenderer(@NotNull BaseCallStackElementRenderer renderer2) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Icon icon2 = ProfilerCommonIcons.ArrowTopLeft;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ProfilerCommonIcons.ArrowTopLeft");
        return new CallWithValuePercentageWithMetricTreeRenderer(icon2, renderer2, this.getMetric());
    }

    public BackTracesPanel(@NotNull BaseCallStackElementRenderer renderer2, @NotNull ValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        super(renderer2, metric);
    }
}

