/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBDefaultTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs;", "Lcom/intellij/execution/ui/layout/impl/JBRunnerTabs;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "addClosableTab", "", "tab", "Lcom/intellij/ui/tabs/TabInfo;", "select", "", "createCloseGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createTabBorder", "Lcom/intellij/ui/tabs/JBTabsBorder;", "CloseTabLabelAction", "Companion", "intellij.profiler.common"})
public final class JBRunnerClosableTabs
extends JBRunnerTabs {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected JBTabsBorder createTabBorder() {
        return (JBTabsBorder)new JBDefaultTabsBorder((JBTabsImpl)this);
    }

    public final void addClosableTab(@NotNull TabInfo tab, boolean select2) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        DefaultActionGroup tabLabelActions = new DefaultActionGroup(new AnAction[]{(AnAction)new CloseTabLabelAction(tab)});
        if (tab.getTabLabelActions() != null) {
            tabLabelActions.addSeparator();
            tabLabelActions.addAll(tab.getTabLabelActions());
        }
        tab.setTabLabelActions((ActionGroup)tabLabelActions, "unknown");
        this.addTab(tab);
        if (select2) {
            this.select(tab, true);
        }
    }

    public static /* synthetic */ void addClosableTab$default(JBRunnerClosableTabs jBRunnerClosableTabs, TabInfo tabInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        jBRunnerClosableTabs.addClosableTab(tabInfo, bl);
    }

    private final DefaultActionGroup createCloseGroup() {
        return new DefaultActionGroup(new AnAction[]{(AnAction)new DumbAwareAction(this, CommonProfilerBundleKt.profilerMessage("ui.tabs.close", new Object[0]), null, AllIcons.Actions.Close){
            final /* synthetic */ JBRunnerClosableTabs this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TabInfo tabInfo = this.this$0.getTargetInfo();
                if (tabInfo != null) {
                    if (com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo)) {
                        this.this$0.removeTab(this.this$0.getTargetInfo());
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                TabInfo tabInfo = this.this$0.getTargetInfo();
                presentation2.setEnabledAndVisible(tabInfo != null ? com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) : false);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"), this$0.getComponent());
            }
        }, new AnAction(this, CommonProfilerBundleKt.profilerMessage("ui.tabs.closeOthers", new Object[0])){
            final /* synthetic */ JBRunnerClosableTabs this$0;

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                List list2 = this.this$0.getTabs();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"tabs");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TabInfo it = (TabInfo)element$iv$iv;
                    boolean bl = false;
                    TabInfo tabInfo = it;
                    Intrinsics.checkNotNullExpressionValue((Object)tabInfo, (String)"it");
                    if (!(com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) && Intrinsics.areEqual((Object)it, (Object)this.this$0.getTargetInfo()) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    TabInfo it = (TabInfo)element$iv;
                    boolean bl = false;
                    this.this$0.removeTab(it);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void update(@NotNull AnActionEvent e) {
                boolean bl;
                Presentation presentation2;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Presentation presentation3 = e.getPresentation();
                    Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
                    List list2 = this.this$0.getTabs();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"tabs");
                    Iterable iterable = list2;
                    presentation2 = presentation3;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TabInfo it = (TabInfo)element$iv;
                            boolean bl2 = false;
                            TabInfo tabInfo = it;
                            Intrinsics.checkNotNullExpressionValue((Object)tabInfo, (String)"it");
                            if (!(com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) && Intrinsics.areEqual((Object)it, (Object)this.this$0.getTargetInfo()) ^ true)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                presentation2.setVisible(bl3);
            }

            public boolean isDumbAware() {
                return true;
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        }});
    }

    public JBRunnerClosableTabs(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, parent);
        this.setPopupGroup((ActionGroup)this.createCloseGroup(), "unknown", true);
        this.setTabDraggingEnabled(true);
        this.addTabMouseListener(new MouseAdapter(){
            private TabInfo tabToRemove;

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    this.tabToRemove = this.findInfo(e);
                }
            }

            @Override
            public void mouseReleased(@Nullable MouseEvent e) {
                Object object = this.tabToRemove;
                if (object != null) {
                    TabInfo tabInfo = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    TabInfo it = tabInfo;
                    boolean bl3 = false;
                    object = Companion.isClosable(it) ? tabInfo : null;
                    if (object != null) {
                        tabInfo = object;
                        JBRunnerClosableTabs jBRunnerClosableTabs = this;
                        bl2 = false;
                        boolean bl4 = false;
                        TabInfo p1 = tabInfo;
                        boolean bl5 = false;
                        jBRunnerClosableTabs.removeTab(p1);
                    }
                }
                this.tabToRemove = null;
            }
        });
        this.addListener(new TabsListener(){

            public void tabRemoved(@NotNull TabInfo tabToRemove) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)tabToRemove, (String)"tabToRemove");
                    JComponent jComponent = tabToRemove.getComponent();
                    if (!(jComponent instanceof Disposable)) {
                        jComponent = null;
                    }
                    Disposable disposable2 = (Disposable)jComponent;
                    if (disposable2 == null) break block1;
                    Disposable disposable3 = disposable2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Disposable p1 = disposable3;
                    boolean bl3 = false;
                    Disposer.dispose((Disposable)p1);
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs$CloseTabLabelAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "tabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "(Lcom/intellij/profiler/ui/JBRunnerClosableTabs;Lcom/intellij/ui/tabs/TabInfo;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.profiler.common"})
    private final class CloseTabLabelAction
    extends DumbAwareAction {
        private final TabInfo tabInfo;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JBRunnerClosableTabs.this.removeTab(this.tabInfo);
        }

        public CloseTabLabelAction(TabInfo tabInfo) {
            Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
            super(CommonProfilerBundleKt.profilerMessage("ui.tabs.close", new Object[0]), null, AllIcons.Actions.Close);
            this.tabInfo = tabInfo;
            Presentation presentation2 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
            presentation2.setHoveredIcon(AllIcons.Actions.CloseHovered);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs$Companion;", "", "()V", "isClosable", "", "Lcom/intellij/ui/tabs/TabInfo;", "intellij.profiler.common"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isClosable(TabInfo $this$isClosable) {
            AnAction[] anActionArray = $this$isClosable.getTabLabelActions();
            AnAction[] anActionArray2 = anActionArray;
            if (anActionArray == null) return false;
            AnAction[] anActionArray3 = anActionArray2.getChildren(null);
            anActionArray2 = anActionArray3;
            if (anActionArray3 == null) return false;
            AnAction[] $this$any$iv = anActionArray2;
            boolean $i$f$any = false;
            AnAction[] anActionArray4 = $this$any$iv;
            int n = anActionArray4.length;
            int n2 = 0;
            while (n2 < n) {
                AnAction element$iv;
                AnAction it = element$iv = anActionArray4[n2];
                boolean bl = false;
                if (it instanceof CloseTabLabelAction) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

