/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.profiler.ui.MergedCalleesPanelKt;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.TransformCallTreeActionsKt;
import com.intellij.profiler.ui.callusage.CallUsageNodeKt;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.profiler.ui.callusage.MouseAwareLabel;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNode;
import com.intellij.profiler.ui.callusage.UsageModelActions;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.treetable.MouseAwareTreeCellRendererPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010\u001eJB\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020%H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020,2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u00100\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u00103\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u00104\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u00105\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)H\u0002R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer;", "Lcom/intellij/profiler/ui/treetable/MouseAwareTreeCellRendererPanel;", "treeTable", "Lcom/intellij/ui/components/JBTreeTable;", "parentComponent", "Lcom/intellij/profiler/ui/MainCallTreeDataComponent;", "(Lcom/intellij/ui/components/JBTreeTable;Lcom/intellij/profiler/ui/MainCallTreeDataComponent;)V", "INSETS", "Lcom/intellij/util/ui/JBEmptyBorder;", "Lorg/jetbrains/annotations/NotNull;", "STACKED_INSETS", "fold", "Lcom/intellij/profiler/ui/callusage/MouseAwareLabel;", "horizontalStrut", "Ljava/awt/Component;", "kotlin.jvm.PlatformType", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "links", "", "Ljavax/swing/JComponent;", "[Ljavax/swing/JComponent;", "metrics", "Lcom/intellij/ui/components/JBLabel;", "optional", "recursionIcon", "stub", "Ljavax/swing/JPanel;", "unfold", "getHighlightables", "()[Ljavax/swing/JComponent;", "getTreeCellRendererComponent", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "mouseClicked", "", "event", "Ljava/awt/event/MouseEvent;", "updateComponents", "updateFoldLink", "uiData", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion$TreeNodeUIData;", "updateMetrics", "updateRecursionIcon", "updateUnfoldLink", "Companion", "intellij.profiler.common"})
public final class CallUsageTreeCellRenderer
extends MouseAwareTreeCellRendererPanel {
    private final JBEmptyBorder STACKED_INSETS;
    private final JBEmptyBorder INSETS;
    private final JBLabel metrics;
    private final MouseAwareLabel unfold;
    private final MouseAwareLabel fold;
    private final JBLabel recursionIcon;
    private final Component horizontalStrut;
    private final SimpleColoredComponent label;
    private final JPanel stub;
    private final JComponent[] optional;
    private final JComponent[] links;
    private final MainCallTreeDataComponent parentComponent;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public CallUsageTreeCellRenderer getTreeCellRendererComponent(@NotNull JTree tree, @Nullable Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.updateComponents(selected2);
        TreeModel treeModel = tree.getModel();
        if (!(treeModel instanceof MainCallTreeUIModel)) {
            treeModel = null;
        }
        MainCallTreeUIModel mainCallTreeUIModel = (MainCallTreeUIModel)((Object)treeModel);
        if (mainCallTreeUIModel == null) {
            return this;
        }
        MainCallTreeUIModel usageModel = mainCallTreeUIModel;
        Object object = value2;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.callusage.CallUsageNode /* = com.intellij.profiler.model.CallTreeNode<com.intellij.profiler.api.BaseCallStackElement> */");
        }
        CallTreeNode usageNode = (CallTreeNode)object;
        Companion.TreeNodeUIData treeNodeUIData = Companion.createUIData(usageModel, usageNode);
        if (treeNodeUIData == null) {
            return this;
        }
        Companion.TreeNodeUIData uiData = treeNodeUIData;
        this.updateMetrics(uiData, selected2);
        this.updateUnfoldLink(uiData, row2);
        this.updateFoldLink(uiData, row2);
        this.updateRecursionIcon(uiData, row2);
        Component component2 = this.horizontalStrut;
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"horizontalStrut");
        component2.setVisible(this.unfold.isVisible() || this.fold.isVisible());
        if (uiData.getVisibleNodes().size() > 1) {
            this.parentComponent.getCallStackElementRenderer().appendStackElementInRenderer((BaseCallStackElement)CollectionsKt.first(uiData.getVisibleNodes()), this.label, tree, this.isSelected());
            this.label.append(" \u2192 ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.parentComponent.getCallStackElementRenderer().appendStackElementInRenderer((BaseCallStackElement)CollectionsKt.last(uiData.getVisibleNodes()), this.label, tree, this.isSelected());
        } else {
            this.parentComponent.getCallStackElementRenderer().appendStackElementInRenderer((BaseCallStackElement)CollectionsKt.first(uiData.getVisibleNodes()), this.label, tree, this.isSelected());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateComponents(boolean selected2) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Color color;
        JComponent[] $this$forEach$iv2 = this.optional;
        boolean $i$f$forEach = false;
        JComponent[] jComponentArray = $this$forEach$iv2;
        int n = jComponentArray.length;
        for (int j = 0; j < n; ++j) {
            JComponent element$iv;
            JComponent it = element$iv = jComponentArray[j];
            boolean bl = false;
            it.setVisible(false);
        }
        this.label.clear();
        this.setToolTipText(null);
        this.stub.setBackground(RenderingUtil.getBackground((JTree)this.tree, (boolean)selected2));
        Color color2 = RenderingUtil.getForeground((JTree)this.tree, (boolean)selected2);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"RenderingUtil.getForeground(tree, selected)");
        Color foreground = color2;
        if (selected2) {
            color = foreground;
        } else {
            Color color3 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"JBUI.CurrentTheme.Link.Foreground.ENABLED");
        }
        Color hoverground = color;
        Object $this$filterIsInstance$iv = this.links;
        boolean $i$f$filterIsInstance = false;
        JComponent[] jComponentArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MouseAwareLabel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (JComponent element$iv : $this$forEach$iv) {
            MouseAwareLabel it = (MouseAwareLabel)((Object)element$iv);
            boolean bl = false;
            it.setHoverground(hoverground);
            it.setForeground(hoverground);
        }
        this.metrics.setForeground(foreground);
        this.label.setForeground(foreground);
    }

    private final void updateMetrics(Companion.TreeNodeUIData uiData, boolean selected2) {
        double frac = uiData.getToggledViewFraction().getFractionValue();
        if (!selected2) {
            this.metrics.setForeground(FlameChartColors.INSTANCE.getFireColor$intellij_profiler_common(frac));
        }
        this.metrics.setVisible(true);
        this.metrics.setText(ProfilerUIUtilsKt.fractionToString$default(frac, 0.0, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateUnfoldLink(Companion.TreeNodeUIData uiData, int row2) {
        List<BaseCallStackElement> foldedNodes = uiData.getVisibleNodes();
        if (foldedNodes.size() <= 1) {
            return;
        }
        this.unfold.setVisible(true);
        if (this.getHighlightedRow() == row2 && this.getHighlightedComponent() == this.unfold) {
            this.unfold.entered(null);
            HtmlBuilder builder2 = new HtmlBuilder();
            builder2.append((HtmlChunk)HtmlChunk.div((String)"margin-bottom: 12px; font-weight: bold").child(HtmlChunk.text((String)CommonProfilerBundleKt.profilerMessage("settings.tooltips.showFilteredCalls", new Object[0]))));
            Iterable $this$forEachIndexed$iv = foldedNodes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BaseCallStackElement baseCallStackElement = (BaseCallStackElement)item$iv;
                int i2 = n;
                boolean bl2 = false;
                String node2 = XmlStringUtil.escapeString((String)this.parentComponent.getCallStackElementRenderer().getText((BaseCallStackElement)it));
                builder2.append((HtmlChunk)HtmlChunk.div((String)("padding-left: " + i2 * 4 + "px; white-space: nowrap")).child(HtmlChunk.text((String)node2)));
            }
            this.setToolTipText(builder2.wrapWithHtmlBody().toString());
        } else {
            this.unfold.exited(null);
        }
    }

    private final void updateFoldLink(Companion.TreeNodeUIData uiData, int row2) {
        if (((CommonProfilerUiOptions)CallUsageNodeKt.getSettings().getState()).getCallTreeState().getFilterCalls() && uiData.getCanBeFolded()) {
            this.fold.setVisible(true);
            if (this.getHighlightedRow() == row2 && this.getHighlightedComponent() == this.fold) {
                this.fold.entered(null);
                this.setToolTipText(CommonProfilerBundleKt.profilerMessage("settings.tooltips.hideFilteredCalls", new Object[0]));
            } else {
                this.fold.exited(null);
            }
        }
    }

    private final void updateRecursionIcon(Companion.TreeNodeUIData uiData, int row2) {
        if (uiData.getRecursionCount() > 0) {
            this.recursionIcon.setVisible(true);
            this.recursionIcon.setBorder(this.unfold.isVisible() || this.fold.isVisible() ? (Border)this.STACKED_INSETS : (Border)this.INSETS);
            if (this.getHighlightedRow() == row2 && this.getHighlightedComponent() == this.recursionIcon) {
                this.setToolTipText(MergedCalleesPanelKt.collapseRecursionCallsActionText(uiData.getRecursionCount()));
            }
        }
    }

    @Override
    protected void mouseClicked(@NotNull MouseEvent event) {
        block8: {
            Object object;
            MainCallTreeUIModel uiModel;
            block11: {
                block10: {
                    TreePath path2;
                    block9: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (event.getButton() != 1) {
                                return;
                            }
                            path2 = this.tree.getPathForRow(this.getHighlightedRow());
                            if (this.getHighlightedComponent() != this.unfold) break block7;
                            JTree jTree = this.tree;
                            Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
                            TreePath treePath = path2;
                            Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path");
                            UsageModelActions.INSTANCE.unfold(jTree, treePath);
                            break block8;
                        }
                        if (this.getHighlightedComponent() != this.fold) break block9;
                        JTree jTree = this.tree;
                        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
                        TreePath treePath = path2;
                        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path");
                        UsageModelActions.INSTANCE.fold(jTree, treePath);
                        break block8;
                    }
                    if (this.getHighlightedComponent() != this.recursionIcon) break block8;
                    ProfilerUsageTriggerCollector.Companion.reportRecursionCollapse();
                    JTree jTree = this.tree;
                    Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
                    TreeModel treeModel = jTree.getModel();
                    if (!(treeModel instanceof MainCallTreeUIModel)) {
                        treeModel = null;
                    }
                    MainCallTreeUIModel mainCallTreeUIModel = (MainCallTreeUIModel)((Object)treeModel);
                    if (mainCallTreeUIModel == null) {
                        return;
                    }
                    uiModel = mainCallTreeUIModel;
                    TreePath treePath = path2;
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path");
                    object = treePath.getLastPathComponent();
                    if (object == null) break block10;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Object object3 = it;
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.callusage.CallUsageNode /* = com.intellij.profiler.model.CallTreeNode<com.intellij.profiler.api.BaseCallStackElement> */");
                    }
                    object = (CallTreeNode)object3;
                    if (object != null) break block11;
                }
                return;
            }
            Object node2 = object;
            TransformCallTreeActionsKt.addFocusOnSubTreeTab(this.parentComponent, uiModel.getUIVisibleNodeView((CallTreeNode<BaseCallStackElement>)node2).getMaybeWrappedVisibleTreeNode(), true);
        }
    }

    @Override
    @NotNull
    protected JComponent[] getHighlightables() {
        return this.links;
    }

    public CallUsageTreeCellRenderer(@NotNull JBTreeTable treeTable, @NotNull MainCallTreeDataComponent parentComponent) {
        Object $this$apply;
        Intrinsics.checkNotNullParameter((Object)treeTable, (String)"treeTable");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        super((JTree)treeTable.getTree());
        this.parentComponent = parentComponent;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)3, (int)3, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"JBUI.Borders.empty(3, 3, 0, 0)");
        this.STACKED_INSETS = jBEmptyBorder;
        JBEmptyBorder jBEmptyBorder2 = JBUI.Borders.empty((int)3, (int)0, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder2, (String)"JBUI.Borders.empty(3, 0, 0, 0)");
        this.INSETS = jBEmptyBorder2;
        this.metrics = new JBLabel();
        this.unfold = new MouseAwareLabel("\u2193");
        Object object = new MouseAwareLabel("\u2191");
        boolean bl = false;
        boolean bl2 = false;
        MouseAwareLabel mouseAwareLabel = object;
        CallUsageTreeCellRenderer callUsageTreeCellRenderer = this;
        boolean bl3 = false;
        $this$apply.setBorder((Border)this.INSETS);
        Unit unit = Unit.INSTANCE;
        callUsageTreeCellRenderer.fold = object;
        this.recursionIcon = new JBLabel(AllIcons.Gutter.RecursiveMethod);
        this.horizontalStrut = Box.createHorizontalStrut(8);
        this.label = new SimpleColoredComponent();
        object = new JPanel();
        bl = false;
        bl2 = false;
        $this$apply = object;
        callUsageTreeCellRenderer = this;
        boolean bl4 = false;
        ((Container)$this$apply).setLayout(new BoxLayout((Container)$this$apply, 0));
        ((Container)$this$apply).add((Component)this.metrics);
        ((Container)$this$apply).add((Component)((Object)this.unfold));
        ((Container)$this$apply).add((Component)((Object)this.fold));
        ((Container)$this$apply).add((Component)this.recursionIcon);
        ((Container)$this$apply).add(this.horizontalStrut);
        ((Container)$this$apply).add((Component)this.label);
        unit = Unit.INSTANCE;
        callUsageTreeCellRenderer.stub = object;
        this.optional = new JComponent[]{(JComponent)this.metrics, (JComponent)((Object)this.unfold), (JComponent)((Object)this.fold), (JComponent)this.recursionIcon};
        this.links = new JComponent[]{(JComponent)((Object)this.unfold), (JComponent)((Object)this.fold), (JComponent)this.recursionIcon};
        this.setLayout(new BorderLayout());
        this.stub.setOpaque(false);
        Object[] objectArray = this.stub.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"stub.components");
        Iterable $this$forEach$iv = ArraysKt.filterIsInstance((Object[])objectArray, JComponent.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl5 = false;
            it.setOpaque(false);
        }
        this.add(this.stub);
        this.metrics.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.metrics.setHorizontalAlignment(4);
        JTree jTree = this.tree;
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"tree");
        int width = ProfilerUIUtilsKt.metricsStringWidth(jTree, true) + 8;
        if (this.metrics.getWidth() != width) {
            this.metrics.setPreferredSize(new Dimension(width, 0));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion;", "", "()V", "createUIData", "Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion$TreeNodeUIData;", "treeModel", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel;", "delegatedTreeNode", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "TreeNodeUIData", "intellij.profiler.common"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final TreeNodeUIData createUIData(@NotNull MainCallTreeUIModel treeModel, @NotNull CallTreeNode<BaseCallStackElement> delegatedTreeNode) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)treeModel), (String)"treeModel");
            Intrinsics.checkNotNullParameter(delegatedTreeNode, (String)"delegatedTreeNode");
            List<CallTreeNode<BaseCallStackElement>> maybeFoldedVisibleNodes = treeModel.getListOfNodesFoldedToRightNode(delegatedTreeNode);
            int recursionCount = maybeFoldedVisibleNodes.size() > 1 ? 0 : treeModel.recursionCount(delegatedTreeNode);
            boolean canBeFolded = treeModel.canBeFolded(delegatedTreeNode);
            UIVisibleCallTreeNode<BaseCallStackElement> uiNodeView = treeModel.getUIVisibleNodeView((CallTreeNode)CollectionsKt.first(maybeFoldedVisibleNodes));
            if (uiNodeView.getCall() == null) {
                return null;
            }
            Iterable iterable = maybeFoldedVisibleNodes;
            MainCallTreeUIModel.TreeNodeToggledViewFraction treeNodeToggledViewFraction = treeModel.treeNodeToggledViewFraction(uiNodeView);
            double d = uiNodeView.getFractionOfAllCalls();
            double d2 = uiNodeView.getFractionOfParentCall();
            long l = uiNodeView.getValue();
            boolean $i$f$mapNotNull = false;
            void var9_13 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                BaseCallStackElement baseCallStackElement;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                CallTreeNode it = (CallTreeNode)element$iv$iv;
                boolean bl2 = false;
                CallWithValue callWithValue = (CallWithValue)it.getData();
                if ((callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null) == null) continue;
                baseCallStackElement = baseCallStackElement;
                boolean bl3 = false;
                boolean bl4 = false;
                BaseCallStackElement it$iv$iv = baseCallStackElement;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            int n = recursionCount;
            boolean bl = canBeFolded;
            List list3 = list2;
            MainCallTreeUIModel.TreeNodeToggledViewFraction treeNodeToggledViewFraction2 = treeNodeToggledViewFraction;
            double d3 = d;
            double d4 = d2;
            long l2 = l;
            return new TreeNodeUIData(l2, d4, d3, treeNodeToggledViewFraction2, list3, bl, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010#\u001a\u00020\rH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003JU\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u000fH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTreeCellRenderer$Companion$TreeNodeUIData;", "", "value", "", "fractionOfParentCall", "", "fractionOfAllCalls", "toggledViewFraction", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;", "visibleNodes", "", "Lcom/intellij/profiler/api/BaseCallStackElement;", "canBeFolded", "", "recursionCount", "", "(JDDLcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;Ljava/util/List;ZI)V", "getCanBeFolded", "()Z", "getFractionOfAllCalls", "()D", "getFractionOfParentCall", "getRecursionCount", "()I", "getToggledViewFraction", "()Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;", "getValue", "()J", "getVisibleNodes", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "intellij.profiler.common"})
        public static final class TreeNodeUIData {
            private final long value;
            @TestOnly
            private final double fractionOfParentCall;
            @TestOnly
            private final double fractionOfAllCalls;
            @NotNull
            private final MainCallTreeUIModel.TreeNodeToggledViewFraction toggledViewFraction;
            @NotNull
            private final List<BaseCallStackElement> visibleNodes;
            private final boolean canBeFolded;
            private final int recursionCount;

            public final long getValue() {
                return this.value;
            }

            public final double getFractionOfParentCall() {
                return this.fractionOfParentCall;
            }

            public final double getFractionOfAllCalls() {
                return this.fractionOfAllCalls;
            }

            @NotNull
            public final MainCallTreeUIModel.TreeNodeToggledViewFraction getToggledViewFraction() {
                return this.toggledViewFraction;
            }

            @NotNull
            public final List<BaseCallStackElement> getVisibleNodes() {
                return this.visibleNodes;
            }

            public final boolean getCanBeFolded() {
                return this.canBeFolded;
            }

            public final int getRecursionCount() {
                return this.recursionCount;
            }

            public TreeNodeUIData(long value2, double fractionOfParentCall, double fractionOfAllCalls, @NotNull MainCallTreeUIModel.TreeNodeToggledViewFraction toggledViewFraction, @NotNull List<? extends BaseCallStackElement> visibleNodes, boolean canBeFolded, int recursionCount) {
                Intrinsics.checkNotNullParameter((Object)toggledViewFraction, (String)"toggledViewFraction");
                Intrinsics.checkNotNullParameter(visibleNodes, (String)"visibleNodes");
                this.value = value2;
                this.fractionOfParentCall = fractionOfParentCall;
                this.fractionOfAllCalls = fractionOfAllCalls;
                this.toggledViewFraction = toggledViewFraction;
                this.visibleNodes = visibleNodes;
                this.canBeFolded = canBeFolded;
                this.recursionCount = recursionCount;
            }

            public final long component1() {
                return this.value;
            }

            public final double component2() {
                return this.fractionOfParentCall;
            }

            public final double component3() {
                return this.fractionOfAllCalls;
            }

            @NotNull
            public final MainCallTreeUIModel.TreeNodeToggledViewFraction component4() {
                return this.toggledViewFraction;
            }

            @NotNull
            public final List<BaseCallStackElement> component5() {
                return this.visibleNodes;
            }

            public final boolean component6() {
                return this.canBeFolded;
            }

            public final int component7() {
                return this.recursionCount;
            }

            @NotNull
            public final TreeNodeUIData copy(long value2, double fractionOfParentCall, double fractionOfAllCalls, @NotNull MainCallTreeUIModel.TreeNodeToggledViewFraction toggledViewFraction, @NotNull List<? extends BaseCallStackElement> visibleNodes, boolean canBeFolded, int recursionCount) {
                Intrinsics.checkNotNullParameter((Object)toggledViewFraction, (String)"toggledViewFraction");
                Intrinsics.checkNotNullParameter(visibleNodes, (String)"visibleNodes");
                return new TreeNodeUIData(value2, fractionOfParentCall, fractionOfAllCalls, toggledViewFraction, visibleNodes, canBeFolded, recursionCount);
            }

            public static /* synthetic */ TreeNodeUIData copy$default(TreeNodeUIData treeNodeUIData, long l, double d, double d2, MainCallTreeUIModel.TreeNodeToggledViewFraction treeNodeToggledViewFraction, List list2, boolean bl, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    l = treeNodeUIData.value;
                }
                if ((n2 & 2) != 0) {
                    d = treeNodeUIData.fractionOfParentCall;
                }
                if ((n2 & 4) != 0) {
                    d2 = treeNodeUIData.fractionOfAllCalls;
                }
                if ((n2 & 8) != 0) {
                    treeNodeToggledViewFraction = treeNodeUIData.toggledViewFraction;
                }
                if ((n2 & 0x10) != 0) {
                    list2 = treeNodeUIData.visibleNodes;
                }
                if ((n2 & 0x20) != 0) {
                    bl = treeNodeUIData.canBeFolded;
                }
                if ((n2 & 0x40) != 0) {
                    n = treeNodeUIData.recursionCount;
                }
                return treeNodeUIData.copy(l, d, d2, treeNodeToggledViewFraction, list2, bl, n);
            }

            @NotNull
            public String toString() {
                return "TreeNodeUIData(value=" + this.value + ", fractionOfParentCall=" + this.fractionOfParentCall + ", fractionOfAllCalls=" + this.fractionOfAllCalls + ", toggledViewFraction=" + this.toggledViewFraction + ", visibleNodes=" + this.visibleNodes + ", canBeFolded=" + this.canBeFolded + ", recursionCount=" + this.recursionCount + ")";
            }

            public int hashCode() {
                MainCallTreeUIModel.TreeNodeToggledViewFraction treeNodeToggledViewFraction = this.toggledViewFraction;
                List<BaseCallStackElement> list2 = this.visibleNodes;
                int n = ((((Long.hashCode(this.value) * 31 + Double.hashCode(this.fractionOfParentCall)) * 31 + Double.hashCode(this.fractionOfAllCalls)) * 31 + (treeNodeToggledViewFraction != null ? ((Object)treeNodeToggledViewFraction).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31;
                int n2 = this.canBeFolded ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return (n + n2) * 31 + Integer.hashCode(this.recursionCount);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof TreeNodeUIData)) break block3;
                        TreeNodeUIData treeNodeUIData = (TreeNodeUIData)object;
                        if (this.value != treeNodeUIData.value || Double.compare(this.fractionOfParentCall, treeNodeUIData.fractionOfParentCall) != 0 || Double.compare(this.fractionOfAllCalls, treeNodeUIData.fractionOfAllCalls) != 0 || !Intrinsics.areEqual((Object)this.toggledViewFraction, (Object)treeNodeUIData.toggledViewFraction) || !Intrinsics.areEqual(this.visibleNodes, treeNodeUIData.visibleNodes) || this.canBeFolded != treeNodeUIData.canBeFolded || this.recursionCount != treeNodeUIData.recursionCount) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

