/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.profiler.ui.concurrency.EdtPromise;
import com.intellij.profiler.ui.concurrency.SupplierUnderProgressIndicator;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class EdtWorker
implements Disposable {
    private final ExecutorService myExecutor;
    private final Supplier<? extends ProgressIndicator> myIndicatorFactory;
    private final AtomicReference<ProgressIndicator> myIndicator;
    private final AtomicBoolean myDisposed;

    public EdtWorker(@NotNull ExecutorService executor) {
        if (executor == null) {
            EdtWorker.$$$reportNull$$$0(0);
        }
        this.myIndicatorFactory = () -> new EmptyProgressIndicator();
        this.myIndicator = new AtomicReference();
        this.myDisposed = new AtomicBoolean();
        this.myExecutor = executor;
    }

    @NotNull
    public <T> EdtPromise<T> updateAsync(@NotNull SupplierUnderProgressIndicator<? extends T> task2) {
        ProgressIndicator oldIndicator;
        if (task2 == null) {
            EdtWorker.$$$reportNull$$$0(1);
        }
        if (this.myDisposed.get()) {
            throw new IllegalStateException("EdtWorker has been disposed");
        }
        @NotNull ProgressIndicator newIndicator = this.myIndicatorFactory.get();
        if (newIndicator == (oldIndicator = this.myIndicator.getAndSet(newIndicator))) {
            throw new IllegalStateException("ProgressIndicator " + newIndicator + " from factory is same");
        }
        if (oldIndicator != null) {
            oldIndicator.cancel();
        }
        EdtPromiseImpl promise = new EdtPromiseImpl();
        Runnable worker = () -> {
            try {
                boolean canStart;
                boolean isCompleted = false;
                boolean bl = canStart = !this.isCancelled(newIndicator, promise);
                if (canStart) {
                    boolean canSetResult;
                    Object result2 = task2.run(newIndicator);
                    boolean bl2 = canSetResult = !this.isCancelled(newIndicator, promise);
                    if (canSetResult) {
                        promise.setResult(result2);
                        isCompleted = true;
                    }
                }
                if (!isCompleted) {
                    promise.setError(new ProcessCanceledException());
                }
            }
            catch (Throwable t) {
                promise.setError(t);
            }
        };
        this.myExecutor.execute(() -> ProgressManager.getInstance().runProcess(worker, newIndicator));
        EdtPromiseImpl edtPromiseImpl = promise;
        if (edtPromiseImpl == null) {
            EdtWorker.$$$reportNull$$$0(2);
        }
        return edtPromiseImpl;
    }

    private boolean isCancelled(ProgressIndicator indicator2, EdtPromise<?> promise) {
        return this.myIndicator.get() != indicator2 || promise.isCancelled() || this.myDisposed.get();
    }

    public void dispose() {
        ProgressIndicator indicator2;
        if (!this.myDisposed.getAndSet(true) && (indicator2 = this.myIndicator.get()) != null) {
            indicator2.cancel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ui/concurrency/EdtWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ui/concurrency/EdtWorker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateAsync";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EdtPromiseImpl<T>
    extends AsyncPromise<T>
    implements EdtPromise<T> {
        private EdtPromiseImpl() {
        }

        @Override
        @NotNull
        public EdtPromiseImpl<T> andExecute(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                EdtPromiseImpl.$$$reportNull$$$0(0);
            }
            EdtPromise edtPromise = this.andSchedule(0L, runnable2);
            if (edtPromise == null) {
                EdtPromiseImpl.$$$reportNull$$$0(1);
            }
            return edtPromise;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public EdtPromiseImpl<T> andSchedule(long delay, @NotNull Runnable runnable2) {
            void runnable3;
            if (runnable2 == null) {
                EdtPromiseImpl.$$$reportNull$$$0(2);
            }
            Runnable command = () -> this.lambda$andSchedule$0((Runnable)runnable3);
            if (delay > 0L) {
                EdtScheduledExecutorService.getInstance().schedule(command, delay, TimeUnit.MILLISECONDS);
            } else {
                EdtScheduledExecutorService.getInstance().execute(command);
            }
            EdtPromiseImpl edtPromiseImpl = this;
            if (edtPromiseImpl == null) {
                EdtPromiseImpl.$$$reportNull$$$0(3);
            }
            return edtPromiseImpl;
        }

        public void setResult(@Nullable T t) {
            UIUtil.invokeLaterIfNeeded(() -> super.setResult(t));
        }

        public boolean setError(@NotNull Throwable error2) {
            if (error2 == null) {
                EdtPromiseImpl.$$$reportNull$$$0(4);
            }
            UIUtil.invokeLaterIfNeeded(() -> super.setError(error2));
            return true;
        }

        public void cancel() {
            UIUtil.invokeLaterIfNeeded(() -> super.cancel());
        }

        private /* synthetic */ void lambda$andSchedule$0(Runnable runnable2) {
            if (!this.isDone()) {
                runnable2.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profiler/ui/concurrency/EdtWorker$EdtPromiseImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profiler/ui/concurrency/EdtWorker$EdtPromiseImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "andExecute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "andSchedule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "andExecute";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "andSchedule";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

