/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphMouseListener;", "T", "Ljava/awt/event/MouseAdapter;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "getFlameGraphPanel", "()Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "handlePopupMouseEvent", "", "e", "Ljava/awt/event/MouseEvent;", "mousePressed", "mouseReleased", "intellij.profiler.common"})
public class FlameGraphMouseListener<T>
extends MouseAdapter {
    @NotNull
    private final FlameGraphPanel<T> flameGraphPanel;
    @NotNull
    private final ActionGroup actionGroup;

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handlePopupMouseEvent(e);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.handlePopupMouseEvent(e);
    }

    protected final void handlePopupMouseEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!e.isPopupTrigger()) {
            return;
        }
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
        FlameGraphNode<Point> flameGraphNode = this.flameGraphPanel.getNodeBounds(point);
        if (flameGraphNode == null) {
            return;
        }
        FlameGraphNode<Point> nodeBounds = flameGraphNode;
        this.flameGraphPanel.setSearchEnabled(false);
        this.flameGraphPanel.selectNode(nodeBounds);
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ProfilerFlameGraph", this.actionGroup);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026FlameGraph\", actionGroup)");
        JPopupMenu jPopupMenu = actionPopupMenu.getComponent();
        boolean bl = false;
        boolean bl2 = false;
        JPopupMenu $this$apply = jPopupMenu;
        boolean bl3 = false;
        $this$apply.show((Component)((Object)this.flameGraphPanel), e.getX(), e.getY());
        this.flameGraphPanel.putClientProperty("FlameGraphPopup", $this$apply);
    }

    @NotNull
    protected final FlameGraphPanel<T> getFlameGraphPanel() {
        return this.flameGraphPanel;
    }

    @NotNull
    protected final ActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public FlameGraphMouseListener(@NotNull FlameGraphPanel<T> flameGraphPanel, @NotNull ActionGroup actionGroup2) {
        Intrinsics.checkNotNullParameter(flameGraphPanel, (String)"flameGraphPanel");
        Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
        this.flameGraphPanel = flameGraphPanel;
        this.actionGroup = actionGroup2;
    }
}

