/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.sunburst;

import com.intellij.profiler.ui.sunburst.SunburstModel;
import com.intellij.profiler.ui.sunburst.SunburstSection;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import kotlin.Metadata;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a6\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001aU\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00060\u00112\u0006\u0010\u0012\u001a\u0002H\r2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"asinFast", "", "x", "createShape", "Ljava/awt/Shape;", "section", "Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "", "y", "thickness", "adjust", "generate0", "", "T", "model", "Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "result", "", "elem", "start", "mult", "depth", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;Ljava/util/Collection;Ljava/lang/Object;DDI)V", "intellij.profiler.common"})
public final class SunburstKt {
    /*
     * WARNING - void declaration
     */
    private static final <T> void generate0(SunburstModel<T> model2, Collection<SunburstSection<T>> result2, T elem, double start2, double mult, int depth) {
        int count = model2.getChildCount(elem);
        double shift = start2;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            T child2 = model2.getChild(elem, (int)i2);
            double fraction = model2.getFraction(elem, child2) * mult;
            if (fraction != 0.0) {
                double d = fraction;
                boolean bl = false;
                if (!Double.isNaN(d)) {
                    double end = shift + fraction;
                    if (i2 == count - 1 && end > start2 + mult) {
                        end = start2 + mult;
                    }
                    result2.add(new SunburstSection<T>(child2, shift, end, depth, model2.getColor(child2)));
                    try {
                        SunburstKt.generate0(model2, result2, child2, shift, fraction, depth + 1);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        // empty catch block
                    }
                    shift += fraction;
                }
            }
            ++i2;
        }
    }

    private static final Shape createShape(SunburstSection<?> section, int x, int y, double thickness, double adjust) {
        double internalGap;
        boolean isFullTurn;
        double border = 1.0;
        double externalRadius = thickness * (double)(section.getDepth() + 1) + adjust - border;
        if (externalRadius < 0.0) {
            return null;
        }
        double startAngle = (double)-360 * section.getStart() + (double)90;
        double extentAngle = (double)360 * (section.getStart() - section.getEnd());
        boolean bl = false;
        if (0.5 * border > Math.PI * thickness * Math.abs(extentAngle) / (double)180) {
            return null;
        }
        double d = 0.0;
        double d2 = externalRadius + border - thickness;
        boolean bl2 = false;
        double internalRadius = Math.max(d, d2);
        double minLineSize = 1.0 + border;
        bl2 = false;
        double d3 = Math.PI * internalRadius * Math.abs(extentAngle) / (double)180;
        if (d3 - border < minLineSize) {
            double d4 = d3 - minLineSize;
            double d5 = 0.0;
            boolean bl3 = false;
            border = Math.max(d4, d5);
        }
        double externalGap = (double)2 * Math.toDegrees(SunburstKt.asinFast(border / externalRadius));
        boolean bl4 = false;
        boolean bl5 = isFullTurn = Math.abs(extentAngle) == 360.0;
        if (!isFullTurn) {
            startAngle -= externalGap / (double)2;
            extentAngle += externalGap / (double)2;
        }
        Arc2D.Double external = new Arc2D.Double();
        external.setArcByCenter(x, y, externalRadius, startAngle, extentAngle, isFullTurn ? 1 : 2);
        if (internalRadius <= 0.0) {
            return external;
        }
        double d6 = internalGap = internalRadius <= 0.0 ? 0.0 : (double)2 * Math.toDegrees(SunburstKt.asinFast(border / internalRadius));
        if (!isFullTurn) {
            startAngle += externalGap / (double)2 - internalGap / (double)2;
            extentAngle -= externalGap / (double)2 - internalGap / (double)2;
        }
        Arc2D.Double internal = new Arc2D.Double();
        internal.setArcByCenter(x, y, internalRadius, startAngle + extentAngle, -extentAngle, 0);
        external.setArcType(0);
        GeneralPath result2 = new GeneralPath(external);
        result2.append(internal, true);
        return result2;
    }

    private static final double asinFast(double x) {
        return x * (1.0 + x * x * (0.0 + x * x * (0.0 + x * x * 0.0)));
    }

    public static final /* synthetic */ Shape access$createShape(SunburstSection section, int x, int y, double thickness, double adjust) {
        return SunburstKt.createShape(section, x, y, thickness, adjust);
    }

    public static final /* synthetic */ void access$generate0(SunburstModel model2, Collection result2, Object elem, double start2, double mult, int depth) {
        SunburstKt.generate0(model2, result2, elem, start2, mult, depth);
    }
}

