/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.charts.ChartComponent;
import com.intellij.profiler.ui.flamegraph.AnchorViewScroller;
import com.intellij.profiler.ui.flamegraph.SmoothScrollPane;
import com.intellij.profiler.ui.flamegraph.ViewScroller;
import com.intellij.profiler.ui.timeline.DefaultTimelineCellRenderer;
import com.intellij.profiler.ui.timeline.ScrollableMouseAdapter;
import com.intellij.profiler.ui.timeline.TimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelinePanel;
import com.intellij.profiler.ui.timeline.TimelinePanel$createToolbar$;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\tQRSTUVWXYB\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u000206H\u0002J\b\u0010B\u001a\u00020@H\u0016J\b\u0010C\u001a\u00020\u0014H\u0002J\"\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010F0E2\u0006\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u0014J0\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020K2\u0006\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u00142\u0006\u0010L\u001a\u00020\u00142\u0006\u0010M\u001a\u00020\u0014H\u0002J\u0014\u0010N\u001a\u00020@*\u00020O2\u0006\u0010P\u001a\u00020OH\u0002R\u001e\u0010\u0007\u001a\u00120\bR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010\u0019R$\u0010%\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u000f\"\u0004\b'\u0010\u0011R&\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020*0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R<\u00100\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010:\u001a\u0002092\u0006\u0010\u000b\u001a\u0002098B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006Z"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "T", "F", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "model", "Lcom/intellij/profiler/ui/timeline/TimelineModel;", "(Lcom/intellij/profiler/ui/timeline/TimelineModel;)V", "chart", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyChart;", "dragPoints", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$DragPoints;", "value", "", "dragToChangeZoom", "getDragToChangeZoom", "()Z", "setDragToChangeZoom", "(Z)V", "header", "<set-?>", "", "headerHeight", "getHeaderHeight", "()I", "setHeaderHeight", "(I)V", "headerHeight$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "range", "getRange", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "setRange", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;)V", "rowHeight", "getRowHeight", "setRowHeight", "showChart", "getShowChart", "setShowChart", "stringConverter", "Lkotlin/Function1;", "", "getStringConverter", "()Lkotlin/jvm/functions/Function1;", "setStringConverter", "(Lkotlin/jvm/functions/Function1;)V", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "timelineRenderer", "getTimelineRenderer", "()Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "setTimelineRenderer", "(Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;)V", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "", "zoom", "getZoom", "()D", "setZoom", "(D)V", "addNotify", "", "createToolbar", "doLayout", "getExpectedHeight", "getIntervalsAt", "", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "x", "y", "paintSelectedArea", "g", "Ljava/awt/Graphics2D;", "width", "height", "synchronize", "Ljavax/swing/JScrollPane;", "that", "DragPoints", "MyChart", "MyMouseListener", "MyTimelineCellRendererAdapter", "MyTooltip", "MyTree", "MyTreeCellRendererAdapter", "MyTreeIterable", "MyTreeModelAdapter", "intellij.profiler.common"})
public final class TimelinePanel<T, F>
extends BorderLayoutPanel {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final MyChart chart;
    private final Tree tree;
    private final ActionToolbar toolbar;
    private final BorderLayoutPanel header;
    @NotNull
    private Function1<? super T, String> stringConverter;
    private DragPoints dragPoints;
    private final ReadWriteProperty headerHeight$delegate;
    private final TimelineModel<T, F> model;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelinePanel.class, "headerHeight", "getHeaderHeight()I", 0))};
    }

    public final int getRowHeight() {
        return this.tree.getRowHeight();
    }

    public final void setRowHeight(int value2) {
        this.tree.setRowHeight(value2);
    }

    @NotNull
    public final TimelineComponent.Range getRange() {
        return this.chart.getRange();
    }

    public final void setRange(@NotNull TimelineComponent.Range value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.chart.setRange(value2);
    }

    @NotNull
    public final Function1<T, String> getStringConverter() {
        return this.stringConverter;
    }

    public final void setStringConverter(@NotNull Function1<? super T, String> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.stringConverter = function1;
    }

    @NotNull
    public final TimelineCellRenderer<T, F> getTimelineRenderer() {
        TimelineCellRenderer timelineCellRenderer2 = this.chart.getCellRenderer();
        if (timelineCellRenderer2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.timeline.TimelinePanel<T, F>.MyTimelineCellRendererAdapter");
        }
        return ((MyTimelineCellRendererAdapter)timelineCellRenderer2).getDelegate();
    }

    public final void setTimelineRenderer(@NotNull TimelineCellRenderer<T, F> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.chart.setCellRenderer(new MyTimelineCellRendererAdapter(value2));
    }

    private final double getZoom() {
        return (double)this.chart.getWidth() / (double)this.chart.getVisibleRect().width;
    }

    private final void setZoom(double value2) {
        this.chart.setPreferredSize(new Dimension(MathKt.roundToInt((double)((double)this.chart.getVisibleRect().width * value2)), this.tree.getHeight()));
        this.chart.setSize(this.chart.getPreferredSize());
        this.chart.repaint();
    }

    private final boolean getShowChart() {
        return ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTimelineState().getShowChart();
    }

    private final void setShowChart(boolean value2) {
        ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTimelineState().setShowChart(value2);
    }

    private final boolean getDragToChangeZoom() {
        return ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTimelineState().getDragToChangeZoom();
    }

    private final void setDragToChangeZoom(boolean value2) {
        ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTimelineState().setDragToChangeZoom(value2);
    }

    private final int getHeaderHeight() {
        return ((Number)this.headerHeight$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setHeaderHeight(int n) {
        this.headerHeight$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    public void addNotify() {
        super.addNotify();
        this.revalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final ActionToolbar createToolbar() {
        void $this$apply;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        boolean bl2 = false;
        DefaultActionGroup $this$apply2 = defaultActionGroup;
        boolean bl3 = false;
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup();
        boolean bl4 = false;
        boolean bl5 = false;
        DefaultActionGroup defaultActionGroup3 = defaultActionGroup2;
        DefaultActionGroup defaultActionGroup4 = $this$apply2;
        boolean bl6 = false;
        Presentation presentation2 = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(AllIcons.Actions.Show);
        Presentation presentation3 = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"templatePresentation");
        presentation3.setText(CommonProfilerBundleKt.profilerMessage("settings.callTree.viewSettings", new Object[0]));
        $this$apply.setPopup(true);
        $this$apply.add((AnAction)new DumbAwareToggleAction(CommonProfilerBundleKt.profilerMessage("checkbox.timeline.show.chart", new Object[0]), this){
            final /* synthetic */ TimelinePanel this$0;
            {
                this.this$0 = timelinePanel;
                super($super_call_param$1);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return TimelinePanel.access$getChart$p(this.this$0).getHeader().isDatasetVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimelinePanel.access$getChart$p(this.this$0).getHeader().setDatasetVisible(state);
                TimelinePanel.access$setShowChart$p(this.this$0, state);
                this.this$0.revalidate();
            }
        });
        Unit unit = Unit.INSTANCE;
        defaultActionGroup4.add((AnAction)defaultActionGroup2);
        $this$apply2.add((AnAction)new DumbAwareAction(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.zoomIn", new Object[0]), "", AllIcons.General.ZoomIn, this){
            final /* synthetic */ TimelinePanel this$0;
            {
                this.this$0 = timelinePanel;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AnchorViewScroller scroller2 = new AnchorViewScroller((Function1<? super Rectangle, ? extends Point>)((Function1)createToolbar.group.1.actionPerformed.scroller.1.INSTANCE));
                scroller2.scroll((Component)TimelinePanel.access$getChart$p(this.this$0), (Function1)new Function1<MyChart, Unit>(this){
                    final /* synthetic */ createToolbar$$inlined$apply$lambda$2 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull MyChart it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TimelinePanel timelinePanel = this.this$0.this$0;
                        TimelinePanel.access$setZoom$p(timelinePanel, TimelinePanel.access$getZoom$p(timelinePanel) * 1.2);
                    }
                });
            }
        });
        $this$apply2.add((AnAction)new DumbAwareAction(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.zoomOut", new Object[0]), "", AllIcons.General.ZoomOut, this){
            final /* synthetic */ TimelinePanel this$0;
            {
                this.this$0 = timelinePanel;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AnchorViewScroller scroller2 = new AnchorViewScroller((Function1<? super Rectangle, ? extends Point>)((Function1)createToolbar.group.1.actionPerformed.scroller.1.INSTANCE));
                scroller2.scroll((Component)TimelinePanel.access$getChart$p(this.this$0), (Function1)new Function1<MyChart, Unit>(this){
                    final /* synthetic */ createToolbar$$inlined$apply$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull MyChart it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TimelinePanel timelinePanel = this.this$0.this$0;
                        TimelinePanel.access$setZoom$p(timelinePanel, TimelinePanel.access$getZoom$p(timelinePanel) / 1.2);
                    }
                });
            }
        });
        $this$apply2.add((AnAction)new DumbAwareAction(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.resetZoom", new Object[0]), "", AllIcons.General.ActualZoom, this){
            final /* synthetic */ TimelinePanel this$0;
            {
                this.this$0 = timelinePanel;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimelinePanel.access$setZoom$p(this.this$0, 1.0);
            }
        });
        $this$apply2.add((AnAction)new DumbAwareToggleAction(CommonProfilerBundleKt.profilerMessage("checkbox.timeline.dragToChangeZoom", new Object[0]), "", AllIcons.Graph.SnapToGrid, this){
            final /* synthetic */ TimelinePanel this$0;
            {
                this.this$0 = timelinePanel;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return TimelinePanel.access$getDragToChangeZoom$p(this.this$0);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimelinePanel.access$setDragToChangeZoom$p(this.this$0, state);
            }
        });
        DefaultActionGroup group2 = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TimelineChart", (ActionGroup)group2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026elineChart\", group, true)");
        defaultActionGroup = actionToolbar;
        bl = false;
        bl2 = false;
        DefaultActionGroup it = defaultActionGroup;
        boolean bl7 = false;
        it.setTargetComponent((JComponent)((Object)this));
        return defaultActionGroup;
    }

    public void doLayout() {
        super.doLayout();
        int expectedHeight = this.getExpectedHeight();
        if (this.getHeaderHeight() != expectedHeight) {
            this.setHeaderHeight(expectedHeight);
        }
    }

    @NotNull
    public final List<TimelineModel.TimelineInterval<F>> getIntervalsAt(int x, int y) {
        TreePath treePath = this.tree.getClosestPathForLocation(0, y);
        if (treePath == null) {
            return CollectionsKt.emptyList();
        }
        TreePath path2 = treePath;
        Rectangle bounds2 = this.tree.getPathBounds(path2);
        if (bounds2 != null && (bounds2.y > y || bounds2.y + bounds2.height < y)) {
            return CollectionsKt.emptyList();
        }
        Object object = path2.getLastPathComponent();
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object node2 = object;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(this.model.getIntervals(node2)), (Function1)new Function1<TimelineModel.TimelineInterval<F>, Boolean>(this, x){
            final /* synthetic */ TimelinePanel this$0;
            final /* synthetic */ int $x;

            public final boolean invoke(@NotNull TimelineModel.TimelineInterval<F> ti) {
                Intrinsics.checkNotNullParameter(ti, (String)"ti");
                return TimelinePanel.access$getChart$p(this.this$0).toScreenCoordinate(ti.getStart()) <= this.$x && this.$x <= TimelinePanel.access$getChart$p(this.this$0).toScreenCoordinate(ti.getEnd());
            }
            {
                this.this$0 = timelinePanel;
                this.$x = n;
                super(1);
            }
        }));
    }

    private final int getExpectedHeight() {
        int multiplier = this.chart.getHeader().isDatasetVisible() ? 3 : 1;
        JComponent jComponent = this.toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        return multiplier * jComponent.getHeight() + 1;
    }

    private final void paintSelectedArea(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(ColorUtil.withAlpha((Color)UIUtil.getTreeBackground((boolean)true, (this.tree.hasFocus() || this.chart.hasFocus() ? 1 : 0) != 0), (double)0.5));
        g.fillRect(x, y, width, height);
    }

    private final void synchronize(JScrollPane $this$synchronize, JScrollPane that) {
        $this$synchronize.setHorizontalScrollBarPolicy(32);
        that.setHorizontalScrollBarPolicy(32);
        that.setVerticalScrollBar($this$synchronize.getVerticalScrollBar());
    }

    public TimelinePanel(@NotNull TimelineModel<T, F> model2) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        this.model = model2;
        this.chart = new MyChart();
        this.tree = new MyTree();
        this.header = new BorderLayoutPanel();
        this.stringConverter = stringConverter.1.INSTANCE;
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = JBUI.getInt((String)"TableHeader.height", (int)25);
        boolean $i$f$observable = false;
        this.headerHeight$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ TimelinePanel this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = timelinePanel;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property2, Object oldValue, Object newValue2) {
                void newValue3;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                int n = ((Number)newValue2).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property2;
                boolean bl = false;
                TimelinePanel.access$getChart$p(this.this$0).setHeaderHeight((int)newValue3);
                TimelinePanel.access$getHeader$p(this.this$0).setPreferredSize(new Dimension(0, (int)newValue3));
                TimelinePanel.access$getHeader$p(this.this$0).revalidate();
            }
        };
        this.toolbar = this.createToolbar();
        OnePixelSplitter splitter = new OnePixelSplitter(0.2f);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane(tree)");
        JScrollPane treeWrapper = jScrollPane;
        treeWrapper.setBorder((Border)JBUI.Borders.empty());
        BorderLayoutPanel firstComponentPane = new BorderLayoutPanel();
        this.header.addToTop((Component)this.toolbar.getComponent());
        this.header.setBorder(JBUI.Borders.customLine((Color)UIUtil.getBoundsColor(), (int)0, (int)0, (int)1, (int)0));
        firstComponentPane.addToTop((Component)this.header);
        firstComponentPane.addToCenter((Component)treeWrapper);
        splitter.setFirstComponent((JComponent)firstComponentPane);
        SmoothScrollPane chartWrapper2 = new SmoothScrollPane<TimelineComponent<T, F>>(this, this.chart){
            final /* synthetic */ TimelinePanel this$0;

            public double getCurrentZoom() {
                return TimelinePanel.access$getZoom$p(this.this$0);
            }

            public void changeZoom(@NotNull ViewScroller scroller2, @NotNull Function1<? super Double, Double> eval) {
                Intrinsics.checkNotNullParameter((Object)scroller2, (String)"scroller");
                Intrinsics.checkNotNullParameter(eval, (String)"eval");
                scroller2.scroll(this.getComponent(), (Function1)new Function1<TimelineComponent<T, F>, Unit>(this, eval){
                    final /* synthetic */ chartWrapper.1 this$0;
                    final /* synthetic */ Function1 $eval;

                    public final void invoke(@NotNull TimelineComponent<T, F> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        TimelinePanel.access$setZoom$p(this.this$0.this$0, ((Number)this.$eval.invoke((Object)TimelinePanel.access$getZoom$p(this.this$0.this$0))).doubleValue());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$eval = function1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        chartWrapper2.setBorder((Border)JBUI.Borders.empty());
        splitter.setSecondComponent((JComponent)((Object)chartWrapper2));
        this.synchronize(treeWrapper, (JScrollPane)((Object)chartWrapper2));
        this.addToCenter((Component)splitter);
        this.tree.putClientProperty((Object)RenderingUtil.FOCUSABLE_SIBLING, (Object)this.chart);
        this.chart.putClientProperty(RenderingUtil.FOCUSABLE_SIBLING, this.tree);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                chart.repaint();
            }
        });
        this.tree.setCellRenderer((TreeCellRenderer)new MyTreeCellRendererAdapter());
        MyMouseListener listener2 = new MyMouseListener();
        this.chart.setCellRenderer(new MyTimelineCellRendererAdapter(new DefaultTimelineCellRenderer()));
        this.chart.setMinimumSize(new Dimension(0, 0));
        this.chart.addMouseListener(listener2);
        this.chart.addMouseMotionListener(listener2);
        this.chart.addMouseWheelListener(listener2);
        this.chart.setBorder(this.tree.getBorder());
        this.chart.getHeader().setDatasetVisible(this.getShowChart());
        this.chart.setFocusable(true);
        this.chart.addKeyListener(listener2);
        this.chart.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, listener2);
        List<ChartComponent> list2 = this.chart.getHeader().getChart().getOverlays();
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.charts.ChartComponent>");
        }
        TypeIntrinsics.asMutableList(list2).add(new ChartComponent(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void paintComponent(@NotNull Graphics2D g) {
                block0: {
                    void from2;
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    DragPoints dragPoints = dragPoints;
                    if (dragPoints == null) break block0;
                    DragPoints dragPoints2 = dragPoints;
                    boolean bl = false;
                    boolean bl2 = false;
                    DragPoints $dstr$from$to = dragPoints2;
                    boolean bl3 = false;
                    Point point = $dstr$from$to.component1();
                    Point to = $dstr$from$to.component2();
                    Rectangle visibleRect = chart.getVisibleRect();
                    int n = from2.x;
                    int n2 = to.x;
                    int n3 = 0;
                    int x = Math.min(n, n2) - visibleRect.x;
                    n2 = from2.x;
                    n3 = to.x;
                    boolean bl4 = false;
                    int width = Math.max(n2, n3) - x - visibleRect.x;
                    this.paintSelectedArea(g, x, 0, width, chart.getHeaderHeight());
                }
            }
        });
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        boolean bl = false;
        final HashSet cyclingDetector = new HashSet();
        FilteredTraverserBase filteredTraverserBase = JBTreeTraverser.from((Function)new Function(){

            public final Iterable<T> fun(final T parent) {
                return cyclingDetector.add(parent) ? (Iterable)JBIterable.create((Supplier)new Supplier(){

                    public final Iterator<T> get() {
                        return IntStream.range(0, model.getChildCount(parent)).mapToObj(new IntFunction(){

                            public final T apply(int it) {
                                return model.getChild(parent, it);
                            }
                        }).iterator();
                    }
                }) : (Iterable)JBIterable.empty();
            }
        }).withRoot(this.model.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"JBTreeTraverser.from<T> \u2026withRoot(model.getRoot())");
        Iterable $this$forEach$iv = (Iterable)filteredTraverserBase;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object node2 = element$iv = iterator2.next();
            boolean bl2 = false;
            Iterable<TimelineModel.TimelineInterval<F>> $this$forEach$iv2 = this.model.getIntervals(node2);
            boolean $i$f$forEach2 = false;
            Iterator<TimelineModel.TimelineInterval<F>> iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                TimelineModel.TimelineInterval<F> element$iv2;
                TimelineModel.TimelineInterval<F> interval = element$iv2 = iterator3.next();
                boolean bl3 = false;
                if (minTime > interval.getStart()) {
                    minTime = interval.getStart();
                }
                if (maxTime >= interval.getEnd()) continue;
                maxTime = interval.getEnd();
            }
        }
        if (minTime <= maxTime) {
            this.setRange(new TimelineComponent.Range(minTime, maxTime));
        }
    }

    public static final /* synthetic */ void access$setDragToChangeZoom$p(TimelinePanel $this, boolean bl) {
        $this.setDragToChangeZoom(bl);
    }

    public static final /* synthetic */ double access$getZoom$p(TimelinePanel $this) {
        return $this.getZoom();
    }

    public static final /* synthetic */ boolean access$getShowChart$p(TimelinePanel $this) {
        return $this.getShowChart();
    }

    public static final /* synthetic */ void access$setShowChart$p(TimelinePanel $this, boolean bl) {
        $this.setShowChart(bl);
    }

    public static final /* synthetic */ BorderLayoutPanel access$getHeader$p(TimelinePanel $this) {
        return $this.header;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016R,\u0010\u0004\u001a\u0014\u0018\u00010\u0005R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyMouseListener;", "Lcom/intellij/profiler/ui/timeline/ScrollableMouseAdapter;", "Ljava/awt/event/KeyListener;", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "lastTooltipShown", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;", "Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "getLastTooltipShown", "()Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;", "setLastTooltipShown", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;)V", "popupComponent", "Lcom/intellij/ui/components/JBLabel;", "clearDragSelection", "", "convertMouseEvent", "Ljava/awt/event/MouseEvent;", "e", "withId", "", "keyPressed", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyTyped", "magnify", "Ljava/awt/Point;", "scale", "", "at", "mouseClicked", "mouseDragged", "event", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "intellij.profiler.common"})
    private final class MyMouseListener
    extends ScrollableMouseAdapter
    implements KeyListener {
        private final JBLabel popupComponent = new JBLabel();
        @Nullable
        private MyTooltip lastTooltipShown;

        @Nullable
        public final MyTooltip getLastTooltipShown() {
            return this.lastTooltipShown;
        }

        public final void setLastTooltipShown(@Nullable MyTooltip myTooltip) {
            this.lastTooltipShown = myTooltip;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TimelinePanel.this.chart.requestFocus(true);
            if (event.getButton() == 1 && (event.isControlDown() || TimelinePanel.this.getDragToChangeZoom())) {
                Point point = event.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"event.point");
                TimelinePanel.this.dragPoints = new DragPoints(point);
            } else {
                super.mousePressed(event);
            }
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (TimelinePanel.this.dragPoints != null) {
                Object object;
                Rectangle visibleRect = TimelinePanel.this.chart.getVisibleRect();
                Object object2 = TimelinePanel.this.dragPoints;
                if (object2 != null && (object2 = ((DragPoints)object2).getTo()) != null) {
                    int n = event.getX();
                    int n2 = visibleRect.x;
                    boolean bl = false;
                    n = Math.max(n, n2);
                    n2 = visibleRect.x + visibleRect.width;
                    bl = false;
                    ((Point)object2).x = Math.min(n, n2);
                }
                if ((object = TimelinePanel.this.dragPoints) != null && (object = ((DragPoints)object).getTo()) != null) {
                    ((Point)object).y = event.getY();
                }
                TimelinePanel.this.repaint();
            } else {
                super.mouseDragged(event);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DragPoints dragPoints = TimelinePanel.this.dragPoints;
            if (dragPoints != null) {
                TimelinePanel.this.dragPoints = null;
                Rectangle visibleRect = TimelinePanel.this.chart.getVisibleRect();
                int sourceWidth = TimelinePanel.this.chart.getWidth();
                int n = dragPoints.getFrom().x - dragPoints.getTo().x;
                boolean bl = false;
                int targetWidth = Math.abs(n);
                if (targetWidth < 10) {
                    TimelinePanel.this.repaint();
                    return;
                }
                double targetZoom = (double)sourceWidth / (double)targetWidth;
                int n2 = dragPoints.getFrom().x;
                int n3 = dragPoints.getTo().x;
                boolean bl2 = false;
                long time = TimelinePanel.this.chart.toWorldCoordinate(Math.min(n2, n3));
                TimelinePanel.this.setZoom(targetZoom);
                visibleRect.x = TimelinePanel.this.chart.toScreenCoordinate(time);
                TimelinePanel.this.chart.scrollRectToVisible(visibleRect);
            } else {
                super.mouseReleased(event);
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreePath location = TimelinePanel.this.tree.getClosestPathForLocation(0, e.getY());
            if (location != null) {
                TimelinePanel.this.tree.dispatchEvent((AWTEvent)this.convertMouseEvent(e, 501));
            }
        }

        private final MouseEvent convertMouseEvent(MouseEvent e, int withId) {
            Point p = e.getPoint();
            SwingUtilities.convertPoint(e.getComponent(), p, (Component)TimelinePanel.this.tree);
            return new MouseEvent((Component)TimelinePanel.this.tree, withId, e.getWhen(), e.getModifiers(), p.x, p.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        static /* synthetic */ MouseEvent convertMouseEvent$default(MyMouseListener myMouseListener, MouseEvent mouseEvent, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = mouseEvent.getID();
            }
            return myMouseListener.convertMouseEvent(mouseEvent, n);
        }

        @Override
        @NotNull
        public Point magnify(double scale, @NotNull Point at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            AnchorViewScroller scroller2 = new AnchorViewScroller((Function1<? super Rectangle, ? extends Point>)((Function1)new Function1<Rectangle, Point>(at){
                final /* synthetic */ Point $at;

                @NotNull
                public final Point invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$at;
                }
                {
                    this.$at = point;
                    super(1);
                }
            }));
            scroller2.scroll((Component)TimelinePanel.this.chart, (Function1)new Function1<MyChart, Unit>(this, scale){
                final /* synthetic */ MyMouseListener this$0;
                final /* synthetic */ double $scale;

                public final void invoke(@NotNull MyChart it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    TimelinePanel timelinePanel = this.this$0.TimelinePanel.this;
                    TimelinePanel.access$setZoom$p(timelinePanel, TimelinePanel.access$getZoom$p(timelinePanel) * this.$scale);
                }
                {
                    this.this$0 = myMouseListener;
                    this.$scale = d;
                    super(1);
                }
            });
            return new Point(MathKt.roundToInt((double)((double)at.x * scale)), at.y);
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (TimelinePanel.this.dragPoints != null && e.getKeyCode() == 27) {
                this.clearDragSelection();
                e.consume();
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getKeyCode() == 17) {
                this.clearDragSelection();
            }
        }

        private final void clearDragSelection() {
            TimelinePanel.this.dragPoints = null;
            TimelinePanel.this.repaint();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            TimelineModel.TimelineInterval element2;
            TimelineModel.TimelineInterval timelineInterval;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List list2 = TimelinePanel.this.getIntervalsAt(e.getX(), e.getY());
            if (list2.size() > 1) {
                long mouse = TimelinePanel.this.chart.toWorldCoordinate(e.getX());
                Iterable iterable = list2;
                Comparator comparator2 = Comparator.comparingLong(new ToLongFunction(mouse){
                    final /* synthetic */ long $mouse;

                    public final long applyAsLong(TimelineModel.TimelineInterval<F> it) {
                        long mid = (it.getStart() + it.getEnd()) / (long)2;
                        long l = mid - this.$mouse;
                        boolean bl = false;
                        return Math.abs(l);
                    }
                    {
                        this.$mouse = l;
                    }
                }).thenComparingLong(mouseMoved.element.2.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Comparator.comparingLong\u2026 abs(it.end - it.start) }");
                timelineInterval = (TimelineModel.TimelineInterval)CollectionsKt.minWithOrNull((Iterable)iterable, comparator2);
            } else {
                timelineInterval = element2 = (TimelineModel.TimelineInterval)CollectionsKt.firstOrNull(list2);
            }
            if (element2 != null) {
                this.popupComponent.setText(TimelinePanel.this.getTimelineRenderer().getTooltipText(element2));
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                this.lastTooltipShown = new MyTooltip(point, (JComponent)this.popupComponent);
                IdeTooltipManager.getInstance().show(this.lastTooltipShown, false, false);
            } else {
                IdeTooltipManager.getInstance().hide(this.lastTooltipShown);
                this.lastTooltipShown = null;
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MyTooltip myTooltip = this.lastTooltipShown;
            if (myTooltip != null) {
                MyTooltip myTooltip2 = myTooltip;
                IdeTooltipManager ideTooltipManager = IdeTooltipManager.getInstance();
                boolean bl = false;
                boolean bl2 = false;
                IdeTooltip p1 = myTooltip2;
                boolean bl3 = false;
                ideTooltipManager.hide(p1);
            }
            this.lastTooltipShown = null;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;", "Lcom/intellij/ide/IdeTooltip;", "point", "Ljava/awt/Point;", "tipComponent", "Ljavax/swing/JComponent;", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Ljava/awt/Point;Ljavax/swing/JComponent;)V", "getDismissDelay", "", "getShowDelay", "intellij.profiler.common"})
    private final class MyTooltip
    extends IdeTooltip {
        @Override
        public int getShowDelay() {
            return 500;
        }

        @Override
        public int getDismissDelay() {
            return Integer.MAX_VALUE;
        }

        public MyTooltip(@NotNull Point point, JComponent tipComponent) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter((Object)tipComponent, (String)"tipComponent");
            super(TimelinePanel.this.chart, point, tipComponent, new Object[0]);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u00028\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTreeModelAdapter;", "T", "Lcom/intellij/util/ui/tree/AbstractTreeModel;", "Ljavax/swing/tree/TreeModel;", "model", "Lcom/intellij/profiler/ui/timeline/TimelineModel;", "(Lcom/intellij/profiler/ui/timeline/TimelineModel;)V", "getChild", "parent", "", "index", "", "(Ljava/lang/Object;I)Ljava/lang/Object;", "getChildCount", "getIndexOfChild", "child", "getRoot", "isLeaf", "", "node", "intellij.profiler.common"})
    private static final class MyTreeModelAdapter<T>
    extends AbstractTreeModel
    implements TreeModel {
        private final TimelineModel<T, ?> model;

        @Override
        @Nullable
        public Object getRoot() {
            return this.model.getRoot();
        }

        @Override
        public boolean isLeaf(@NotNull Object node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            return this.model.isLeaf(node2);
        }

        @Override
        public int getChildCount(@NotNull Object parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return this.model.getChildCount(parent);
        }

        @Override
        public int getIndexOfChild(@NotNull Object parent, @NotNull Object child2) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
            return this.model.getIndexOfChild(parent, child2);
        }

        public T getChild(@Nullable Object parent, int index2) {
            return (T)this.model.getChild(parent, index2);
        }

        public MyTreeModelAdapter(@NotNull TimelineModel<T, ?> model2) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            this.model = model2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTreeCellRendererAdapter;", "Ljavax/swing/tree/TreeCellRenderer;", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "renderException", "Lcom/intellij/ui/components/JBLabel;", "getRenderException$annotations", "()V", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.profiler.common"})
    private final class MyTreeCellRendererAdapter
    implements TreeCellRenderer {
        private final JBLabel renderException = new JBLabel("Render exception");

        private static /* synthetic */ void getRenderException$annotations() {
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, @Nullable Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Component component2;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            try {
                Component result2 = TimelinePanel.this.getTimelineRenderer().getNodeRendererComponent(TimelinePanel.this, value2, selected2, hasFocus);
                result2.setForeground(RenderingUtil.getForeground((JTree)tree, (boolean)selected2));
                result2.setBackground(RenderingUtil.getBackground((JTree)tree, (boolean)selected2));
                component2 = result2;
            }
            catch (Exception e) {
                component2 = (Component)this.renderException;
            }
            return component2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0096\u0001\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J1\u0010\u0013\u001a\u00020\u00142\u0010\u0010\b\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTimelineCellRendererAdapter;", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "delegate", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;)V", "getDelegate", "()Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "getNodeRendererComponent", "Ljava/awt/Component;", "panel", "Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "value", "isSelected", "", "hasFocus", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Ljava/lang/Object;ZZ)Ljava/awt/Component;", "getSelectionBackground", "Ljava/awt/Color;", "row", "", "paint", "", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "g", "Ljava/awt/Graphics2D;", "node", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "intellij.profiler.common"})
    private final class MyTimelineCellRendererAdapter
    implements TimelineCellRenderer<T, F> {
        @NotNull
        private final TimelineCellRenderer<T, F> delegate;

        @Override
        public boolean isSelected(int row2) {
            return TimelinePanel.this.tree.isRowSelected(row2);
        }

        @Override
        @NotNull
        public Color getSelectionBackground() {
            Color color = UIUtil.getTreeBackground((boolean)true, (TimelinePanel.this.tree.hasFocus() || TimelinePanel.this.chart.hasFocus() ? 1 : 0) != 0);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"UIUtil.getTreeBackground\u2026us() || chart.hasFocus())");
            return color;
        }

        @NotNull
        public final TimelineCellRenderer<T, F> getDelegate() {
            return this.delegate;
        }

        public MyTimelineCellRendererAdapter(TimelineCellRenderer<T, F> delegate2) {
            Intrinsics.checkNotNullParameter(delegate2, (String)"delegate");
            this.delegate = delegate2;
        }

        @Override
        @NotNull
        public Component getNodeRendererComponent(@NotNull TimelinePanel<T, ?> panel2, T value2, boolean isSelected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            return this.delegate.getNodeRendererComponent(panel2, value2, isSelected, hasFocus);
        }

        @Override
        public void paint(@NotNull TimelineComponent<?, F> panel2, @NotNull Graphics2D g, @NotNull TimelineModel.TimelineInterval<F> node2) {
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter(node2, (String)"node");
            this.delegate.paint(panel2, g, node2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTreeIterable;", "T", "", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "iterator", "", "intellij.profiler.common"})
    private final class MyTreeIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<T> iterator() {
            Rectangle rectangle = TimelinePanel.this.tree.getVisibleRect();
            boolean bl = false;
            boolean bl2 = false;
            Rectangle $this$apply = rectangle;
            boolean bl3 = false;
            $this$apply.y += ((TimelinePanel)TimelinePanel.this).tree.getInsets().top;
            Rectangle visibleRect = rectangle;
            int fromIndex = TimelinePanel.this.tree.getClosestRowForLocation(visibleRect.x, visibleRect.y);
            int toIndex = TimelinePanel.this.tree.getClosestRowForLocation(visibleRect.x, visibleRect.y + visibleRect.height);
            if (fromIndex < 0 || toIndex < 0) {
                Iterator iterator2 = Collections.emptyIterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"Collections.emptyIterator()");
                return iterator2;
            }
            return new Iterator<T>(this, toIndex, fromIndex){
                private int cursor;
                final /* synthetic */ MyTreeIterable this$0;
                final /* synthetic */ int $toIndex;
                final /* synthetic */ int $fromIndex;

                public final int getCursor() {
                    return this.cursor;
                }

                public final void setCursor(int n) {
                    this.cursor = n;
                }

                public boolean hasNext() {
                    return this.cursor <= this.$toIndex;
                }

                public T next() {
                    int n = this.cursor;
                    this.cursor = n + 1;
                    TreePath treePath = TimelinePanel.access$getTree$p(this.this$0.TimelinePanel.this).getPathForRow(n);
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"tree.getPathForRow(cursor++)");
                    return (T)treePath.getLastPathComponent();
                }
                {
                    this.this$0 = this$0;
                    this.$toIndex = $captured_local_variable$1;
                    this.$fromIndex = $captured_local_variable$2;
                    this.cursor = $captured_local_variable$2;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyChart;", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "value", "", "rowHeight", "getRowHeight", "()I", "setRowHeight", "(I)V", "getInsets", "Ljava/awt/Insets;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.profiler.common"})
    private final class MyChart
    extends TimelineComponent<T, F> {
        @Override
        @NotNull
        public Insets getInsets() {
            Insets insets = TimelinePanel.this.tree.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"tree.insets");
            return insets;
        }

        @Override
        public int getRowHeight() {
            return TimelinePanel.this.tree.getRowHeight();
        }

        @Override
        public void setRowHeight(int value2) {
            TimelinePanel.this.tree.setRowHeight(value2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            DragPoints dragPoints = TimelinePanel.this.dragPoints;
            if (dragPoints != null) {
                void from2;
                DragPoints dragPoints2 = dragPoints;
                boolean bl = false;
                boolean bl2 = false;
                DragPoints $dstr$from$to = dragPoints2;
                boolean bl3 = false;
                Point point = $dstr$from$to.component1();
                Point to = $dstr$from$to.component2();
                int n = from2.x;
                int n2 = to.x;
                int n3 = 0;
                int x = Math.min(n, n2);
                n2 = from2.x;
                n3 = to.x;
                boolean bl4 = false;
                int width = Math.max(n2, n3) - x;
                TimelinePanel.this.paintSelectedArea(g2d, x, ((TimelinePanel)TimelinePanel.this).chart.getVisibleRect().y, width, ((TimelinePanel)TimelinePanel.this).chart.getVisibleRect().height);
            }
            g2d.dispose();
        }

        public MyChart() {
            super(TimelinePanel.this.model, new MyTreeIterable());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTree;", "Lcom/intellij/ui/treeStructure/Tree;", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "repaint", "", "tm", "", "x", "", "y", "width", "height", "treeDidChange", "intellij.profiler.common"})
    private final class MyTree
    extends Tree {
        public void treeDidChange() {
            JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)TimelinePanel.this.chart);
            if (jScrollPane != null) {
                JScrollPane jScrollPane2 = jScrollPane;
                boolean bl = false;
                boolean bl2 = false;
                JScrollPane it = jScrollPane2;
                boolean bl3 = false;
                Rectangle bounds2 = TimelinePanel.this.chart.getBounds();
                TimelinePanel.this.chart.setPreferredSize(new Dimension(((TimelinePanel)TimelinePanel.this).chart.getPreferredSize().width, this.getPreferredSize().height));
                TimelinePanel.this.chart.setBounds(new Rectangle(bounds2.x, bounds2.y, ((TimelinePanel)TimelinePanel.this).chart.getPreferredSize().width, ((TimelinePanel)TimelinePanel.this).chart.getPreferredSize().height));
                TimelinePanel.this.chart.revalidate();
                TimelinePanel.this.chart.repaint();
            }
            super.treeDidChange();
        }

        public void repaint(long tm, int x, int y, int width, int height) {
            TimelinePanel.this.repaint(tm, 0, y, TimelinePanel.this.getWidth(), height);
        }

        /*
         * WARNING - void declaration
         */
        public MyTree() {
            boolean bl;
            block4: {
                super((TreeModel)new MyTreeModelAdapter(TimelinePanel.this.model));
                TreeModel treeModel = this.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"model");
                Object object = treeModel.getRoot();
                if (object != null) {
                    Object object2 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    int n = 0;
                    int n2 = this.getModel().getChildCount(it);
                    while (n < n2) {
                        void i2;
                        if (!this.getModel().isLeaf(this.getModel().getChild(it, (int)i2))) {
                            bl = false;
                            break block4;
                        }
                        ++i2;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
            }
            boolean isListView = bl;
            this.setRootVisible(!isListView);
            this.setBorder(isListView ? (Border)JBUI.Borders.empty((int)1, (int)-11, (int)1, (int)0) : (Border)JBUI.Borders.empty((int)1, (int)4, (int)1, (int)0));
            int defaultRowHeight = UIManager.getInt("Tree.rowHeight");
            this.rowHeight = defaultRowHeight < 1 ? JBUIScale.scale((int)20) : defaultRowHeight;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\n\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u000b\u001a\u00020\u0003H\u0086\u0002R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$DragPoints;", "", "startPont", "Ljava/awt/Point;", "(Ljava/awt/Point;)V", "from", "getFrom", "()Ljava/awt/Point;", "to", "getTo", "component1", "component2", "intellij.profiler.common"})
    private static final class DragPoints {
        @NotNull
        private final Point from;
        @NotNull
        private final Point to;

        @NotNull
        public final Point getFrom() {
            return this.from;
        }

        @NotNull
        public final Point getTo() {
            return this.to;
        }

        @NotNull
        public final Point component1() {
            return this.from;
        }

        @NotNull
        public final Point component2() {
            return this.to;
        }

        public DragPoints(@NotNull Point startPont) {
            Intrinsics.checkNotNullParameter((Object)startPont, (String)"startPont");
            this.from = new Point();
            this.to = new Point();
            this.from.x = startPont.x;
            this.from.y = startPont.y;
            this.to.x = startPont.x;
            this.to.y = startPont.y;
        }
    }
}

