/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.HashSet;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class DefaultTreeTableCellRenderer
implements TableCellRenderer {
    private Border myBorder;
    @NotNull
    private final TableCellRenderer myDelegate;

    public DefaultTreeTableCellRenderer(@NotNull TableCellRenderer delegate2) {
        if (delegate2 == null) {
            DefaultTreeTableCellRenderer.$$$reportNull$$$0(0);
        }
        this.myBorder = JBUI.Borders.empty((int)1);
        this.myDelegate = delegate2;
    }

    public void setBorder(Border border) {
        this.myBorder = border;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
        Component component2 = this.myDelegate.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
        component2.setBackground(UIUtil.getTableBackground((boolean)isSelected, (boolean)RenderingUtil.isFocused((JComponent)table)));
        component2.setForeground(UIUtil.getTableForeground((boolean)isSelected, (boolean)RenderingUtil.isFocused((JComponent)table)));
        ((JComponent)component2).setBorder(this.myBorder);
        return component2;
    }

    public static void install(JBTreeTable table) {
        DefaultTreeTableCellRenderer.install(table, DefaultTreeTableCellRenderer::new);
    }

    public static void install(JBTreeTable table, Function<? super TableCellRenderer, ? extends TableCellRenderer> delegate2) {
        TableModel model2 = table.getTable().getModel();
        HashSet installed = new HashSet();
        for (int i2 = 0; i2 < model2.getColumnCount(); ++i2) {
            Class<?> columnClass = model2.getColumnClass(i2);
            if (!installed.add(columnClass)) continue;
            TableCellRenderer renderer2 = table.getDefaultRenderer(columnClass);
            table.setDefaultRenderer(columnClass, delegate2.apply(renderer2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/profiler/ui/treetable/DefaultTreeTableCellRenderer", "<init>"));
    }
}

