/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsMigrationListener;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsMigrationNotifier
implements CodeStyleSettingsMigrationListener {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Code style settings migration", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginId.getId((String)"com.intellij"));

    public void codeStyleSettingsMigrated(@NotNull Project project) {
        if (project == null) {
            CodeStyleSettingsMigrationNotifier.$$$reportNull$$$0(0);
        }
        CodeStyleSettingsMigrationNotifier.doNotify(project);
    }

    private static void doNotify(@NotNull Project project) {
        if (project == null) {
            CodeStyleSettingsMigrationNotifier.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            CodeStyleMigrationNotification notification = new CodeStyleMigrationNotification(project.getName());
            notification.notify(project);
        }, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsMigrationNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "codeStyleSettingsMigrated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doNotify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ShowMoreInfoAction
    extends DumbAwareAction {
        ShowMoreInfoAction() {
            super(IdeBundle.messagePointer((String)"action.ProjectCodeStyleSettingsManager.ShowMoreInfoAction.text.more.info", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowMoreInfoAction.$$$reportNull$$$0(0);
            }
            BrowserUtil.open((String)"https://confluence.jetbrains.com/display/IDEADEV/New+project+code+style+settings+format+in+2017.3");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/codeStyle/CodeStyleSettingsMigrationNotifier$ShowMoreInfoAction", "actionPerformed"));
        }
    }

    private static class CodeStyleMigrationNotification
    extends Notification {
        CodeStyleMigrationNotification(@NotNull String projectName) {
            if (projectName == null) {
                CodeStyleMigrationNotification.$$$reportNull$$$0(0);
            }
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message((String)"project.code.style.migration.title", (Object[])new Object[0]), ApplicationBundle.message((String)"project.code.style.migration.message", (Object[])new Object[]{projectName}), NotificationType.INFORMATION);
            this.addAction((AnAction)new ShowMoreInfoAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/intellij/psi/codeStyle/CodeStyleSettingsMigrationNotifier$CodeStyleMigrationNotification", "<init>"));
        }
    }
}

