/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.IgnorePsiEventsMarker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PsiToDocumentSynchronizer {
    private static final Logger LOG = Logger.getInstance(PsiToDocumentSynchronizer.class);
    private static final Key<Boolean> PSI_DOCUMENT_ATOMIC_ACTION = Key.create((String)"PSI_DOCUMENT_ATOMIC_ACTION");
    private final PsiDocumentManagerBase myPsiDocumentManager;
    private final MessageBus myBus;
    private final Map<Document, Pair<DocumentChangeTransaction, Integer>> myTransactionsMap;
    private volatile Document mySyncDocument;
    private boolean myIgnorePsiEvents;

    PsiToDocumentSynchronizer(@NotNull PsiDocumentManagerBase psiDocumentManager, @NotNull MessageBus bus) {
        if (psiDocumentManager == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(1);
        }
        this.myTransactionsMap = new ConcurrentHashMap<Document, Pair<DocumentChangeTransaction, Integer>>();
        this.myPsiDocumentManager = psiDocumentManager;
        this.myBus = bus;
    }

    @Nullable
    public DocumentChangeTransaction getTransaction(@NotNull Document document) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(2);
        }
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(document);
        return (DocumentChangeTransaction)Pair.getFirst(pair);
    }

    public boolean isInSynchronization(@NotNull Document document) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(3);
        }
        return this.mySyncDocument == document;
    }

    @TestOnly
    void cleanupForNextTest() {
        this.myTransactionsMap.clear();
        this.mySyncDocument = null;
    }

    private void checkPsiModificationAllowed(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(4);
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
            throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
        }
    }

    private DocumentEx getCachedDocument(PsiFile psiFile, boolean force) {
        DocumentEx document = (DocumentEx)FileDocumentManager.getInstance().getCachedDocument(psiFile.getViewProvider().getVirtualFile());
        if (document == null || document instanceof DocumentWindow || !force && this.getTransaction(document) == null) {
            return null;
        }
        return document;
    }

    private void doSync(@NotNull PsiTreeChangeEvent event, @NotNull DocSyncAction syncAction) {
        if (event == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(5);
        }
        if (syncAction == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(6);
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        DocumentEx document = this.getCachedDocument(psiFile, true);
        if (document == null) {
            return;
        }
        PsiToDocumentSynchronizer.performAtomically(psiFile, () -> syncAction.syncDocument(document, (PsiTreeChangeEventImpl)event));
        boolean insideTransaction = this.myTransactionsMap.containsKey(document);
        if (!insideTransaction) {
            document.setModificationStamp(psiFile.getViewProvider().getModificationStamp());
        }
    }

    static boolean isInsideAtomicChange(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(7);
        }
        return file2.getUserData(PSI_DOCUMENT_ATOMIC_ACTION) == Boolean.TRUE;
    }

    public static void performAtomically(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(8);
        }
        if (runnable2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(9);
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        assert (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2));
        file2.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, (Object)Boolean.TRUE);
        try {
            runnable2.run();
        }
        finally {
            file2.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, null);
        }
    }

    public void setIgnorePsiEvents(boolean ignorePsiEvents) {
        this.myIgnorePsiEvents = ignorePsiEvents;
    }

    public boolean isIgnorePsiEvents() {
        return this.myIgnorePsiEvents;
    }

    public boolean toProcessPsiEvent() {
        return !this.myIgnorePsiEvents && !this.myPsiDocumentManager.isCommitInProgress() && !ApplicationManager.getApplication().hasWriteAction(IgnorePsiEventsMarker.class);
    }

    @TestOnly
    public void replaceString(@NotNull Document document, int startOffset, int endOffset, @NotNull String s) {
        DocumentChangeTransaction documentChangeTransaction;
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(10);
        }
        if (s == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(11);
        }
        if ((documentChangeTransaction = this.getTransaction(document)) != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, s, null);
        }
    }

    @TestOnly
    public void insertString(@NotNull Document document, int offset, @NotNull String s) {
        DocumentChangeTransaction documentChangeTransaction;
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(12);
        }
        if (s == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(13);
        }
        if ((documentChangeTransaction = this.getTransaction(document)) != null) {
            documentChangeTransaction.replace(offset, 0, s, null);
        }
    }

    public void startTransaction(@NotNull Project project, @NotNull Document doc, @NotNull PsiFile scope2) {
        Pair pair;
        if (project == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(14);
        }
        if (doc == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(15);
        }
        if (scope2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(16);
        }
        LOG.assertTrue(!project.isDisposed());
        Pair prev2 = pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            PsiFile psiFile = scope2.getContainingFile();
            pair = new Pair((Object)new DocumentChangeTransaction(doc, psiFile), (Object)0);
            if (scope2.isPhysical()) {
                ((PsiDocumentTransactionListener)this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC)).transactionStarted(doc, psiFile);
            }
        } else {
            pair = new Pair((Object)((DocumentChangeTransaction)pair.getFirst()), (Object)((Integer)pair.getSecond() + 1));
        }
        LOG.assertTrue(this.myTransactionsMap.put(doc, (Pair<DocumentChangeTransaction, Integer>)pair) == prev2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(@NotNull Document document) {
        DocumentChangeTransaction documentChangeTransaction;
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(17);
        }
        if ((documentChangeTransaction = this.removeTransaction(document)) == null) {
            return false;
        }
        PsiFile changeScope = documentChangeTransaction.myChangeScope;
        try {
            this.mySyncDocument = document;
            PsiTreeChangeEventImpl fakeEvent = new PsiTreeChangeEventImpl(changeScope.getManager());
            fakeEvent.setParent((PsiElement)changeScope);
            fakeEvent.setFile(changeScope);
            this.checkPsiModificationAllowed(fakeEvent);
            this.doSync(fakeEvent, (document1, event) -> PsiToDocumentSynchronizer.doCommitTransaction(document1, documentChangeTransaction));
            if (PomModelImpl.shouldFirePhysicalPsiEvents((PsiElement)changeScope)) {
                ((PsiDocumentTransactionListener)this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC)).transactionCompleted(document, changeScope);
            }
        }
        catch (Throwable e) {
            this.myPsiDocumentManager.forceReload(changeScope.getViewProvider().getVirtualFile(), changeScope.getViewProvider());
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
        }
        finally {
            this.mySyncDocument = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommitTransaction(@NotNull Document document, @NotNull DocumentChangeTransaction documentChangeTransaction) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(18);
        }
        if (documentChangeTransaction == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(19);
        }
        DocumentEx ex = (DocumentEx)document;
        ex.suppressGuardedExceptions();
        try {
            boolean isReadOnly = !document.isWritable();
            ex.setReadOnly(false);
            for (Map.Entry entry2 : documentChangeTransaction.myAffectedFragments.descendingMap().entrySet()) {
                ex.replaceString(((TextRange)entry2.getKey()).getStartOffset(), ((TextRange)entry2.getKey()).getEndOffset(), (CharSequence)entry2.getValue());
            }
            ex.setReadOnly(isReadOnly);
        }
        finally {
            ex.unSuppressGuardedExceptions();
        }
    }

    @Nullable
    private DocumentChangeTransaction removeTransaction(@NotNull Document doc) {
        Pair pair;
        if (doc == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(20);
        }
        if ((pair = this.myTransactionsMap.get(doc)) == null) {
            return null;
        }
        int nestedCount = (Integer)pair.getSecond();
        if (nestedCount > 0) {
            pair = Pair.create((Object)((DocumentChangeTransaction)pair.getFirst()), (Object)(nestedCount - 1));
            this.myTransactionsMap.put(doc, (Pair<DocumentChangeTransaction, Integer>)pair);
            return null;
        }
        this.myTransactionsMap.remove(doc);
        return (DocumentChangeTransaction)pair.getFirst();
    }

    public boolean isDocumentAffectedByTransactions(@NotNull Document document) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(21);
        }
        return this.myTransactionsMap.containsKey(document);
    }

    @ApiStatus.Internal
    public void processEvents(@NotNull TreeChangeEventImpl changeSet, @NotNull PsiFile file2) {
        DocumentChangeTransaction transaction;
        if (changeSet == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(23);
        }
        if (file2 instanceof DummyHolder || !this.toProcessPsiEvent()) {
            return;
        }
        DocumentEx document = this.getCachedDocument(file2, false);
        DocumentChangeTransaction documentChangeTransaction = transaction = document == null ? null : this.getTransaction(document);
        if (transaction == null) {
            return;
        }
        for (TreeChangeImpl change : changeSet.getSortedChanges()) {
            int parentStart = change.getChangedParent().getStartOffset();
            for (ASTNode child2 : change.getAffectedChildren()) {
                PsiElement newPsi;
                ChangeInfoImpl info2 = change.getChangeByChild(child2);
                ASTNode newChild = info2.getNewChild();
                PsiElement psiElement = newPsi = newChild == null ? null : newChild.getPsi();
                if (newPsi instanceof ForeignLeafPsiElement) continue;
                transaction.replace(info2.getOffsetInParent() + parentStart, info2.getOldLength(), newChild == null ? "" : newChild.getText(), newPsi);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncAction";
                break;
            }
            case 7: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentChangeTransaction";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeSet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/PsiToDocumentSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransaction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSynchronization";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPsiModificationAllowed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doSync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideAtomicChange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "performAtomically";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "insertString";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "startTransaction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "commitTransaction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "doCommitTransaction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "removeTransaction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentAffectedByTransactions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DocumentChangeTransaction {
        private final TreeMap<TextRange, CharSequence> myAffectedFragments;
        private final PsiFile myChangeScope;
        private ImmutableCharSequence myPsiText;

        DocumentChangeTransaction(@NotNull Document doc, @NotNull PsiFile scope2) {
            if (doc == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(1);
            }
            this.myAffectedFragments = new TreeMap(Comparator.comparingInt(TextRange::getStartOffset));
            this.myChangeScope = scope2;
            this.myPsiText = CharArrayUtil.createImmutableCharSequence((CharSequence)doc.getImmutableCharSequence());
        }

        @TestOnly
        @NotNull
        public Map<TextRange, CharSequence> getAffectedFragments() {
            TreeMap<TextRange, CharSequence> treeMap = this.myAffectedFragments;
            if (treeMap == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(2);
            }
            return treeMap;
        }

        void replace(int psiStart, int length, @NotNull String replace, @Nullable PsiElement replacement) {
            int newEndInReplace;
            int newStartInReplace;
            if (replace == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(3);
            }
            int start2 = 0;
            int end = start2 + length;
            CharSequence chars = this.myPsiText.subSequence(psiStart, psiStart + length);
            if (StringUtil.equals((CharSequence)chars, (CharSequence)replace)) {
                return;
            }
            int replaceLength = replace.length();
            for (newStartInReplace = 0; newStartInReplace < replaceLength && start2 < end && replace.charAt(newStartInReplace) == chars.charAt(start2); ++start2, ++newStartInReplace) {
            }
            for (newEndInReplace = replaceLength; start2 < end && newStartInReplace < newEndInReplace && replace.charAt(newEndInReplace - 1) == chars.charAt(end - 1); --newEndInReplace, --end) {
            }
            if (replacement != null && (newStartInReplace > 0 || newEndInReplace < replaceLength)) {
                PsiElement startLeaf = replacement.findElementAt(newStartInReplace);
                PsiElement endLeaf = replacement.findElementAt(newEndInReplace - 1);
                if (startLeaf != null && endLeaf != null) {
                    int leafStart = startLeaf.getTextRange().getStartOffset() - replacement.getTextRange().getStartOffset();
                    int leafEnd = endLeaf.getTextRange().getEndOffset() - replacement.getTextRange().getStartOffset();
                    start2 += leafStart - newStartInReplace;
                    end += leafEnd - newEndInReplace;
                    newStartInReplace = leafStart;
                    newEndInReplace = leafEnd;
                }
            }
            if (newStartInReplace == newEndInReplace && start2 > 0 && start2 < end && StringUtil.indexOf((CharSequence)chars, (char)'\n', (int)start2, (int)end) != -1) {
                while (start2 > 0 && newStartInReplace > 0 && chars.charAt(start2 - 1) == chars.charAt(end - 1) && chars.charAt(end - 1) != '\n') {
                    --start2;
                    --end;
                    --newStartInReplace;
                    --newEndInReplace;
                }
            }
            this.updateFragments(start2 += psiStart, end += psiStart, replace.substring(newStartInReplace, newEndInReplace));
        }

        private void updateFragments(int start2, int end, @NotNull String replace) {
            if (replace == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(4);
            }
            int docStart = this.psiToDocumentOffset(start2);
            int docEnd = this.psiToDocumentOffset(end);
            TextRange startRange = this.findFragment(docStart);
            TextRange endRange = this.findFragment(docEnd);
            this.myPsiText = this.myPsiText.replace(start2, end, (CharSequence)replace);
            TextRange newFragment = new TextRange(startRange != null ? startRange.getStartOffset() : docStart, endRange != null ? endRange.getEndOffset() : docEnd);
            CharSequence newReplacement = this.myPsiText.subSequence(this.documentToPsiOffset(newFragment.getStartOffset(), false), this.documentToPsiOffset(newFragment.getEndOffset(), true) + replace.length() - (end - start2));
            this.myAffectedFragments.keySet().removeIf(range2 -> range2.intersects(newFragment));
            this.myAffectedFragments.put(newFragment, newReplacement);
        }

        private TextRange findFragment(int docOffset) {
            return (TextRange)ContainerUtil.find(this.myAffectedFragments.keySet(), range2 -> range2.containsOffset(docOffset));
        }

        private int psiToDocumentOffset(int offset) {
            for (Map.Entry<TextRange, CharSequence> entry2 : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry2.getValue().length();
                TextRange range2 = entry2.getKey();
                if (range2.getStartOffset() + lengthAfter < offset) {
                    offset += range2.getLength() - lengthAfter;
                    continue;
                }
                return Math.min(range2.getStartOffset(), offset);
            }
            return offset;
        }

        private int documentToPsiOffset(int offset, boolean greedyRight) {
            int delta = 0;
            for (Map.Entry<TextRange, CharSequence> entry2 : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry2.getValue().length();
                TextRange range2 = entry2.getKey();
                if (range2.containsOffset(offset)) {
                    return range2.getStartOffset() + delta + (greedyRight ? lengthAfter : 0);
                }
                if (range2.getStartOffset() > offset) break;
                delta += lengthAfter - range2.getLength();
            }
            return offset + delta;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFragments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    private static interface DocSyncAction {
        public void syncDocument(@NotNull Document var1, @NotNull PsiTreeChangeEventImpl var2);
    }
}

