/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformIdTableBuilding {
    public static final Key<EditorHighlighter> EDITOR_HIGHLIGHTER = new Key("Editor");
    private static final TokenSet ABSTRACT_FILE_COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    private PlatformIdTableBuilding() {
    }

    @Nullable
    public static DataIndexer<TodoIndexEntry, Integer, FileContent> getTodoIndexer(FileType fileType) {
        DataIndexer extIndexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
        if (extIndexer != null) {
            return extIndexer;
        }
        if (fileType instanceof LanguageFileType) {
            TokenSet commentTokens;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet tokenSet = commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            if (commentTokens != null) {
                return new TokenSetTodoIndexer(commentTokens);
            }
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new TokenSetTodoIndexer(ABSTRACT_FILE_COMMENT_TOKENS);
        }
        return null;
    }

    public static boolean checkCanUseCachedEditorHighlighter(CharSequence chars, EditorHighlighter editorHighlighter) {
        assert (editorHighlighter instanceof LexerEditorHighlighter);
        boolean b = ((LexerEditorHighlighter)editorHighlighter).checkContentIsEqualTo(chars);
        if (!b) {
            Logger logger = Logger.getInstance((String)IdTableBuilding.class.getName());
            logger.warn("Unexpected mismatch of editor highlighter content with indexing content");
        }
        return b;
    }

    public static boolean isTodoIndexerRegistered(@NotNull FileType fileType) {
        if (fileType == null) {
            PlatformIdTableBuilding.$$$reportNull$$$0(0);
        }
        return TodoIndexers.INSTANCE.forFileType(fileType) != null || fileType instanceof InternalFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding", "isTodoIndexerRegistered"));
    }

    private static class TokenSetTodoIndexer
    extends VersionedTodoIndexer {
        final TokenSet myCommentTokens;

        TokenSetTodoIndexer(@NotNull TokenSet commentTokens) {
            if (commentTokens == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(0);
            }
            this.myCommentTokens = commentTokens;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            EditorHighlighter highlighter;
            if (inputData == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(1);
            }
            IndexPattern[] patterns = IndexPatternUtil.getIndexPatterns();
            BaseFilterLexer.TodoScanningState todoScanningState = BaseFilterLexer.createTodoScanningState(patterns);
            if (patterns.length == 0) {
                Map<TodoIndexEntry, Integer> map2 = Collections.emptyMap();
                if (map2 == null) {
                    TokenSetTodoIndexer.$$$reportNull$$$0(2);
                }
                return map2;
            }
            CharSequence chars = inputData.getContentAsText();
            OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
            EditorHighlighter editorHighlighter = (EditorHighlighter)inputData.getUserData(EDITOR_HIGHLIGHTER);
            if (editorHighlighter != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter(chars, editorHighlighter)) {
                highlighter = editorHighlighter;
            } else {
                highlighter = HighlighterFactory.createHighlighter((Project)inputData.getProject(), (VirtualFile)inputData.getFile());
                highlighter.setText(chars);
            }
            int documentLength = chars.length();
            HighlighterIterator iterator2 = highlighter.createIterator(0);
            while (!iterator2.atEnd()) {
                IElementType token2 = iterator2.getTokenType();
                if (this.myCommentTokens.contains(token2) || CacheUtil.isInComments(token2)) {
                    int start2 = iterator2.getStart();
                    if (start2 >= documentLength) break;
                    int end = iterator2.getEnd();
                    BaseFilterLexer.advanceTodoItemsCount(chars.subSequence(start2, Math.min(end, documentLength)), occurrenceConsumer, todoScanningState);
                    if (end > documentLength) break;
                }
                iterator2.advance();
            }
            HashMap<TodoIndexEntry, Integer> map3 = new HashMap<TodoIndexEntry, Integer>();
            for (IndexPattern pattern : patterns) {
                int count = occurrenceConsumer.getOccurrenceCount(pattern);
                if (count <= 0) continue;
                map3.put(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), count);
            }
            HashMap<TodoIndexEntry, Integer> hashMap = map3;
            if (hashMap == null) {
                TokenSetTodoIndexer.$$$reportNull$$$0(3);
            }
            return hashMap;
        }

        @Override
        public int getVersion() {
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTokens";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

