/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameXmlAttributeProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenameXmlAttributeProcessor.class);

    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(0);
        }
        return element2 instanceof XmlAttribute || element2 instanceof XmlAttributeValue;
    }

    @Override
    public void renameElement(@NotNull PsiElement element2, @NotNull String newName2, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element2 == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(1);
        }
        if (newName2 == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(3);
        }
        if (element2 instanceof XmlAttribute) {
            RenameXmlAttributeProcessor.doRenameXmlAttribute((XmlAttribute)element2, newName2, listener2);
        } else if (element2 instanceof XmlAttributeValue) {
            RenameXmlAttributeProcessor.doRenameXmlAttributeValue((XmlAttributeValue)element2, newName2, usages, listener2);
        }
    }

    private static void doRenameXmlAttribute(XmlAttribute attribute, String newName2, @Nullable RefactoringElementListener listener2) {
        try {
            PsiElement element2 = attribute.setName(newName2);
            if (listener2 != null) {
                listener2.elementRenamed(element2);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doRenameXmlAttributeValue(@NotNull XmlAttributeValue value2, String newName2, UsageInfo[] infos, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (value2 == null) {
            RenameXmlAttributeProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(value2.isValid());
        RenameXmlAttributeProcessor.renameAll((PsiElement)value2, infos, newName2, value2.getValue());
        PsiManager psiManager = value2.getManager();
        LOG.assertTrue(psiManager != null);
        XmlFile file2 = (XmlFile)PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)("<a attr=\"" + newName2 + "\"/>"));
        PsiElement element2 = value2.replace((PsiElement)file2.getRootTag().getAttributes()[0].getValueElement());
        if (listener2 != null) {
            listener2.elementRenamed(element2);
        }
    }

    private static void renameAll(PsiElement originalElement, UsageInfo[] infos, String newName2, String originalName) throws IncorrectOperationException {
        if (newName2.equals(originalName)) {
            return;
        }
        ArrayDeque<PsiReference> queue2 = new ArrayDeque<PsiReference>(infos.length);
        for (UsageInfo info2 : infos) {
            PsiReference ref;
            if (info2.getElement() == null || (ref = info2.getReference()) == null) continue;
            queue2.addLast(ref);
        }
        while (!queue2.isEmpty()) {
            PsiReference reference2 = (PsiReference)queue2.removeFirst();
            PsiElement oldElement = reference2.getElement();
            if (!oldElement.isValid() || oldElement == originalElement) continue;
            PsiElement newElement = reference2.handleElementRename(newName2);
            if (oldElement.isValid()) continue;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)originalElement, (SearchScope)new LocalSearchScope(newElement), (boolean)false)) {
                queue2.addLast(psiReference);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameXmlAttributeProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRenameXmlAttributeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

