/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            SafeDeleteHandler.$$$reportNull$$$0(0);
        }
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element2 == null || !SafeDeleteProcessor.validElement(element2)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{SafeDeleteHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)SafeDeleteHandler.getRefactoringName(), (String)"refactoring.safeDelete");
            return;
        }
        this.invoke(project, new PsiElement[]{element2}, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            SafeDeleteHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(2);
        }
        SafeDeleteHandler.invoke(project, elements, (Module)LangDataKeys.MODULE.getData(dataContext), true, null, null);
    }

    public static void invoke(Project project, PsiElement[] elements, boolean checkDelegates) {
        SafeDeleteHandler.invoke(project, elements, checkDelegates, null);
    }

    public static void invoke(Project project, PsiElement[] elements, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project, elements, null, checkDelegates, successRunnable, null);
    }

    public static void invoke(Project project, PsiElement[] elements, @Nullable Module module, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project, elements, module, checkDelegates, successRunnable, null);
    }

    public static void invoke(Project project, PsiElement[] elements, @Nullable Module module, boolean checkDelegates, @Nullable Runnable successRunnable, @Nullable Runnable afterRefactoring) {
        SafeDeleteHandler.invoke(project, elements, module, checkDelegates, successRunnable, afterRefactoring, false);
    }

    public static void invoke(final Project project, PsiElement[] elements, @Nullable Module module, boolean checkDelegates, final @Nullable Runnable successRunnable, final @Nullable Runnable afterRefactoring, boolean silent) {
        for (PsiElement psiElement : elements) {
            if (SafeDeleteProcessor.validElement(psiElement)) continue;
            return;
        }
        Object[] temptoDelete = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        Set elementsSet = ContainerUtil.set((Object[])temptoDelete);
        LinkedHashSet<Object> fullElementsSet = new LinkedHashSet<Object>();
        if (checkDelegates) {
            for (Object element3 : temptoDelete) {
                boolean found = false;
                for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                    Collection<? extends PsiElement> addElements;
                    if (!delegate2.handlesElement((PsiElement)element3)) continue;
                    found = true;
                    Collection<? extends PsiElement> collection = addElements = delegate2 instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate2).getElementsToSearch((PsiElement)element3, module, elementsSet) : delegate2.getElementsToSearch((PsiElement)element3, elementsSet);
                    if (addElements == null) {
                        return;
                    }
                    fullElementsSet.addAll(addElements);
                    break;
                }
                if (found) continue;
                fullElementsSet.add(element3);
            }
        } else {
            ContainerUtil.addAll(fullElementsSet, (Object[])temptoDelete);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, fullElementsSet, (boolean)true)) {
            return;
        }
        final PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(fullElementsSet);
        if (ApplicationManager.getApplication().isUnitTestMode() || silent) {
            RefactoringSettings settings2 = RefactoringSettings.getInstance();
            SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, null, psiElementArray, settings2.SAFE_DELETE_SEARCH_IN_COMMENTS, settings2.SAFE_DELETE_SEARCH_IN_NON_JAVA, true);
            if (afterRefactoring != null) {
                processor2.setAfterRefactoringCallback(afterRefactoring);
            }
            processor2.run();
            if (successRunnable != null) {
                successRunnable.run();
            }
        } else {
            SafeDeleteDialog.Callback callback2 = new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, () -> {
                        if (successRunnable != null) {
                            successRunnable.run();
                        }
                        dialog2.close(1);
                    }, psiElementArray, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true);
                    if (afterRefactoring != null) {
                        processor2.setAfterRefactoringCallback(afterRefactoring);
                    }
                    processor2.run();
                }
            };
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project, psiElementArray, callback2);
            dialog2.show();
        }
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"safe.delete.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/safeDelete/SafeDeleteHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

