/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomDictionariesPanel
extends JPanel {
    private final SpellCheckerSettings mySettings;
    @NotNull
    private final SpellCheckerManager myManager;
    private final CustomDictionariesTableView myCustomDictionariesTableView;
    private final List<String> removedDictionaries;
    private final List<String> defaultDictionaries;

    public CustomDictionariesPanel(@NotNull SpellCheckerSettings settings2, final @NotNull Project project, final @NotNull SpellCheckerManager manager2) {
        if (settings2 == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(1);
        }
        if (manager2 == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(2);
        }
        this.removedDictionaries = new ArrayList<String>();
        this.mySettings = settings2;
        this.myManager = manager2;
        this.defaultDictionaries = project.isDefault() ? new ArrayList<String>() : Arrays.asList(SpellCheckerBundle.message("app.dictionary", new Object[0]), SpellCheckerBundle.message("project.dictionary", new Object[0]));
        this.myCustomDictionariesTableView = new CustomDictionariesTableView(new ArrayList<String>(settings2.getCustomDictionariesPaths()), this.defaultDictionaries);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((Object)this.myCustomDictionariesTableView)).setAddActionName(SpellCheckerBundle.message("add.custom.dictionaries", new Object[0])).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button4) {
                CustomDictionariesPanel.this.myCustomDictionariesTableView.stopEditing();
                CustomDictionariesPanel.this.doChooseFiles(project, (Consumer<? super List<VirtualFile>>)((Consumer)files2 -> files2.stream().map(VirtualFile::getPath).map(PathUtil::toSystemDependentName).filter(path2 -> !CustomDictionariesPanel.this.myCustomDictionariesTableView.getItems().contains(path2)).forEach(path2 -> CustomDictionariesPanel.this.myCustomDictionariesTableView.getListTableModel().addRow(path2))));
            }
        }).setRemoveActionName(SpellCheckerBundle.message("remove.custom.dictionaries", new Object[0])).setRemoveAction(button4 -> {
            this.removedDictionaries.addAll(this.myCustomDictionariesTableView.getSelectedObjects());
            TableUtil.removeSelectedItems((JTable)((Object)this.myCustomDictionariesTableView));
        }).setRemoveActionUpdater(e -> !ContainerUtil.exists((Iterable)this.myCustomDictionariesTableView.getSelectedObjects(), this.defaultDictionaries::contains)).setEditActionName(SpellCheckerBundle.message("edit.custom.dictionary", new Object[0])).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedDictionary = (String)CustomDictionariesPanel.this.myCustomDictionariesTableView.getSelectedObject();
                if (selectedDictionary == null) {
                    return;
                }
                if (CustomDictionariesPanel.this.defaultDictionaries.contains(selectedDictionary)) {
                    selectedDictionary = selectedDictionary.equals(SpellCheckerBundle.message("app.dictionary", new Object[0])) ? CustomDictionariesPanel.this.myManager.getAppDictionaryPath() : CustomDictionariesPanel.this.myManager.getProjectDictionaryPath();
                }
                manager2.openDictionaryInEditor(selectedDictionary);
            }
        }).disableUpDownActions();
        this.myCustomDictionariesTableView.getEmptyText().setText(SpellCheckerBundle.message("no.custom.dictionaries", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)decorator.createPanel(), "Center");
    }

    private void doChooseFiles(@NotNull Project project, @NotNull Consumer<? super List<VirtualFile>> consumer) {
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(4);
        }
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileSelectable(VirtualFile file2) {
                return FileUtilRt.extensionEquals((String)file2.getPath(), (String)"dic");
            }
        };
        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor2, (Project)project, (Component)this.getParent(), (VirtualFile)project.getBaseDir(), consumer);
    }

    public List<String> getRemovedDictionaries() {
        return this.removedDictionaries;
    }

    public boolean isModified() {
        List<String> oldPaths = this.mySettings.getCustomDictionariesPaths();
        List newPaths = ContainerUtil.filter((Collection)this.myCustomDictionariesTableView.getItems(), o -> !this.defaultDictionaries.contains(o));
        if (oldPaths.size() != newPaths.size()) {
            return true;
        }
        return !newPaths.containsAll(oldPaths) || !oldPaths.containsAll(newPaths);
    }

    public void reset() {
        this.myCustomDictionariesTableView.getListTableModel().setItems(new ArrayList(ContainerUtil.concat(this.defaultDictionaries, this.mySettings.getCustomDictionariesPaths())));
        this.removedDictionaries.clear();
    }

    public void apply() {
        this.mySettings.setCustomDictionariesPaths(new ArrayList<String>(ContainerUtil.filter((Collection)this.myCustomDictionariesTableView.getItems(), dict -> !this.defaultDictionaries.contains(dict))));
    }

    public List<String> getValues() {
        return this.myCustomDictionariesTableView.getItems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CustomDictionariesTableView
    extends TableView<String> {
        final TableCellRenderer myTypeRenderer;

        private CustomDictionariesTableView(@NotNull List<String> dictionaries, @NotNull List<String> defaultDictionaries) {
            if (dictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(0);
            }
            if (defaultDictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(1);
            }
            this.myTypeRenderer = CustomDictionariesTableView.createTypeRenderer(defaultDictionaries);
            this.setModelAndUpdateColumns(new ListTableModel(this.createDictionaryColumnInfos(), ContainerUtil.concat(defaultDictionaries, dictionaries), 0));
            this.setAutoResizeMode(3);
            this.setShowGrid(false);
            this.setShowVerticalLines(false);
            this.setGridColor(this.getForeground());
            this.setTableHeader(null);
        }

        private static TableCellRenderer createTypeRenderer(final List<String> defaultDictionaries) {
            return new TableCellRenderer(){
                final SimpleColoredComponent myLabel = new SimpleColoredComponent();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
                    CustomDictionaryProvider provider2;
                    this.myLabel.clear();
                    this.myLabel.append((String)value2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String type = defaultDictionaries.contains(value2) ? SpellCheckerBundle.message("built.in.dictionary", new Object[0]) : ((provider2 = (CustomDictionaryProvider)CustomDictionaryProvider.EP_NAME.getExtensionList().stream().filter(dictionaryProvider -> dictionaryProvider.isApplicable((String)value2)).findAny().orElse(null)) != null ? provider2.getDictionaryType() : SpellCheckerBundle.message("words.list.dictionary", new Object[0]));
                    this.myLabel.append(" [" + type + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    return this.myLabel;
                }
            };
        }

        private ColumnInfo[] createDictionaryColumnInfos() {
            return new ColumnInfo[]{new ColumnInfo<String, String>(SpellCheckerBundle.message("custom.dictionary.title", new Object[0])){

                public String valueOf(String info2) {
                    return info2;
                }

                @Nullable
                public TableCellRenderer getRenderer(String s) {
                    return myTypeRenderer;
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dictionaries";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultDictionaries";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel$CustomDictionariesTableView";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

