/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");
    @NonNls
    protected static final String PATTERN_PLACEHOLDER = "$$PATTERN_PLACEHOLDER$$";

    public abstract void compile(PsiElement @NotNull [] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    @NotNull
    public abstract NodeFilter getLexicalNodesFilter();

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    @NotNull
    public List<MatchPredicate> getCustomPredicates(@NotNull MatchVariableConstraint constraint, @NotNull String name, @NotNull MatchOptions options2) {
        if (constraint == null) {
            StructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (name == null) {
            StructuralSearchProfile.$$$reportNull$$$0(1);
        }
        if (options2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(2);
        }
        List<MatchPredicate> list2 = Collections.emptyList();
        if (list2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public @NotNull PsiElement @NotNull [] createPatternTree(@NotNull String text2, @NotNull PatternTreeContext context2, @NotNull LanguageFileType fileType, @NotNull Language language, @Nullable String contextId, @NotNull Project project, boolean physical) {
        if (text2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(8);
        }
        return this.doCreatePatternTree(text2, context2, fileType, language, project, physical, this.getContext(text2, language, contextId));
    }

    @NotNull
    public @NotNull PsiElement @NotNull [] createPatternTree(@NotNull String text2, @NotNull PatternContextInfo contextInfo, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical) {
        String contextConstraint;
        if (text2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (contextInfo == null) {
            StructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)(contextConstraint = contextInfo.getContextConstraint()))) {
            PatternContext patternContext = contextInfo.getPatternContext();
            String contextId = patternContext != null ? patternContext.getId() : null;
            PsiElement[] psiElementArray = this.createPatternTree(text2, contextInfo.getTreeContext(), fileType, language, contextId, project, physical);
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(14);
            }
            return psiElementArray;
        }
        return this.doCreatePatternTree(text2, contextInfo.getTreeContext(), fileType, language, project, physical, this.getContextByConstraint(contextConstraint, project));
    }

    @NotNull
    private @NotNull PsiElement @NotNull [] doCreatePatternTree(@NotNull String text2, @NotNull PatternTreeContext context2, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical, @NotNull String strContext) {
        if (text2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(17);
        }
        if (language == null) {
            StructuralSearchProfile.$$$reportNull$$$0(18);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(19);
        }
        if (strContext == null) {
            StructuralSearchProfile.$$$reportNull$$$0(20);
        }
        String placeholderName = this.getPlaceholderVarName();
        String patternInContext = context2 == PatternTreeContext.File ? text2 : strContext.replace(placeholderName, text2);
        @NonNls String name = "__dummy." + fileType.getDefaultExtension();
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText(name, language, (CharSequence)patternInContext, physical, true);
        if (file2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                StructuralSearchProfile.$$$reportNull$$$0(21);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (context2 == PatternTreeContext.File) {
            PsiElement[] psiElementArray = new PsiElement[]{file2};
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(22);
            }
            return psiElementArray;
        }
        int offset = strContext.indexOf(placeholderName);
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                StructuralSearchProfile.$$$reportNull$$$0(23);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement topElement = element2;
        int patternLength = text2.length();
        for (element2 = element2.getParent(); element2 != null; element2 = element2.getParent()) {
            if (element2.getTextRange().getStartOffset() != offset || element2.getTextLength() > patternLength) continue;
            topElement = element2;
        }
        if (topElement instanceof PsiFile) {
            PsiElement[] psiElementArray = topElement.getChildren();
            if (psiElementArray == null) {
                StructuralSearchProfile.$$$reportNull$$$0(24);
            }
            return psiElementArray;
        }
        SmartList result2 = new SmartList();
        result2.add(topElement);
        int endOffset = offset + patternLength;
        for (topElement = topElement.getNextSibling(); topElement != null && topElement.getTextRange().getEndOffset() <= endOffset; topElement = topElement.getNextSibling()) {
            result2.add(topElement);
        }
        PsiElement[] psiElementArray = result2.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(25);
        }
        return psiElementArray;
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        List<PatternContext> list2 = Collections.emptyList();
        if (list2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    protected String getPlaceholderVarName() {
        return PATTERN_PLACEHOLDER;
    }

    @NotNull
    protected String getContext(@NotNull String pattern, @Nullable Language language, @Nullable String contextId) {
        if (pattern == null) {
            StructuralSearchProfile.$$$reportNull$$$0(27);
        }
        String string = this.getPlaceholderVarName();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private String getContextByConstraint(@NotNull String contextConstraint, @NotNull Project project) {
        Configuration configuration2;
        if (contextConstraint == null) {
            StructuralSearchProfile.$$$reportNull$$$0(29);
        }
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(30);
        }
        String string = (configuration2 = ConfigurationManager.getInstance(project).findConfigurationByName(contextConstraint)) != null ? configuration2.getMatchOptions().getSearchPattern() : this.getPlaceholderVarName();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(@NotNull Project project, @NotNull String text2, @Nullable String contextId) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(33);
        }
        return null;
    }

    @NotNull
    public String getCodeFragmentText(@NotNull PsiFile fragment2) {
        if (fragment2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(34);
        }
        String string = fragment2.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    @Nullable
    public LanguageFileType detectFileType(@NotNull PsiElement context2) {
        if (context2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(36);
        }
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(37);
        }
        if (replaceOptions == null) {
            StructuralSearchProfile.$$$reportNull$$$0(38);
        }
        return null;
    }

    public boolean supportsShortenFQNames() {
        return false;
    }

    public boolean supportsUseStaticImports() {
        return false;
    }

    public void checkSearchPattern(@NotNull CompiledPattern pattern) {
        if (pattern == null) {
            StructuralSearchProfile.$$$reportNull$$$0(39);
        }
    }

    public void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options2) {
        if (project == null) {
            StructuralSearchProfile.$$$reportNull$$$0(40);
        }
        if (options2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(41);
        }
        String fileType = StringUtil.toLowerCase((String)options2.getMatchOptions().getFileType().getName());
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileType));
    }

    public boolean shouldShowProblem(@NotNull PsiErrorElement error2) {
        if (error2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(42);
        }
        return false;
    }

    public boolean canBeVarDelimiter(@NotNull PsiElement element2) {
        if (element2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(43);
        }
        return false;
    }

    @NotNull
    public String getText(@NotNull PsiElement match, int start2, int end) {
        if (match == null) {
            StructuralSearchProfile.$$$reportNull$$$0(44);
        }
        String matchText = match.getText();
        if (start2 == 0 && end == -1) {
            String string = matchText;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = matchText.substring(start2, end == -1 ? matchText.length() : end);
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element2) {
        String name;
        if (element2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(47);
        }
        if (element2 instanceof PsiNamedElement && (name = ((PsiNamedElement)element2).getName()) != null) {
            String string = name;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = element2.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(49);
        }
        return string;
    }

    public String getMeaningfulText(@NotNull PsiElement element2) {
        if (element2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(50);
        }
        return this.getTypedVarString(element2);
    }

    public String getAlternativeText(@NotNull PsiElement element2, @NotNull String previousText) {
        if (element2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(51);
        }
        if (previousText == null) {
            StructuralSearchProfile.$$$reportNull$$$0(52);
        }
        return null;
    }

    @NotNull
    public PsiElement updateCurrentNode(@NotNull PsiElement node2) {
        if (node2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(53);
        }
        PsiElement psiElement = node2;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(54);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement extendMatchedByDownUp(@NotNull PsiElement node2) {
        if (node2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(55);
        }
        PsiElement psiElement = node2;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(56);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement extendMatchOnePsiFile(@NotNull PsiElement file2) {
        if (file2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(57);
        }
        PsiElement psiElement = file2;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(58);
        }
        return psiElement;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    public Configuration @NotNull [] getPredefinedTemplates() {
        if (Configuration.EMPTY_ARRAY == null) {
            StructuralSearchProfile.$$$reportNull$$$0(59);
        }
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node2, @NotNull ReplaceOptions options2, @NotNull ReplacementBuilder builder2) {
        if (node2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(60);
        }
        if (options2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(61);
        }
        if (builder2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(62);
        }
    }

    public void handleSubstitution(@NotNull ParameterInfo info2, @NotNull MatchResult match, @NotNull StringBuilder result2, @NotNull ReplacementInfo replacementInfo) {
        if (info2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(63);
        }
        if (match == null) {
            StructuralSearchProfile.$$$reportNull$$$0(64);
        }
        if (result2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(65);
        }
        if (replacementInfo == null) {
            StructuralSearchProfile.$$$reportNull$$$0(66);
        }
        if (info2.getName().equals(match.getName())) {
            String replacementString;
            boolean removeSemicolon = false;
            if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (buf.length() > 0) {
                        if (info2.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            PsiElement sibling = currentElement.getPrevSibling();
                            buf.append(sibling instanceof PsiWhiteSpace ? sibling.getText() : " ");
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    removeSemicolon = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else {
                if (info2.isStatementContext()) {
                    removeSemicolon = match.getMatch() instanceof PsiComment;
                }
                replacementString = match.getMatchImage();
            }
            int offset = Replacer.insertSubstitution(result2, 0, info2, replacementString);
            if (info2.isStatementContext() && (removeSemicolon || StringUtil.endsWithChar((CharSequence)replacementString, (char)';') || StringUtil.endsWithChar((CharSequence)replacementString, (char)'}'))) {
                int start2 = info2.getStartIndex() + offset;
                result2.delete(start2, start2 + 1);
            }
        }
    }

    public void handleNoSubstitution(@NotNull ParameterInfo info2, @NotNull StringBuilder result2) {
        if (info2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(67);
        }
        if (result2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(68);
        }
        if (info2.isHasCommaBefore()) {
            result2.delete(info2.getBeforeDelimiterPos(), info2.getBeforeDelimiterPos() + 1);
        } else if (info2.isHasCommaAfter()) {
            result2.delete(info2.getAfterDelimiterPos(), info2.getAfterDelimiterPos() + 1);
        }
    }

    @Contract(value="null -> false")
    public boolean isIdentifier(@Nullable PsiElement element2) {
        return false;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set2 = Collections.emptySet();
        if (set2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(69);
        }
        return set2;
    }

    public boolean isDocCommentOwner(@NotNull PsiElement match) {
        if (match == null) {
            StructuralSearchProfile.$$$reportNull$$$0(70);
        }
        return false;
    }

    @NotNull
    public PsiElement getPresentableElement(@NotNull PsiElement element2) {
        PsiElement parent;
        if (element2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(71);
        }
        if (this.isIdentifier(element2) && (parent = element2.getParent()) != null) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                StructuralSearchProfile.$$$reportNull$$$0(72);
            }
            return psiElement;
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            StructuralSearchProfile.$$$reportNull$$$0(73);
        }
        return psiElement;
    }

    public boolean isApplicableConstraint(@NotNull String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target2) {
        if (constraintName == null) {
            StructuralSearchProfile.$$$reportNull$$$0(74);
        }
        switch (constraintName) {
            case "MINIMUM ZERO": {
                if (target2) {
                    return false;
                }
            }
            case "MAXIMUM UNLIMITED": 
            case "TEXT": 
            case "REFERENCE": {
                return !completePattern;
            }
        }
        return false;
    }

    public final boolean isApplicableConstraint(@NotNull String constraintName, @NotNull List<? extends PsiElement> nodes, boolean completePattern, boolean target2) {
        if (constraintName == null) {
            StructuralSearchProfile.$$$reportNull$$$0(75);
        }
        if (nodes == null) {
            StructuralSearchProfile.$$$reportNull$$$0(76);
        }
        if (nodes.isEmpty()) {
            return this.isApplicableConstraint(constraintName, (PsiElement)null, completePattern, target2);
        }
        boolean result2 = true;
        for (PsiElement psiElement : nodes) {
            result2 &= this.isApplicableConstraint(constraintName, psiElement, completePattern, target2);
        }
        return result2;
    }

    public boolean isApplicableContextConfiguration(@NotNull Configuration configuration2) {
        if (configuration2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(77);
        }
        return !configuration2.isPredefined();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 41: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 30: 
            case 32: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strContext";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConstraint";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 43: 
            case 47: 
            case 50: 
            case 51: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: 
            case 64: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
            case 53: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementInfo";
                break;
            }
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPredicates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreatePatternTree";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternContexts";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByConstraint";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentText";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCurrentNode";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "extendMatchedByDownUp";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "extendMatchOnePsiFile";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedTemplates";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPredicates";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 73: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCreatePatternTree";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContextByConstraint";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCodeFragmentText";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkSearchPattern";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowProblem";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimiter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulText";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentNode";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "extendMatchedByDownUp";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "extendMatchOnePsiFile";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleSubstitution";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "handleNoSubstitution";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElement";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConstraint";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableContextConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

