/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeChooser;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.Spacer;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.ToolbarLabel;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper
implements DocumentListener {
    @NonNls
    private static final String SEARCH_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String REPLACE_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String RECURSIVE_STATE = "structural.search.recursive";
    @NonNls
    private static final String SHORTEN_FQN_STATE = "structural.search.shorten.fqn";
    @NonNls
    private static final String REFORMAT_STATE = "structural.search.reformat";
    @NonNls
    private static final String USE_STATIC_IMPORT_STATE = "structural.search.use.static.import";
    @NonNls
    private static final String FILTERS_VISIBLE_STATE = "structural.search.filters.visible";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH_DIALOG = Key.create((String)"STRUCTURAL_SEARCH_DIALOG");
    public static final Key<String> STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID = Key.create((String)"STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID");
    public static final Key<Runnable> STRUCTURAL_SEARCH_ERROR_CALLBACK = Key.create((String)"STRUCTURAL_SEARCH_ERROR_CALLBACK");
    private static final Key<Configuration> STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION = Key.create((String)"STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION");
    public static final Key<Boolean> TEST_STRUCTURAL_SEARCH_DIALOG = Key.create((String)"TEST_STRUCTURAL_SEARCH_DIALOG");
    @NotNull
    private final SearchContext mySearchContext;
    private Editor myEditor;
    private boolean myReplace;
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    @NonNls
    private LanguageFileType myFileType;
    private Language myDialect;
    private PatternContext myPatternContext;
    private final List<RangeHighlighter> myRangeHighlighters;
    private final DocumentListener myRestartHighlightingListener;
    private final Alarm myAlarm;
    private boolean myUseLastConfiguration;
    private final boolean myEditConfigOnly;
    private final FileTypeChooser myFileTypeChooser;
    private ActionToolbarImpl myOptionsToolbar;
    private EditorTextField mySearchCriteriaEdit;
    private EditorTextField myReplaceCriteriaEdit;
    private OnePixelSplitter mySearchEditorPanel;
    private FilterPanel myFilterPanel;
    private LinkComboBox myTargetComboBox;
    private ScopePanel myScopePanel;
    private JCheckBox myOpenInNewTab;
    private JComponent myReplacePanel;
    private SwitchAction mySwitchAction;
    private Balloon myBalloon;

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(0);
        }
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(1);
        }
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myRangeHighlighters = new SmartList();
        this.myRestartHighlightingListener = new DocumentListener(){
            final Runnable runnable = () -> ReadAction.nonBlocking(() -> StructuralSearchDialog.this.addMatchHighlights()).withDocumentsCommitted(StructuralSearchDialog.this.getProject()).expireWith(StructuralSearchDialog.this.getDisposable()).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "documentChanged"));
            }
        };
        this.myFileTypeChooser = new FileTypeChooser();
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message("find.dialog.find.button", new Object[0]));
        }
        this.myReplace = replace;
        this.myEditConfigOnly = editConfigOnly;
        this.mySearchContext = searchContext;
        this.myEditor = searchContext.getEditor();
        this.addRestartHighlightingListenerToCurrentEditor();
        FileEditorManagerListener listener2 = new FileEditorManagerListener(){
            FileEditor myNewEditor;
            final Runnable runnable = () -> {
                StructuralSearchDialog.this.removeRestartHighlightingListenerFromCurrentEditor();
                StructuralSearchDialog.this.removeMatchHighlights();
                if (this.myNewEditor instanceof TextEditor) {
                    StructuralSearchDialog.this.myEditor = ((TextEditor)this.myNewEditor).getEditor();
                    StructuralSearchDialog.this.addMatchHighlights();
                    StructuralSearchDialog.this.addRestartHighlightingListenerToCurrentEditor();
                } else {
                    StructuralSearchDialog.this.myEditor = null;
                }
            };

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                this.myNewEditor = event.getNewEditor();
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "selectionChanged"));
            }
        };
        MessageBusConnection connection = this.getProject().getMessageBus().connect(this.getDisposable());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "beforePluginUnload"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                StructuralSearchDialog.this.close(1);
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (project == StructuralSearchDialog.this.getProject()) {
                    StructuralSearchDialog.this.close(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "projectClosing"));
            }
        });
        this.myConfiguration = this.createConfiguration(null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        this.setValidationDelay(100);
    }

    private void addRestartHighlightingListenerToCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().addDocumentListener(this.myRestartHighlightingListener);
        }
    }

    private void removeRestartHighlightingListenerFromCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().removeDocumentListener(this.myRestartHighlightingListener);
        }
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.myUseLastConfiguration = useLastConfiguration;
    }

    private EditorTextField createEditor(boolean replace) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile != null);
        Document document = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, "", profile);
        document.addDocumentListener((DocumentListener)this, this.myDisposable);
        document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        MyEditorTextField textField2 = new MyEditorTextField(document, replace);
        textField2.setFont(EditorFontType.getGlobalPlainFont());
        textField2.setPreferredSize(new Dimension(550, 150));
        textField2.setMinimumSize(new Dimension(200, 50));
        return textField2;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            StructuralSearchDialog.$$$reportNull$$$0(2);
        }
        this.initValidation();
    }

    private void initializeFilterPanel() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.getProject(), matchOptions, false, false);
        if (compiledPattern == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            SubstitutionShortInfoHandler.updateEditorInlays(this.mySearchCriteriaEdit.getEditor());
            if (this.myReplace) {
                SubstitutionShortInfoHandler.updateEditorInlays(this.myReplaceCriteriaEdit.getEditor());
            }
            this.myFilterPanel.setCompiledPattern(compiledPattern);
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    @NotNull
    private Configuration createConfiguration(Configuration template) {
        if (this.myReplace) {
            return template == null ? new ReplaceConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined()) : new ReplaceConfiguration(template);
        }
        if (template == null) {
            return new SearchConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined());
        }
        return template instanceof ReplaceConfiguration ? new ReplaceConfiguration(template) : new SearchConfiguration(template);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    static String getUserDefined() {
        return SSRBundle.message("new.template.defaultname", new Object[0]);
    }

    private void setTextFromContext() {
        SelectionModel selectionModel;
        String selectedText;
        Editor editor = this.myEditor;
        if (editor != null && (selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(selectedText)) {
                return;
            }
            String text2 = selectedText.trim();
            this.setTextForEditor(text2.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.setTextForEditor(text2, this.myReplaceCriteriaEdit);
            }
            this.myScopePanel.setScopesFromContext(null);
            ApplicationManager.getApplication().invokeLater(() -> this.startTemplate());
            return;
        }
        Configuration previousConfiguration = (Configuration)this.getProject().getUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION);
        if (previousConfiguration != null) {
            this.loadConfiguration(previousConfiguration);
        } else {
            Configuration configuration2 = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration();
            if (configuration2 != null) {
                this.loadConfiguration(configuration2);
            }
        }
    }

    private void setTextForEditor(String text2, EditorTextField editor) {
        editor.setText(text2);
        editor.selectAll();
        Project project = this.getProject();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        PsiFile file2 = documentManager.getPsiFile(document);
        if (file2 == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)SSRBundle.message("command.name.adjust.line.indent", new Object[0]), (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, new TextRange(0, document.getTextLength())), (PsiFile[])new PsiFile[]{file2});
    }

    private void startSearching() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.mySearchContext).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        }
    }

    @NotNull
    @Nls
    @NlsContexts.DialogTitle
    private String getDefaultTitle() {
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchCriteriaEdit = this.createEditor(false);
        this.mySearchEditorPanel.setFirstComponent((JComponent)((Object)this.mySearchCriteriaEdit));
        JPanel wrapper2 = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("Borders.ContrastBorderColor");
        wrapper2.setBorder(IdeBorderFactory.createBorder((Color)color));
        wrapper2.add((Component)this.mySearchEditorPanel, "Center");
        this.myReplacePanel = this.createReplacePanel();
        this.myReplacePanel.setVisible(this.myReplace);
        this.myScopePanel = new ScopePanel(this.getProject(), this.myDisposable);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.getProject()).getRecentDirectories());
            this.myScopePanel.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)scope2 -> this.initValidation()));
        } else {
            this.myScopePanel.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.getProject(), this.myFileType, this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        this.myTargetComboBox = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)item -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(name).setPartOfSearchResults(name.equals(item));
            }
            this.initValidation();
        }));
        String text2 = SSRBundle.message("search.target.label", new Object[0]);
        JLabel searchTargetLabel = new JLabel(text2);
        searchTargetLabel.setLabelFor((Component)((Object)this.myTargetComboBox));
        this.myTargetComboBox.setMnemonic(TextWithMnemonic.parse((String)text2).getMnemonic());
        JPanel centerPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(centerPanel);
        centerPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(wrapper2).addComponent(this.myReplacePanel).addComponent(this.myScopePanel).addGroup(layout.createSequentialGroup().addComponent(searchTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(wrapper2).addGap(8).addComponent(this.myReplacePanel).addComponent(this.myScopePanel, -2, -1, -2).addGap(16).addGroup(layout.createParallelGroup().addComponent(searchTargetLabel).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        return centerPanel;
    }

    private JComponent createReplacePanel() {
        ToolbarLabel replacementTemplateLabel = new ToolbarLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        DefaultActionGroup labelGroup = new DefaultActionGroup(new AnAction[]{new Spacer(), replacementTemplateLabel});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar labelToolbar = actionManager.createActionToolbar("StructuralReplaceDialog", (ActionGroup)labelGroup, true);
        labelToolbar.setTargetComponent(null);
        CheckboxAction shortenFqn = new CheckboxAction(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                super.update(e);
                StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                e.getPresentation().setEnabledAndVisible(profile != null && profile.supportsShortenFQNames());
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (!StructuralSearchDialog.this.myReplace) {
                    return false;
                }
                return StructuralSearchDialog.this.myConfiguration.getReplaceOptions().isToShortenFQN();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.myConfiguration.getReplaceOptions().setToShortenFQN(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CheckboxAction staticImport = new CheckboxAction(SSRBundle.message("use.static.import.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                super.update(e);
                StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                e.getPresentation().setEnabledAndVisible(profile != null && profile.supportsUseStaticImports());
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (!StructuralSearchDialog.this.myReplace) {
                    return false;
                }
                return StructuralSearchDialog.this.myConfiguration.getReplaceOptions().isToUseStaticImport();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    7.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.myConfiguration.getReplaceOptions().setToUseStaticImport(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CheckboxAction reformat = new CheckboxAction(SSRBundle.message("reformat.checkbox", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (!StructuralSearchDialog.this.myReplace) {
                    return false;
                }
                return StructuralSearchDialog.this.myConfiguration.getReplaceOptions().isToReformatAccordingToStyle();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                StructuralSearchDialog.this.myConfiguration.getReplaceOptions().setToReformatAccordingToStyle(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup replacementActionGroup = new DefaultActionGroup(new AnAction[]{shortenFqn, staticImport, reformat});
        ActionToolbar replacementToolbar = actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)replacementActionGroup, true);
        replacementToolbar.setTargetComponent(null);
        OnePixelSplitter replaceEditorPanel = new OnePixelSplitter(false, 1.0f);
        replaceEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.myReplaceCriteriaEdit = this.createEditor(true);
        replaceEditorPanel.setFirstComponent((JComponent)((Object)this.myReplaceCriteriaEdit));
        JPanel wrapper2 = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("Borders.ContrastBorderColor");
        wrapper2.setBorder(IdeBorderFactory.createBorder((Color)color));
        wrapper2.add((Component)replaceEditorPanel, "Center");
        JPanel replacePanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(replacePanel);
        replacePanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(labelToolbar.getComponent(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(replacementToolbar.getComponent(), -2, -1, -2)).addComponent(wrapper2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(labelToolbar.getComponent(), -2, -1, -2).addComponent(replacementToolbar.getComponent(), -2, -1, -2)).addGap(4).addComponent(wrapper2));
        return replacePanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        List<PatternContext> contexts;
        DumbAwareAction historyAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).getHistoryConfigurations().isEmpty());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object source;
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (!((source = e.getInputEvent().getSource()) instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).getHistoryConfigurations()).setRenderer((ListCellRenderer)((Object)new ConfigurationCellRenderer())).setItemChosenCallback(c -> {
                    if (c instanceof ReplaceConfiguration && !StructuralSearchDialog.this.myReplace) {
                        StructuralSearchDialog.this.mySwitchAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)StructuralSearchDialog.this.mySwitchAction, null, (String)"unknown", (DataContext)DataContext.EMPTY_CONTEXT));
                    }
                    StructuralSearchDialog.this.loadConfiguration((Configuration)c);
                }).setSelectionMode(0).createPopup().showUnderneathOf((Component)source);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ActionUtil.copyFrom((AnAction)historyAction, (String)"ShowSearchHistory");
        ToolbarLabel searchTemplateLabel = new ToolbarLabel(SSRBundle.message("search.template", new Object[0]));
        DefaultActionGroup historyActionGroup = new DefaultActionGroup(new AnAction[]{historyAction, searchTemplateLabel});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar historyToolbar = actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)historyActionGroup, true);
        historyToolbar.setTargetComponent(null);
        CheckboxAction injected = new CheckboxAction(SSRBundle.message("search.in.injected.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myEditConfigOnly) {
                    e.getPresentation().setVisible(false);
                }
                super.update(e);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(1);
                }
                return StructuralSearchDialog.this.myConfiguration.getMatchOptions().isSearchInjectedCode();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    10.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.myConfiguration.getMatchOptions().setSearchInjectedCode(state);
                StructuralSearchDialog.this.initValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CheckboxAction recursive = new CheckboxAction(SSRBundle.message("recursive.matching.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(!StructuralSearchDialog.this.myReplace);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(1);
                }
                return StructuralSearchDialog.this.myConfiguration.getMatchOptions().isRecursiveSearch();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    11.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.myConfiguration.getMatchOptions().setRecursiveSearch(state);
                StructuralSearchDialog.this.initValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CheckboxAction matchCase = new CheckboxAction(FindBundle.message("find.popup.case.sensitive", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                return StructuralSearchDialog.this.myConfiguration.getMatchOptions().isCaseSensitiveMatch();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    12.$$$reportNull$$$0(1);
                }
                StructuralSearchDialog.this.myConfiguration.getMatchOptions().setCaseSensitiveMatch(state);
                StructuralSearchDialog.this.initValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFileType = UIUtil.detectFileType(this.mySearchContext);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null && !(contexts = profile.getPatternContexts()).isEmpty()) {
            this.myPatternContext = contexts.get(0);
        }
        this.myFileTypeChooser.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypeChooser.setFileTypeInfoConsumer(info2 -> {
            if (info2 == null) {
                this.myFileType = null;
                this.myDialect = null;
                this.myPatternContext = null;
            } else {
                this.myFileType = info2.getFileType();
                this.myDialect = info2.getDialect();
                this.myPatternContext = info2.getContext();
            }
            this.myOptionsToolbar.updateActionsImmediately();
            this.myFilterPanel.setFileType(this.myFileType);
            String contextId = this.myPatternContext == null ? "" : this.myPatternContext.getId();
            StructuralSearchProfile profile1 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
            Document searchDocument = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, this.mySearchCriteriaEdit.getText(), profile1);
            searchDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)(this.myFileType == null ? PlainTextFileType.INSTANCE : this.myFileType), searchDocument);
            searchDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            Document replaceDocument = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, this.myReplaceCriteriaEdit.getText(), profile1);
            replaceDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)(this.myFileType == null ? PlainTextFileType.INSTANCE : this.myFileType), replaceDocument);
            replaceDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            this.initValidation();
        });
        DefaultActionGroup templateActionGroup = new DefaultActionGroup();
        templateActionGroup.add((AnAction)new DumbAwareAction(SSRBundle.message("save.template.text.button", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!StringUtil.isEmptyOrSpaces((String)StructuralSearchDialog.this.mySearchCriteriaEdit.getText()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(1);
                }
                ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$13";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        templateActionGroup.add((AnAction)new DumbAwareAction(SSRBundle.message("save.inspection.action.text", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!StringUtil.isEmptyOrSpaces((String)StructuralSearchDialog.this.mySearchCriteriaEdit.getText()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$0(1);
                }
                StructuralSearchProfileActionProvider.createNewInspection(StructuralSearchDialog.this.getConfiguration(), StructuralSearchDialog.this.getProject());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$14";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        templateActionGroup.addSeparator();
        this.mySwitchAction = new SwitchAction();
        templateActionGroup.addAll(new AnAction[]{new CopyConfigurationAction(), new PasteConfigurationAction(), new DumbAwareAction(SSRBundle.message("copy.existing.template.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                SelectTemplateDialog dialog2;
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                if (!(dialog2 = new SelectTemplateDialog(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFilterPanel, false, StructuralSearchDialog.this.myReplace)).showAndGet()) {
                    return;
                }
                Configuration[] configurations = dialog2.getSelectedConfigurations();
                if (configurations.length == 1) {
                    MatchOptions source = StructuralSearchDialog.this.myConfiguration.getMatchOptions();
                    MatchOptions sink = configurations[0].getMatchOptions();
                    sink.setSearchInjectedCode(source.isSearchInjectedCode());
                    sink.setRecursiveSearch(source.isRecursiveSearch());
                    sink.setCaseSensitiveMatch(source.isCaseSensitiveMatch());
                    StructuralSearchDialog.this.loadConfiguration(configurations[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$15", "actionPerformed"));
            }
        }, Separator.getInstance(), this.mySwitchAction});
        templateActionGroup.setPopup(true);
        Presentation presentation2 = templateActionGroup.getTemplatePresentation();
        presentation2.setIcon(AllIcons.General.Settings);
        presentation2.setText(SSRBundle.message("tools.button", new Object[0]));
        final Icon filterModifiedIcon = ExecutionUtil.getLiveIndicator((Icon)AllIcons.General.Filter);
        DumbAwareToggleAction filterAction = new DumbAwareToggleAction(SSRBundle.message("filter.button", new Object[0]), SSRBundle.message("filter.button.description", new Object[0]), filterModifiedIcon){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    16.$$$reportNull$$$0(0);
                }
                super.update(e);
                Presentation presentation2 = e.getPresentation();
                presentation2.setIcon(StructuralSearchDialog.this.myFilterPanel.hasVisibleFilter() ? filterModifiedIcon : AllIcons.General.Filter);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    16.$$$reportNull$$$0(1);
                }
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    16.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.setFilterPanelVisible(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$16";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{injected, recursive, matchCase, this.myFileTypeChooser, filterAction, templateActionGroup});
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)optionsActionGroup, true);
        this.myOptionsToolbar.setTargetComponent((JComponent)((Object)this.mySearchCriteriaEdit));
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel northPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(northPanel);
        northPanel.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(historyToolbar.getComponent(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myOptionsToolbar, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(historyToolbar.getComponent()).addComponent(this.myOptionsToolbar));
        return northPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (this.myEditConfigOnly) {
            return null;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.myOpenInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.myOpenInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel2.add((Component)this.myOpenInNewTab, "East");
        return panel2;
    }

    private Project getProject() {
        return this.mySearchContext.getProject();
    }

    @Nullable
    public Point getInitialLocation() {
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension size2 = dimensionService.getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        if (size2 != null) {
            this.setSize(size2.width, this.myEditConfigOnly ? size2.height - this.myScopePanel.getPreferredSize().height : size2.height);
        } else {
            this.pack();
            Dimension otherSize = dimensionService.getSize(this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY, this.getProject());
            if (otherSize != null) {
                this.setSize(otherSize.width, this.getSize().height);
            }
        }
        if (this.myEditConfigOnly) {
            return super.getInitialLocation();
        }
        Point location = dimensionService.getLocation(SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        return location == null ? super.getInitialLocation() : location;
    }

    public void show() {
        if (!this.myUseLastConfiguration) {
            this.setTextFromContext();
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        this.setFilterPanelVisible(properties.getBoolean(FILTERS_VISIBLE_STATE, true));
        super.show();
        StructuralSearchPlugin.getInstance(this.getProject()).setDialog(this);
    }

    private void startTemplate() {
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder builder2 = StructuralSearchTemplateBuilder.getInstance().buildTemplate(psiFile);
        if (builder2 == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)SSRBundle.message("command.name.live.search.template.builder", new Object[0]), (String)"Structural Search", () -> builder2.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.removeMatchHighlights();
        this.myAlarm.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        if (this.myEditConfigOnly) {
            return;
        }
        SearchScope scope2 = this.myScopePanel.getScope();
        if (scope2 instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope2;
            FindInProjectSettings.getInstance((Project)this.getProject()).addDirectory(directoryScope.getDirectory().getPresentableUrl());
        }
        FindSettings.getInstance().setShowResultsInSeparateView(this.myOpenInNewTab.isSelected());
        ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
        this.startSearching();
    }

    public Configuration getConfiguration() {
        this.saveConfiguration();
        return this.myReplace ? new ReplaceConfiguration(this.myConfiguration) : new SearchConfiguration(this.myConfiguration);
    }

    private void removeMatchHighlights() {
        if (this.myEditConfigOnly || this.myRangeHighlighters.isEmpty()) {
            return;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.getProject();
            if (project.isDisposed()) {
                return;
            }
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter highlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    private void addMatchHighlights() {
        if (this.myEditConfigOnly || DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        Project project = this.getProject();
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(document));
        if (file2 == null) {
            return;
        }
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)file2, PredefinedSearchScopeProviderImpl.getCurrentFileScopeName()));
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        try {
            new Matcher(project, matchOptions).findMatches(sink);
            List<MatchResult> matches = sink.getMatches();
            this.removeMatchHighlights();
            this.addMatchHighlights(matches, editor, file2, SSRBundle.message("status.bar.text.results.found.in.current.file", matches.size()));
        }
        catch (StructuralSearchException e) {
            this.reportMessage(e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", ""), true, (JComponent)((Object)this.mySearchCriteriaEdit));
            this.removeMatchHighlights();
        }
    }

    private void addMatchHighlights(@NotNull List<? extends MatchResult> matchResults, @NotNull Editor editor, @NotNull PsiFile file2, @NlsContexts.StatusBarText @Nullable String statusBarText) {
        if (matchResults == null) {
            StructuralSearchDialog.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            StructuralSearchDialog.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            StructuralSearchDialog.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.getProject();
            if (project.isDisposed()) {
                return;
            }
            if (!matchResults.isEmpty()) {
                for (MatchResult result2 : matchResults) {
                    PsiElement match = result2.getMatch();
                    if (match == null || match.getContainingFile() != file2) continue;
                    int start2 = -1;
                    int end = -1;
                    if ("__multi_line__".equals(result2.getName())) {
                        for (MatchResult child2 : result2.getChildren()) {
                            int endOffset;
                            TextRange range2 = child2.getMatch().getTextRange();
                            int startOffset = range2.getStartOffset();
                            if (start2 == -1 || start2 > startOffset) {
                                start2 = startOffset;
                            }
                            if (end >= (endOffset = range2.getEndOffset())) continue;
                            end = endOffset;
                        }
                    } else {
                        TextRange range3 = match.getTextRange();
                        start2 = range3.getStartOffset();
                        end = range3.getEndOffset();
                    }
                    HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                    highlightManager.addRangeHighlight(editor, start2, end, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, this.myRangeHighlighters);
                }
                HighlightHandlerBase.setupFindModel(project);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo(statusBarText);
        });
    }

    protected boolean continuousValidation() {
        return false;
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        if (threadToUse == null) {
            StructuralSearchDialog.$$$reportNull$$$0(7);
        }
        return threadToUse;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        JRootPane component2 = this.getRootPane();
        if (component2 == null) {
            List<ValidationInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                StructuralSearchDialog.$$$reportNull$$$0(8);
            }
            return list2;
        }
        SmartList errors = new SmartList();
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        try {
            Project project = this.getProject();
            CompiledPattern compiledPattern = null;
            try {
                compiledPattern = PatternCompiler.compilePattern(project, matchOptions, true, !this.myEditConfigOnly && !this.myPerformAction);
            }
            catch (MalformedPatternException e) {
                this.removeMatchHighlights();
                if (!StringUtil.isEmptyOrSpaces((String)matchOptions.getSearchPattern())) {
                    String message2 = e.getMessage();
                    errors.add(new ValidationInfo(message2 == null ? SSRBundle.message("this.pattern.is.malformed.message", new Object[0]) : message2, (JComponent)((Object)this.mySearchCriteriaEdit)));
                }
            }
            catch (UnsupportedPatternException e) {
                this.removeMatchHighlights();
                errors.add(new ValidationInfo(e.getMessage(), (JComponent)((Object)this.mySearchCriteriaEdit)));
            }
            catch (NoMatchFoundException e) {
                this.removeMatchHighlights();
                errors.add(new ValidationInfo(e.getMessage(), (JComponent)((Object)this.mySearchCriteriaEdit)));
            }
            if (this.myReplace) {
                try {
                    Replacer.checkReplacementPattern(this.getProject(), this.myConfiguration.getReplaceOptions());
                }
                catch (UnsupportedPatternException e) {
                    errors.add(new ValidationInfo(e.getMessage(), (JComponent)((Object)this.myReplaceCriteriaEdit)));
                }
                catch (MalformedPatternException e) {
                    errors.add(new ValidationInfo(e.getMessage(), (JComponent)((Object)this.myReplaceCriteriaEdit)));
                }
            }
            this.initializeFilterPanel();
            if (compiledPattern != null) {
                this.addMatchHighlights();
            } else {
                errors.add(new ValidationInfo(""));
            }
            ApplicationManager.getApplication().invokeLater(() -> this.setSearchTargets(this.myConfiguration.getMatchOptions()), ModalityState.stateForComponent((Component)component2));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
        }
        SmartList smartList = errors;
        if (smartList == null) {
            StructuralSearchDialog.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private void reportMessage(@NlsContexts.PopupContent @Nullable String message2, boolean error2, @NotNull JComponent component2) {
        if (component2 == null) {
            StructuralSearchDialog.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            if (message2 == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, error2 ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            this.myBalloon.show(new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, component2.getHeight())), Balloon.Position.below);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        }, ModalityState.stateForComponent((Component)component2));
    }

    private void securityCheck() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int scripts = 0;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint.getScriptCodeConstraint().length() <= 2) continue;
            ++scripts;
        }
        if (this.myConfiguration instanceof ReplaceConfiguration) {
            ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
            for (ReplacementVariableDefinition variableDefinition : replaceOptions.getVariableDefinitions()) {
                if (variableDefinition.getScriptCodeConstraint().length() <= 2) continue;
                ++scripts;
            }
        }
        if (scripts > 0) {
            NotificationGroupManager.getInstance().getNotificationGroup("Structural Search").createNotification(SSRBundle.message("import.template.script.warning.title", new Object[0]), SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), scripts), NotificationType.WARNING).notify(this.mySearchContext.getProject());
        }
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.setFilterPanelVisible(true);
        this.myConfiguration.setCurrentVariableName(variableName);
    }

    private void setFilterPanelVisible(boolean visible) {
        if (visible) {
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            if (!this.isFilterPanelVisible()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelVisible()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    private boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void setSearchTargets(MatchOptions matchOptions) {
        ArrayList<String> names2 = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(names2);
        names2.remove("__context__");
        names2.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItems(names2);
        this.myTargetComboBox.setEnabled(names2.size() > 1);
        for (String name : names2) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint == null || !constraint.isPartOfSearchResults()) continue;
            this.myTargetComboBox.setSelectedItem(name);
            return;
        }
        this.myTargetComboBox.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
    }

    private boolean loadConfiguration(String text2) {
        if (text2 == null) {
            return false;
        }
        try {
            Configuration configuration2 = ConfigurationUtil.fromXml(text2);
            if (configuration2 == null) {
                return false;
            }
            if (configuration2 instanceof ReplaceConfiguration && !this.myReplace) {
                this.mySwitchAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.mySwitchAction, null, (String)"unknown", (DataContext)DataContext.EMPTY_CONTEXT));
            }
            this.loadConfiguration(configuration2);
            this.securityCheck();
        }
        catch (JDOMException e) {
            this.reportMessage(SSRBundle.message("import.template.script.corrupted", new Object[0]) + "\n" + e.getMessage(), false, this.myOptionsToolbar);
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration2) {
        Configuration newConfiguration = this.createConfiguration(configuration2);
        if (this.myUseLastConfiguration) {
            newConfiguration.setUuid(this.myConfiguration.getUuid());
            newConfiguration.setName(this.myConfiguration.getName());
            newConfiguration.setDescription(this.myConfiguration.getDescription());
            newConfiguration.setSuppressId(this.myConfiguration.getSuppressId());
            newConfiguration.setProblemDescriptor(this.myConfiguration.getProblemDescriptor());
        }
        this.myConfiguration = newConfiguration;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.setSearchTargets(matchOptions);
        if (!this.myEditConfigOnly) {
            SearchScope scope2 = matchOptions.getScope();
            this.myScopePanel.setScopesFromContext(scope2);
        }
        this.myFileTypeChooser.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor searchEditor = this.mySearchCriteriaEdit.getEditor();
        if (searchEditor != null) {
            searchEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            Editor replaceEditor = this.myReplaceCriteriaEdit.getEditor();
            if (replaceEditor != null) {
                replaceEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
            }
            if (configuration2 instanceof ReplaceConfiguration) {
                ReplaceOptions replaceOptions = configuration2.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
            }
        } else if (configuration2 instanceof ReplaceConfiguration) {
            matchOptions.setRecursiveSearch(properties.getBoolean(RECURSIVE_STATE));
        }
    }

    private void saveConfiguration() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.myEditConfigOnly) {
            SearchScope scope2 = this.myScopePanel.getScope();
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scope2.getDisplayName());
            matchOptions.setScope((SearchScope)(searchWithinHierarchy && !this.myPerformAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : scope2));
        } else {
            matchOptions.setScope(null);
        }
        if (this.myFileType != null) {
            matchOptions.setFileType(this.myFileType);
        }
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myPatternContext);
        matchOptions.setSearchPattern(this.getPattern(this.mySearchCriteriaEdit));
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
            replaceOptions.setReplacement(this.getPattern(this.myReplaceCriteriaEdit));
            matchOptions.setRecursiveSearch(false);
            properties.setValue(SHORTEN_FQN_STATE, replaceOptions.isToShortenFQN());
            properties.setValue(USE_STATIC_IMPORT_STATE, replaceOptions.isToUseStaticImport());
            properties.setValue(REFORMAT_STATE, replaceOptions.isToReformatAccordingToStyle());
        } else {
            properties.setValue(RECURSIVE_STATE, matchOptions.isRecursiveSearch());
        }
    }

    private String getPattern(EditorTextField textField2) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null) {
            Document document = textField2.getDocument();
            String pattern = (String)ReadAction.compute(() -> {
                PsiFile file2 = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
                assert (file2 != null);
                return profile.getCodeFragmentText(file2);
            });
            return pattern.isEmpty() ? textField2.getText() : pattern;
        }
        return textField2.getText();
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void dispose() {
        this.getProject().putUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION, (Object)this.myConfiguration);
        this.storeDimensions();
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(FILTERS_VISIBLE_STATE, this.isFilterPanelVisible(), true);
        StructuralSearchPlugin.getInstance(this.getProject()).setDialog(null);
        this.myAlarm.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        this.removeRestartHighlightingListenerFromCurrentEditor();
        super.dispose();
    }

    private void storeDimensions() {
        if (this.myEditConfigOnly) {
            return;
        }
        String key1 = this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY;
        String key2 = this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY;
        Point location = this.getLocation();
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        DimensionService dimensionService = DimensionService.getInstance();
        dimensionService.setLocation(SEARCH_DIMENSION_SERVICE_KEY, location, this.getProject());
        Dimension size2 = this.getSize();
        dimensionService.setSize(key1, size2, this.getProject());
        Dimension otherSize = dimensionService.getSize(key2, this.getProject());
        if (otherSize != null && otherSize.width != size2.width) {
            otherSize.width = size2.width;
            dimensionService.setSize(key2, otherSize, this.getProject());
        }
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationThreadToUse";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMatchHighlights";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditorTextField
    extends EditorTextField {
        private final boolean myReplace;

        MyEditorTextField(Document document, boolean replace) {
            super(document, StructuralSearchDialog.this.getProject(), (FileType)StructuralSearchDialog.this.myFileType, false, false);
            this.myReplace = replace;
        }

        @Override
        @NotNull
        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
            if (profile != null) {
                TemplateEditorUtil.setHighlighter((Editor)editor, UIUtil.getTemplateContextType(profile));
            }
            SubstitutionShortInfoHandler.install(editor, StructuralSearchDialog.this.myFilterPanel, variableName -> {
                if (variableName.endsWith("$replacement")) {
                    variableName = StringUtil.trimEnd((String)variableName, (String)"$replacement");
                    assert (StructuralSearchDialog.this.myConfiguration instanceof ReplaceConfiguration);
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddReplacementVariable(variableName, StructuralSearchDialog.this.myConfiguration));
                } else {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, StructuralSearchDialog.this.myConfiguration));
                }
                if (StructuralSearchDialog.this.isFilterPanelVisible()) {
                    StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)variableName);
                }
            }, StructuralSearchDialog.this.myDisposable, this.myReplace);
            editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, StructuralSearchDialog.this.myConfiguration);
            this.getDocument().putUserData(STRUCTURAL_SEARCH_ERROR_CALLBACK, () -> {
                if (this.getClientProperty("JComponent.outline") == null) {
                    StructuralSearchDialog.this.initValidation();
                }
            });
            TextCompletionUtil.installCompletionHint(editor);
            editor.putUserData(STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
            editor.setEmbeddedIntoDialogWrapper(true);
            EditorEx editorEx = editor;
            if (editorEx == null) {
                MyEditorTextField.$$$reportNull$$$0(0);
            }
            return editorEx;
        }

        @Override
        protected void updateBorder(@NotNull EditorEx editor) {
            if (editor == null) {
                MyEditorTextField.$$$reportNull$$$0(1);
            }
            this.setupBorder(editor);
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setBorder(new ErrorBorder(scrollPane.getBorder()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBorder";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class PasteConfigurationAction
    extends AnAction
    implements DumbAware {
        PasteConfigurationAction() {
            super(SSRBundle.messagePointer("import.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String contents;
            if (e == null) {
                PasteConfigurationAction.$$$reportNull$$$0(0);
            }
            if (!StructuralSearchDialog.this.loadConfiguration(contents = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor))) {
                StructuralSearchDialog.this.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, StructuralSearchDialog.this.myOptionsToolbar);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$PasteConfigurationAction", "actionPerformed"));
        }
    }

    private class CopyConfigurationAction
    extends AnAction
    implements DumbAware {
        CopyConfigurationAction() {
            super(SSRBundle.messagePointer("export.template.action", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyConfigurationAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!StringUtil.isEmptyOrSpaces((String)StructuralSearchDialog.this.mySearchCriteriaEdit.getText()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyConfigurationAction.$$$reportNull$$$0(1);
            }
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(StructuralSearchDialog.this.getConfiguration())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$CopyConfigurationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        SwitchAction() {
            this.init();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchAction.$$$reportNull$$$0(0);
            }
            StructuralSearchDialog.this.storeDimensions();
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension size2 = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.REPLACE_DIMENSION_SERVICE_KEY : StructuralSearchDialog.SEARCH_DIMENSION_SERVICE_KEY, e.getProject());
            if (size2 != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, size2.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.init();
        }

        private void init() {
            this.getTemplatePresentation().setText(SSRBundle.messagePointer(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet searchShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet replaceShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet shortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{searchShortcutSet, replaceShortcutSet}) : new CompositeShortcutSet(new ShortcutSet[]{replaceShortcutSet, searchShortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)shortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction", "actionPerformed"));
        }
    }

    private static class ErrorBorder
    implements Border {
        private final Border myErrorBorder;

        ErrorBorder(Border errorBorder) {
            this.myErrorBorder = errorBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            EditorTextField editorTextField = (EditorTextField)ComponentUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Object object = editorTextField.getClientProperty("JComponent.outline");
            if ("error".equals(object) || "warning".equals(object)) {
                this.myErrorBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myErrorBorder.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

