/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.util.ui.FontInfo;
import com.intellij.util.ui.JBDimension;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.Nullable;

public final class FontComboBox
extends AbstractFontCombo {
    private Model myModel;
    private final JBDimension mySize;

    public FontComboBox() {
        this(false);
    }

    public FontComboBox(boolean withAllStyles) {
        this(withAllStyles, true, false);
    }

    public FontComboBox(boolean withAllStyles, boolean filterNonLatin, boolean noFontItem) {
        super(new Model(withAllStyles, filterNonLatin, noFontItem));
        Dimension size2 = super.getPreferredSize();
        size2.width = size2.height * 8;
        this.mySize = JBDimension.create((Dimension)size2, (boolean)true);
        this.setSwingPopup(false);
        this.setRenderer((ListCellRenderer)((Object)new FontInfoRenderer()));
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -42 || e.getIndex1() != -42) {
                    return;
                }
                ComboPopup popup2 = FontComboBox.this.getPopup();
                if (popup2 != null && popup2.isVisible()) {
                    popup2.hide();
                    popup2.show();
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.mySize.size();
    }

    @Override
    public boolean isMonospacedOnly() {
        return this.myModel.myMonospacedOnly;
    }

    @Override
    public boolean isMonospacedOnlySupported() {
        return true;
    }

    @Override
    public void setMonospacedOnly(boolean monospaced) {
        this.myModel.setMonospacedOnly(monospaced);
    }

    @Override
    public String getFontName() {
        Object item = this.myModel.getSelectedItem();
        return item == null ? null : item.toString();
    }

    @Override
    public void setFontName(@NlsSafe @Nullable String item) {
        this.myModel.setSelectedItem(item);
    }

    @Override
    public boolean isNoFontSelected() {
        return this.myModel.isNoFontSelected();
    }

    public void setModel(ComboBoxModel model2) {
        if (!(model2 instanceof Model)) {
            throw new UnsupportedOperationException();
        }
        this.myModel = (Model)model2;
        super.setModel(model2);
    }

    private static final class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private final NoFontItem myNoFontItem;
        private volatile List<FontInfo> myAllFonts = Collections.emptyList();
        private volatile List<FontInfo> myMonoFonts = Collections.emptyList();
        private boolean myMonospacedOnly;
        private Object mySelectedItem;

        private Model(boolean withAllStyles, boolean filterNonLatin, boolean noFontItem) {
            this.myNoFontItem = noFontItem ? new NoFontItem() : null;
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isUnitTestMode()) {
                this.setFonts(FontInfo.getAll((boolean)withAllStyles), filterNonLatin);
            } else {
                application.executeOnPooledThread(() -> {
                    List all2 = FontInfo.getAll((boolean)withAllStyles);
                    application.invokeLater(() -> {
                        this.setFonts(all2, filterNonLatin);
                        this.onModelToggled();
                    }, application.getAnyModalityState());
                });
            }
        }

        private void setFonts(List<FontInfo> all2, boolean filterNonLatin) {
            ArrayList<FontInfo> allFonts = new ArrayList<FontInfo>(all2.size());
            ArrayList<FontInfo> monoFonts = new ArrayList<FontInfo>();
            for (FontInfo info2 : all2) {
                if (filterNonLatin && info2.getFont().canDisplayUpTo(info2.toString()) != -1) continue;
                allFonts.add(info2);
                if (!info2.isMonospaced()) continue;
                monoFonts.add(info2);
            }
            this.myAllFonts = allFonts;
            this.myMonoFonts = monoFonts;
        }

        public void setMonospacedOnly(boolean monospaced) {
            if (this.myMonospacedOnly != monospaced) {
                this.myMonospacedOnly = monospaced;
                this.onModelToggled();
            }
        }

        void onModelToggled() {
            Object item = this.getSelectedItem();
            this.setSelectedItem(null);
            this.setSelectedItem(item);
            this.fireContentsChanged(this, -42, -42);
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public void setSelectedItem(@Nullable Object item) {
            if (item == null && this.myNoFontItem != null) {
                item = this.myNoFontItem;
            } else {
                FontInfo info2;
                if (item instanceof FontInfo && (info2 = this.getInfo(item)) == null) {
                    List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
                    Object object = item = list2.isEmpty() ? null : list2.get(0);
                }
                if (item instanceof String && (info2 = this.getInfo(item)) != null) {
                    item = info2;
                }
            }
            if (!Comparing.equal((Object)this.mySelectedItem, (Object)item) || item == this.myNoFontItem) {
                this.mySelectedItem = item;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public boolean isNoFontSelected() {
            return this.getSelectedItem() == this.myNoFontItem;
        }

        @Override
        public int getSize() {
            List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
            int size2 = list2.size();
            if (this.mySelectedItem instanceof String) {
                ++size2;
            }
            if (this.myNoFontItem != null) {
                ++size2;
            }
            return size2;
        }

        @Override
        public Object getElementAt(int index2) {
            int i2 = index2;
            if (this.myNoFontItem != null) {
                if (index2 == 0) {
                    return this.myNoFontItem;
                }
                --i2;
            }
            List<FontInfo> list2 = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
            return 0 <= i2 && i2 < list2.size() ? list2.get(i2) : this.mySelectedItem;
        }

        private FontInfo getInfo(Object item) {
            for (FontInfo info2 : this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts) {
                if (!(item instanceof String ? info2.toString().equalsIgnoreCase((String)item) : info2.equals(item))) continue;
                return info2;
            }
            return null;
        }

        private static final class NoFontItem {
            private NoFontItem() {
            }

            public String toString() {
                return ApplicationBundle.message((String)"settings.editor.font.none", (Object[])new Object[0]);
            }
        }
    }
}

