/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;

class SlideComponent
extends JComponent {
    private static final int OFFSET = 11;
    private int myPointerValue = 0;
    private int myValue = 0;
    private final boolean myVertical;
    @Nls
    private final String myTitle;
    private final List<Consumer<? super Integer>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private LightweightHint myTooltipHint;
    private final JLabel myLabel = new JLabel();
    private Unit myUnit = Unit.LEVEL;

    void setUnits(Unit unit) {
        this.myUnit = unit;
    }

    SlideComponent(@Nls String title2, boolean vertical) {
        this.myTitle = title2;
        this.myVertical = vertical;
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SlideComponent.this.processMouse(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SlideComponent.this.processMouse(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SlideComponent.this.updateBalloonText();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                SlideComponent.this.updateBalloonText();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SlideComponent.this.myTooltipHint != null) {
                    SlideComponent.this.myTooltipHint.hide();
                    SlideComponent.this.myTooltipHint = null;
                }
            }
        });
        this.addMouseWheelListener(event -> {
            int units = event.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            int pointerValue = this.myPointerValue + units;
            pointerValue = Math.max(pointerValue, 11);
            int size2 = this.myVertical ? this.getHeight() : this.getWidth();
            this.myPointerValue = pointerValue = Math.min(pointerValue, size2 - 12);
            this.myValue = this.pointerValueToValue(this.myPointerValue);
            this.repaint();
            this.fireValueChanged();
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SlideComponent.this.setValue(SlideComponent.this.getValue());
                SlideComponent.this.fireValueChanged();
                SlideComponent.this.repaint();
            }
        });
    }

    private void updateBalloonText() {
        Point point = this.myVertical ? new Point(0, this.myPointerValue) : new Point(this.myPointerValue, 0);
        this.myLabel.setText(this.myTitle + ": " + Unit.formatValue(this.myValue, this.myUnit));
        if (this.myTooltipHint == null) {
            this.myTooltipHint = new LightweightHint(this.myLabel);
            this.myTooltipHint.setCancelOnClickOutside(false);
            this.myTooltipHint.setCancelOnOtherWindowOpen(false);
            HintHint hint = new HintHint(this, point).setPreferredPosition(this.myVertical ? Balloon.Position.atLeft : Balloon.Position.above).setBorderColor(Color.BLACK).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            this.myTooltipHint.show(this, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hint);
        } else {
            this.myTooltipHint.setLocation(new RelativePoint((Component)this, point));
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.updateBalloonText();
    }

    private void processMouse(MouseEvent e) {
        int pointerValue = this.myVertical ? e.getY() : e.getX();
        pointerValue = Math.max(pointerValue, 11);
        int size2 = this.myVertical ? this.getHeight() : this.getWidth();
        this.myPointerValue = pointerValue = Math.min(pointerValue, size2 - 12);
        this.myValue = this.pointerValueToValue(this.myPointerValue);
        this.repaint();
        this.fireValueChanged();
    }

    public void addListener(Consumer<? super Integer> listener2) {
        this.myListeners.add(listener2);
    }

    private void fireValueChanged() {
        for (Consumer<? super Integer> listener2 : this.myListeners) {
            listener2.consume((Object)this.myValue);
        }
    }

    public void setValue(int value2) {
        this.myPointerValue = this.valueToPointerValue(value2);
        this.myValue = value2;
    }

    public int getValue() {
        return this.myValue;
    }

    private int pointerValueToValue(int pointerValue) {
        int size2 = this.myVertical ? this.getHeight() : this.getWidth();
        float proportion = (float)(size2 - 23) / 255.0f;
        return Math.round((float)(pointerValue -= 11) / proportion);
    }

    private int valueToPointerValue(int value2) {
        int size2 = this.myVertical ? this.getHeight() : this.getWidth();
        float proportion = (float)(size2 - 23) / 255.0f;
        return 11 + (int)((float)value2 * proportion);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myVertical ? new Dimension(22, 100) : new Dimension(100, 22);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.myVertical ? new Dimension(22, 50) : new Dimension(50, 22);
    }

    @Override
    public final void setToolTipText(String text2) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.myVertical) {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)Color.WHITE, (float)0.0f, (float)this.getHeight(), (Color)Color.BLACK));
            g.fillRect(7, 10, 12, this.getHeight() - 20);
            g.setColor((Color)Gray._150);
            g.drawRect(7, 10, 12, this.getHeight() - 20);
            g.setColor((Color)Gray._250);
            g.drawRect(8, 11, 10, this.getHeight() - 22);
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)Color.WHITE, (float)this.getWidth(), (float)0.0f, (Color)Color.BLACK));
            g.fillRect(10, 7, this.getWidth() - 20, 12);
            g.setColor((Color)Gray._150);
            g.drawRect(10, 7, this.getWidth() - 20, 12);
            g.setColor((Color)Gray._250);
            g.drawRect(11, 8, this.getWidth() - 22, 10);
        }
        SlideComponent.drawKnob(g2d, this.myVertical ? 7 : this.myPointerValue, this.myVertical ? this.myPointerValue : 7, this.myVertical);
    }

    private static void drawKnob(Graphics2D g2d, int x, int y, boolean vertical) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (vertical) {
            Polygon arrowShadow = new Polygon();
            arrowShadow.addPoint(x - 5, (y -= 6) + 1);
            arrowShadow.addPoint(x + 7, y + 7);
            arrowShadow.addPoint(x - 5, y + 13);
            g2d.setColor(new Color(0, 0, 0, 70));
            g2d.fill(arrowShadow);
            Polygon arrowHead = new Polygon();
            arrowHead.addPoint(x - 6, y);
            arrowHead.addPoint(x + 6, y + 6);
            arrowHead.addPoint(x - 6, y + 12);
            g2d.setColor(new Color(153, 51, 0));
            g2d.fill(arrowHead);
        } else {
            Polygon arrowShadow = new Polygon();
            arrowShadow.addPoint((x -= 6) + 1, y - 5);
            arrowShadow.addPoint(x + 13, y - 5);
            arrowShadow.addPoint(x + 7, y + 7);
            g2d.setColor(new Color(0, 0, 0, 70));
            g2d.fill(arrowShadow);
            Polygon arrowHead = new Polygon();
            arrowHead.addPoint(x, y - 6);
            arrowHead.addPoint(x + 12, y - 6);
            arrowHead.addPoint(x + 6, y + 6);
            g2d.setColor(new Color(153, 51, 0));
            g2d.fill(arrowHead);
        }
    }

    static enum Unit {
        PERCENT,
        LEVEL;

        private static final float PERCENT_MAX_VALUE = 100.0f;
        private static final float LEVEL_MAX_VALUE = 255.0f;

        private static float getMaxValue(Unit unit) {
            return LEVEL.equals((Object)unit) ? 255.0f : 100.0f;
        }

        @NlsSafe
        private static String formatValue(int value2, Unit unit) {
            return String.format("%d%s", (int)(Unit.getMaxValue(unit) / 255.0f * (float)value2), unit.equals((Object)PERCENT) ? "%" : "");
        }
    }
}

