/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ComponentUtil;
import com.intellij.ui.WindowMouseListener;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WindowResizeListener
extends WindowMouseListener {
    private final Insets myBorder;
    private final Icon myCorner;

    public WindowResizeListener(Component content2, Insets border, Icon corner) {
        super(content2);
        this.myBorder = border;
        this.myCorner = corner;
    }

    public WindowResizeListener(Component content2, Icon corner) {
        super(content2);
        this.myBorder = null;
        this.myCorner = corner;
    }

    protected Insets getResizeOffset(Component view) {
        return null;
    }

    protected Insets getResizeBorder(Component view) {
        return this.myBorder;
    }

    @Override
    protected boolean isDisabled(Component view) {
        if (view instanceof Dialog && !((Dialog)view).isResizable()) {
            return true;
        }
        if (view instanceof Frame && !((Frame)view).isResizable()) {
            return true;
        }
        return super.isDisabled(view);
    }

    @Override
    int getCursorType(Component view, Point location) {
        Container parent;
        Container container = parent = view instanceof Window ? null : view.getParent();
        if (parent != null) {
            SwingUtilities.convertPointFromScreen(location, parent);
        }
        Rectangle bounds2 = view.getBounds();
        JBInsets.removeFrom((Rectangle)bounds2, (Insets)this.getResizeOffset(view));
        int top = location.y - bounds2.y;
        if (top < 0) {
            return -1;
        }
        int left = location.x - bounds2.x;
        if (left < 0) {
            return -1;
        }
        int right = bounds2.width - left;
        if (right < 0) {
            return -1;
        }
        int bottom = bounds2.height - top;
        if (bottom < 0) {
            return -1;
        }
        if (this.myCorner != null && right < this.myCorner.getIconWidth() && bottom < this.myCorner.getIconHeight()) {
            return 0;
        }
        Insets expected = this.getResizeBorder(view);
        if (expected != null) {
            if (view instanceof Frame) {
                int state = ((Frame)view).getExtendedState();
                if (WindowResizeListener.isStateSet(2, state)) {
                    left = Integer.MAX_VALUE;
                    right = Integer.MAX_VALUE;
                }
                if (WindowResizeListener.isStateSet(4, state)) {
                    top = Integer.MAX_VALUE;
                    bottom = Integer.MAX_VALUE;
                }
            }
            if (top < expected.top) {
                if (left < expected.left * 2) {
                    return 6;
                }
                if (right < expected.right * 2) {
                    return 7;
                }
                return 8;
            }
            if (bottom < expected.bottom) {
                if (left < expected.left * 2) {
                    return 4;
                }
                if (right < expected.right * 2) {
                    return 5;
                }
                return 9;
            }
            if (left < expected.left) {
                if (top < expected.top * 2) {
                    return 6;
                }
                if (bottom < expected.bottom * 2) {
                    return 4;
                }
                return 10;
            }
            if (right < expected.right) {
                if (top < expected.top * 2) {
                    return 7;
                }
                if (bottom < expected.bottom * 2) {
                    return 5;
                }
                return 11;
            }
        }
        return -1;
    }

    @Override
    void updateBounds(Rectangle bounds2, Component view, int dx, int dy) {
        Dimension minimum = this.getMinimumSize(view);
        if (this.myCursorType == 7 || this.myCursorType == 11 || this.myCursorType == 5 || this.myCursorType == 0) {
            bounds2.width += WindowResizeListener.fixMinSize(dx, bounds2.width, minimum.width);
        } else if (this.myCursorType == 6 || this.myCursorType == 10 || this.myCursorType == 4) {
            dx = WindowResizeListener.fixMinSize(-dx, bounds2.width, minimum.width);
            bounds2.x -= dx;
            bounds2.width += dx;
        }
        if (this.myCursorType == 4 || this.myCursorType == 9 || this.myCursorType == 5 || this.myCursorType == 0) {
            bounds2.height += WindowResizeListener.fixMinSize(dy, bounds2.height, minimum.height);
        } else if (this.myCursorType == 6 || this.myCursorType == 8 || this.myCursorType == 7) {
            dy = WindowResizeListener.fixMinSize(-dy, bounds2.height, minimum.height);
            bounds2.y -= dy;
            bounds2.height += dy;
        }
    }

    @Override
    protected void setCursorType(int cursorType) {
        super.setCursorType(cursorType);
        ourIsResizing = this.myCursorType >= 4 && this.myCursorType <= 11;
    }

    protected Dimension getMinimumSize(Component comp) {
        return comp.getMinimumSize();
    }

    private static int fixMinSize(int delta, int value2, int min) {
        return delta + value2 < min ? min - value2 : delta;
    }

    @ApiStatus.Experimental
    public static class ToolkitListener
    extends WindowResizeListener {
        private final WindowMouseListener.ToolkitListenerHelper myHelper;
        private final AtomicReference<Dimension> myMinSize = new AtomicReference();

        public ToolkitListener(final Component content2, Insets border, Icon corner) {
            super(content2, border, corner);
            this.myHelper = new WindowMouseListener.ToolkitListenerHelper(this);
            this.myMinSize.set(content2.getMinimumSize());
            final Window window = ComponentUtil.getWindow((Component)content2);
            if (window != null) {
                window.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (e.getID() == 1400) {
                            myMinSize.set(content2.getMinimumSize());
                        } else if (e.getID() == 4 && !window.isShowing()) {
                            window.removeHierarchyListener(this);
                        }
                    }
                });
            }
        }

        @Override
        protected void setBounds(Component comp, Rectangle bounds2) {
            this.myHelper.setBounds(comp, bounds2, () -> super.setBounds(comp, bounds2));
        }

        @Override
        protected void setCursor(@NotNull Component content2, Cursor cursor) {
            if (content2 == null) {
                ToolkitListener.$$$reportNull$$$0(0);
            }
            this.myHelper.setCursor(content2, cursor, () -> super.setCursor(content2, cursor));
        }

        @Override
        protected Dimension getMinimumSize(Component comp) {
            return this.myMinSize.get();
        }

        public void addTo(Component comp) {
            this.myHelper.addTo(comp);
        }

        public void removeFrom(Component comp) {
            this.myHelper.removeFrom(comp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/WindowResizeListener$ToolkitListener", "setCursor"));
        }
    }
}

