/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.io.IOException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Helpers {
    private static final Logger LOG = Logger.getInstance(Helpers.class);
    private static final String MODEL_ID_PREFIX = "Model Identifier:";
    @NonNls
    private static final String TB_SERVER_PROCESS = "TouchBarServer";
    private static final boolean FORCE_PHYSICAL_ESC = Boolean.getBoolean("touchbar.physical.esc");
    private static Boolean ourIsPhysicalEsc = null;
    private static Future<?> ourIsPhysicalEscFuture = null;
    private static Robot ourRobot = null;

    static void emulateKeyPress(int javaKeyEventCode) {
        if (ourRobot == null) {
            try {
                ourRobot = new Robot();
            }
            catch (AWTException e) {
                LOG.debug((Throwable)e);
            }
        }
        if (ourRobot == null) {
            return;
        }
        ourRobot.keyPress(javaKeyEventCode);
        ourRobot.keyRelease(javaKeyEventCode);
    }

    static boolean isTouchBarServerRunning() {
        GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pgrep", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
        try {
            ProcessOutput out = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
            return !out.getStdout().isEmpty();
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static boolean restartTouchBarServer() {
        try {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pkill", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
            ProcessOutput out = ExecUtil.sudoAndGetOutput((GeneralCommandLine)cmdLine, (String)"");
            return out.getStderr().isEmpty();
        }
        catch (ExecutionException | IOException e) {
            LOG.debug(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppId() {
        String appId;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        ID nativePool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
        try {
            ID bundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID dict = Foundation.invoke((ID)bundle, (String)"infoDictionary", (Object[])new Object[0]);
            ID nsAppID = Foundation.invoke((ID)dict, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleIdentifier")});
            appId = Foundation.toStringViaUTF8((ID)nsAppID);
        }
        finally {
            Foundation.invoke((ID)nativePool, (String)"release", (Object[])new Object[0]);
        }
        if (appId == null || appId.isEmpty()) {
            LOG.error("can't obtain application id from NSBundle.mainBundle");
        }
        return appId;
    }

    public static boolean isPhisycalEsc() {
        if (FORCE_PHYSICAL_ESC) {
            return true;
        }
        if (ourIsPhysicalEsc != null) {
            return ourIsPhysicalEsc;
        }
        if (ourIsPhysicalEscFuture != null) {
            if (!ourIsPhysicalEscFuture.isDone()) {
                return false;
            }
            ourIsPhysicalEscFuture = null;
            return ourIsPhysicalEsc;
        }
        ourIsPhysicalEsc = false;
        @NotNull Application app = ApplicationManager.getApplication();
        ourIsPhysicalEscFuture = app.executeOnPooledThread(() -> {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"system_profiler", TB_SERVER_PROCESS});
            cmdLine.addParameter("SPHardwareDataType");
            try {
                ProcessOutput out = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM));
                LOG.debug("SPHardwareDataType output:");
                for (String line : out.getStdoutLines(true)) {
                    LOG.debug("\t" + line);
                    if (!line.startsWith(MODEL_ID_PREFIX)) continue;
                    ourIsPhysicalEsc = line.substring(MODEL_ID_PREFIX.length()).contains("16");
                    LOG.debug("\tourIsPhysicalEsc=" + ourIsPhysicalEsc);
                }
            }
            catch (ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            return ourIsPhysicalEsc;
        });
        return false;
    }

    @Nullable
    static Component getCurrentFocusComponent() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = focusManager.getPermanentFocusOwner();
        }
        if (focusOwner == null) {
            return focusManager.getFocusedWindow();
        }
        return focusOwner;
    }

    @NotNull
    static String getActionId(@NotNull AnAction action2) {
        if (action2 == null) {
            Helpers.$$$reportNull$$$0(0);
        }
        String actionId = ActionManager.getInstance().getId((AnAction)(action2 instanceof CustomisedActionGroup ? ((CustomisedActionGroup)action2).getOrigin() : action2));
        String string = actionId == null ? action2.toString() : actionId;
        if (string == null) {
            Helpers.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/Helpers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/Helpers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

