/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jna.Pointer;
import java.awt.Dimension;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

class TBItemButton
extends TBItem {
    private static final int TEST_DELAY_MS = Integer.getInteger("touchbar.test.delay", 0);
    private static final Executor ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Touchbar buttons updater", (int)2);
    @Nullable
    protected final TouchBarStats.AnActionStats myActionStats;
    @Nullable
    private String myText;
    @Nullable
    private String myHint;
    private boolean myIsHintDisabled = false;
    private int myLayoutBits = 0;
    private boolean myHasArrowIcon = false;
    private boolean myNeedGetDisabledIcon = false;
    private AsyncPromise<Pair<Pointer, Dimension>> myRasterPromise;
    @Nullable
    private Runnable myAction;
    @Nullable
    private NSTLibrary.Action myNativeCallback;
    private boolean myExecuteOnEDT = true;
    private ModalityState myModality = null;
    @Nullable
    protected Icon myOriginIcon;
    protected int myFlags = 0;
    protected int myUpdateOptions;

    TBItemButton(@Nullable ItemListener listener2, @Nullable TouchBarStats.AnActionStats actionStats) {
        super("button", listener2);
        this.myActionStats = actionStats;
    }

    @Nullable
    private Icon getDarkIcon(@Nullable Icon icon2) {
        if (icon2 == null) {
            return null;
        }
        long startNs = this.myActionStats != null ? System.nanoTime() : 0L;
        icon2 = IconLoader.getDarkIcon((Icon)icon2, (boolean)true);
        if (this.myActionStats != null) {
            this.myActionStats.iconGetDarkDurationNs += System.nanoTime() - startNs;
        }
        return icon2;
    }

    TBItemButton setIcon(Icon icon2, boolean needGetDisabled) {
        if (!Objects.equals(icon2, this.myOriginIcon) || this.myNeedGetDisabledIcon != needGetDisabled) {
            this.myOriginIcon = icon2;
            this.myNeedGetDisabledIcon = needGetDisabled;
            this.myUpdateOptions |= 8;
        }
        return this;
    }

    TBItemButton setIcon(Icon icon2) {
        if (!Objects.equals(icon2, this.myOriginIcon) || this.myNeedGetDisabledIcon) {
            this.myOriginIcon = icon2;
            this.myNeedGetDisabledIcon = false;
            this.myUpdateOptions |= 8;
        }
        return this;
    }

    TBItemButton setIconFromPresentation(@NotNull Presentation presentation2) {
        Icon icon2;
        if (presentation2 == null) {
            TBItemButton.$$$reportNull$$$0(0);
        }
        boolean needGetDisabledIcon = false;
        if (presentation2.isEnabled()) {
            icon2 = presentation2.getIcon();
        } else {
            icon2 = presentation2.getDisabledIcon();
            if (icon2 == null && presentation2.getIcon() != null) {
                needGetDisabledIcon = true;
                icon2 = presentation2.getIcon();
            }
        }
        return this.setIcon(icon2, needGetDisabledIcon);
    }

    TBItemButton setIconAndTextFromPresentation(@NotNull Presentation presentation2, @Nullable TouchbarDataKeys.ActionDesc pd) {
        if (presentation2 == null) {
            TBItemButton.$$$reportNull$$$0(1);
        }
        if (pd != null) {
            if (pd.isShowImage() && pd.isShowText()) {
                this.setIconFromPresentation(presentation2);
                this.setText(presentation2.getText());
            } else if (pd.isShowText()) {
                this.setText(presentation2.getText());
                this.setIcon(null);
            } else {
                this.setIconFromPresentation(presentation2);
                this.setText(this.myOriginIcon != null ? null : presentation2.getText());
            }
        } else {
            this.setIconFromPresentation(presentation2);
            this.setText(this.myOriginIcon != null ? null : presentation2.getText());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TBItemButton setHasArrowIcon(boolean hasArrowIcon) {
        if (hasArrowIcon != this.myHasArrowIcon) {
            this.myHasArrowIcon = hasArrowIcon;
            TBItemButton tBItemButton = this;
            synchronized (tBItemButton) {
                if (this.myNativePeer != ID.NIL) {
                    Icon ic2 = this.myHasArrowIcon ? AllIcons.Mac.Touchbar.PopoverArrow : null;
                    NST.setArrowImage(this.myNativePeer, ic2);
                }
            }
        }
        return this;
    }

    TBItemButton setText(String text2) {
        if (!Objects.equals(text2, this.myText)) {
            this.myText = text2;
            this.myUpdateOptions |= 4;
        }
        return this;
    }

    TBItemButton setText(String text2, String hint, boolean isHintDisabled) {
        if (!Objects.equals(text2, this.myText) || !Objects.equals(hint, this.myHint) || hint != null && this.myIsHintDisabled != isHintDisabled) {
            this.myText = text2;
            this.myHint = hint;
            this.myIsHintDisabled = isHintDisabled;
            this.myUpdateOptions |= 4;
        }
        return this;
    }

    TBItemButton setModality(ModalityState modality) {
        this.myModality = modality;
        return this;
    }

    TBItemButton setAction(Runnable action2, boolean executeOnEDT) {
        if (action2 != this.myAction || this.myExecuteOnEDT != executeOnEDT) {
            this.myAction = action2;
            this.myExecuteOnEDT = executeOnEDT;
            this.myNativeCallback = this.myAction == null ? null : () -> {
                if (this.myExecuteOnEDT) {
                    @NotNull Application app = ApplicationManager.getApplication();
                    if (this.myModality != null) {
                        app.invokeLater(this.myAction, this.myModality);
                    } else {
                        app.invokeLater(this.myAction);
                    }
                } else {
                    this.myAction.run();
                }
                ActivityTracker.getInstance().inc();
                if (this.myListener != null) {
                    this.myListener.onItemEvent(this, 0);
                }
            };
            this.myUpdateOptions |= 0x10;
        }
        return this;
    }

    TBItemButton setWidth(int width) {
        return this.setLayout(width, 0, 2, 8);
    }

    TBItemButton setLayout(int width, int widthFlags, int margin, int border) {
        if (width < 0) {
            width = 0;
        }
        if (margin < 0) {
            margin = 0;
        }
        if (border < 0) {
            border = 0;
        }
        int newLayout = width & 0xFFF;
        newLayout |= widthFlags;
        newLayout |= NSTLibrary.margin2mask((byte)margin);
        if (this.myLayoutBits != (newLayout |= NSTLibrary.border2mask((byte)border))) {
            this.myLayoutBits = newLayout;
            this.myUpdateOptions |= 1;
        }
        return this;
    }

    TBItemButton setPriority(byte prio) {
        int flags = this.myFlags | NSTLibrary.priority2mask(prio);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    TBItemButton setToggle() {
        return this._setFlag(8, true);
    }

    TBItemButton setColored() {
        return this._setFlag(4, true);
    }

    TBItemButton setSelected(boolean isSelected) {
        return this._setFlag(2, isSelected);
    }

    TBItemButton setDisabled(boolean isDisabled) {
        return this._setFlag(1, isDisabled);
    }

    TBItemButton setTransparentBg() {
        return this._setFlag(16, true);
    }

    private TBItemButton _setFlag(int nstLibFlag, boolean val) {
        int flags = TBItemButton._applyFlag(this.myFlags, val, nstLibFlag);
        if (flags != this.myFlags) {
            this.myFlags = flags;
            this.myUpdateOptions |= 2;
        }
        return this;
    }

    boolean updateLater(boolean force) {
        if (!(force || this.myIsVisible && this.myUpdateOptions != 0 && this.myNativePeer != ID.NIL)) {
            return false;
        }
        if (this.myRasterPromise != null && !this.myRasterPromise.isDone()) {
            this.myRasterPromise.cancel();
        }
        this.myRasterPromise = new AsyncPromise();
        this.myRasterPromise.onSuccess(raster -> {
            int updateOptions = this.myUpdateOptions;
            String text2 = (updateOptions & 4) != 0 ? this.myText : null;
            String hint = (updateOptions & 4) != 0 ? this.myHint : null;
            NSTLibrary.Action callback2 = (updateOptions & 0x10) != 0 ? this.myNativeCallback : null;
            int validFlags = this._validateFlags();
            int isHintDisabled = this.myIsHintDisabled ? 1 : 0;
            int layoutBits = this.myLayoutBits;
            this.myUpdateOptions = 0;
            TBItemButton tBItemButton = this;
            synchronized (tBItemButton) {
                if (this.myNativePeer.equals((Object)ID.NIL)) {
                    return;
                }
                NST.updateButton(this.myNativePeer, updateOptions, layoutBits, validFlags, text2, hint, isHintDisabled, (Pair<Pointer, Dimension>)raster, callback2);
            }
        });
        ourExecutor.execute(() -> {
            if (this.myOriginIcon == null || !force && (this.myUpdateOptions & 8) == 0) {
                if (TEST_DELAY_MS > 0) {
                    TBItemButton.waitTheTestDelay();
                }
                this.myRasterPromise.setResult(null);
                return;
            }
            long startNs = this.myActionStats != null ? System.nanoTime() : 0L;
            Icon icon2 = (Icon)ReadAction.nonBlocking(() -> {
                Icon darkIcon;
                if (TEST_DELAY_MS > 0) {
                    TBItemButton.waitTheTestDelay();
                }
                if ((darkIcon = this.getDarkIcon(this.myOriginIcon)) == null) {
                    return null;
                }
                return this.myNeedGetDisabledIcon ? IconLoader.getDisabledIcon((Icon)darkIcon) : darkIcon;
            }).executeSynchronously();
            Pair<Pointer, Dimension> raster = NST.get4ByteRGBARaster(icon2);
            if (this.myActionStats != null && raster != null) {
                ++this.myActionStats.iconUpdateIconRasterCount;
                this.myActionStats.iconRenderingDurationNs += System.nanoTime() - startNs;
            }
            this.myRasterPromise.setResult(raster);
        });
        return true;
    }

    private static void waitTheTestDelay() {
        if (TEST_DELAY_MS <= 0) {
            return;
        }
        ProgressIndicator progress2 = Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator());
        long start2 = System.currentTimeMillis();
        while (true) {
            progress2.checkCanceled();
            if (System.currentTimeMillis() - start2 > (long)TEST_DELAY_MS) break;
            TimeoutUtil.sleep((long)1L);
        }
    }

    @Override
    protected ID _createNativePeer() {
        if (this.myOriginIcon != null && this.myRasterPromise == null) {
            this.updateLater(true);
        }
        ID result2 = NST.createButton(this.getUid(), this.myLayoutBits, this._validateFlags(), this.myText, this.myHint, this.myIsHintDisabled ? 1 : 0, this.myRasterPromise == null || !this.myRasterPromise.isSucceeded() ? null : (Pair)this.myRasterPromise.get(), this.myNativeCallback);
        if (this.myHasArrowIcon) {
            Icon ic2 = AllIcons.Mac.Touchbar.PopoverArrow;
            NST.setArrowImage(result2, ic2);
        }
        return result2;
    }

    private int _validateFlags() {
        int flags = this.myFlags;
        if ((flags & 4) != 0 && (flags & 1) != 0) {
            return flags & 0xFFFFFFFB;
        }
        return flags;
    }

    private static int _applyFlag(int src, boolean include, int flag) {
        return include ? src | flag : src & ~flag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "presentation";
        objectArray2[1] = "com/intellij/ui/mac/touchbar/TBItemButton";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setIconFromPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setIconAndTextFromPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

