/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.GroupHeaderSeparator;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.popup.NumericMnemonicItem;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupListElementRenderer<E>
extends GroupedItemsListRenderer<E> {
    public static final Key<@NlsSafe String> CUSTOM_KEY_STROKE_TEXT = new Key("CUSTOM_KEY_STROKE_TEXT");
    protected final ListPopupImpl myPopup;
    private JLabel myShortcutLabel;
    @Nullable
    private JLabel myValueLabel;
    protected JLabel myMnemonicLabel;
    protected JLabel myIconLabel;
    protected JComponent myButtonPane;
    protected JComponent myMainPane;
    protected JComponent myNextStepButtonSeparator;
    protected JComponent myIconBar;

    public PopupListElementRenderer(final ListPopupImpl aPopup) {
        super(new ListItemDescriptorAdapter<E>(){

            @Override
            public String getTextFor(E value2) {
                return aPopup.getListStep().getTextFor(value2);
            }

            @Override
            public Icon getIconFor(E value2) {
                return aPopup.getListStep().getIconFor(value2);
            }

            @Override
            public Icon getSelectedIconFor(E value2) {
                return aPopup.getListStep().getSelectedIconFor(value2);
            }

            @Override
            public boolean hasSeparatorAboveOf(E value2) {
                return aPopup.getListModel().isSeparatorAboveOf(value2);
            }

            @Override
            public String getCaptionAboveOf(E value2) {
                return aPopup.getListModel().getCaptionAboveOf(value2);
            }

            @Override
            @Nullable
            public String getTooltipFor(E value2) {
                ListPopupStep<Object> listStep = aPopup.getListStep();
                if (!(listStep instanceof ListPopupStepEx)) {
                    return null;
                }
                return ((ListPopupStepEx)listStep).getTooltipTextFor(value2);
            }
        });
        this.myPopup = aPopup;
    }

    protected SeparatorWithText createSeparator() {
        return new GroupHeaderSeparator(this.getDefaultItemComponentBorder().getBorderInsets(new JLabel()));
    }

    @Override
    protected JComponent createItemComponent() {
        this.createLabel();
        JPanel panel2 = new JPanel(new BorderLayout()){
            private final AccessibleContext myAccessibleContext;
            {
                this.myAccessibleContext = PopupListElementRenderer.this.myTextLabel.getAccessibleContext();
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.myAccessibleContext == null) {
                    return super.getAccessibleContext();
                }
                return this.myAccessibleContext;
            }
        };
        panel2.add((Component)this.myTextLabel, "West");
        this.myValueLabel = new JLabel();
        this.myValueLabel.setEnabled(false);
        this.myValueLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUIScale.scale((int)8), (int)1, (int)0));
        this.myValueLabel.setForeground(UIManager.getColor("MenuItem.acceleratorForeground"));
        this.myValueLabel.setOpaque(false);
        panel2.add((Component)this.myValueLabel, "Center");
        this.myShortcutLabel = new JLabel();
        this.myShortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)1, (int)3));
        this.myShortcutLabel.setForeground(UIManager.getColor("MenuItem.acceleratorForeground"));
        this.myShortcutLabel.setOpaque(false);
        panel2.add((Component)this.myShortcutLabel, "East");
        this.myMnemonicLabel = new JLabel();
        Dimension preferredSize = new JLabel("W").getPreferredSize();
        Insets insets = JBUI.CurrentTheme.ActionsList.numberMnemonicInsets();
        JBInsets.addTo((Dimension)preferredSize, (Insets)insets);
        this.myMnemonicLabel.setPreferredSize(preferredSize);
        this.myMnemonicLabel.setBorder((Border)new JBEmptyBorder(insets));
        this.myMnemonicLabel.setFont(JBUI.CurrentTheme.ActionsList.applyStylesForNumberMnemonic((Font)this.myMnemonicLabel.getFont()));
        this.myMnemonicLabel.setVisible(false);
        this.myIconBar = this.createIconBar();
        return this.layoutComponent(panel2);
    }

    @Override
    protected void createLabel() {
        super.createLabel();
        this.myIconLabel = new JLabel();
    }

    @Override
    protected JComponent layoutComponent(JComponent middleItemComponent) {
        this.myNextStepLabel = new JLabel();
        this.myNextStepLabel.setOpaque(false);
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)middleItemComponent, "Center");
        JPanel right = new JPanel(new BorderLayout());
        int leftRightInset = (20 - AllIcons.Icons.Ide.MenuArrow.getIconWidth()) / 2;
        right.add((Component)this.myNextStepLabel, "Center");
        this.myNextStepButtonSeparator = PopupListElementRenderer.createNextStepButtonSeparator();
        left.add((Component)this.myNextStepButtonSeparator, "East");
        if (this.myIconBar != null) {
            left.add((Component)this.myIconBar, "West");
        }
        JPanel result2 = new JPanel();
        result2.setLayout(new GridBagLayout());
        result2.setBorder((Border)JBUI.Borders.empty());
        Insets insets = this.getDefaultItemComponentBorder().getBorderInsets(result2);
        left.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)0));
        right.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)leftRightInset, (int)insets.bottom, (int)insets.right));
        GridBag gbc = new GridBag().setDefaultAnchor(0, 17).setDefaultWeightX(0, 1.0).setDefaultAnchor(10).setDefaultWeightX(0.0).setDefaultWeightY(1.0).setDefaultPaddingX(0).setDefaultPaddingY(0).setDefaultInsets(0, 0, 0, 0).setDefaultFill(1);
        result2.add((Component)left, gbc.next());
        result2.add((Component)right, gbc.next());
        this.myMainPane = left;
        this.myButtonPane = right;
        return result2;
    }

    protected void setComponentIcon(Icon icon2, Icon disabledIcon) {
        if (this.myIconLabel == null) {
            return;
        }
        this.myIconLabel.setIcon(icon2);
        this.myIconLabel.setDisabledIcon(disabledIcon);
    }

    @NotNull
    protected static JComponent createNextStepButtonSeparator() {
        SeparatorComponent separator = new SeparatorComponent((Color)JBColor.namedColor((String)"Menu.separatorColor", (Color)JBColor.lightGray), SeparatorOrientation.VERTICAL);
        separator.setHGap(0);
        separator.setVGap(2);
        SeparatorComponent separatorComponent = separator;
        if (separatorComponent == null) {
            PopupListElementRenderer.$$$reportNull$$$0(0);
        }
        return separatorComponent;
    }

    @Override
    @Nullable
    protected Icon getItemIcon(E value2, boolean isSelected) {
        if (!Registry.is((String)"ide.list.popup.separate.next.step.button")) {
            return super.getItemIcon(value2, isSelected);
        }
        ListPopupStep<Object> step2 = this.myPopup.getListStep();
        return step2.hasSubstep(value2) && step2.isFinal(value2) && this.isNextStepButtonSelected(this.myPopup.getList()) ? this.myDescriptor.getIconFor(value2) : super.getItemIcon(value2, isSelected);
    }

    @Override
    protected void customizeComponent(JList<? extends E> list2, E value2, boolean isSelected) {
        if (this.mySeparatorComponent.isVisible() && this.mySeparatorComponent instanceof GroupHeaderSeparator) {
            ((GroupHeaderSeparator)this.mySeparatorComponent).setHideLine(this.myCurrentIndex == 0);
        }
        ListPopupStep<Object> step2 = this.myPopup.getListStep();
        boolean isSelectable = step2.isSelectable(value2);
        this.myTextLabel.setEnabled(isSelectable);
        this.myMainPane.setOpaque(false);
        this.myButtonPane.setOpaque(false);
        this.myNextStepButtonSeparator.setVisible(false);
        boolean nextStepButtonSelected = false;
        if (step2.hasSubstep(value2)) {
            this.myNextStepLabel.setVisible(isSelectable);
            if (Registry.is((String)"ide.list.popup.separate.next.step.button") && step2.isFinal(value2)) {
                this.myMainPane.setOpaque(true);
                this.myButtonPane.setOpaque(true);
                this.myComponent.setBackground(this.calcBackground(false, isSelected));
                nextStepButtonSelected = this.isNextStepButtonSelected(list2);
                this.myMainPane.setBackground(this.calcBackground(isSelected && !nextStepButtonSelected, isSelected));
                this.myButtonPane.setBackground(this.calcBackground(isSelected && nextStepButtonSelected, isSelected));
                this.setForegroundSelected((JComponent)this.myTextLabel, isSelected && !nextStepButtonSelected);
                this.myNextStepLabel.setIcon(isSelectable && isSelected && nextStepButtonSelected ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow);
                this.myNextStepButtonSeparator.setVisible(!isSelected);
            } else {
                this.myNextStepLabel.setIcon(isSelectable && isSelected ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow);
                this.myComponent.setBackground(this.calcBackground(isSelected && isSelectable, false));
                this.setForegroundSelected((JComponent)this.myTextLabel, isSelected && isSelectable);
            }
        } else {
            this.myNextStepLabel.setVisible(false);
        }
        if (step2 instanceof BaseListPopupStep) {
            E prevValue;
            Color bg = ((BaseListPopupStep)step2).getBackgroundFor(value2);
            Color fg = ((BaseListPopupStep)step2).getForegroundFor(value2);
            if (!isSelected && fg != null) {
                this.myTextLabel.setForeground(fg);
            }
            if (!isSelected && bg != null) {
                UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)bg);
            }
            if (bg != null && this.mySeparatorComponent.isVisible() && this.myCurrentIndex > 0 && Comparing.equal((Object)bg, (Object)((BaseListPopupStep)step2).getBackgroundFor(prevValue = list2.getModel().getElementAt(this.myCurrentIndex - 1)))) {
                this.myRendererComponent.setBackground(bg);
            }
        }
        if (this.myMnemonicLabel != null && value2 instanceof NumericMnemonicItem && ((NumericMnemonicItem)value2).digitMnemonicsEnabled()) {
            Character mnemonic = ((NumericMnemonicItem)value2).getMnemonicChar();
            this.myMnemonicLabel.setText(mnemonic != null ? String.valueOf(mnemonic) : "");
            this.myMnemonicLabel.setForeground(isSelected && isSelectable && !nextStepButtonSelected ? this.getSelectionForeground() : JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND);
            this.myMnemonicLabel.setVisible(true);
        }
        if (step2.isMnemonicsNavigationEnabled()) {
            int pos;
            MnemonicNavigationFilter filter = step2.getMnemonicNavigationFilter();
            int n = pos = filter == null ? -1 : filter.getMnemonicPos(value2);
            if (pos != -1) {
                Object text2 = this.myTextLabel.getText();
                text2 = ((String)text2).substring(0, pos) + ((String)text2).substring(pos + 1);
                this.myTextLabel.setText((String)text2);
                this.myTextLabel.setDisplayedMnemonicIndex(pos);
            }
        } else {
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        }
        if (this.myShortcutLabel != null) {
            this.myShortcutLabel.setEnabled(isSelectable);
            this.myShortcutLabel.setText("");
            if (value2 instanceof ShortcutProvider) {
                AnAction action2;
                Shortcut shortcut;
                ShortcutSet set2 = ((ShortcutProvider)value2).getShortcut();
                String shortcutText = null;
                if (set2 != null && (shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])set2.getShortcuts())) != null) {
                    shortcutText = KeymapUtil.getShortcutText((Shortcut)shortcut);
                }
                if (shortcutText == null && value2 instanceof AnActionHolder && (action2 = ((AnActionHolder)value2).getAction()) instanceof UserDataHolder) {
                    shortcutText = (String)((UserDataHolder)action2).getUserData(CUSTOM_KEY_STROKE_TEXT);
                }
                if (shortcutText != null) {
                    this.myShortcutLabel.setText("     " + shortcutText);
                }
            }
            this.myShortcutLabel.setForeground(isSelected && isSelectable && !nextStepButtonSelected ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
        }
        if (this.myValueLabel != null) {
            this.myValueLabel.setText(step2 instanceof ListPopupStepEx ? ((ListPopupStepEx)step2).getValueFor(value2) : null);
            boolean selected2 = isSelected && isSelectable && !nextStepButtonSelected;
            this.setForegroundSelected(this.myValueLabel, selected2);
        }
    }

    protected JComponent createIconBar() {
        Box res2 = Box.createHorizontalBox();
        res2.setBorder((Border)JBUI.Borders.emptyRight((int)JBUI.CurrentTheme.ActionsList.elementIconGap()));
        res2.add(this.myIconLabel);
        res2.add(this.myMnemonicLabel);
        return res2;
    }

    private Color calcBackground(boolean selected2, boolean hovered2) {
        if (selected2) {
            return this.getSelectionBackground();
        }
        if (hovered2) {
            return JBUI.CurrentTheme.Table.Hover.background((boolean)true);
        }
        return this.getBackground();
    }

    protected boolean isNextStepButtonSelected(JList<?> list2) {
        if (!Registry.is((String)"ide.list.popup.separate.next.step.button")) {
            return false;
        }
        return list2 instanceof ListPopupImpl.NestedList && ((ListPopupImpl.NestedList)((Object)list2)).isNextStepButtonSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/list/PopupListElementRenderer", "createNextStepButtonSeparator"));
    }
}

