/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.ItemWrapperListRenderer;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.ui.popup.util.SplitterItem;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MasterDetailPopupBuilder
implements MasterController {
    private static final Color BORDER_COLOR = Gray._135;
    private final Project myProject;
    private final DetailController myDetailController = new DetailController(this);
    private JComponent myChooserComponent;
    private Delegate myDelegate;
    private DetailView myDetailView;
    private JLabel myPathLabel;
    private JBPopup myPopup;
    private SpeedSearch mySpeedSearch;
    private String myDimensionServiceKey = null;
    private boolean myAddDetailViewToEast = true;
    private ActionGroup myActions = null;
    private Consumer<? super IPopupChooserBuilder> myPopupTuner = null;
    private Runnable myDoneRunnable = null;

    public MasterDetailPopupBuilder(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MasterDetailPopupBuilder setList(@NotNull JBList list2) {
        if (list2 == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(0);
        }
        this.myChooserComponent = list2;
        this.myDetailController.setList(list2);
        list2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    MasterDetailPopupBuilder.this.removeSelectedItems();
                } else if (e.getModifiersEx() == 0 && !MasterDetailPopupBuilder.this.mySpeedSearch.isHoldingFilter()) {
                    MasterDetailPopupBuilder.this.myDelegate.handleMnemonic(e, MasterDetailPopupBuilder.this.myProject, MasterDetailPopupBuilder.this.myPopup);
                }
            }
        });
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MasterDetailPopupBuilder.this.chooseItems(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)list2);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                MasterDetailPopupBuilder.this.chooseItems(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$3", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, (JComponent)list2);
        list2.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                MasterDetailPopupBuilder.this.myDetailController.updateDetailView();
            }
        });
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(1);
        }
        return masterDetailPopupBuilder;
    }

    private void removeSelectedItems() {
        if (this.myChooserComponent instanceof JList) {
            Object[] values2;
            JList list2 = (JList)this.myChooserComponent;
            ListModel listModel = list2.getModel();
            int index2 = list2.getSelectedIndex();
            if (index2 == -1 || index2 >= listModel.getSize()) {
                return;
            }
            for (Object value2 : values2 = list2.getSelectedValues()) {
                ItemWrapper item = (ItemWrapper)value2;
                if (!item.allowedToRemove()) continue;
                DefaultListModel model2 = listModel instanceof DefaultListModel ? (DefaultListModel)listModel : (DefaultListModel)((FilteringListModel)listModel).getOriginalModel();
                model2.removeElement(item);
                if (model2.getSize() > 0) {
                    if (model2.getSize() == index2) {
                        list2.setSelectedIndex(model2.getSize() - 1);
                    } else if (model2.getSize() > index2) {
                        list2.setSelectedIndex(index2);
                    }
                } else {
                    list2.clearSelection();
                }
                item.removed(this.myProject);
            }
        } else {
            this.myDelegate.removeSelectedItemsInTree();
        }
    }

    private void chooseItems(boolean withEnterOrDoubleClick) {
        for (ItemWrapper item : this.getSelectedItems()) {
            this.myDelegate.itemChosen(item, this.myProject, this.myPopup, withEnterOrDoubleClick);
        }
    }

    @NotNull
    public MasterDetailPopupBuilder setDelegate(@NotNull Delegate delegate2) {
        if (delegate2 == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(2);
        }
        this.myDelegate = delegate2;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(3);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setDetailView(@NotNull DetailView detailView) {
        if (detailView == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(4);
        }
        this.myDetailView = detailView;
        this.myDetailController.setDetailView(this.myDetailView);
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(5);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(6);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setAddDetailViewToEast(boolean addDetailViewToEast) {
        this.myAddDetailViewToEast = addDetailViewToEast;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(7);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setActionsGroup(@Nullable ActionGroup actions2) {
        this.myActions = actions2;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(8);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setPopupTuner(@Nullable Consumer<? super IPopupChooserBuilder> tuner) {
        this.myPopupTuner = tuner;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(9);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public MasterDetailPopupBuilder setDoneRunnable(@Nullable Runnable doneRunnable) {
        this.myDoneRunnable = doneRunnable;
        MasterDetailPopupBuilder masterDetailPopupBuilder = this;
        if (masterDetailPopupBuilder == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(10);
        }
        return masterDetailPopupBuilder;
    }

    @NotNull
    public JBPopup createMasterDetailPopup() {
        String title2;
        if (this.myChooserComponent instanceof JList) {
            ((JList)this.myChooserComponent).setCellRenderer(new ListItemRenderer(this.myProject, this.myDelegate));
        }
        if (this.myDetailView == null) {
            this.setDetailView(new DetailViewImpl(this.myProject));
        }
        this.myPathLabel = new JLabel(" ");
        this.myPathLabel.setHorizontalAlignment(4);
        this.myPathLabel.setFont(this.myPathLabel.getFont().deriveFont(10.0f));
        JPanel footerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOR);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        footerPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)(SystemInfo.isMac ? 20 : 4)));
        footerPanel.add(this.myPathLabel);
        Runnable itemCallback = () -> IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(() -> this.chooseItems(false));
        JComponent toolBar = null;
        if (this.myActions != null) {
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("MasterDetailPopup", this.myActions, true);
            actionToolbar.setReservePlaceAutoPopupIcon(false);
            actionToolbar.setMinimumButtonSize(new Dimension(20, 20));
            toolBar = actionToolbar.getComponent();
            toolBar.setBorder(JBUI.Borders.merge((Border)toolBar.getBorder(), (Border)JBUI.Borders.emptyLeft((int)12), (boolean)true));
            toolBar.setOpaque(false);
        }
        PopupChooserBuilder builder2 = this.createInnerBuilder().setMovable(true).setResizable(true).setAutoselectOnMouseMove(false).setMayBeParent(true).setDimensionServiceKey(this.myDimensionServiceKey).setUseDimensionServiceForXYLocation(this.myDimensionServiceKey != null).setSettingButton((Component)toolBar).setSouthComponent((JComponent)footerPanel).setItemChoosenCallback(itemCallback).setFilteringEnabled(o -> ((ItemWrapper)o).speedSearchText());
        if (this.myPopupTuner != null) {
            this.myPopupTuner.consume((Object)builder2);
        }
        if (this.myDoneRunnable != null) {
            ActionListener actionListener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MasterDetailPopupBuilder.this.myDoneRunnable.run();
                }
            };
            if (SystemInfoRt.isMac && !StartupUiUtil.isUnderDarcula()) {
                final JButton done = new JButton(LangBundle.message((String)"button.done", (Object[])new Object[0]));
                done.setOpaque(false);
                done.setMnemonic('o');
                done.addActionListener(actionListener2);
                builder2.setCommandButton((ActiveComponent)new ActiveComponent.Adapter(){

                    @NotNull
                    public JComponent getComponent() {
                        JButton jButton = done;
                        if (jButton == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        return jButton;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$7", "getComponent"));
                    }
                });
            } else {
                IconButton close2 = new IconButton(LangBundle.message((String)"button.close", (Object[])new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered);
                builder2.setCommandButton((ActiveComponent)new InplaceButton(close2, actionListener2));
            }
        }
        if ((title2 = this.myDelegate.getTitle()) != null) {
            builder2.setTitle(title2);
        }
        this.myPopup = builder2.createPopup();
        builder2.getScrollPane().setBorder(IdeBorderFactory.createBorder((int)4));
        this.mySpeedSearch = ((ListWithFilter)builder2.getPreferableFocusComponent()).getSpeedSearch();
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                MasterDetailPopupBuilder.this.myDetailView.clearEditor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$8", "onClosed"));
            }
        });
        if (this.myDoneRunnable != null) {
            new AnAction(IdeBundle.messagePointer((String)"action.Anonymous.text.done", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    MasterDetailPopupBuilder.this.myDoneRunnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$9", "actionPerformed"));
                }
            }.registerCustomShortcutSet(10, 128, this.myPopup.getContent());
        }
        JBPopup jBPopup = this.myPopup;
        if (jBPopup == null) {
            MasterDetailPopupBuilder.$$$reportNull$$$0(11);
        }
        return jBPopup;
    }

    private PopupChooserBuilder createInnerBuilder() {
        if (this.myChooserComponent instanceof JList) {
            return new MyPopupChooserBuilder((JList)this.myChooserComponent);
        }
        if (this.myChooserComponent instanceof JTree) {
            return new MyPopupChooserBuilder((JTree)this.myChooserComponent);
        }
        throw new IllegalStateException("Incorrect chooser component: " + this.myChooserComponent);
    }

    @Override
    public ItemWrapper[] getSelectedItems() {
        Object[] values2 = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        if (this.myChooserComponent instanceof JList) {
            values2 = ((JList)this.myChooserComponent).getSelectedValues();
        } else if (this.myChooserComponent instanceof JTree) {
            values2 = this.myDelegate.getSelectedItemsInTree();
        }
        ItemWrapper[] items = new ItemWrapper[values2.length];
        for (int i2 = 0; i2 < values2.length; ++i2) {
            items[i2] = (ItemWrapper)values2[i2];
        }
        return items;
    }

    @Override
    public JLabel getPathLabel() {
        return this.myPathLabel;
    }

    private String getSplitterProportionKey() {
        return this.myDimensionServiceKey != null ? this.myDimensionServiceKey + ".splitter" : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/util/MasterDetailPopupBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/util/MasterDetailPopupBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setDelegate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setDetailView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setDimensionServiceKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddDetailViewToEast";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setActionsGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setPopupTuner";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setDoneRunnable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMasterDetailPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setList";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDelegate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDetailView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPopupChooserBuilder
    extends PopupChooserBuilder {
        MyPopupChooserBuilder(JList list2) {
            if (list2 == null) {
                MyPopupChooserBuilder.$$$reportNull$$$0(0);
            }
            super(list2);
        }

        private MyPopupChooserBuilder(JTree tree) {
            if (tree == null) {
                MyPopupChooserBuilder.$$$reportNull$$$0(1);
            }
            super(tree);
        }

        protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component2) {
            if (MasterDetailPopupBuilder.this.myAddDetailViewToEast) {
                JBSplitter splitPane = new JBSplitter(0.3f);
                splitPane.setSplitterProportionKey(MasterDetailPopupBuilder.this.getSplitterProportionKey());
                splitPane.setFirstComponent(component2);
                splitPane.setSecondComponent((JComponent)MasterDetailPopupBuilder.this.myDetailView);
                contentPane.add((Component)splitPane, "Center");
            } else {
                super.addCenterComponentToContentPane(contentPane, component2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/popup/util/MasterDetailPopupBuilder$MyPopupChooserBuilder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ListItemRenderer
    extends JPanel
    implements ListCellRenderer {
        private final ColoredListCellRenderer myRenderer;

        private ListItemRenderer(Project project, Delegate delegate2) {
            super(new BorderLayout());
            this.setBackground(UIUtil.getListBackground());
            JComponent accessory = delegate2.createAccessoryView(project);
            if (accessory != null) {
                this.add((Component)accessory, "West");
            }
            this.myRenderer = new ItemWrapperListRenderer(project, accessory);
            this.add((Component)this.myRenderer, "Center");
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
            if (value2 instanceof SplitterItem) {
                String label2 = ((SplitterItem)value2).getText();
                TitledSeparator separator = new TitledSeparator(label2);
                separator.setBackground(UIUtil.getListBackground());
                separator.setForeground(UIUtil.getListForeground());
                return separator;
            }
            this.myRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
            this.myRenderer.revalidate();
            return this;
        }
    }

    public static interface Delegate {
        @Nullable
        @NlsContexts.PopupTitle
        public String getTitle();

        public void handleMnemonic(KeyEvent var1, Project var2, JBPopup var3);

        @Nullable
        public JComponent createAccessoryView(Project var1);

        public Object[] getSelectedItemsInTree();

        public void itemChosen(ItemWrapper var1, Project var2, JBPopup var3, boolean var4);

        public void removeSelectedItemsInTree();
    }
}

