/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import java.awt.event.FocusEvent;
import javax.swing.JList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PopupImplUtil {
    private static final Logger LOG = Logger.getInstance(PopupImplUtil.class);

    private PopupImplUtil() {
    }

    public static AccessToken prohibitFocusEventsInHandleSelect() {
        final boolean[] insideOnChosen = new boolean[]{true};
        final AccessToken token2 = ProhibitAWTEvents.startFiltered("Popup.handleSelect", e -> {
            if (!(e instanceof FocusEvent) || ((FocusEvent)e).isTemporary()) {
                return null;
            }
            Throwable throwable = new Throwable("Focus events are prohibited inside Popup.handleSelect; got " + e + "Please put the handler into BaseStep.doFinalStep or PopupStep.getFinalRunnable.");
            ApplicationManager.getApplication().invokeLater(() -> LOG.error(throwable), ModalityState.any(), __ -> !insideOnChosen[0]);
            return null;
        });
        return new AccessToken(){

            public void finish() {
                insideOnChosen[0] = false;
                token2.finish();
            }
        };
    }

    @Nullable
    public static Object getDataImplForList(@NotNull JList<?> list2, @NotNull String dataId) {
        if (list2 == null) {
            PopupImplUtil.$$$reportNull$$$0(0);
        }
        if (dataId == null) {
            PopupImplUtil.$$$reportNull$$$0(1);
        }
        if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            int index2 = list2.getSelectedIndex();
            return index2 > -1 ? list2.getSelectedValue() : ObjectUtils.NULL;
        }
        if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            Object[] values2 = list2.getSelectedValues();
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (values2[i2] != null) continue;
                values2[i2] = ObjectUtils.NULL;
            }
            return values2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataId";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/popup/util/PopupImplUtil";
        objectArray[2] = "getDataImplForList";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

