/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class MapBasedTree<K, N> {
    private static final Logger LOG = Logger.getInstance(MapBasedTree.class);
    private final Map<K, Entry<N>> map;
    private final Function<? super N, ? extends K> keyFunction;
    private final TreePath path;
    private volatile Entry<N> root;
    private volatile Consumer<? super N> nodeRemoved;
    private volatile Consumer<? super N> nodeInserted;

    public MapBasedTree(boolean identity, @NotNull Function<? super N, ? extends K> keyFunction) {
        if (keyFunction == null) {
            MapBasedTree.$$$reportNull$$$0(0);
        }
        this(identity, keyFunction, null);
    }

    public MapBasedTree(boolean identity, @NotNull Function<? super N, ? extends K> keyFunction, TreePath path2) {
        if (keyFunction == null) {
            MapBasedTree.$$$reportNull$$$0(1);
        }
        this.map = identity ? new IdentityHashMap() : new HashMap();
        this.keyFunction = keyFunction;
        this.path = path2;
    }

    public void invalidate() {
        if (this.root != null) {
            this.root.invalidate();
        }
        this.map.values().forEach(entry2 -> entry2.invalidate());
    }

    public void onRemove(@NotNull Consumer<? super N> consumer) {
        Consumer<N> old;
        if (consumer == null) {
            MapBasedTree.$$$reportNull$$$0(2);
        }
        this.nodeRemoved = (old = this.nodeRemoved) == null ? consumer : old.andThen(consumer);
    }

    public void onInsert(@NotNull Consumer<? super N> consumer) {
        Consumer<N> old;
        if (consumer == null) {
            MapBasedTree.$$$reportNull$$$0(3);
        }
        this.nodeInserted = (old = this.nodeInserted) == null ? consumer : old.andThen(consumer);
    }

    public Entry<N> findEntry(K key) {
        return key == null ? null : this.map.get(key);
    }

    public N findNode(K key) {
        Entry<N> entry2 = this.findEntry(key);
        return entry2 == null ? null : (N)entry2.node;
    }

    public Entry<N> getEntry(N node2) {
        K key = this.getKey(node2);
        Entry<N> entry2 = this.findEntry(key);
        return entry2 == null || entry2.node == node2 ? entry2 : null;
    }

    public Entry<N> getRootEntry() {
        return this.root;
    }

    public K getKey(N node2) {
        if (node2 == null) {
            return null;
        }
        K key = this.keyFunction.apply(node2);
        if (key != null) {
            return key;
        }
        LOG.warn("MapBasedTree: key function provides null");
        return null;
    }

    public boolean updateRoot(Pair<? extends N, Boolean> pair) {
        Object node2 = Pair.getFirst(pair);
        if (this.root == null ? node2 == null : this.root.node == node2) {
            return false;
        }
        if (this.root != null) {
            this.remove(this.root, this.keyFunction.apply(this.root.node));
            this.root = null;
        }
        if (!this.map.isEmpty()) {
            this.map.clear();
            LOG.warn("MapBasedTree: clear lost entries");
        }
        if (node2 != null) {
            this.root = new Entry<Object>(this.path, null, node2, (Boolean)pair.second);
            this.insert(this.root, this.keyFunction.apply(node2));
        }
        return true;
    }

    public UpdateResult<N> update(@NotNull Entry<N> parent, List<? extends Pair<N, Boolean>> children2) {
        if (parent == null) {
            MapBasedTree.$$$reportNull$$$0(4);
        }
        ArrayList newChildren = new ArrayList(children2 == null ? 0 : children2.size());
        List<Object> oldChildren = parent.children;
        IdentityHashMap<Entry, Object> mapInserted = new IdentityHashMap<Entry, Object>();
        IdentityHashMap mapContained = new IdentityHashMap();
        if (children2 != null && !children2.isEmpty()) {
            children2.forEach(pair -> {
                if (pair == null || pair.first == null) {
                    LOG.warn("MapBasedTree: ignore null node");
                    return;
                }
                K key = this.getKey(pair.first);
                if (key == null) {
                    return;
                }
                Entry<Object> entry2 = this.findEntry(key);
                if (entry2 == null) {
                    entry2 = new Entry<Object>(parent, parent.node, pair.first, (Boolean)pair.second);
                    mapInserted.put(entry2, key);
                } else {
                    if (parent != entry2.getParentPath()) {
                        LOG.warn("MapBasedTree: ignore node that belongs to another parent");
                        return;
                    }
                    mapContained.put(entry2, key);
                }
                entry2.index = newChildren.size();
                newChildren.add(entry2);
            });
        }
        parent.leaf = children2 == null;
        parent.children = MapBasedTree.guard(newChildren);
        parent.valid = true;
        List removed = oldChildren;
        ArrayList inserted = newChildren;
        List contained = null;
        if (!mapContained.isEmpty()) {
            if (oldChildren == null) {
                oldChildren = Collections.emptyList();
                LOG.warn("MapBasedTree: unexpected state");
            }
            removed = ContainerUtil.filter(oldChildren, entry2 -> !mapContained.containsKey(entry2));
            inserted = ContainerUtil.filter(newChildren, entry2 -> !mapContained.containsKey(entry2));
            contained = ContainerUtil.filter(newChildren, entry2 -> mapContained.containsKey(entry2));
        }
        this.removeChildren(parent, removed);
        mapInserted.forEach(this::insert);
        return new UpdateResult(removed, inserted, contained);
    }

    private void removeChildren(Entry<N> parent, List<Entry<N>> children2) {
        if (children2 != null) {
            for (Entry<N> entry2 : children2) {
                if (parent.loading == entry2.node) {
                    parent.loading = null;
                    continue;
                }
                this.remove(entry2, this.getKey(entry2.node));
            }
        }
    }

    private void remove(Entry<N> entry2, K key) {
        if (key != null) {
            Entry<N> removed = this.map.remove(key);
            if (removed == null) {
                LOG.warn("MapBasedTree: expected entry is not found");
            } else if (removed != entry2) {
                LOG.warn("MapBasedTree: do not remove unexpected entry");
                this.map.put(key, removed);
                return;
            }
        }
        this.removeChildren(entry2, entry2.children);
        Consumer<N> consumer = this.nodeRemoved;
        if (consumer != null) {
            consumer.accept(entry2.node);
        }
    }

    private void insert(Entry<N> entry2, K key) {
        Entry<N> removed;
        if (key != null && (removed = this.map.put(key, entry2)) != null) {
            LOG.warn("MapBasedTree: do not replace unexpected entry");
            this.map.put(key, removed);
            return;
        }
        Consumer<N> consumer = this.nodeInserted;
        if (consumer != null) {
            consumer.accept(entry2.node);
        }
    }

    private static <T> List<T> guard(List<? extends T> list2) {
        return list2 == null || list2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFunction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/MapBasedTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onRemove";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onInsert";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class UpdateResult<N> {
        private final List<Entry<N>> removed;
        private final List<Entry<N>> inserted;
        private final List<Entry<N>> contained;

        private UpdateResult(List<Entry<N>> removed, List<Entry<N>> inserted, List<Entry<N>> contained) {
            this.removed = MapBasedTree.guard(removed);
            this.inserted = MapBasedTree.guard(inserted);
            this.contained = MapBasedTree.guard(contained);
        }

        public TreeModelEvent getEvent(@NotNull Object source, TreePath path2, @NotNull List<Entry<N>> list2) {
            if (source == null) {
                UpdateResult.$$$reportNull$$$0(0);
            }
            if (list2 == null) {
                UpdateResult.$$$reportNull$$$0(1);
            }
            int size2 = list2.size();
            int[] indices = new int[size2];
            Object[] nodes = new Object[size2];
            int index2 = 0;
            for (Entry<N> entry2 : list2) {
                indices[index2] = entry2.index;
                nodes[index2++] = entry2.node;
            }
            return new TreeModelEvent(source, path2, indices, nodes);
        }

        public List<Entry<N>> getRemoved() {
            return this.removed;
        }

        public List<Entry<N>> getInserted() {
            return this.inserted;
        }

        public List<Entry<N>> getContained() {
            return this.contained;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/tree/MapBasedTree$UpdateResult";
            objectArray[2] = "getEvent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Entry<N>
    extends TreePath {
        private final N node;
        private final N parent;
        private volatile int index;
        private volatile boolean leaf;
        private volatile List<Entry<N>> children;
        private volatile N loading;
        private volatile boolean valid;

        private Entry(TreePath path2, N parent, N node2, Boolean leaf) {
            super(path2, node2);
            this.node = node2;
            this.parent = parent;
            this.leaf = Boolean.TRUE.equals(leaf);
            if (this.leaf) {
                this.children = Collections.emptyList();
            }
            this.invalidate();
        }

        public void invalidate() {
            this.valid = this.leaf;
        }

        public N getNode() {
            return this.node;
        }

        public N getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public boolean isLoadingRequired() {
            return !this.valid || this.children == null;
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public Entry<N> getChildEntry(int index2) {
            if (this.children != null && 0 <= index2 && index2 < this.children.size()) {
                return this.children.get(index2);
            }
            return null;
        }

        public N getChild(int index2) {
            Entry<N> entry2 = this.getChildEntry(index2);
            return entry2 == null ? null : (N)entry2.getNode();
        }

        public int getIndexOf(N child2) {
            if (this.children != null) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    if (child2 != this.children.get(i2).getNode()) continue;
                    return i2;
                }
            }
            return -1;
        }

        void setLoadingChildren(N loading) {
            if (this.children != null) {
                LOG.warn("MapBasedTree: rewrite loaded nodes");
            }
            this.loading = loading;
            this.children = loading == null ? Collections.emptyList() : Collections.singletonList(new Entry<N>(this, this.node, loading, true));
            this.valid = true;
        }
    }
}

