/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabDescriptor;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContentUtilEx
extends ContentsUtil {
    @Deprecated
    public static void addTabbedContent(@NotNull ContentManager manager2, @NotNull JComponent contentComponent, @NotNull @NonNls String groupPrefix, @NotNull @NlsContexts.TabTitle String tabName, boolean select2, @Nullable Disposable childDisposable) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(0);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(1);
        }
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(2);
        }
        if (tabName == null) {
            ContentUtilEx.$$$reportNull$$$0(3);
        }
        ContentUtilEx.addTabbedContent(manager2, new TabGroupId(groupPrefix, groupPrefix), new TabDescriptor(contentComponent, () -> tabName, childDisposable), select2);
    }

    public static void addTabbedContent(@NotNull ContentManager manager2, @NotNull JComponent contentComponent, @NotNull @NonNls String groupId2, @NotNull Supplier<@NlsContexts.TabTitle String> groupDisplayName, @NotNull Supplier<@NlsContexts.TabTitle String> tabDisplayName, boolean select2, @Nullable Disposable childDisposable) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(4);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(5);
        }
        if (groupId2 == null) {
            ContentUtilEx.$$$reportNull$$$0(6);
        }
        if (groupDisplayName == null) {
            ContentUtilEx.$$$reportNull$$$0(7);
        }
        if (tabDisplayName == null) {
            ContentUtilEx.$$$reportNull$$$0(8);
        }
        ContentUtilEx.addTabbedContent(manager2, new TabGroupId(groupId2, groupDisplayName), new TabDescriptor(contentComponent, tabDisplayName, childDisposable), select2);
    }

    public static void addTabbedContent(@NotNull ContentManager manager2, @NotNull TabGroupId tabGroupId, @NotNull TabDescriptor tab, boolean select2) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(9);
        }
        if (tabGroupId == null) {
            ContentUtilEx.$$$reportNull$$$0(10);
        }
        if (tab == null) {
            ContentUtilEx.$$$reportNull$$$0(11);
        }
        if (ContentUtilEx.isSplitMode(tabGroupId)) {
            ContentUtilEx.addSplitTabbedContent(manager2, tabGroupId, tab, select2);
        } else {
            ContentUtilEx.addMergedTabbedContent(manager2, tabGroupId, tab, select2);
        }
    }

    public static void addSplitTabbedContent(@NotNull ContentManager manager2, @NotNull TabGroupId tabGroupId, @NotNull TabDescriptor tab, boolean select2) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(12);
        }
        if (tabGroupId == null) {
            ContentUtilEx.$$$reportNull$$$0(13);
        }
        if (tab == null) {
            ContentUtilEx.$$$reportNull$$$0(14);
        }
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(tab.getComponent(), tabGroupId.getDisplayName(tab), true);
        content2.setTabName(tabGroupId.getDisplayName(tab));
        content2.putUserData(Content.TABBED_CONTENT_KEY, (Object)Boolean.TRUE);
        content2.putUserData(Content.TAB_GROUP_ID_KEY, (Object)tabGroupId);
        content2.putUserData(Content.TAB_DESCRIPTOR_KEY, (Object)tab);
        Disposer.register((Disposable)content2, (Disposable)tab);
        ContentUtilEx.addContent((ContentManager)manager2, (Content)content2, (boolean)select2);
    }

    private static void addMergedTabbedContent(@NotNull ContentManager manager2, @NotNull TabGroupId tabGroupId, @NotNull TabDescriptor tab, boolean select2) {
        TabbedContent tabbedContent;
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(15);
        }
        if (tabGroupId == null) {
            ContentUtilEx.$$$reportNull$$$0(16);
        }
        if (tab == null) {
            ContentUtilEx.$$$reportNull$$$0(17);
        }
        if ((tabbedContent = ContentUtilEx.findTabbedContent(manager2, tabGroupId.getId())) != null) {
            if (select2) {
                manager2.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(tab, true);
            return;
        }
        ContentUtilEx.createMergedTabbedContent(manager2, tabGroupId, Collections.singletonList(tab), tab, select2);
    }

    private static void createMergedTabbedContent(@NotNull ContentManager manager2, @NotNull TabGroupId tabGroupId, @NotNull List<TabDescriptor> tabs2, @Nullable TabDescriptor tabToSelect, boolean selectContent) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(18);
        }
        if (tabGroupId == null) {
            ContentUtilEx.$$$reportNull$$$0(19);
        }
        if (tabs2 == null) {
            ContentUtilEx.$$$reportNull$$$0(20);
        }
        Iterator<TabDescriptor> iterator2 = tabs2.iterator();
        TabbedContentImpl tabbedContent = new TabbedContentImpl(tabGroupId, iterator2.next(), true);
        ContentUtilEx.addContent((ContentManager)manager2, (Content)tabbedContent, (boolean)selectContent);
        while (iterator2.hasNext()) {
            TabDescriptor tab;
            tabbedContent.addContent(tab, (tab = iterator2.next()) == tabToSelect);
        }
    }

    @Nullable
    public static TabbedContent findTabbedContent(@NotNull ContentManager manager2, @NotNull @NonNls String id2) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(21);
        }
        if (id2 == null) {
            ContentUtilEx.$$$reportNull$$$0(22);
        }
        for (Content content2 : manager2.getContents()) {
            if (!(content2 instanceof TabbedContent) || !((TabbedContent)content2).getId().getId().equals(id2)) continue;
            return (TabbedContent)content2;
        }
        return null;
    }

    @NotNull
    @NlsContexts.TabTitle
    public static String getFullName(@NotNull @NlsContexts.TabTitle String groupPrefix, @NotNull @NlsContexts.TabTitle String tabName) {
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(23);
        }
        if (tabName == null) {
            ContentUtilEx.$$$reportNull$$$0(24);
        }
        if (tabName.isEmpty()) {
            String string = groupPrefix;
            if (string == null) {
                ContentUtilEx.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = groupPrefix + ": " + tabName;
        if (string == null) {
            ContentUtilEx.$$$reportNull$$$0(26);
        }
        return string;
    }

    public static boolean selectContent(@NotNull ContentManager manager2, @NotNull JComponent contentComponent, boolean requestFocus) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(27);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(28);
        }
        for (Content content2 : manager2.getContents()) {
            if (content2 instanceof TabbedContentImpl) {
                boolean found = ((TabbedContentImpl)content2).findAndSelectContent(contentComponent);
                if (!found) continue;
                manager2.setSelectedContent(content2, requestFocus);
                return true;
            }
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent)) continue;
            manager2.setSelectedContent(content2, requestFocus);
            return true;
        }
        return false;
    }

    @Nullable
    public static JComponent findContentComponent(@NotNull ContentManager manager2, @NotNull Condition<? super JComponent> condition2) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(29);
        }
        if (condition2 == null) {
            ContentUtilEx.$$$reportNull$$$0(30);
        }
        for (Content content2 : manager2.getContents()) {
            if (content2 instanceof TabbedContent) {
                JComponent component2 = ContentUtilEx.findContentComponent((TabbedContent)content2, condition2);
                if (component2 == null) continue;
                return component2;
            }
            if (!condition2.value((Object)content2.getComponent())) continue;
            return content2.getComponent();
        }
        return null;
    }

    @Nullable
    private static JComponent findContentComponent(@NotNull TabbedContent tabbedContent, @NotNull Condition<? super JComponent> condition2) {
        if (tabbedContent == null) {
            ContentUtilEx.$$$reportNull$$$0(31);
        }
        if (condition2 == null) {
            ContentUtilEx.$$$reportNull$$$0(32);
        }
        for (Pair tab : tabbedContent.getTabs()) {
            if (!condition2.value(tab.second)) continue;
            return (JComponent)tab.second;
        }
        return null;
    }

    public static boolean closeContentTab(@NotNull ContentManager manager2, @NotNull Condition<? super JComponent> condition2) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(33);
        }
        if (condition2 == null) {
            ContentUtilEx.$$$reportNull$$$0(34);
        }
        for (Content content2 : manager2.getContents()) {
            if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
                TabbedContent tabbedContent = (TabbedContent)content2;
                JComponent component2 = ContentUtilEx.findContentComponent(tabbedContent, condition2);
                if (component2 == null) continue;
                tabbedContent.removeContent(component2);
                return true;
            }
            if (!condition2.value((Object)content2.getComponent())) continue;
            manager2.removeContent(content2, true);
            return true;
        }
        return false;
    }

    public static int getSelectedTab(@NotNull TabbedContent content2) {
        int selectedIndex;
        if (content2 == null) {
            ContentUtilEx.$$$reportNull$$$0(35);
        }
        if ((selectedIndex = content2.getSelectedIndex()) != -1) {
            return selectedIndex;
        }
        JComponent current2 = content2.getComponent();
        int index2 = 0;
        for (Pair tab : content2.getTabs()) {
            if (tab.second == current2) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    public static void updateTabbedContentDisplayName(@NotNull ContentManager manager2, @NotNull JComponent contentComponent) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(36);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(37);
        }
        for (Content content2 : manager2.getContents()) {
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent)) continue;
            TabGroupId groupId2 = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY);
            TabDescriptor tab = (TabDescriptor)content2.getUserData(Content.TAB_DESCRIPTOR_KEY);
            if (groupId2 == null || tab == null) continue;
            content2.setDisplayName(groupId2.getDisplayName(tab));
            return;
        }
    }

    public static void mergeTabs(@NotNull ContentManager manager2, @NotNull TabGroupId groupId2) {
        if (manager2 == null) {
            ContentUtilEx.$$$reportNull$$$0(38);
        }
        if (groupId2 == null) {
            ContentUtilEx.$$$reportNull$$$0(39);
        }
        ArrayList<TabDescriptor> tabs2 = new ArrayList<TabDescriptor>();
        Content selectedContent = manager2.getSelectedContent();
        TabDescriptor selectedTab = null;
        ArrayList<Content> mergedContent = new ArrayList<Content>();
        for (Content content2 : manager2.getContents()) {
            if (!groupId2.equals(content2.getUserData(Content.TAB_GROUP_ID_KEY))) continue;
            TabDescriptor tab = (TabDescriptor)content2.getUserData(Content.TAB_DESCRIPTOR_KEY);
            if (tab == null) {
                tab = new TabDescriptor(content2.getComponent(), content2.getDisplayName().substring(groupId2.getDisplayName().length() + 2));
            }
            if (content2 == selectedContent) {
                selectedTab = tab;
            }
            tabs2.add(tab);
            manager2.removeContent(content2, false);
            content2.setComponent(null);
            content2.setShouldDisposeContent(false);
            mergedContent.add(content2);
        }
        ContentUtilEx.setSplitMode(groupId2.getId(), false);
        ContentUtilEx.createMergedTabbedContent(manager2, groupId2, tabs2, selectedTab, selectedTab != null);
        mergedContent.forEach(Disposer::dispose);
    }

    public static boolean isSplitMode(@NotNull TabGroupId tabGroupId) {
        if (tabGroupId == null) {
            ContentUtilEx.$$$reportNull$$$0(40);
        }
        return ContentUtilEx.isSplitMode(tabGroupId.getId(), tabGroupId.getSplitByDefault());
    }

    public static boolean isSplitMode(@NonNls @NotNull String groupId2, boolean defaultValue) {
        if (groupId2 == null) {
            ContentUtilEx.$$$reportNull$$$0(41);
        }
        return PropertiesComponent.getInstance().getBoolean("tabbed.toolwindow.expanded." + groupId2, defaultValue);
    }

    public static void setSplitMode(@NonNls @NotNull String groupId2, boolean value2) {
        if (groupId2 == null) {
            ContentUtilEx.$$$reportNull$$$0(42);
        }
        if (value2) {
            PropertiesComponent.getInstance().setValue("tabbed.toolwindow.expanded." + groupId2, Boolean.TRUE.toString());
        } else {
            PropertiesComponent.getInstance().unsetValue("tabbed.toolwindow.expanded." + groupId2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 5: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 3: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 6: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabDisplayName";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabGroupId";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ContentUtilEx";
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedContent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ContentUtilEx";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTabbedContent";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSplitTabbedContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMergedTabbedContent";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createMergedTabbedContent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findTabbedContent";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 25: 
            case 26: {
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "selectContent";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findContentComponent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "closeContentTab";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTab";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateTabbedContentDisplayName";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "mergeTabs";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isSplitMode";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setSplitMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

