/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextAware;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class IconUtil {
    public static final Key<Integer> ICON_FLAG_IGNORE_MASK = new Key("ICON_FLAG_IGNORE_MASK");
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create((String)"iconDeferrer:projectWasEverInitialized");
    private static final Function<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> IconUtil.computeFileIcon(key.getFile(), key.getFlags(), key.getProject());

    private static boolean wasEverInitialized(@NotNull Project project) {
        Boolean was;
        if (project == null) {
            IconUtil.$$$reportNull$$$0(0);
        }
        if ((was = (Boolean)project.getUserData(PROJECT_WAS_EVER_INITIALIZED)) == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, (Object)true);
            } else {
                was = false;
            }
        }
        return was;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon2, int maxWidth, int maxHeight) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(1);
        }
        if (icon2.getIconHeight() <= maxHeight && icon2.getIconWidth() <= maxWidth) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                IconUtil.$$$reportNull$$$0(2);
            }
            return icon3;
        }
        Image image = IconLoader.toImage((Icon)icon2, null);
        if (image == null) {
            Icon icon4 = icon2;
            if (icon4 == null) {
                IconUtil.$$$reportNull$$$0(3);
            }
            return icon4;
        }
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            scale = ((JBHiDPIScaledImage)image).getScale();
            image = ((JBHiDPIScaledImage)image).getDelegate();
        }
        BufferedImage bi = ImageUtil.toBufferedImage((Image)image);
        Graphics2D g = bi.createGraphics();
        int imageWidth = ImageUtil.getRealWidth((Image)image);
        int imageHeight = ImageUtil.getRealHeight((Image)image);
        maxWidth = maxWidth == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxWidth * scale);
        maxHeight = maxHeight == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxHeight * scale);
        int w = Math.min(imageWidth, maxWidth);
        int h = Math.min(imageHeight, maxHeight);
        BufferedImage img = ImageUtil.createImage((Graphics)g, (int)w, (int)h, (int)3);
        int offX = imageWidth > maxWidth ? (imageWidth - maxWidth) / 2 : 0;
        int offY = imageHeight > maxHeight ? (imageHeight - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row2 = 0; row2 < h; ++row2) {
                img.setRGB(col, row2, bi.getRGB(col + offX, row2 + offY));
            }
        }
        g.dispose();
        return new JBImageIcon(RetinaImage.createFrom((Image)img, (double)scale, null));
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon2, @NotNull Rectangle area) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(4);
        }
        if (area == null) {
            IconUtil.$$$reportNull$$$0(5);
        }
        if (!new Rectangle(icon2.getIconWidth(), icon2.getIconHeight()).contains(area)) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                IconUtil.$$$reportNull$$$0(6);
            }
            return icon3;
        }
        return new CropIcon(icon2, area);
    }

    @NotNull
    public static Icon flip(final @NotNull Icon icon2, final boolean horizontal) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(7);
        }
        return new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    AffineTransform transform = AffineTransform.getTranslateInstance(horizontal ? (double)(x + this.getIconWidth()) : (double)x, horizontal ? (double)y : (double)(y + this.getIconHeight()));
                    transform.concatenate(AffineTransform.getScaleInstance(horizontal ? -1.0 : 1.0, horizontal ? 1.0 : -1.0));
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    icon2.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return icon2.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon2.getIconHeight();
            }
        };
    }

    @NotNull
    public static Icon computeFileIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, @Nullable Project project) {
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(8);
        }
        if (!file2.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            Icon icon2 = AllIcons.FileTypes.Unknown;
            if (icon2 == null) {
                IconUtil.$$$reportNull$$$0(9);
            }
            return icon2;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file2, flags = IconUtil.filterFileIconFlags(file2, flags), project);
        Icon icon3 = providersIcon != null ? providersIcon : IconUtil.computeBaseFileIcon(file2);
        boolean dumb = project != null && DumbService.getInstance((Project)project).isDumb();
        for (FileIconPatcher patcher : FileIconPatcher.EP_NAME.getExtensionList()) {
            if (dumb && !DumbService.isDumbAware((Object)patcher)) continue;
            icon3 = patcher.patchIcon(icon3, file2, flags & 0xFFFFFFFD, project);
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon3 = new LayeredIcon(icon3, PlatformIcons.SYMLINK_ICON);
        }
        if (!(!BitUtil.isSet((int)flags, (int)2) || file2.isWritable() && WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2, (Project)project))) {
            icon3 = new LayeredIcon(icon3, PlatformIcons.LOCKED_ICON);
        }
        LastComputedIconCache.put((UserDataHolder)file2, (Icon)icon3, (int)flags);
        Icon icon4 = icon3;
        if (icon4 == null) {
            IconUtil.$$$reportNull$$$0(10);
        }
        return icon4;
    }

    @Iconable.IconFlags
    private static int filterFileIconFlags(@NotNull VirtualFile file2, @Iconable.IconFlags int flags) {
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(11);
        }
        UserDataHolder fileTypeDataHolder = (UserDataHolder)ObjectUtils.tryCast((Object)file2.getFileType(), UserDataHolder.class);
        int fileTypeFlagIgnoreMask = (Integer)ICON_FLAG_IGNORE_MASK.get(fileTypeDataHolder, (Object)0);
        int flagIgnoreMask = (Integer)ICON_FLAG_IGNORE_MASK.get((UserDataHolder)file2, (Object)fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask;
    }

    @NotNull
    public static Icon getIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, @Nullable Project project) {
        Icon lastIcon;
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(12);
        }
        Icon base = (lastIcon = LastComputedIconCache.get((UserDataHolder)file2, (int)flags)) != null ? lastIcon : IconUtil.computeBaseFileIcon(file2);
        Icon icon2 = IconManager.getInstance().createDeferredIcon(base, (Object)new FileIconKey(file2, project, flags), ICON_NULLABLE_FUNCTION);
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(13);
        }
        return icon2;
    }

    @NotNull
    public static Icon computeBaseFileIcon(@NotNull VirtualFile vFile) {
        Icon icon2;
        if (vFile == null) {
            IconUtil.$$$reportNull$$$0(14);
        }
        if ((icon2 = TypePresentationService.getService().getIcon((Object)vFile)) != null) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                IconUtil.$$$reportNull$$$0(15);
            }
            return icon3;
        }
        FileType fileType = vFile.getFileType();
        if (vFile.isDirectory() && !(fileType instanceof DirectoryFileType)) {
            Icon icon4 = IconManager.getInstance().tooltipOnlyIfComposite(PlatformIcons.FOLDER_ICON);
            if (icon4 == null) {
                IconUtil.$$$reportNull$$$0(16);
            }
            return icon4;
        }
        icon2 = fileType.getIcon();
        return icon2 != null ? icon2 : IconUtil.getEmptyIcon(false);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, Project project) {
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(17);
        }
        for (FileIconProvider provider2 : FileIconProvider.EP_NAME.getExtensionList()) {
            Icon icon2 = provider2.getIcon(file2, flags, project);
            if (icon2 == null) continue;
            return icon2;
        }
        return null;
    }

    @NotNull
    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon((Icon)EmptyIcon.create((Icon)PlatformIcons.CLASS_ICON), 0);
        if (showVisibility) {
            baseIcon.setIcon((Icon)EmptyIcon.create((Icon)PlatformIcons.PUBLIC_ICON), 1);
        }
        RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            IconUtil.$$$reportNull$$$0(18);
        }
        return rowIcon;
    }

    @NotNull
    public static Image toImage(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(19);
        }
        return IconUtil.toImage(icon2, null);
    }

    @NotNull
    public static Image toImage(@NotNull Icon icon2, @Nullable ScaleContext context2) {
        Image image;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(20);
        }
        if ((image = IconLoader.toImage((Icon)icon2, (ScaleContext)context2)) == null) {
            image = new BufferedImage(1, 0, 2);
        }
        Image image2 = image;
        if (image2 == null) {
            IconUtil.$$$reportNull$$$0(21);
        }
        return image2;
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(22);
        }
        return IconUtil.toBufferedImage(icon2, false);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Icon icon2, boolean inUserScale) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(23);
        }
        return IconUtil.toBufferedImage(icon2, null, inUserScale);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Icon icon2, @Nullable ScaleContext context2, boolean inUserScale) {
        Image image;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(24);
        }
        if ((image = IconLoader.toImage((Icon)icon2, (ScaleContext)context2)) == null) {
            image = new BufferedImage(1, 0, 2);
        }
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image, (boolean)inUserScale);
        if (bufferedImage == null) {
            IconUtil.$$$reportNull$$$0(25);
        }
        return bufferedImage;
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon2 = AllIcons.General.Add;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(26);
        }
        return icon2;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon2 = AllIcons.General.Remove;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(27);
        }
        return icon2;
    }

    @NotNull
    public static Icon getMoveUpIcon() {
        Icon icon2 = AllIcons.Actions.MoveUp;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(28);
        }
        return icon2;
    }

    @NotNull
    public static Icon getMoveDownIcon() {
        Icon icon2 = AllIcons.Actions.MoveDown;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(29);
        }
        return icon2;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon2 = AllIcons.Actions.Edit;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(30);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddClassIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddClass;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(31);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddPatternIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddPattern;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(32);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddJiraPatternIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddJira;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(33);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddYouTrackPatternIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddYouTrack;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(34);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddBlankLineIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddBlankLine;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(35);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddPackageIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddFolder;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(36);
        }
        return icon2;
    }

    @NotNull
    public static Icon getAddLinkIcon() {
        Icon icon2 = AllIcons.ToolbarDecorator.AddLink;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(37);
        }
        return icon2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon2 = IconLoader.getIcon((String)(IconUtil.getToolbarDecoratorIconsFolder() + "analyze.png"), IconUtil.class);
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(38);
        }
        return icon2;
    }

    public static void paintInCenterOf(@NotNull Component c, @NotNull Graphics g, @NotNull Icon icon2) {
        if (c == null) {
            IconUtil.$$$reportNull$$$0(39);
        }
        if (g == null) {
            IconUtil.$$$reportNull$$$0(40);
        }
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(41);
        }
        int x = (c.getWidth() - icon2.getIconWidth()) / 2;
        int y = (c.getHeight() - icon2.getIconHeight()) / 2;
        icon2.paintIcon(c, g, x, y);
    }

    @NotNull
    @NonNls
    private static String getToolbarDecoratorIconsFolder() {
        String string = "/toolbarDecorator/" + (SystemInfoRt.isMac ? "mac/" : "");
        if (string == null) {
            IconUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static Icon @NotNull [] getEqualSizedIcons(Icon ... icons) {
        if (icons == null) {
            IconUtil.$$$reportNull$$$0(43);
        }
        Icon[] result2 = new Icon[icons.length];
        int width = 0;
        int height = 0;
        for (Icon icon2 : icons) {
            width = Math.max(width, icon2.getIconWidth());
            height = Math.max(height, icon2.getIconHeight());
        }
        for (int i2 = 0; i2 < icons.length; ++i2) {
            result2[i2] = new IconSizeWrapper(icons[i2], width, height);
        }
        if (result2 == null) {
            IconUtil.$$$reportNull$$$0(44);
        }
        return result2;
    }

    @NotNull
    public static Icon toSize(@Nullable Icon icon2, int width, int height) {
        return new IconSizeWrapper(icon2, width, height);
    }

    public static void paintSelectionAwareIcon(@NotNull Icon icon2, @Nullable JComponent component2, @NotNull Graphics g, int x, int y, boolean selected2) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(45);
        }
        if (g == null) {
            IconUtil.$$$reportNull$$$0(46);
        }
        if (selected2) {
            SVGLoader.paintIconWithSelection((Icon)icon2, (Component)component2, (Graphics)g, (int)x, (int)y);
        } else {
            icon2.paintIcon(component2, g, x, y);
        }
    }

    @Nullable
    @ApiStatus.Internal
    @Contract(value="null -> null; !null -> !null")
    public static Icon wrapToSelectionAwareIcon(final @Nullable Icon iconUnderSelection) {
        if (iconUnderSelection == null) {
            return null;
        }
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                SVGLoader.paintIconWithSelection((Icon)iconUnderSelection, (Component)c, (Graphics)g, (int)x, (int)y);
            }

            @Override
            public int getIconWidth() {
                return iconUnderSelection.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return iconUnderSelection.getIconHeight();
            }
        };
    }

    @Deprecated
    @NotNull
    public static Icon scale(final @NotNull Icon source, double _scale) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(47);
        }
        final double scale = IconUtil.clampScale(_scale);
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                IconUtil.paintScaled(c, g, x, y, scale, source);
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale);
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale);
            }
        };
    }

    private static double clampScale(double _scale) {
        return MathUtil.clamp((double)_scale, (double)0.1, (double)32.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void paintScaled(@Nullable Component c, @NotNull Graphics g, int x, int y, double scale, @NotNull Icon icon2) {
        if (g == null) {
            IconUtil.$$$reportNull$$$0(48);
        }
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(49);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            void source;
            g2d.translate(x, y);
            AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
            transform.preConcatenate(g2d.getTransform());
            g2d.setTransform(transform);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            source.paintIcon(c, g2d, 0, 0);
        }
        finally {
            g2d.dispose();
        }
    }

    @NotNull
    public static Icon resizeSquared(final @NotNull Icon source, int size2) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(50);
        }
        final JBValue sizeValue = JBUI.uiIntValue((String)"ResizedIcon", (int)size2);
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                double scale = IconUtil.clampScale((double)sizeValue.get() / (double)source.getIconWidth());
                IconUtil.paintScaled(c, g, x, y, scale, source);
            }

            @Override
            public int getIconWidth() {
                return sizeValue.get();
            }

            @Override
            public int getIconHeight() {
                return sizeValue.get();
            }
        };
    }

    @Contract(value="null, _->null; !null, _->!null")
    public static Icon copy(@Nullable Icon icon2, @Nullable Component ancestor) {
        return IconLoader.copy((Icon)icon2, (Component)ancestor, (boolean)false);
    }

    @Contract(value="null, _->null; !null, _->!null")
    public static Icon deepCopy(@Nullable Icon icon2, @Nullable Component ancestor) {
        return IconLoader.copy((Icon)icon2, (Component)ancestor, (boolean)true);
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon2, @Nullable Component ancestor, float scale) {
        ScaleContext ctx;
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(51);
        }
        if (ancestor == null && icon2 instanceof ScaleContextAware) {
            UserScaleContext usrCtx = ((ScaleContextAware)icon2).getScaleContext();
            ctx = ScaleContext.create((UserScaleContext)usrCtx);
        } else {
            ctx = ScaleContext.create((Component)ancestor);
        }
        ctx.update(ScaleType.OBJ_SCALE.of((double)scale));
        return IconUtil.scale(icon2, ctx);
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon2, @NotNull ScaleContext ctx) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(52);
        }
        if (ctx == null) {
            IconUtil.$$$reportNull$$$0(53);
        }
        double scale = ctx.getScale(ScaleType.OBJ_SCALE);
        if (icon2 instanceof CopyableIcon && (icon2 = ((CopyableIcon)icon2).deepCopy()) instanceof ScalableIcon) {
            if (icon2 instanceof ScaleContextAware) {
                ctx = (ScaleContext)ctx.copy();
                ctx.update(ScaleType.OBJ_SCALE.of(1.0));
                ((ScaleContextAware)icon2).updateScaleContext((UserScaleContext)ctx);
            }
            Icon icon3 = ((ScalableIcon)icon2).scale((float)scale);
            if (icon3 == null) {
                IconUtil.$$$reportNull$$$0(54);
            }
            return icon3;
        }
        return IconUtil.scale(icon2, scale);
    }

    @NotNull
    public static Icon scaleByFont(@NotNull Icon icon2, @Nullable Component ancestor, float fontSize) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(55);
        }
        float scale = JBUIScale.getFontScale((float)fontSize);
        if (icon2 instanceof ScaleContextAware) {
            ScaleContextAware ctxIcon = (ScaleContextAware)icon2;
            double usrScale = ctxIcon.getScaleContext().getScale(ScaleType.USR_SCALE);
            scale = (float)((double)scale / usrScale);
        }
        return IconUtil.scale(icon2, ancestor, scale);
    }

    @NotNull
    public static Icon overrideScale(@NotNull Icon icon2, Scale scale) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(56);
        }
        if (icon2 instanceof CompositeIcon) {
            CompositeIcon compositeIcon = (CompositeIcon)icon2;
            for (int i2 = 0; i2 < compositeIcon.getIconCount(); ++i2) {
                Icon subIcon = compositeIcon.getIcon(i2);
                if (subIcon == null) continue;
                IconUtil.overrideScale(subIcon, scale);
            }
        }
        if (icon2 instanceof ScaleContextAware) {
            ((ScaleContextAware)icon2).getScaleContext().overrideScale(scale);
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            IconUtil.$$$reportNull$$$0(57);
        }
        return icon3;
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(58);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(59);
        }
        return IconUtil.colorize(source, color, false);
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(60);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(61);
        }
        return IconUtil.colorize(g, source, color, false);
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(62);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(63);
        }
        return IconUtil.filterIcon(source, () -> new ColorFilter(color, keepGray), null);
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(64);
        }
        if (color == null) {
            IconUtil.$$$reportNull$$$0(65);
        }
        return IconUtil.filterIcon(g, source, new ColorFilter(color, keepGray));
    }

    @NotNull
    public static Icon desaturate(@NotNull Icon source) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(66);
        }
        return IconUtil.filterIcon(source, () -> new DesaturationFilter(), null);
    }

    @NotNull
    public static Icon brighter(@NotNull Icon source, int tones) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(67);
        }
        return IconUtil.filterIcon(source, () -> new BrighterFilter(tones), null);
    }

    @NotNull
    public static Icon darker(@NotNull Icon source, int tones) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(68);
        }
        return IconUtil.filterIcon(source, () -> new DarkerFilter(tones), null);
    }

    @NotNull
    private static Icon filterIcon(Graphics2D g, @NotNull Icon source, @NotNull ColorFilter filter) {
        if (source == null) {
            IconUtil.$$$reportNull$$$0(69);
        }
        if (filter == null) {
            IconUtil.$$$reportNull$$$0(70);
        }
        BufferedImage src = g != null ? ImageUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)2) : ImageUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)2);
        Graphics2D g2d = src.createGraphics();
        source.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        BufferedImage img = g != null ? ImageUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)2) : ImageUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)2);
        for (int y = 0; y < src.getRaster().getHeight(); ++y) {
            for (int x = 0; x < src.getRaster().getWidth(); ++x) {
                int rgba = src.getRGB(x, y);
                if ((rgba & 0xFF000000) == 0) continue;
                img.setRGB(x, y, filter.filterRGB(x, y, rgba));
            }
        }
        return IconUtil.createImageIcon((Image)img);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static JBImageIcon createImageIcon(@NotNull BufferedImage img) {
        if (img == null) {
            IconUtil.$$$reportNull$$$0(71);
        }
        return IconUtil.createImageIcon((Image)img);
    }

    @NotNull
    public static JBImageIcon createImageIcon(@NotNull Image img) {
        if (img == null) {
            IconUtil.$$$reportNull$$$0(72);
        }
        return new JBImageIcon(img){

            public int getIconWidth() {
                return ImageUtil.getUserWidth((Image)this.getImage());
            }

            public int getIconHeight() {
                return ImageUtil.getUserHeight((Image)this.getImage());
            }
        };
    }

    @NotNull
    public static Icon textToIcon(@NotNull String text2, final @NotNull Component component2, final float fontSize) {
        if (text2 == null) {
            IconUtil.$$$reportNull$$$0(73);
        }
        if (component2 == null) {
            IconUtil.$$$reportNull$$$0(74);
        }
        final class MyIcon
        extends JBScalableIcon {
            @NotNull
            private final String myText;
            private Font myFont;
            private FontMetrics myMetrics;
            private final WeakReference<Component> myCompRef;

            private MyIcon(@NotNull String text2) {
                if (component22 == null) {
                    MyIcon.$$$reportNull$$$0(0);
                }
                this.myCompRef = new WeakReference<Component>(component2);
                this.myText = text2;
                this.setIconPreScaled(false);
                this.getScaleContext().addUpdateListener(() -> this.update());
                this.update();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                try {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    g.setFont(this.myFont);
                    UIUtil.drawStringWithHighlighting((Graphics)g, (String)this.myText, (int)((int)this.scaleVal(x, ScaleType.OBJ_SCALE) + (int)this.scaleVal(2.0)), (int)((int)this.scaleVal(y, ScaleType.OBJ_SCALE) + this.getIconHeight() - (int)this.scaleVal(1.0)), (Color)JBColor.foreground(), (Color)JBColor.background());
                }
                finally {
                    g.dispose();
                }
            }

            public int getIconWidth() {
                return this.myMetrics.stringWidth(this.myText) + (int)this.scaleVal(4.0);
            }

            public int getIconHeight() {
                return this.myMetrics.getHeight();
            }

            private void update() {
                this.myFont = JBFont.create((Font)JBFont.label().deriveFont((float)this.scaleVal(fontSize, ScaleType.OBJ_SCALE)));
                Component comp = (Component)this.myCompRef.get();
                if (comp == null) {
                    comp = new Component(){};
                }
                this.myMetrics = comp.getFontMetrics(this.myFont);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof MyIcon)) {
                    return false;
                }
                MyIcon icon2 = (MyIcon)((Object)o);
                if (!Objects.equals(this.myText, icon2.myText)) {
                    return false;
                }
                return Objects.equals(this.myFont, icon2.myFont);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/IconUtil$1MyIcon", "<init>"));
            }
        }
        return new MyIcon(text2);
    }

    @NotNull
    public static Icon addText(@NotNull Icon base, @NotNull String text2) {
        if (base == null) {
            IconUtil.$$$reportNull$$$0(75);
        }
        if (text2 == null) {
            IconUtil.$$$reportNull$$$0(76);
        }
        LayeredIcon icon2 = new LayeredIcon(2);
        icon2.setIcon(base, 0);
        icon2.setIcon(IconUtil.textToIcon(text2, new JLabel(), JBUIScale.scale((float)6.0f)), 1, 4);
        LayeredIcon layeredIcon = icon2;
        if (layeredIcon == null) {
            IconUtil.$$$reportNull$$$0(77);
        }
        return layeredIcon;
    }

    @NotNull
    public static Icon filterIcon(@NotNull Icon icon2, Supplier<? extends RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        if (icon2 == null) {
            IconUtil.$$$reportNull$$$0(78);
        }
        Icon icon3 = IconLoader.filterIcon((Icon)icon2, filterSupplier, (Component)ancestor);
        if (icon3 == null) {
            IconUtil.$$$reportNull$$$0(79);
        }
        return icon3;
    }

    public static Icon replaceInnerIcon(@Nullable Icon icon2, @NotNull Icon toCheck, @NotNull Icon toReplace) {
        block7: {
            block6: {
                if (toCheck == null) {
                    IconUtil.$$$reportNull$$$0(80);
                }
                if (toReplace == null) {
                    IconUtil.$$$reportNull$$$0(81);
                }
                if (!(icon2 instanceof LayeredIcon)) break block6;
                Icon[] layers = ((LayeredIcon)icon2).getAllLayers();
                for (int i2 = 0; i2 < layers.length; ++i2) {
                    Icon layer = layers[i2];
                    if (layer == toCheck) {
                        layers[i2] = toReplace;
                        continue;
                    }
                    IconUtil.replaceInnerIcon(layer, toCheck, toReplace);
                }
                break block7;
            }
            if (!(icon2 instanceof RowIcon)) break block7;
            Icon[] allIcons = ((RowIcon)icon2).getAllIcons();
            for (int i3 = 0; i3 < allIcons.length; ++i3) {
                Icon anIcon = allIcons[i3];
                if (anIcon == toCheck) {
                    ((RowIcon)icon2).setIcon(toReplace, i3);
                    continue;
                }
                IconUtil.replaceInnerIcon(anIcon, toCheck, toReplace);
            }
        }
        return icon2;
    }

    @Nullable
    public static Icon rowIcon(@Nullable Icon left, @Nullable Icon right) {
        if (left != null && right != null) {
            return new RowIcon(left, right);
        }
        if (left != null) {
            return left;
        }
        return right;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 54: 
            case 57: 
            case 77: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 54: 
            case 57: 
            case 77: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 41: 
            case 45: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 54: 
            case 57: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/IconUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 40: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 47: 
            case 49: 
            case 50: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 59: 
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "img";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/IconUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cropIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFileIcon";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBaseFileIcon";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIcon";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toImage";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toBufferedImage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddIcon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveIcon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveUpIcon";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveDownIcon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddClassIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPatternIcon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddJiraPatternIcon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddYouTrackPatternIcon";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddBlankLineIcon";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPackageIcon";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddLinkIcon";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyzeIcon";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIconsFolder";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualSizedIcons";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideScale";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "addText";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wasEverInitialized";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cropIcon";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 54: 
            case 57: 
            case 77: 
            case 79: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "flip";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeFileIcon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterFileIconFlags";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeBaseFileIcon";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersIcon";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toBufferedImage";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "paintInCenterOf";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getEqualSizedIcons";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "paintSelectionAwareIcon";
                break;
            }
            case 47: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "paintScaled";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resizeSquared";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "scaleByFont";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "overrideScale";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 69: 
            case 70: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createImageIcon";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "textToIcon";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "replaceInnerIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 44: 
            case 54: 
            case 57: 
            case 77: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DarkerFilter
    extends RGBImageFilter {
        private final int myTones;

        DarkerFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            Color originalColor = new Color(rgb, true);
            Color filteredColor = ColorUtil.toAlpha((Color)ColorUtil.darker((Color)originalColor, (int)this.myTones), (int)originalColor.getAlpha());
            return filteredColor.getRGB();
        }
    }

    private static class BrighterFilter
    extends RGBImageFilter {
        private final int myTones;

        BrighterFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            Color originalColor = new Color(rgb, true);
            Color filteredColor = ColorUtil.toAlpha((Color)ColorUtil.brighter((Color)originalColor, (int)this.myTones), (int)originalColor.getAlpha());
            return filteredColor.getRGB();
        }
    }

    private static class DesaturationFilter
    extends RGBImageFilter {
        private DesaturationFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgba) {
            int r = rgba >> 16 & 0xFF;
            int g = rgba >> 8 & 0xFF;
            int b = rgba & 0xFF;
            int min = Math.min(Math.min(r, g), b);
            int max = Math.max(Math.max(r, g), b);
            int grey = (max + min) / 2;
            return rgba & 0xFF000000 | grey << 16 | grey << 8 | grey;
        }
    }

    private static final class ColorFilter
    extends RGBImageFilter {
        private final float[] myBase;
        private final boolean myKeepGray;

        private ColorFilter(@NotNull Color color, boolean keepGray) {
            if (color == null) {
                ColorFilter.$$$reportNull$$$0(0);
            }
            this.myKeepGray = keepGray;
            this.myBase = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        }

        @Override
        public int filterRGB(int x, int y, int rgba) {
            int r = rgba >> 16 & 0xFF;
            int g = rgba >> 8 & 0xFF;
            int b = rgba & 0xFF;
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            int rgb = Color.HSBtoRGB(this.myBase[0], this.myBase[1] * (this.myKeepGray ? hsb[1] : 1.0f), this.myBase[2] * hsb[2]);
            return rgba & 0xFF000000 | rgb & 0xFFFFFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/IconUtil$ColorFilter", "<init>"));
        }
    }

    private static final class CropIcon
    implements Icon {
        private final Icon mySrc;
        private final Rectangle myCrop;

        private CropIcon(@NotNull Icon src, @NotNull Rectangle crop) {
            if (src == null) {
                CropIcon.$$$reportNull$$$0(0);
            }
            if (crop == null) {
                CropIcon.$$$reportNull$$$0(1);
            }
            this.mySrc = src;
            this.myCrop = crop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = g.create();
            try {
                Rectangle iconClip = new Rectangle(x, y, this.myCrop.width, this.myCrop.height);
                Rectangle gClip = g.getClipBounds();
                if (gClip != null) {
                    Rectangle2D.intersect(iconClip, gClip, iconClip);
                }
                g.setClip(iconClip);
                this.mySrc.paintIcon(c, g, x - this.myCrop.x, y - this.myCrop.y);
            }
            finally {
                g.dispose();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (" + this.mySrc + " -> " + this.myCrop + ")";
        }

        @Override
        public int getIconWidth() {
            return this.myCrop.width;
        }

        @Override
        public int getIconHeight() {
            return this.myCrop.height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CropIcon)) {
                return false;
            }
            CropIcon icon2 = (CropIcon)o;
            return this.mySrc.equals(icon2.mySrc) && this.myCrop.equals(icon2.myCrop);
        }

        public int hashCode() {
            return Objects.hash(this.mySrc, this.myCrop);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "src";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "crop";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/IconUtil$CropIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IconSizeWrapper
    implements Icon {
        private final Icon myIcon;
        private final int myWidth;
        private final int myHeight;

        protected IconSizeWrapper(@Nullable Icon icon2, int width, int height) {
            this.myIcon = icon2;
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIcon(this.myIcon, c, g, x, y);
        }

        protected void paintIcon(@Nullable Icon icon2, Component c, Graphics g, int x, int y) {
            if (icon2 == null) {
                return;
            }
            icon2.paintIcon(c, g, x += (this.myWidth - icon2.getIconWidth()) / 2, y += (this.myHeight - icon2.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }
}

