/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IntObjectLRUMap<T> {
    private final MapEntry<T> myHeader;
    private final MapEntry<T>[] myArray;
    private final int myCapacity;
    private int mySize;

    public IntObjectLRUMap(int capacity) {
        this.myCapacity = capacity;
        this.myArray = new MapEntry[capacity * 8 / 5];
        this.myHeader = new MapEntry<Object>(0, null);
        this.myHeader.after = this.myHeader;
        this.myHeader.before = this.myHeader.after;
    }

    @Nullable
    public MapEntry<T> getEntry(int key) {
        MapEntry<T> candidate = this.myArray[this.getArrayIndex(key)];
        while (candidate != null) {
            if (candidate.key == key) {
                return candidate;
            }
            candidate = candidate.next;
        }
        return null;
    }

    private int getArrayIndex(int key) {
        return (key & Integer.MAX_VALUE) % this.myArray.length;
    }

    public void removeEntry(int key) {
        int index2 = this.getArrayIndex(key);
        MapEntry<T> candidate = this.myArray[index2];
        MapEntry<T> prev2 = null;
        while (candidate != null) {
            if (candidate.key == key) {
                if (prev2 == null) {
                    this.myArray[index2] = candidate.next;
                } else {
                    prev2.next = candidate.next;
                }
                candidate.before.after = candidate.after;
                candidate.after.before = candidate.before;
                candidate.after = null;
                candidate.before = null;
                candidate.next = null;
                --this.mySize;
                return;
            }
            prev2 = candidate;
            candidate = candidate.next;
        }
    }

    public MapEntry<T> putEntry(@NotNull MapEntry<T> entry2) {
        if (entry2 == null) {
            IntObjectLRUMap.$$$reportNull$$$0(0);
        }
        this.removeEntry(entry2.key);
        int index2 = this.getArrayIndex(entry2.key);
        entry2.next = this.myArray[index2];
        this.myArray[index2] = entry2;
        entry2.before = this.myHeader.before;
        entry2.after = this.myHeader;
        entry2.before.after = entry2;
        this.myHeader.before = entry2;
        ++this.mySize;
        if (this.mySize <= this.myCapacity) {
            return null;
        }
        MapEntry eldest = this.myHeader.after;
        this.removeEntry(eldest.key);
        return eldest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/util/containers/IntObjectLRUMap", "putEntry"));
    }

    public static class MapEntry<T> {
        public final int key;
        public final T value;
        MapEntry<T> next;
        MapEntry<T> before;
        MapEntry<T> after;

        public MapEntry(int key, T value2) {
            this.key = key;
            this.value = value2;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

