/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\rH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0007J\b\u0010\u0011\u001a\u00020\rH\u0007J\b\u0010\u0012\u001a\u00020\rH\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/CorruptionMarker;", "", "()V", "CORRUPTION_MARKER_NAME", "", "EXPLICIT_INVALIDATION_REASON", "MARKED_AS_DIRTY_REASON", "corruptionMarker", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCorruptionMarker", "()Ljava/nio/file/Path;", "createCorruptionMarker", "", "reason", "dropIndexes", "markIndexesAsClosed", "markIndexesAsDirty", "requestInvalidation", "requireInvalidation", "", "intellij.platform.lang.impl"})
public final class CorruptionMarker {
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private static final String MARKED_AS_DIRTY_REASON = "Indexes marked as dirty (IDE is expected to be work)";
    private static final String EXPLICIT_INVALIDATION_REASON = "Explicit index invalidation";
    @NotNull
    public static final CorruptionMarker INSTANCE;

    private final Path getCorruptionMarker() {
        return PathManager.getIndexRoot().resolve(CORRUPTION_MARKER_NAME);
    }

    @JvmStatic
    public static final void markIndexesAsDirty() {
        INSTANCE.createCorruptionMarker(MARKED_AS_DIRTY_REASON);
    }

    @JvmStatic
    public static final void markIndexesAsClosed() {
        Path path2 = INSTANCE.getCorruptionMarker();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
        boolean corruptionMarkerExists = PathKt.exists((Path)path2);
        if (corruptionMarkerExists) {
            try {
                Path path3 = INSTANCE.getCorruptionMarker();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"corruptionMarker");
                if (Intrinsics.areEqual((Object)PathKt.readText((Path)path3), (Object)MARKED_AS_DIRTY_REASON)) {
                    Path path4 = INSTANCE.getCorruptionMarker();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"corruptionMarker");
                    Path path5 = path4;
                    boolean bl = false;
                    Files.delete(path5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @JvmStatic
    public static final void requestInvalidation() {
        FileBasedIndexImpl.LOG.info("Explicit index invalidation has been requested");
        INSTANCE.createCorruptionMarker(EXPLICIT_INVALIDATION_REASON);
    }

    @JvmStatic
    public static final boolean requireInvalidation() {
        Path path2 = INSTANCE.getCorruptionMarker();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
        boolean corruptionMarkerExists = PathKt.exists((Path)path2);
        if (corruptionMarkerExists) {
            String message2 = "Indexes are corrupted and will be rebuilt";
            try {
                Path path3 = INSTANCE.getCorruptionMarker();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"corruptionMarker");
                String corruptionReason = PathKt.readText((Path)path3);
                FileBasedIndexImpl.LOG.info(message2 + " (reason = " + corruptionReason + ')');
            }
            catch (Exception e) {
                FileBasedIndexImpl.LOG.info(message2);
            }
        }
        return IndexInfrastructure.hasIndices() && corruptionMarkerExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void dropIndexes() {
        Path it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        int n;
        boolean $i$f$directoryStreamIfExists;
        Path $this$directoryStreamIfExists$iv;
        Path path2 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"PathManager.getIndexRoot()");
        Path indexRoot = path2;
        if (Files.exists(indexRoot, new LinkOption[0])) {
            ExtensionPointName<FileBasedIndexInfrastructureExtension> extensionPointName = FileBasedIndexInfrastructureExtension.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexInfrastructureExtension.EP_NAME");
            Object[] objectArray = extensionPointName.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexInfrastruc\u2026ension.EP_NAME.extensions");
            Object[] $this$mapNotNull$iv = objectArray;
            boolean $i$f$mapNotNull = false;
            Object[] object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Object[] $this$forEach$iv$iv$iv = object;
            boolean $i$f$forEach2 = false;
            Object[] objectArray2 = $this$forEach$iv$iv$iv;
            int n2 = objectArray2.length;
            for (int j = 0; j < n2; ++j) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = objectArray2[j];
                boolean bl = false;
                FileBasedIndexInfrastructureExtension it2 = (FileBasedIndexInfrastructureExtension)element$iv$iv;
                boolean bl2 = false;
                FileBasedIndexInfrastructureExtension fileBasedIndexInfrastructureExtension = it2;
                Intrinsics.checkNotNullExpressionValue((Object)fileBasedIndexInfrastructureExtension, (String)"it");
                if (fileBasedIndexInfrastructureExtension.getPersistentStateRoot() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set filesToBeIgnored = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$directoryStreamIfExists$iv = indexRoot;
            $i$f$directoryStreamIfExists = false;
            try {
                Closeable noSuchFileException = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                boolean bl = false;
                n = 0;
                Throwable throwable = null;
                try {
                    DirectoryStream dirStream2 = (DirectoryStream)noSuchFileException;
                    boolean bl6 = false;
                    $this$forEach$iv = dirStream2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Path)element$iv;
                        boolean bl7 = false;
                        Path path3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it");
                        if (filesToBeIgnored.contains(((Object)path3.getFileName()).toString())) continue;
                        FileUtil.deleteWithRenaming((File)it.toFile());
                    }
                    dirStream2 = Unit.INSTANCE;
                }
                catch (Throwable dirStream2) {
                    throwable = dirStream2;
                    throw dirStream2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)noSuchFileException, (Throwable)throwable);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        } else {
            Files.createDirectories(indexRoot, new FileAttribute[0]);
        }
        Path indexingDiagnosticDir2 = IndexDiagnosticDumper.Companion.getIndexingDiagnosticDir();
        if (PathKt.exists((Path)indexingDiagnosticDir2)) {
            $this$directoryStreamIfExists$iv = indexingDiagnosticDir2;
            $i$f$directoryStreamIfExists = false;
            try {
                Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                boolean bl = false;
                n = 0;
                Throwable throwable = null;
                try {
                    DirectoryStream dirStream3 = (DirectoryStream)closeable;
                    boolean bl8 = false;
                    $this$forEach$iv = dirStream3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Path)element$iv;
                        boolean bl9 = false;
                        FileUtil.deleteWithRenaming((Path)it);
                    }
                    dirStream3 = Unit.INSTANCE;
                }
                catch (Throwable dirStream3) {
                    throwable = dirStream3;
                    throw dirStream3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        }
        SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
        ID.reinitializeDiskStorage();
        PersistentIndicesConfiguration.saveConfiguration();
        FileUtil.delete((Path)INSTANCE.getCorruptionMarker());
        ExtensionPointName<FileBasedIndexInfrastructureExtension> extensionPointName = FileBasedIndexInfrastructureExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"FileBasedIndexInfrastructureExtension.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FileBasedIndexInfrastruc\u2026ension.EP_NAME.extensions");
        Object[] $this$forEach$iv2 = objectArray;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FileBasedIndexInfrastructureExtension it3 = (FileBasedIndexInfrastructureExtension)element$iv;
            boolean bl = false;
            it3.resetPersistentState();
        }
        FileBasedIndexLayoutSettings.INSTANCE.saveCurrentLayout();
    }

    private final void createCorruptionMarker(String reason) {
        try {
            Path path2 = this.getCorruptionMarker();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
            PathKt.write$default((Path)path2, (CharSequence)reason, null, (boolean)false, (int)6, null);
        }
        catch (Exception e) {
            FileBasedIndexImpl.LOG.warn((Throwable)e);
        }
    }

    private CorruptionMarker() {
    }

    static {
        CorruptionMarker corruptionMarker;
        INSTANCE = corruptionMarker = new CorruptionMarker();
    }
}

