/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndexDataInitialization;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.UpdateTask;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class RegisteredIndexes {
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final Future<IndexConfiguration> myStateFuture;
    private final List<ID<?, ?>> myIndicesForDirectories;
    private final Set<ID<?, ?>> myNotRequiringContentIndices;
    private final Set<ID<?, ?>> myRequiringContentIndices;
    private final Set<FileType> myNoLimitCheckTypes;
    private volatile boolean myExtensionsRelatedDataWasLoaded;
    private volatile boolean myInitialized;
    private volatile IndexConfiguration myState;
    private volatile Future<?> myAllIndicesInitializedFuture;
    private final Map<ID<?, ?>, DocumentUpdateTask> myUnsavedDataUpdateTasks;
    private final AtomicBoolean myShutdownPerformed;

    RegisteredIndexes(@NotNull FileDocumentManager fileDocumentManager, @NotNull FileBasedIndexImpl fileBasedIndex) {
        if (fileDocumentManager == null) {
            RegisteredIndexes.$$$reportNull$$$0(0);
        }
        if (fileBasedIndex == null) {
            RegisteredIndexes.$$$reportNull$$$0(1);
        }
        this.myIndicesForDirectories = new SmartList();
        this.myNotRequiringContentIndices = new HashSet();
        this.myRequiringContentIndices = new HashSet();
        this.myNoLimitCheckTypes = new HashSet<FileType>();
        this.myUnsavedDataUpdateTasks = new ConcurrentHashMap();
        this.myShutdownPerformed = new AtomicBoolean(false);
        this.myFileDocumentManager = fileDocumentManager;
        this.myFileBasedIndex = fileBasedIndex;
        this.myStateFuture = IndexDataInitializer.submitGenesisTask(new FileBasedIndexDataInitialization(fileBasedIndex, this));
        if (!IndexDataInitializer.ourDoAsyncIndicesInitialization) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.waitUntilIndicesAreInitialized());
        }
    }

    boolean performShutdown() {
        return this.myShutdownPerformed.compareAndSet(false, true);
    }

    void setState(@NotNull IndexConfiguration state) {
        if (state == null) {
            RegisteredIndexes.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    IndexConfiguration getState() {
        return this.myState;
    }

    IndexConfiguration getConfigurationState() {
        IndexConfiguration state = this.myState;
        if (state == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    void waitUntilAllIndicesAreInitialized() {
        this.waitUntilIndicesAreInitialized();
        RegisteredIndexes.await(this.myAllIndicesInitializedFuture);
    }

    void waitUntilIndicesAreInitialized() {
        RegisteredIndexes.await(this.myStateFuture);
    }

    void extensionsDataWasLoaded() {
        this.myExtensionsRelatedDataWasLoaded = true;
    }

    void markInitialized() {
        this.myInitialized = true;
    }

    void ensureLoadedIndexesUpToDate() {
        this.myAllIndicesInitializedFuture = IndexDataInitializer.submitGenesisTask(() -> {
            if (!this.myShutdownPerformed.get()) {
                this.myFileBasedIndex.ensureStaleIdsDeleted();
                this.myFileBasedIndex.getChangedFilesCollector().ensureUpToDateAsync();
            }
            return null;
        });
    }

    void registerIndexExtension(@NotNull FileBasedIndexExtension<?, ?> extension2) {
        if (extension2 == null) {
            RegisteredIndexes.$$$reportNull$$$0(3);
        }
        ID name = extension2.getName();
        if (extension2.dependsOnFileContent()) {
            this.myUnsavedDataUpdateTasks.put(name, new DocumentUpdateTask(name));
        }
        if (!extension2.dependsOnFileContent()) {
            if (extension2.indexDirectories()) {
                this.myIndicesForDirectories.add(name);
            }
            this.myNotRequiringContentIndices.add(name);
        } else {
            this.myRequiringContentIndices.add(name);
        }
        this.myNoLimitCheckTypes.addAll(extension2.getFileTypesWithSizeLimitNotApplicable());
    }

    @NotNull
    Set<FileType> getNoLimitCheckFileTypes() {
        Set<FileType> set2 = this.myNoLimitCheckTypes;
        if (set2 == null) {
            RegisteredIndexes.$$$reportNull$$$0(4);
        }
        return set2;
    }

    boolean areIndexesReady() {
        return this.myStateFuture.isDone() && this.myAllIndicesInitializedFuture != null && this.myAllIndicesInitializedFuture.isDone();
    }

    boolean isExtensionsDataLoaded() {
        return this.myExtensionsRelatedDataWasLoaded;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    Set<ID<?, ?>> getRequiringContentIndices() {
        return this.myRequiringContentIndices;
    }

    @NotNull
    Set<ID<?, ?>> getNotRequiringContentIndices() {
        Set<ID<?, ?>> set2 = this.myNotRequiringContentIndices;
        if (set2 == null) {
            RegisteredIndexes.$$$reportNull$$$0(5);
        }
        return set2;
    }

    @NotNull
    List<ID<?, ?>> getIndicesForDirectories() {
        List<ID<?, ?>> list2 = this.myIndicesForDirectories;
        if (list2 == null) {
            RegisteredIndexes.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public boolean isContentDependentIndex(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            RegisteredIndexes.$$$reportNull$$$0(7);
        }
        return this.myRequiringContentIndices.contains(indexId);
    }

    UpdateTask<Document> getUnsavedDataUpdateTask(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            RegisteredIndexes.$$$reportNull$$$0(8);
        }
        return this.myUnsavedDataUpdateTasks.get(indexId);
    }

    private static void await(@NotNull Future<?> future2) {
        if (future2 == null) {
            RegisteredIndexes.$$$reportNull$$$0(9);
        }
        if (ProgressManager.getInstance().isInNonCancelableSection()) {
            try {
                future2.get();
            }
            catch (InterruptedException e) {
                FileBasedIndexImpl.LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                FileBasedIndexImpl.LOG.error((Throwable)e);
            }
        } else {
            ProgressIndicatorUtils.awaitWithCheckCanceled(future2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/RegisteredIndexes";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/RegisteredIndexes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoLimitCheckFileTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotRequiringContentIndices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesForDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexExtension";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isContentDependentIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedDataUpdateTask";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "await";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DocumentUpdateTask
    extends UpdateTask<Document> {
        private final ID<?, ?> myIndexId;

        DocumentUpdateTask(ID<?, ?> indexId) {
            this.myIndexId = indexId;
        }

        @Override
        void doProcess(Document document, Project project) {
            RegisteredIndexes.this.myFileBasedIndex.indexUnsavedDocument(document, this.myIndexId, project, RegisteredIndexes.this.myFileDocumentManager.getFile(document));
        }
    }
}

