/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

final class StorageGuard {
    private final Lock myLock = new ReentrantLock();
    private final Condition myCondition = this.myLock.newCondition();
    private int myHolds;
    private final StorageModeExitHandler myTrueStorageModeExitHandler = new StorageModeExitHandler(){

        @Override
        public void leave() {
            StorageGuard.this.leave(true);
        }
    };
    private final StorageModeExitHandler myFalseStorageModeExitHandler = new StorageModeExitHandler(){

        @Override
        public void leave() {
            StorageGuard.this.leave(false);
        }
    };

    StorageGuard() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    StorageModeExitHandler enter(boolean mode) {
        boolean nonCancelableSection = ProgressManager.getInstance().isInNonCancelableSection();
        this.myLock.lock();
        if (mode) {
            while (this.myHolds < 0) {
                this.await(nonCancelableSection);
            }
            ++this.myHolds;
            StorageModeExitHandler storageModeExitHandler = this.myTrueStorageModeExitHandler;
            StorageModeExitHandler storageModeExitHandler2 = storageModeExitHandler;
            if (storageModeExitHandler2 == null) {
                StorageGuard.$$$reportNull$$$0(0);
            }
            return storageModeExitHandler2;
        }
        while (this.myHolds > 0) {
            this.await(nonCancelableSection);
        }
        --this.myHolds;
        StorageModeExitHandler storageModeExitHandler = this.myFalseStorageModeExitHandler;
        StorageModeExitHandler storageModeExitHandler3 = storageModeExitHandler;
        if (storageModeExitHandler3 == null) {
            StorageGuard.$$$reportNull$$$0(1);
        }
        return storageModeExitHandler3;
        finally {
            this.myLock.unlock();
        }
    }

    private void await(boolean nonCancelableSection) {
        if (nonCancelableSection) {
            this.myCondition.awaitUninterruptibly();
        } else {
            ProgressIndicatorUtils.awaitWithCheckCanceled(this.myCondition);
        }
    }

    private void leave(boolean mode) {
        this.myLock.lock();
        try {
            this.myHolds += mode ? -1 : 1;
            if (this.myHolds == 0) {
                this.myCondition.signalAll();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/StorageGuard", "enter"));
    }

    public static interface StorageModeExitHandler {
        public void leave();
    }
}

