/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.contentQueue.CachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.CurrentProjectHintedCachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.FailedToLoadContentException;
import com.intellij.util.indexing.contentQueue.TooLargeContentException;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexUpdateRunner {
    private static final long SOFT_MAX_TOTAL_BYTES_LOADED_INTO_MEMORY = 0x1400000L;
    private static final CopyOnWriteArrayList<IndexingJob> ourIndexingJobs = new CopyOnWriteArrayList();
    private final FileBasedIndexImpl myFileBasedIndex;
    private final ExecutorService myIndexingExecutor;
    private final int myNumberOfIndexingThreads;
    private static long ourTotalBytesLoadedIntoMemory = 0L;
    private static final Lock ourLoadedBytesLimitLock = new ReentrantLock();
    private static final Condition ourLoadedBytesAreReleasedCondition = ourLoadedBytesLimitLock.newCondition();

    public IndexUpdateRunner(@NotNull FileBasedIndexImpl fileBasedIndex, @NotNull ExecutorService indexingExecutor, int numberOfIndexingThreads) {
        if (fileBasedIndex == null) {
            IndexUpdateRunner.$$$reportNull$$$0(0);
        }
        if (indexingExecutor == null) {
            IndexUpdateRunner.$$$reportNull$$$0(1);
        }
        this.myFileBasedIndex = fileBasedIndex;
        this.myIndexingExecutor = indexingExecutor;
        this.myNumberOfIndexingThreads = numberOfIndexingThreads;
    }

    public void indexFiles(@NotNull Project project, @NotNull List<FileSet> fileSets, @NotNull ProgressIndicator indicator2) throws IndexingInterruptedException {
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(2);
        }
        if (fileSets == null) {
            IndexUpdateRunner.$$$reportNull$$$0(3);
        }
        if (indicator2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(4);
        }
        long startTime = System.nanoTime();
        try {
            this.doIndexFiles(project, fileSets, indicator2);
        }
        catch (RuntimeException e) {
            throw new IndexingInterruptedException(e);
        }
        finally {
            long visibleIndexingTime = System.nanoTime() - startTime;
            long totalProcessingTimeInAllThreads = fileSets.stream().mapToLong(b -> b.statistics.getProcessingTimeInAllThreads()).sum();
            fileSets.forEach(b -> {
                long weightedVisibleTime = totalProcessingTimeInAllThreads == 0L ? 0L : (long)((double)visibleIndexingTime * ((double)b.statistics.getProcessingTimeInAllThreads() / (double)totalProcessingTimeInAllThreads));
                b.statistics.setIndexingVisibleTime(weightedVisibleTime);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIndexFiles(@NotNull Project project, @NotNull List<FileSet> fileSets, @NotNull ProgressIndicator indicator2) {
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(5);
        }
        if (fileSets == null) {
            IndexUpdateRunner.$$$reportNull$$$0(6);
        }
        if (indicator2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.and(fileSets, b -> b.files.isEmpty())) {
            return;
        }
        indicator2.checkCanceled();
        indicator2.setIndeterminate(false);
        CurrentProjectHintedCachedFileContentLoader contentLoader = new CurrentProjectHintedCachedFileContentLoader(project);
        ProgressIndicator originalIndicator = IndexUpdateRunner.unwrapAll(indicator2);
        ProgressSuspender originalSuspender = ProgressSuspender.getSuspender(originalIndicator);
        IndexingJob indexingJob = new IndexingJob(project, indicator2, contentLoader, fileSets, originalIndicator, originalSuspender);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            while (!indexingJob.areAllFilesProcessed()) {
                this.indexOneFileOfJob(indexingJob);
            }
        } else {
            ourIndexingJobs.add(indexingJob);
            try {
                Throwable error2;
                AtomicInteger numberOfRunningWorkers = new AtomicInteger();
                Runnable worker = () -> {
                    try {
                        this.indexJobsFairly();
                    }
                    finally {
                        numberOfRunningWorkers.decrementAndGet();
                    }
                };
                for (int i2 = 0; i2 < this.myNumberOfIndexingThreads; ++i2) {
                    this.myIndexingExecutor.execute(worker);
                    numberOfRunningWorkers.incrementAndGet();
                }
                while (!project.isDisposed() && !indexingJob.areAllFilesProcessed() && indexingJob.myError.get() == null) {
                    indicator2.checkCanceled();
                    int toAddWorkersNumber = this.myNumberOfIndexingThreads - numberOfRunningWorkers.get();
                    for (int i3 = 0; i3 < toAddWorkersNumber; ++i3) {
                        this.myIndexingExecutor.execute(worker);
                        numberOfRunningWorkers.incrementAndGet();
                    }
                    try {
                        if (!indexingJob.myAllFilesAreProcessedLatch.await(100L, TimeUnit.MILLISECONDS)) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new ProcessCanceledException((Throwable)e);
                    }
                }
                if ((error2 = indexingJob.myError.get()) instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)error2;
                }
                if (error2 != null) {
                    throw new RuntimeException("Indexing of " + project.getName() + " has failed", error2);
                }
            }
            finally {
                ourIndexingJobs.remove(indexingJob);
            }
        }
    }

    private void indexJobsFairly() {
        while (!ourIndexingJobs.isEmpty()) {
            boolean allJobsAreSuspended = true;
            for (IndexingJob job2 : ourIndexingJobs) {
                ProgressIndicator jobIndicator = job2.myIndicator;
                if (job2.myProject.isDisposed() || job2.myNoMoreFilesInQueue.get() || jobIndicator.isCanceled() || job2.myError.get() != null) {
                    ourIndexingJobs.remove(job2);
                    allJobsAreSuspended = false;
                    continue;
                }
                ProgressSuspender suspender = job2.myOriginalProgressSuspender;
                if (suspender != null && suspender.isSuspended()) continue;
                allJobsAreSuspended = false;
                try {
                    Runnable work = () -> this.indexOneFileOfJob(job2);
                    if (suspender != null) {
                        suspender.executeNonSuspendableSection(job2.myOriginalProgressIndicator, work);
                        continue;
                    }
                    work.run();
                }
                catch (Throwable e) {
                    job2.myError.compareAndSet(null, e);
                    ourIndexingJobs.remove(job2);
                }
            }
            if (!allJobsAreSuspended) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexOneFileOfJob(@NotNull IndexingJob indexingJob) throws ProcessCanceledException {
        ContentLoadingResult loadingResult2;
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(8);
        }
        long startTime = System.nanoTime();
        try {
            loadingResult2 = this.loadNextContent(indexingJob, indexingJob.myIndicator);
        }
        catch (TooLargeContentException e) {
            IndexingJobStatistics statistics;
            indexingJob.oneMoreFileProcessed();
            IndexingJobStatistics indexingJobStatistics = statistics = indexingJob.getStatistics(e.getFile());
            synchronized (indexingJobStatistics) {
                statistics.addTooLargeForIndexingFile(e.getFile());
            }
            FileBasedIndexImpl.LOG.info("File: " + e.getFile().getUrl() + " is too large for indexing");
            return;
        }
        catch (FailedToLoadContentException e) {
            indexingJob.oneMoreFileProcessed();
            IndexUpdateRunner.logFailedToLoadContentException(e);
            return;
        }
        finally {
            long contentLoadingTime = System.nanoTime() - startTime;
        }
        if (loadingResult2 == null) {
            return;
        }
        CachedFileContent fileContent = loadingResult2.cachedFileContent;
        VirtualFile file2 = fileContent.getVirtualFile();
        try {
            indexingJob.setLocationBeingIndexed(file2);
            if (!file2.isDirectory()) {
                IndexingJobStatistics statistics;
                FileIndexingStatistics fileIndexingStatistics = (FileIndexingStatistics)ReadAction.nonBlocking(() -> this.myFileBasedIndex.indexFileContent(indexingJob.myProject, fileContent)).expireWith((Disposable)indexingJob.myProject).wrapProgress(indexingJob.myIndicator).executeSynchronously();
                long processingTime = System.nanoTime() - startTime;
                IndexingJobStatistics indexingJobStatistics = statistics = indexingJob.getStatistics(file2);
                synchronized (indexingJobStatistics) {
                    long contentLoadingTime;
                    statistics.addFileStatistics(file2, fileIndexingStatistics, processingTime, contentLoadingTime, loadingResult2.fileLength);
                }
            }
            indexingJob.oneMoreFileProcessed();
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (Throwable e) {
            indexingJob.oneMoreFileProcessed();
            FileBasedIndexImpl.LOG.error("Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted", e);
        }
        finally {
            IndexUpdateRunner.signalThatFileIsUnloaded(loadingResult2.fileLength);
        }
    }

    @Nullable
    private ContentLoadingResult loadNextContent(@NotNull IndexingJob indexingJob, @NotNull ProgressIndicator indicator2) throws FailedToLoadContentException, TooLargeContentException, ProcessCanceledException {
        long fileLength;
        VirtualFile file2;
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(9);
        }
        if (indicator2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(10);
        }
        if ((file2 = (VirtualFile)indexingJob.myQueueOfFiles.poll()) == null) {
            indexingJob.myNoMoreFilesInQueue.set(true);
            return null;
        }
        if (this.myFileBasedIndex.isTooLarge(file2)) {
            throw new TooLargeContentException(file2);
        }
        try {
            fileLength = file2.getLength();
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (Throwable e) {
            throw new FailedToLoadContentException(file2, e);
        }
        try {
            IndexUpdateRunner.waitForFreeMemoryToLoadFileContent(indicator2, fileLength);
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        try {
            CachedFileContent fileContent = indexingJob.myContentLoader.loadContent(file2);
            return new ContentLoadingResult(fileContent, fileLength);
        }
        catch (ProcessCanceledException e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (FailedToLoadContentException | TooLargeContentException e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            throw e;
        }
        catch (Throwable e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            ExceptionUtil.rethrow((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForFreeMemoryToLoadFileContent(@NotNull ProgressIndicator indicator2, long fileLength) throws ProcessCanceledException {
        if (indicator2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(11);
        }
        ourLoadedBytesLimitLock.lock();
        try {
            while (ourTotalBytesLoadedIntoMemory >= 0x1400000L) {
                indicator2.checkCanceled();
                try {
                    ourLoadedBytesAreReleasedCondition.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }
            ourTotalBytesLoadedIntoMemory += fileLength;
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void signalThatFileIsUnloaded(long fileLength) {
        ourLoadedBytesLimitLock.lock();
        try {
            assert (ourTotalBytesLoadedIntoMemory >= fileLength);
            if ((ourTotalBytesLoadedIntoMemory -= fileLength) < 0x1400000L) {
                ourLoadedBytesAreReleasedCondition.signalAll();
            }
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void logFailedToLoadContentException(@NotNull FailedToLoadContentException e) {
        if (e == null) {
            IndexUpdateRunner.$$$reportNull$$$0(12);
        }
        Throwable cause = e.getCause();
        VirtualFile file2 = e.getFile();
        String fileUrl = "File: " + file2.getUrl();
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            FileBasedIndexImpl.LOG.debug(fileUrl, (Throwable)e);
        } else if (cause instanceof IndexOutOfBoundsException || cause instanceof InvalidVirtualFileAccessException) {
            FileBasedIndexImpl.LOG.info(fileUrl, (Throwable)e);
        } else {
            FileBasedIndexImpl.LOG.error(fileUrl, (Throwable)e);
        }
    }

    @NotNull
    @NlsSafe
    public static String getPresentableLocationBeingIndexed(@NotNull Project project, @NotNull VirtualFile file2) {
        String path2;
        VirtualFile actualFile;
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(14);
        }
        if ((actualFile = file2).getFileSystem() instanceof ArchiveFileSystem) {
            actualFile = VfsUtil.getLocalFile((VirtualFile)actualFile);
        }
        path2 = "/".equals(path2 = IndexUpdateRunner.getProjectRelativeOrAbsolutePath(project, actualFile)) ? actualFile.getName() : path2;
        String string = FileUtil.toSystemDependentName((String)path2);
        if (string == null) {
            IndexUpdateRunner.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getProjectRelativeOrAbsolutePath(@NotNull Project project, @NotNull VirtualFile file2) {
        String filePath;
        String projectBase;
        if (project == null) {
            IndexUpdateRunner.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)(projectBase = project.getBasePath())) && FileUtil.isAncestor((String)projectBase, (String)(filePath = file2.getPath()), (boolean)true)) {
            String projectDirName = PathUtil.getFileName((String)projectBase);
            String relativePath = FileUtil.getRelativePath((String)projectBase, (String)filePath, (char)'/');
            if (StringUtil.isNotEmpty((String)projectDirName) && StringUtil.isNotEmpty((String)relativePath)) {
                String string = projectDirName + "/" + relativePath;
                if (string == null) {
                    IndexUpdateRunner.$$$reportNull$$$0(18);
                }
                return string;
            }
        }
        String string = file2.getPath();
        if (string == null) {
            IndexUpdateRunner.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static ProgressIndicator unwrapAll(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(20);
        }
        while (indicator2 instanceof WrappedProgressIndicator) {
            indicator2 = ((WrappedProgressIndicator)indicator2).getOriginalProgressIndicator();
        }
        ProgressIndicator progressIndicator = indicator2;
        if (progressIndicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(21);
        }
        return progressIndicator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingExecutor";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSets";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingJob";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocationBeingIndexed";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRelativeOrAbsolutePath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexOneFileOfJob";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadNextContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "waitForFreeMemoryToLoadFileContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logFailedToLoadContentException";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableLocationBeingIndexed";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRelativeOrAbsolutePath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndexingJob {
        final Project myProject;
        private final Map<VirtualFile, FileSet> myFileToSet;
        final CachedFileContentLoader myContentLoader;
        final BlockingQueue<VirtualFile> myQueueOfFiles;
        final ProgressIndicator myIndicator;
        final int myTotalFiles;
        final AtomicBoolean myNoMoreFilesInQueue;
        final CountDownLatch myAllFilesAreProcessedLatch;
        final ProgressIndicator myOriginalProgressIndicator;
        @Nullable
        final ProgressSuspender myOriginalProgressSuspender;
        final AtomicReference<Throwable> myError;

        IndexingJob(@NotNull Project project, @NotNull ProgressIndicator indicator2, @NotNull CachedFileContentLoader contentLoader, @NotNull List<FileSet> fileSets, @NotNull ProgressIndicator originalProgressIndicator, @Nullable ProgressSuspender originalProgressSuspender) {
            if (project == null) {
                IndexingJob.$$$reportNull$$$0(0);
            }
            if (indicator2 == null) {
                IndexingJob.$$$reportNull$$$0(1);
            }
            if (contentLoader == null) {
                IndexingJob.$$$reportNull$$$0(2);
            }
            if (fileSets == null) {
                IndexingJob.$$$reportNull$$$0(3);
            }
            if (originalProgressIndicator == null) {
                IndexingJob.$$$reportNull$$$0(4);
            }
            this.myNoMoreFilesInQueue = new AtomicBoolean();
            this.myError = new AtomicReference();
            this.myProject = project;
            this.myIndicator = indicator2;
            this.myFileToSet = new HashMap<VirtualFile, FileSet>();
            for (FileSet fileSet : fileSets) {
                fileSet.files.forEach(file2 -> this.myFileToSet.put((VirtualFile)file2, fileSet));
            }
            this.myTotalFiles = this.myFileToSet.keySet().size();
            this.myContentLoader = contentLoader;
            this.myQueueOfFiles = new ArrayBlockingQueue<VirtualFile>(this.myFileToSet.keySet().size(), false, this.myFileToSet.keySet());
            this.myAllFilesAreProcessedLatch = new CountDownLatch(this.myFileToSet.keySet().size());
            this.myOriginalProgressIndicator = originalProgressIndicator;
            this.myOriginalProgressSuspender = originalProgressSuspender;
        }

        @NotNull
        public IndexingJobStatistics getStatistics(@NotNull VirtualFile file2) {
            if (file2 == null) {
                IndexingJob.$$$reportNull$$$0(5);
            }
            IndexingJobStatistics indexingJobStatistics = this.myFileToSet.get((Object)file2).statistics;
            if (indexingJobStatistics == null) {
                IndexingJob.$$$reportNull$$$0(6);
            }
            return indexingJobStatistics;
        }

        public void oneMoreFileProcessed() {
            this.myAllFilesAreProcessedLatch.countDown();
            double newFraction = 1.0 - (double)this.myAllFilesAreProcessedLatch.getCount() / (double)this.myTotalFiles;
            try {
                this.myIndicator.setFraction(newFraction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean areAllFilesProcessed() {
            return this.myAllFilesAreProcessedLatch.getCount() == 0L;
        }

        public void setLocationBeingIndexed(@NotNull VirtualFile virtualFile2) {
            if (virtualFile2 == null) {
                IndexingJob.$$$reportNull$$$0(7);
            }
            String presentableLocation = IndexUpdateRunner.getPresentableLocationBeingIndexed(this.myProject, virtualFile2);
            if (this.myIndicator instanceof SubTaskProgressIndicator) {
                this.myIndicator.setText(presentableLocation);
            } else {
                this.myIndicator.setText2(presentableLocation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentLoader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSets";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProgressIndicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingJob";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingJob";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatistics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatistics";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setLocationBeingIndexed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ContentLoadingResult {
        @NotNull
        final CachedFileContent cachedFileContent;
        final long fileLength;

        private ContentLoadingResult(@NotNull CachedFileContent cachedFileContent, long fileLength) {
            if (cachedFileContent == null) {
                ContentLoadingResult.$$$reportNull$$$0(0);
            }
            this.cachedFileContent = cachedFileContent;
            this.fileLength = fileLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedFileContent", "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$ContentLoadingResult", "<init>"));
        }
    }

    public static final class FileSet {
        public final String debugName;
        public final Collection<VirtualFile> files;
        public final IndexingJobStatistics statistics;

        public FileSet(@NotNull Project project, @NotNull String debugName, @NotNull Collection<VirtualFile> files2) {
            if (project == null) {
                FileSet.$$$reportNull$$$0(0);
            }
            if (debugName == null) {
                FileSet.$$$reportNull$$$0(1);
            }
            if (files2 == null) {
                FileSet.$$$reportNull$$$0(2);
            }
            this.debugName = debugName;
            this.files = files2;
            this.statistics = new IndexingJobStatistics(project, debugName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "debugName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$FileSet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class IndexingInterruptedException
    extends Exception {
        public IndexingInterruptedException(@NotNull Throwable cause) {
            if (cause == null) {
                IndexingInterruptedException.$$$reportNull$$$0(0);
            }
            super(cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingInterruptedException", "<init>"));
        }
    }
}

