/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.JsonSharedIndexDiagnosticEvent;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonDuration;
import com.intellij.util.indexing.diagnostic.dto.JsonFileSize;
import com.intellij.util.indexing.diagnostic.dto.JsonPercentages;
import com.intellij.util.indexing.diagnostic.dto.JsonProcessingSpeed;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J6\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ@\u0010\u001e\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lcom/intellij/util/indexing/diagnostic/SharedIndexDiagnostic;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "Lkotlin/Lazy;", "appendEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/util/indexing/diagnostic/JsonSharedIndexDiagnosticEvent;", "getEventsFile", "Ljava/nio/file/Path;", "onIndexAttachIncompatible", "kind", "", "indexId", "onIndexAttachSuccess", "indexName", "chunkUniqueId", "fbMatch", "Lcom/intellij/util/indexing/diagnostic/dto/JsonPercentages;", "stubMatch", "onIndexDownloaded", "finishType", "downloadTimeNano", "", "packedSizeBytes", "unpackedSizeBytes", "readEvents", "", "intellij.platform.lang.impl"})
public final class SharedIndexDiagnostic {
    private static final Logger LOG;
    private static final Lazy jacksonMapper$delegate;
    @NotNull
    public static final SharedIndexDiagnostic INSTANCE;

    public final void onIndexAttachSuccess(@NotNull Project project, @NotNull String kind, @NotNull String indexName, @NotNull String chunkUniqueId, @NotNull JsonPercentages fbMatch, @NotNull JsonPercentages stubMatch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)chunkUniqueId, (String)"chunkUniqueId");
        Intrinsics.checkNotNullParameter((Object)fbMatch, (String)"fbMatch");
        Intrinsics.checkNotNullParameter((Object)stubMatch, (String)"stubMatch");
        this.appendEvent(project, new JsonSharedIndexDiagnosticEvent.Attached.Success(JsonSharedIndexDiagnosticEvent.Companion.now(), kind, chunkUniqueId, indexName, fbMatch, stubMatch));
    }

    public final void onIndexAttachIncompatible(@NotNull Project project, @NotNull String kind, @NotNull String indexId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        this.appendEvent(project, new JsonSharedIndexDiagnosticEvent.Attached.Incompatible(JsonSharedIndexDiagnosticEvent.Companion.now(), kind, indexId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsonSharedIndexDiagnosticEvent> readEvents(@NotNull Project project) {
        Path eventsFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable<Path> iterable = eventsFile = this.getEventsFile(project);
        Object object = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists(iterable, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            iterable = eventsFile;
            object = Charsets.UTF_8;
            bl = false;
            List<String> list2 = Files.readAllLines(iterable, (Charset)object);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"Files.readAllLines(this, charset)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ObjectMapper $this$readValue$iv = INSTANCE.getJacksonMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                JsonSharedIndexDiagnosticEvent jsonSharedIndexDiagnosticEvent = (JsonSharedIndexDiagnosticEvent)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<JsonSharedIndexDiagnosticEvent>(){});
                collection.add(jsonSharedIndexDiagnosticEvent);
            }
            iterable = (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to read " + eventsFile, (Throwable)e);
            return CollectionsKt.emptyList();
        }
        return iterable;
    }

    public final void onIndexDownloaded(@Nullable Project project, @NotNull String kind, @NotNull String indexId, @NotNull String finishType, long downloadTimeNano, long packedSizeBytes, long unpackedSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        Intrinsics.checkNotNullParameter((Object)finishType, (String)"finishType");
        JsonDuration downloadTime = new JsonDuration(downloadTimeNano);
        JsonSharedIndexDiagnosticEvent.Downloaded event = new JsonSharedIndexDiagnosticEvent.Downloaded(JsonSharedIndexDiagnosticEvent.Companion.now(), kind, indexId, finishType, downloadTime, new JsonFileSize(packedSizeBytes), new JsonFileSize(unpackedSizeBytes), new JsonProcessingSpeed(packedSizeBytes, downloadTimeNano));
        if (project != null) {
            this.appendEvent(project, event);
        }
    }

    private final ObjectMapper getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        SharedIndexDiagnostic sharedIndexDiagnostic = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    private final Path getEventsFile(Project project) {
        Path path2 = IndexDiagnosticDumper.Companion.getProjectDiagnosticDirectory(project).resolve("shared-index-events.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"IndexDiagnosticDumper.ge\u2026hared-index-events.json\")");
        return path2;
    }

    private final void appendEvent(Project project, JsonSharedIndexDiagnosticEvent event) {
        try {
            Path file2 = this.getEventsFile(project);
            String string = this.getJacksonMapper().writeValueAsString((Object)event);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonMapper.writeValueAsString(event)");
            String jsonLine = StringsKt.replace$default((String)string, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            Path path2 = file2;
            Iterable iterable = CollectionsKt.listOf((Object)jsonLine);
            Charset charset = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"Files.write(this, lines, charset, *options)");
        }
        catch (Exception e) {
            LOG.warn("Failed to append shared index event: " + event, (Throwable)e);
        }
    }

    private SharedIndexDiagnostic() {
    }

    static {
        SharedIndexDiagnostic sharedIndexDiagnostic;
        INSTANCE = sharedIndexDiagnostic = new SharedIndexDiagnostic();
        Logger logger = Logger.getInstance(SharedIndexDiagnostic.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Share\u2026exDiagnostic::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
    }
}

