/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.events.VfsEventsMerger;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedFilesListener
implements AsyncFileListener {
    @NotNull
    private final VfsEventsMerger myEventMerger = new VfsEventsMerger();
    @NotNull
    private final CachedValue<VirtualFile> myConfig = new CachedValueImpl<VirtualFile>(() -> new CachedValueProvider.Result((Object)IndexedFilesListener.findVFileByPath(PathManager.getConfigPath()), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    @NotNull
    private final CachedValue<VirtualFile> myLog = new CachedValueImpl<VirtualFile>(() -> new CachedValueProvider.Result((Object)IndexedFilesListener.findVFileByPath(PathManager.getLogPath()), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    @NotNull
    private final CachedValue<Collection<VirtualFile>> myScratchesAndConsolesRoots = new CachedValueImpl<Collection<VirtualFile>>(() -> new CachedValueProvider.Result((Object)ScratchFileService.getAllRootPaths(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));

    @NotNull
    public VfsEventsMerger getEventMerger() {
        VfsEventsMerger vfsEventsMerger2 = this.myEventMerger;
        if (vfsEventsMerger2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(0);
        }
        return vfsEventsMerger2;
    }

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(1);
        }
        if (file2.isDirectory()) {
            ContentIterator iterator2 = fileOrDir -> {
                this.myEventMerger.recordFileEvent(fileOrDir, contentChange);
                if (VfsEventsMerger.LOG != null) {
                    VfsEventsMerger.LOG.info("Build indexes for " + file2 + "; contentChange = " + contentChange);
                }
                return true;
            };
            this.iterateIndexableFiles(file2, iterator2);
        } else {
            this.myEventMerger.recordFileEvent(file2, contentChange);
        }
    }

    private boolean invalidateIndicesForFile(@NotNull VirtualFile file2, @NotNull InvalidationCause cause, @NotNull VfsEventsMerger eventMerger) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(2);
        }
        if (cause == null) {
            IndexedFilesListener.$$$reportNull$$$0(3);
        }
        if (eventMerger == null) {
            IndexedFilesListener.$$$reportNull$$$0(4);
        }
        if (cause != InvalidationCause.REMOVED && this.isUnderConfigOrSystem(file2)) {
            return false;
        }
        if (cause == InvalidationCause.FORCE_REBUILD) {
            file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, (Object)Boolean.TRUE);
        }
        ProgressManager.checkCanceled();
        eventMerger.recordBeforeFileEvent(file2, cause != InvalidationCause.REMOVED && cause != InvalidationCause.RENAMED);
        if (VfsEventsMerger.LOG != null) {
            VfsEventsMerger.LOG.info("Invalidating indexes for " + file2 + "; cause = " + cause);
        }
        return !file2.isDirectory() || FileBasedIndexImpl.isMock(file2) || ManagingFS.getInstance().wereChildrenAccessed(file2);
    }

    protected abstract void iterateIndexableFiles(@NotNull VirtualFile var1, @NotNull ContentIterator var2);

    public void invalidateIndicesRecursively(@NotNull VirtualFile file2, final @NotNull InvalidationCause cause, final @NotNull VfsEventsMerger eventMerger) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(5);
        }
        if (cause == null) {
            IndexedFilesListener.$$$reportNull$$$0(6);
        }
        if (eventMerger == null) {
            IndexedFilesListener.$$$reportNull$$$0(7);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, cause, eventMerger);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/indexing/events/IndexedFilesListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(8);
        }
        final VfsEventsMerger tempMerger = new VfsEventsMerger();
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.invalidateIndicesRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), InvalidationCause.CHANGED, tempMerger);
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.invalidateIndicesRecursively(((VFileDeleteEvent)vFileEvent).getFile(), InvalidationCause.REMOVED, tempMerger);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.invalidateIndicesRecursively(pce.getFile(), InvalidationCause.RENAMED, tempMerger);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.invalidateIndicesRecursively(pce.getFile(), InvalidationCause.CHANGED, tempMerger);
        }
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                IndexedFilesListener.this.myEventMerger.applyMergedEvents(tempMerger);
            }

            public void afterVfsChange() {
                IndexedFilesListener.this.processAfterEvents(events);
            }
        };
    }

    private void processAfterEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(9);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.buildIndicesForFileRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)vFileEvent;
                VirtualFile copy2 = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy2 == null) continue;
                this.buildIndicesForFileRecursively(copy2, false);
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                VirtualFile newChild = vFileEvent.getFile();
                if (newChild == null) continue;
                this.buildIndicesForFileRecursively(newChild, false);
                continue;
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                this.buildIndicesForFileRecursively(((VFileMoveEvent)vFileEvent).getFile(), false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.buildIndicesForFileRecursively(pce.getFile(), false);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.buildIndicesForFileRecursively(pce.getFile(), true);
        }
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        VirtualFile logValue;
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(10);
        }
        if ((logValue = (VirtualFile)this.myLog.getValue()) != null && VfsUtilCore.isAncestor((VirtualFile)logValue, (VirtualFile)file2, (boolean)false)) {
            return true;
        }
        for (VirtualFile root : (Collection)this.myScratchesAndConsolesRoots.getValue()) {
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return false;
        }
        VirtualFile configValue = (VirtualFile)this.myConfig.getValue();
        return configValue != null && VfsUtilCore.isAncestor((VirtualFile)configValue, (VirtualFile)file2, (boolean)false);
    }

    @Nullable
    private static VirtualFile findVFileByPath(@NotNull String path2) {
        if (path2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(11);
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/IndexedFilesListener";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventMerger";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMerger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/IndexedFilesListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildIndicesForFileRecursively";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIndicesForFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIndicesRecursively";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAfterEvents";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnderConfigOrSystem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findVFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum InvalidationCause {
        REMOVED,
        CHANGED,
        RENAMED,
        FORCE_REBUILD;

    }
}

