/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerRetriever;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingException;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.indexing.snapshot.SnapshotSingleValueIndexStorage;
import com.intellij.util.indexing.storage.SnapshotInputMappingIndex;
import com.intellij.util.indexing.storage.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value>
extends MapReduceIndex<Key, Value, FileContent>
implements UpdatableIndex<Key, Value, FileContent> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    @ApiStatus.Internal
    public static final int VERSION = 0;
    private final PersistentSubIndexerRetriever mySubIndexerRetriever;
    private final SnapshotInputMappingIndex<Key, Value, FileContent> mySnapshotInputMappings;
    private final boolean myUpdateMappings;
    private final boolean mySingleEntryIndex;

    public VfsAwareMapReduceIndex(@NotNull FileBasedIndexExtension<Key, Value> extension2, @NotNull VfsAwareIndexStorageLayout<Key, Value> indexStorageLayout, @Nullable ReadWriteLock lock2) throws IOException {
        if (extension2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (indexStorageLayout == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension2, () -> indexStorageLayout.openIndexStorage(), (ThrowableComputable<? extends ForwardIndex, ? extends IOException>)((ThrowableComputable)() -> indexStorageLayout.openForwardIndex()), indexStorageLayout.getForwardIndexAccessor(), () -> indexStorageLayout.createOrClearSnapshotInputMappings(), lock2);
    }

    /*
     * Unable to fully structure code
     */
    protected VfsAwareMapReduceIndex(@NotNull FileBasedIndexExtension<Key, Value> extension, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storage, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndexMap, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable ThrowableComputable<? extends SnapshotInputMappingIndex<Key, Value, FileContent>, ? extends IOException> snapshotInputMappings, @Nullable ReadWriteLock lock) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(3);
        }
        super(extension, storage, forwardIndexMap, forwardIndexAccessor, lock);
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
        try {
            inputMappings = snapshotInputMappings == null ? null : (SnapshotInputMappingIndex)snapshotInputMappings.compute();
        }
        catch (IOException e) {
            this.tryDispose();
            throw e;
        }
        this.mySnapshotInputMappings = inputMappings;
        v0 = this.myUpdateMappings = this.mySnapshotInputMappings != null;
        if (inputMappings != null) {
            backendStorage = this.getStorage();
            if (backendStorage instanceof TransientChangesIndexStorage) {
                backendStorage = ((TransientChangesIndexStorage)backendStorage).getBackendStorage();
            }
            if (backendStorage instanceof SnapshotSingleValueIndexStorage) {
                VfsAwareMapReduceIndex.LOG.assertTrue(forwardIndexMap instanceof IntForwardIndex);
                ((SnapshotSingleValueIndexStorage)backendStorage).init((SnapshotInputMappings)inputMappings, (IntForwardIndex)forwardIndexMap);
            }
        }
        if (VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer)) {
            try {
                this.mySubIndexerRetriever = new PersistentSubIndexerRetriever<SubIndexerType, SubIndexerVersion>((ID)this.myIndexId, extension.getVersion(), (CompositeDataIndexer)this.myIndexer);
                if (!(inputMappings instanceof SnapshotInputMappings)) ** GOTO lbl34
                ((SnapshotInputMappings)inputMappings).setSubIndexerRetriever(this.mySubIndexerRetriever);
            }
            catch (IOException e) {
                this.tryDispose();
                throw e;
            }
        } else {
            this.mySubIndexerRetriever = null;
        }
lbl34:
        // 3 sources

        this.mySingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
    }

    public void resetSnapshotInputMappingsStatistics() {
        if (this.mySnapshotInputMappings instanceof SnapshotInputMappings) {
            ((SnapshotInputMappings)this.mySnapshotInputMappings).resetStatistics();
        }
    }

    @Nullable
    public SnapshotInputMappingsStatistics dumpSnapshotInputMappingsStatistics() {
        if (this.mySnapshotInputMappings instanceof SnapshotInputMappings) {
            return ((SnapshotInputMappings)this.mySnapshotInputMappings).dumpStatistics();
        }
        return null;
    }

    public static boolean isCompositeIndexer(@NotNull DataIndexer<?, ?, ?> indexer) {
        if (indexer == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(4);
        }
        return indexer instanceof CompositeDataIndexer && !FileBasedIndex.USE_IN_MEMORY_INDEX;
    }

    public static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(5);
        }
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && FileBasedIndex.ourSnapshotMappingsEnabled && !FileBasedIndex.USE_IN_MEMORY_INDEX;
    }

    protected void checkNonCancellableSection() {
        LOG.assertTrue(ProgressManager.getInstance().isInNonCancelableSection());
    }

    @NotNull
    protected final InputData<Key, Value> mapInput(int inputId, @Nullable FileContent content2) {
        InputData<Key, Value> data2;
        boolean isPhysical;
        boolean containsSnapshotData = true;
        boolean bl = isPhysical = content2 instanceof FileContentImpl && ((FileContentImpl)content2).isPhysicalContent();
        if (this.mySnapshotInputMappings != null && isPhysical) {
            block10: {
                InputData<Key, Value> inputData;
                try {
                    data2 = this.mySnapshotInputMappings.readData(content2);
                    if (data2 == null) break block10;
                    inputData = data2;
                }
                catch (IOException e) {
                    throw new SnapshotInputMappingException(e);
                }
                if (inputData == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(6);
                }
                return inputData;
            }
            containsSnapshotData = !this.myUpdateMappings;
        }
        data2 = super.mapInput(inputId, (Object)content2);
        if (!containsSnapshotData) {
            InputData<Key, Value> inputData;
            try {
                inputData = ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).putData(content2, data2);
            }
            catch (IOException e) {
                throw new SnapshotInputMappingException(e);
            }
            if (inputData == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(7);
            }
            return inputData;
        }
        InputData<Key, Value> inputData = data2;
        if (inputData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(8);
        }
        return inputData;
    }

    @NotNull
    public InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId, @NotNull Map<Key, Value> keysAndValues) throws IOException {
        if (keysAndValues == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(9);
        }
        InputDataDiffBuilder inputDataDiffBuilder = ((AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor()).createDiffBuilderByMap(inputId, keysAndValues);
        if (inputDataDiffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(10);
        }
        return inputDataDiffBuilder;
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(11);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.setIndexedState(fileId, file2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void invalidateIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    public void setUnindexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateUnindexed(fileId, (ID)this.myIndexId);
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.setUnindexedState(fileId);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        FileIndexingState subIndexerState;
        block17: {
            block16: {
                FileIndexingState fileIndexingState;
                FileIndexingState baseState;
                if (file2 == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(12);
                }
                if ((baseState = IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId)) != FileIndexingState.UP_TO_DATE) {
                    FileIndexingState fileIndexingState2 = baseState;
                    if (fileIndexingState2 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(13);
                    }
                    return fileIndexingState2;
                }
                if (this.mySubIndexerRetriever == null) {
                    FileIndexingState fileIndexingState3 = FileIndexingState.UP_TO_DATE;
                    if (fileIndexingState3 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(14);
                    }
                    return fileIndexingState3;
                }
                if (!(file2 instanceof FileContent) && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
                    FileIndexingState indexConfigurationState = this.isIndexConfigurationUpToDate(fileId, file2);
                    FileIndexingState fileIndexingState4 = indexConfigurationState == FileIndexingState.OUT_DATED ? FileIndexingState.OUT_DATED : FileIndexingState.UP_TO_DATE;
                    if (fileIndexingState4 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(15);
                    }
                    return fileIndexingState4;
                }
                try {
                    subIndexerState = this.mySubIndexerRetriever.getSubIndexerState(fileId, file2);
                    if (subIndexerState != FileIndexingState.UP_TO_DATE) break block16;
                    if (file2 instanceof FileContent && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
                        this.setIndexConfigurationUpToDate(fileId, file2);
                    }
                    fileIndexingState = FileIndexingState.UP_TO_DATE;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    FileIndexingState fileIndexingState5 = FileIndexingState.OUT_DATED;
                    if (fileIndexingState5 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(19);
                    }
                    return fileIndexingState5;
                }
                if (fileIndexingState == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(16);
                }
                return fileIndexingState;
            }
            if (subIndexerState != FileIndexingState.NOT_INDEXED) break block17;
            FileIndexingState fileIndexingState = FileIndexingState.UP_TO_DATE;
            if (fileIndexingState == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(17);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = subIndexerState;
        if (fileIndexingState == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(18);
        }
        return fileIndexingState;
    }

    protected FileIndexingState isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(20);
        }
        return FileIndexingState.OUT_DATED;
    }

    protected void setIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(21);
        }
    }

    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(22);
        }
        if (scope2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(23);
        }
        return (Boolean)ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope2, idFilter));
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        Map map2 = (Map)ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> {
            try {
                return Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        });
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(24);
        }
        return map2;
    }

    @Nullable
    protected Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.mySingleEntryIndex) {
            Integer key = fileId;
            Ref result2 = new Ref(Collections.emptyMap());
            ValueContainer container = this.getData(key);
            container.forEach((id2, value2) -> {
                boolean acceptNullValues = ((SingleEntryIndexer)this.myIndexer).isAcceptNullValues();
                if (value2 != null || acceptNullValues) {
                    result2.set(Collections.singletonMap(key, value2));
                }
                return false;
            });
            return (Map)result2.get();
        }
        if (this.getForwardIndexAccessor() instanceof AbstractMapForwardIndexAccessor) {
            ByteArraySequence serializedInputData = this.getForwardIndex().get(Integer.valueOf(fileId));
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor();
            return forwardIndexAccessor.convertToInputDataMap(fileId, serializedInputData);
        }
        LOG.error("Can't fetch indexed data for index " + this.myIndexId.getName());
        return null;
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(25);
        }
        Runnable action2 = () -> FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(action2);
        } else {
            action2.run();
        }
    }

    @Override
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(26);
        }
        try {
            super.updateWithMap(updateData);
        }
        catch (ProcessCanceledException e) {
            LOG.error("ProcessCancelledException is not expected here!", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupMemoryStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupForNextTest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTransientDataForFile(int inputId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(27);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected ValueSerializationProblemReporter getSerializationProblemReporter() {
        ValueSerializationProblemReporter valueSerializationProblemReporter = problem -> {
            PluginId pluginId = ((ID)this.myIndexId).getPluginId();
            if (pluginId != null) {
                LOG.error((Throwable)new PluginException((Throwable)problem, pluginId));
            } else {
                LOG.error((Throwable)problem);
            }
        };
        if (valueSerializationProblemReporter == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(28);
        }
        return valueSerializationProblemReporter;
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            try {
                ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).flush();
        }
        if (this.mySubIndexerRetriever != null) {
            this.mySubIndexerRetriever.flush();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        catch (Throwable throwable) {
            IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
            throw throwable;
        }
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
    }

    static {
        Application app = ApplicationManager.getApplication();
        if (!IndexDebugProperties.DEBUG) {
            boolean bl = IndexDebugProperties.DEBUG = (app.isEAP() || app.isInternal()) && !ApplicationManagerEx.isInStressTest();
        }
        if (!IndexDebugProperties.IS_UNIT_TEST_MODE) {
            IndexDebugProperties.IS_UNIT_TEST_MODE = app.isUnitTestMode();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageLayout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysAndValues";
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationProblemReporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeIndexer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSnapshotMapping";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 28: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getKeysDiffBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isIndexConfigurationUpToDate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setIndexConfigurationUpToDate";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

