/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.treeWithCheckedNodes;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.ui.PlusMinus;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectedState;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import java.util.Collection;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

public class SelectionManager {
    private final SelectedState<VirtualFile> myState;
    private final Convertor<? super DefaultMutableTreeNode, ? extends VirtualFile> myNodeConvertor;
    private PlusMinus<? super VirtualFile> mySelectionChangeListener;

    public SelectionManager(int selectedSize, int queueSize, Convertor<? super DefaultMutableTreeNode, ? extends VirtualFile> nodeConvertor) {
        this.myNodeConvertor = nodeConvertor;
        this.myState = new SelectedState(selectedSize, queueSize);
    }

    public void toggleSelection(DefaultMutableTreeNode node2) {
        StateWorker stateWorker = new StateWorker(node2, this.myNodeConvertor);
        VirtualFile vf = stateWorker.getVf();
        if (vf == null) {
            return;
        }
        TreeNodeState state = this.getStateImpl(stateWorker);
        if (TreeNodeState.HAVE_SELECTED_ABOVE.equals((Object)state)) {
            return;
        }
        if (TreeNodeState.CLEAR.equals((Object)state) && !this.myState.canAddSelection()) {
            return;
        }
        Set<VirtualFile> old = this.myState.getSelected();
        TreeNodeState futureState = this.myState.putAndPass(vf, TreeNodeState.SELECTED.equals((Object)state) ? TreeNodeState.CLEAR : TreeNodeState.SELECTED);
        if (!TreeNodeState.SELECTED.equals((Object)futureState)) {
            this.myState.clearAllCachedMatching((Processor<VirtualFile>)((Processor)virtualFile2 -> VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)vf, (boolean)false)));
        }
        stateWorker.iterateParents(this.myState, (PairProcessor<? super VirtualFile, ? super TreeNodeState>)((PairProcessor)(virtualFile2, state1) -> {
            if (TreeNodeState.SELECTED.equals((Object)futureState)) {
                this.myState.putAndPass((VirtualFile)virtualFile2, TreeNodeState.HAVE_SELECTED_BELOW);
            } else {
                this.myState.remove((VirtualFile)virtualFile2);
            }
            return true;
        }));
        this.myState.clearAllCachedMatching((Processor<VirtualFile>)((Processor)vf1 -> VfsUtilCore.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)vf1, (boolean)false)));
        for (VirtualFile selected2 : this.myState.getSelected()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)selected2, (boolean)true)) continue;
            this.myState.remove(selected2);
        }
        Set<VirtualFile> selectedAfter = this.myState.getSelected();
        if (this.mySelectionChangeListener != null && !old.equals(selectedAfter)) {
            Collection removed = ContainerUtil.subtract(old, selectedAfter);
            Collection newlyAdded = ContainerUtil.subtract(selectedAfter, old);
            for (VirtualFile file2 : newlyAdded) {
                if (this.mySelectionChangeListener == null) continue;
                this.mySelectionChangeListener.plus((VirtualFile)file2);
            }
            for (VirtualFile file2 : removed) {
                if (this.mySelectionChangeListener == null) continue;
                this.mySelectionChangeListener.minus((VirtualFile)file2);
            }
        }
    }

    public boolean canAddSelection() {
        return this.myState.canAddSelection();
    }

    public void setSelection(Collection<? extends VirtualFile> files2) {
        this.myState.setSelection(files2);
        for (VirtualFile virtualFile2 : files2) {
            if (this.mySelectionChangeListener == null) continue;
            this.mySelectionChangeListener.plus((VirtualFile)virtualFile2);
        }
    }

    public TreeNodeState getState(DefaultMutableTreeNode node2) {
        return this.getStateImpl(new StateWorker(node2, this.myNodeConvertor));
    }

    private TreeNodeState getStateImpl(StateWorker stateWorker) {
        if (stateWorker.getVf() == null) {
            return TreeNodeState.CLEAR;
        }
        TreeNodeState stateSelf = this.myState.get(stateWorker.getVf());
        if (stateSelf != null) {
            return stateSelf;
        }
        Ref result2 = new Ref();
        stateWorker.iterateParents(this.myState, (PairProcessor<? super VirtualFile, ? super TreeNodeState>)((PairProcessor)(virtualFile2, state) -> {
            if (state != null) {
                if (TreeNodeState.SELECTED.equals(state) || TreeNodeState.HAVE_SELECTED_ABOVE.equals(state)) {
                    result2.set((Object)this.myState.putAndPass(stateWorker.getVf(), TreeNodeState.HAVE_SELECTED_ABOVE));
                }
                return false;
            }
            return true;
        }));
        if (!result2.isNull()) {
            return (TreeNodeState)((Object)result2.get());
        }
        for (VirtualFile selected2 : this.myState.getSelected()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)selected2, (boolean)true)) continue;
            return this.myState.putAndPass(stateWorker.getVf(), TreeNodeState.HAVE_SELECTED_BELOW);
        }
        return TreeNodeState.CLEAR;
    }

    public void removeSelection(VirtualFile elementAt) {
        this.myState.remove(elementAt);
        this.myState.clearAllCachedMatching((Processor<VirtualFile>)((Processor)f -> VfsUtilCore.isAncestor((VirtualFile)f, (VirtualFile)elementAt, (boolean)false) || VfsUtilCore.isAncestor((VirtualFile)elementAt, (VirtualFile)f, (boolean)false)));
        if (this.mySelectionChangeListener != null) {
            this.mySelectionChangeListener.minus((VirtualFile)elementAt);
        }
    }

    public void setSelectionChangeListener(@Nullable PlusMinus<? super VirtualFile> selectionChangeListener) {
        this.mySelectionChangeListener = selectionChangeListener;
    }

    private static final class StateWorker {
        private final DefaultMutableTreeNode myNode;
        private final Convertor<? super DefaultMutableTreeNode, ? extends VirtualFile> myConvertor;
        private final VirtualFile myVf;

        private StateWorker(DefaultMutableTreeNode node2, Convertor<? super DefaultMutableTreeNode, ? extends VirtualFile> convertor) {
            this.myNode = node2;
            this.myConvertor = convertor;
            this.myVf = (VirtualFile)this.myConvertor.convert((Object)node2);
        }

        public VirtualFile getVf() {
            return this.myVf;
        }

        public void iterateParents(SelectedState<? super VirtualFile> states, PairProcessor<? super VirtualFile, ? super TreeNodeState> parentsProcessor) {
            for (DefaultMutableTreeNode current2 = (DefaultMutableTreeNode)this.myNode.getParent(); current2 != null; current2 = (DefaultMutableTreeNode)current2.getParent()) {
                VirtualFile file2 = (VirtualFile)this.myConvertor.convert((Object)current2);
                if (file2 == null) {
                    return;
                }
                TreeNodeState state = states.get((VirtualFile)file2);
                if (parentsProcessor.process((Object)file2, (Object)state)) continue;
                return;
            }
        }
    }
}

