/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlPanel
extends JEditorPane
implements HyperlinkListener {
    public HtmlPanel() {
        super("text/html", "");
        this.setEditable(false);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.addHyperlinkListener(this);
        this.setEditorKit((EditorKit)new UIUtil.JBWordWrapHtmlEditorKit());
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
    }

    @Override
    public String getSelectedText() {
        Document doc = this.getDocument();
        int start2 = this.getSelectionStart();
        int end = this.getSelectionEnd();
        try {
            Position p0 = doc.createPosition(start2);
            Position p1 = doc.createPosition(end);
            StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
            this.getEditorKit().write(sw, doc, p0.getOffset(), p1.getOffset() - p0.getOffset());
            return StringUtil.removeHtmlTags((String)sw.toString());
        }
        catch (IOException | BadLocationException exception) {
            return super.getSelectedText();
        }
    }

    public void setBody(@NotNull @Nls String text2) {
        if (text2 == null) {
            HtmlPanel.$$$reportNull$$$0(0);
        }
        if (text2.isEmpty()) {
            this.setText("");
        } else {
            @NlsSafe String cssFontDeclaration = UIUtil.getCssFontDeclaration((Font)this.getBodyFont());
            this.setText(new HtmlBuilder().append((HtmlChunk)HtmlChunk.raw((String)cssFontDeclaration).wrapWith("head")).append((HtmlChunk)HtmlChunk.raw((String)text2).wrapWith(HtmlChunk.body())).wrapWith(HtmlChunk.html()).toString());
        }
    }

    @NotNull
    protected Font getBodyFont() {
        Font font = FontUtil.getCommitMessageFont();
        if (font == null) {
            HtmlPanel.$$$reportNull$$$0(1);
        }
        return font;
    }

    @NotNull
    @Nls
    protected abstract String getBody();

    @Override
    public void updateUI() {
        super.updateUI();
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(1);
        this.update();
    }

    public void update() {
        this.setBody(this.getBody());
        this.customizeLinksStyle();
        this.revalidate();
        this.repaint();
    }

    private void customizeLinksStyle() {
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            String linkColor = "#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
            styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/HtmlPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/HtmlPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setBody";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

