/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.util.xml.stubs.builder.DomStubBuilderVisitor;
import com.intellij.xml.util.XmlUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<DomFileMetaData> {
    private static final Logger LOG = Logger.getInstance(DomStubBuilder.class);

    DomStubBuilder() {
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            DomStubBuilder.$$$reportNull$$$0(0);
        }
        return (fileType = file2.getFileType()) == XmlFileType.INSTANCE && !FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, fileType);
    }

    @NotNull
    public Stream<DomFileMetaData> getAllSubBuilders() {
        Stream<DomFileMetaData> stream = DomApplicationComponent.getInstance().getStubBuildingMetadata().stream();
        if (stream == null) {
            DomStubBuilder.$$$reportNull$$$0(1);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DomFileMetaData getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            DomStubBuilder.$$$reportNull$$$0(2);
        }
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            PsiFile psiFile = fileContent.getPsiFile();
            if (!(psiFile instanceof XmlFile)) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            Project project = fileContent.getProject();
            XmlFile xmlFile = (XmlFile)psiFile;
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile);
            if (fileElement == null) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileMetaData meta = DomApplicationComponent.getInstance().findMeta(fileElement.getFileDescription());
            if (meta == null || !meta.hasStubs()) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileMetaData domFileMetaData = meta;
            return domFileMetaData;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    @NotNull
    public String getSubBuilderVersion(@Nullable DomFileMetaData data2) {
        Object object = data2 == null ? "<no-stub>" : data2.rootTagName + ":" + data2.rootTagName + ":" + data2.implementation;
        if (object == null) {
            DomStubBuilder.$$$reportNull$$$0(3);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable DomFileMetaData meta) {
        if (fileContent == null) {
            DomStubBuilder.$$$reportNull$$$0(4);
        }
        if (meta == null) {
            return null;
        }
        PsiFile psiFile = fileContent.getPsiFile();
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        Project project = fileContent.getProject();
        XmlFile xmlFile = (XmlFile)psiFile;
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile);
            XmlFileHeader header2 = DomService.getInstance().getXmlFileHeader(xmlFile);
            if (header2.getRootTagLocalName() == null) {
                LOG.error("null root tag for " + fileElement + " for " + fileContent.getFile());
            }
            FileStub fileStub = new FileStub(header2);
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                new DomStubBuilderVisitor(DomManagerImpl.getDomManager(project)).visitXmlElement((XmlElement)rootTag, fileStub, 0);
            }
            FileStub fileStub2 = fileStub;
            return fileStub2;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    public int getStubVersion() {
        return 23;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/stubs/builder/DomStubBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/stubs/builder/DomStubBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

