/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.CommitTabTitleUpdater;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/commit/ChangesViewCommitTabTitleUpdater;", "Lcom/intellij/vcs/commit/CommitTabTitleUpdater;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManagerListener;", "commitPanel", "Lcom/intellij/vcs/commit/ChangesViewCommitPanel;", "(Lcom/intellij/vcs/commit/ChangesViewCommitPanel;)V", "start", "", "toolWindowMappingChanged", "updateTab", "intellij.platform.vcs.impl"})
final class ChangesViewCommitTabTitleUpdater
extends CommitTabTitleUpdater
implements ChangesViewContentManagerListener {
    private final ChangesViewCommitPanel commitPanel;

    @Override
    public void start() {
        super.start();
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
    }

    @Override
    public void toolWindowMappingChanged() {
        this.updateTab();
    }

    @Override
    public void updateTab() {
        if (!ChangesViewContentManagerKt.isCommitToolWindowShown(this.getProject())) {
            return;
        }
        super.updateTab();
    }

    public ChangesViewCommitTabTitleUpdater(@NotNull ChangesViewCommitPanel commitPanel2) {
        Intrinsics.checkNotNullParameter((Object)commitPanel2, (String)"commitPanel");
        super(commitPanel2.getChangesView(), "Local Changes", (Function0<String>)((Function0)1.INSTANCE));
        this.commitPanel = commitPanel2;
        Disposer.register((Disposable)((Disposable)this.commitPanel), (Disposable)this);
        this.setPathsProvider((Function0<? extends Iterable<? extends FilePath>>)((Function0)new Function0<Iterable<? extends FilePath>>(){

            @NotNull
            public final Iterable<FilePath> invoke() {
                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
                Object[] objectArray = projectLevelVcsManager.getAllVersionedRoots();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectLevelVcsManager.g\u2026roject).allVersionedRoots");
                VirtualFile singleRoot = (VirtualFile)ArraysKt.singleOrNull((Object[])objectArray);
                return singleRoot != null ? (Iterable)CollectionsKt.listOf((Object)VcsUtil.getFilePath((VirtualFile)singleRoot)) : (Iterable)AbstractCommitWorkflowHandlerKt.getDisplayedPaths(commitPanel);
            }
        }));
    }
}

